<?php

function partage()
{    
  global $commande, $DIR_PARTAGE, $table_partage, $cadre_p, $cx, $auth, $email;
  
  if ($commande == 'PARTAGE DE DOCUMENTS')
  {
      echo '<div class="detail">
        <h1>Partage de documents entre les encadrants</h1><p class="oblique_bleu">C\'est le moyen ici de partager des documents entre tous les encadrants. Vous pouvez mettre n\'importe quel document mais favoriser le type pdf lisible par tous plutôt que des formats nécessitant des logiciels spécialisés (docx, xlsx, dot).
        Un résumé en quelques mots accompagne chaque document. Ce résumé sera associer à vos commandes de recherche.</p>';
  
      fin_partage_vue ();

    }
    else if ($commande == 'ACCES AU DOCUMENT PARTAGE SELECTIONNE')
    {
      $cId = $_POST['cId']; 
      echo '<div class="detail">';
  
      if ($cId == '') //oubli de sélection
      {

        echo '<h1>Accès au document sélectionné</h1>
              <p class="oblique_rouge">Vous devez sélectionner un des documents de la liste.</p>';
        goto liste;
      }
      else
      {
       $doc = p_extract_doc_id ($cId);

        echo '<h1>Accès au document <b>"'. $doc->name . '"</b></h1>
        <p>Déposé par : ' . $doc->name_depot . '<br>
        Résumé : <b>' . sup_anti_slash($doc->desc) . '</b><br>
        Taille : <b>' . $doc->size . '</b></p>';
        add_log ($commande . ' - ' . $doc->name);

        echo '<p>Télécharger ce document en cliquant sur le lien suivant : <A HREF="' . get_site_url() . '/' . $DIR_PARTAGE . '/' . $doc->name . '" target="_blank">' . $doc->name . '</A></p>';

      }
      fin_partage_vue(); 
  }
  else if ($commande == 'ACCES A TOUS LES DOCUMENTS PARTAGES')
  {
   
    echo '<div class="detail">';
    liste:
    echo '<h1>Liste de tous les documents partagés</h1>';

      $docs = p_extract_all_documents ();

      echo '<form method="post"><table border="1"><th class="noir" width=10%>Sel</th><th class="noir">Nom doc</th><th class="noir">Résumé</th><th class="noir">Dépôt par</th><th class="noir">Date
      </th>';

      foreach ($docs as $doc)
      {
        echo '<tr><td class="noir"><input type="radio" name="cId" value="' . $doc->Id . '"></td><td class="noir">' . $doc->name . '</td><td class="noir">' . sup_anti_slash($doc->desc) . '</td><td class="noir">' . sup_anti_slash($doc->name_depot) . '</td><td class="noir">' . $doc->date . '</td></tr>';
      }
      echo '</table>
 
        <input type="submit" name="commande"  value="ACCES AU DOCUMENT PARTAGE SELECTIONNE" > 
        <input type="submit" name="commande"  value="SUPPRIMER LE DOCUMENT PARTAGE SELECTIONNE" > 
        <input type="hidden" name="auth"      value = "' . $auth . '">
        <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
        <input type="hidden" name="cx"        value="' . $cx . '">
        </form>';

        fin_partage_vue();
  }    
  else if ($commande == "SUPPRIMER LE DOCUMENT PARTAGE SELECTIONNE")
  {
      $cId = $_POST['cId'];
      if ($cId == '')
      {
        echo '<div class="detail>"
        <p class="oblique_rouge">Vous devez obligatoirement sélectionner un des documents à supprimer.</p>';
        goto liste;
      }
      else
      {
        $doc = p_extract_doc_id($cId);
        $desc = sup_anti_slash($doc->desc);
        echo '<h1>Supprimer le document  ' . $doc->name . '</h1>
        Résumé : ' . $desc . '<br>
        Déposé par : ' . $doc->name_depot . '<br>';
     
        if ($cadre_p != $doc->name_depot)
        {
          echo '<p class="oblique_bleu">Attention, vous demander la suppression d\'un document qui a été déposé par ' . $doc->name_depot . '. Soyez donc très attentif avant de confirmer la suppression.</p>';
        }
        echo 'Cette opération nécessite une confirmation<br>
          <form method="post">        
          <input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          <input type="hidden" name="cId"    value="' . $cId . '">
          <input type="submit" name="commande" value="CONFIRMER LA SUPPRESSION DU DOCUMENT PARTAGE" > 
          </form><br>';
     }
     fin_partage_vue();
  }  
  else if ($commande == 'CONFIRMER LA SUPPRESSION DU DOCUMENT PARTAGE')
  {

      $cId = $_POST['cId'];

      $doc = p_extract_doc_id($cId);
      $desc = sup_anti_slash($doc->desc);
      echo '<div class="detail">
            <h1>Confirmation de la suppression du document  ' . $doc->name . '</h1>
      Résumé : ' . $desc . '<br>
      Déposé par : ' . $doc->name_depot . '<br>';
      add_log ('Confirmation suppression du document ' . $doc_name);
      p_delete_doc_id ($cId);

      $dest = $DIR_PARTAGE . '/' . $doc->name;
      unlink($dest);

      echo 'Le document "' . $doc->name . '" a été supprimé<br>';
      
      echo '<form method="post">
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        <input type="hidden" name="cId"    value="' . $cId . '">
        </form>';
        fin_partage_vue();
  }   
  else if ($commande == 'RECHERCHER DES DOCUMENTS PARTAGES') 
  {
        echo '<div class="detail">
        <h1>Recherche de documents</h1>
        <p class="oblique">Cette recherche se fait sur le nom des documents, leurs résumés et leurs dépositaires (exemple : michel pour rechercher tous les documents déposés ou modifiés par les Michel).</p>
        <form method="post">Entrer les caractères de votre recherche en minuscule
        <input type="text" name="rechdoc">
        <input type="submit" name="commande" value="LANCER LA RECHERCHE DE PARTAGE"> 
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        <input type="hidden" name="cId"    value="' . $cId . '">
        </form>';
        fin_partage_vue();

  }
  else if ($commande == 'LANCER LA RECHERCHE DE PARTAGE') 
  {
        $rechdoc = $_POST['rechdoc'];
        $cId     = $_POST['cId'];
        echo '<div class="detail">
        <h1>Document recherché</h1><p class="oblique">Sélectionner le document et utilisez le bouton ACCES AU DOCUMENT.</p>';

        $docs = p_recherche_doc ($rechdoc);

        echo '<table border="1"><th class="noir" width=10%>Sel</th><th class="noir">Nom</th><th class="noir">Résumé</th><th class="noir">Dépôt par</th><th class="noir">Date</th><form method="post">';
        foreach ($docs as $doc)
        {
   
            echo '<tr><td class="noir"><input type="radio" name="cId" value="' . $doc->Id . '"></td><td class="noir">' . $doc->name . '</td><td class="noir">' . sup_anti_slash($doc->desc) . '</td><td class="noir">' . $doc->name_depot . '</td><td class="noir">' . $doc->date . '</td></tr>';          
        }
        echo '</table><h1>Recherche de documents</h1>
          <p class="oblique">Cette recherche se fait sur le nom des documents, leurs descriptions et leurs propriétaires</p>
          Entrer les caractères de votre recherche en minuscule
          <input type="text" name="rechdoc" value="' . $rechdoc . '">
          <input type="submit" name="commande" value="LANCER LA RECHERCHE DE PARTAGE"> 
          <input type="submit" name="commande" value="ACCES AU DOCUMENT PARTAGE SELECTIONNE">       
          <input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">
          </form>';
        fin_partage_vue();

  }    
  else if ($commande == 'DEPOSER UN DOCUMENT PARTAGE')
  {
    echo '<div class="detail">
          <h1>Dépôt d\'un document à partager</h1>';
    $cId = 0;

    
    echo '
    <form method="post" enctype="multipart/form-data">
    Document à déposer : <input type="file" id="file" name="mondoc" accept=".*">
    Résumé : <input type="text" name="desc" value="' . $desc . '"  > 
    <input type="submit" name="commande" value="ACQUERIR CE DOCUMENT PARTAGE">
    <input type="hidden" name="auth" value = "' . $auth . '">
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
    <input type="hidden" name="cx" value="' . $cx . '">  
    </form>';
    fin_partage_vue();
  }
  else if ($commande == 'ACQUERIR CE DOCUMENT PARTAGE')
  {
      $mondoc  = $_FILES['mondoc'];
      $desc    = $_POST['desc'];      
      $name    = $mondoc['name'];
      $tmp     = $mondoc['tmp_name'];


      echo '<div class="detail">
            <h1>Acquisition du fichier "' . $name . '"</h1>
            Résumé : ' . $desc . '<br>
            Déposé par : ' . $cadre_p . '<br>';

      $size = filesize($tmp);
      $dest = $DIR_PARTAGE . '/' . $name;

      $doc = p_extract_doc_name ($name);
      if (!empty($doc))
      {
        echo '<p class="oblique_bleu">Ce document "' . $name  . '"" existe déjà. Il sera remplacé par celui-ci.</p>';
        $cId = $doc->Id;

        if (move_uploaded_file ($tmp, $dest))
        {
          p_replace_doc ($cId, $desc, $cadre_p, $size);
          echo '<p>Le document "' . $name . '" a été remplacé</p>';
        }

      }
      else
      {
        if (move_uploaded_file ($tmp, $dest))
        {
          echo 'Le document ' . $name . ' a été enregistré<br>';

          $cId = p_getNewId();

          add_log ('Enregistrement du document : ' . $name );

          p_add_new_doc ($cId, $name, $desc, $cadre_p, $size);
                 
        }
      }
      fin_partage_vue();
    } 
  }


function fin_partage_vue()
{
    global $auth, $email, $cadre_p, $cx;

    echo '<p><form method="post">
        <input type="submit" name="commande"  value="ACCES A TOUS LES DOCUMENTS PARTAGES">
        <input type="submit" name="commande"  value="RECHERCHER DES DOCUMENTS PARTAGES" >
        <input type="submit" name="commande"  value="DEPOSER UN DOCUMENT PARTAGE" > 
        <input type="hidden" name="auth"      value="' . $auth . '">
        <input type="hidden" name="email"     value="' . $email . '">
        <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
        <input type="hidden" name="cx"        value="' . $cx . '">
        <input type="submit" name="commande" value="RETOUR MENU" style="background:#076899 !important;">
        </form></p></div><!--detail-->';
}  


//fonctions SQL base de données du partage
function p_extract_all_documents()
{
  global $wpdb2, $table_partage;
  $req = "SELECT * FROM " . $table_partage . " ORDER BY date";
  $rep = $wpdb2->get_results($req);
  return $rep;
}

function p_extract_doc_id ($cId)
{
  global $wpdb2, $table_partage;  
  $req = "SELECT * FROM " . $table_partage . " WHERE Id = " . $cId;
  $rep = $wpdb2->get_results($req);
  return $rep[0];
}

function p_extract_doc_name ($name)
{
  global $wpdb2, $table_partage;  
  $req = "SELECT * FROM " . $table_partage . " WHERE name = '" . $wpdb2->_real_escape($name) . "'";
  $rep = $wpdb2->get_results($req);
  return $rep[0];
}

function p_replace_doc ($cId, $desc, $cadre_p, $size)
{
  global $wpdb2, $table_partage;    
  $req = "UPDATE " . $table_partage . " SET `desc` = '" . $wpdb2->_real_escape($desc) . "', `date` = '" . 
          date('Y-m-d H:i:s') . "', `name_depot` = '" . $wpdb2->_real_escape($cadre_p) . "', 
          size =" . $size . " WHERE Id = " . $cId ; 
  $wpdb2->get_results($req);   
  if ($wpdb2->last_error)
  {
    echo 'Erreur sql<br>' . $req . '<br>';
    echo $wpdb2->last_error;
    return false;
  }
  else return true;
}      



function p_delete_doc_id ($cId)
{
  global $wpdb2, $table_partage;
  $req = "DELETE FROM " . $table_partage . " WHERE Id = " . $cId;
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
      echo $req . '<br>' . $wpdb2->last_error . '<br>';
      return false;
  }
  else return true;
}

function p_recherche_doc ($recherche)
{
  global $wpdb2, $table_partage;  
  $req = "SELECT * FROM " . $table_partage . " WHERE name LIKE '%%" . $recherche . "%%' 
               OR `desc` LIKE '%%" . $recherche . "%%' 
               OR name_depot LIKE '%%" . $recherche . "%%' ORDER BY date";
  $rep = $wpdb2->get_results($req);
  return $rep;
}

function p_add_new_doc ($cId, $name, $desc, $cadre_p, $size)
{
  global $wpdb2, $table_partage;  
  $req = "INSERT INTO " . $table_partage . " (Id, `name`, `desc`, `date`, `name_depot`, `size`) VALUES (" . $cId . ",'" . $wpdb2->_real_escape($name) . "','" . $wpdb2->_real_escape($desc) . "','" . date('Y-m-d H:i:s') . "','" . $wpdb2->_real_escape($cadre_p) . "'," . $size . ")";
  $wpdb2->get_results($req);  

  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    echo $wpdb2->last_error;
    return false;
  }
  return true;
}

function p_getNewId()
{
  global $wpdb2, $table_idu;
  $req = "SELECT IDU FROM " . $table_idu . " WHERE type = 'PARTAGE'";
  $rep = $wpdb2->get_results($req);
  $Id = $rep[0]->IDU + 1;
  $req = "UPDATE " . $table_idu . " SET IDU = " . $Id . " WHERE type = 'PARTAGE'";
  $wpdb2->get_results($req);
  return $Id;
}                       

?>