<?php

/* 
Template Name: TESTBLOC-NOTES
*/ 
define ('TEST', 1);   //c'est la version blocnote (0) ou testblocnote (1)
//version du 22/10/2025 avec les responsables d'activité

// v2.10  sans modification sortie et sans purge des fichiers d'export 
// v2.20  sans modification des sorties et avec purge des fichiers d'export
// v2.21  une unique commande php avec ajout echo 
// v2.25  blocage du nombre de sorties à une même date
// v2.26  avec le niveau de difficulté
// v2.27  Nom et prénom en majuscule - jj/mm/aaaa pour admin
// v3.00  Avec modification de sortie
// v3.10  Amélioration de l'export - retrait des ---- et articles numérotés
// v3.20  avec fonction nom du jour de la date
// v3.30  Correction de la fonction affich_sortie
// v4.00  Code lecture seulement de 0011 à 0019
// v5.00  WE et séjour
// v5.10  Export WE et Séjour
// v5.20  Finition administrateur sur historique
// v5.30  Form input en table
// v5.40  Couleur sur les input - tous les ... excepté date de fin de séjour + border-color:blue;
// v5.60  Correction nom de fichier
// v5.70  Blocage du code 2015
// v6.00  Avec autorisation programmée
// v6.10  Avec numérotation de la liste des sorties
// v6.20  Code 11 en lecture - filtrer les sorties antérieures à la date du jour
// v6.30  Affichage de la date du jour sur liste code 11
// v6.40  Tous les fichiers et dossiers sont dans le dossier CAF en tête de evolve
// V6.50  Suppression filtre nom du cadre et ajout liste du 4ième trimestre
// v6.60  Annonce code 11 pour tous et sup. accent cadre (wd_remove_accents)
// v7.00  Protection contre Georges Lavorel de saisie de date - 22/09/2021
// v7.10  Date de début et fin de trimestre
// v7.20  06/10/21 Les sorties deviennent des activités
// v7.30  Avec email de création
// v8.00  23/10/21 Sorties récurrentes - Titre détaché - Difficulté détachée 
// v8.30  18/11/21 Ajout ski de fond
// v8.40  01/12/21 Avec 5 niveaux de difficultés
// v8.50  27/12/21 Vue mensuelle des activités 
// v8.60  30/12/21 Calcul du tableau des kms
// v8.70  05/01/22 Activité admin Test
// v8.80  07/01/22 Anti répétition
// v9.00  19/04/2022 Heure php initilisé par date_default_timezone_set('Europe/Paris');
//        08/03/2023 Saut IDU à 8600 à partir de 8300 (sauter les anciens IDU de 8300 à 8600)
//        08/03/2023 Controle doublon fait pour les activités différentes de Club

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\RichText\RichText;
use PhpOffice\PhpSpreadsheet\Shared\Date;

use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

use PhpOffice\PhpSpreadsheet\Style\Conditional;

use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;

if (TEST == 1)
  require_once "test_functions_bd.php";
else
  require_once "cal_functions_bd.php";

?>
<style>

html, normal {
  font-weight: normal;
}

.detail {
  font-weight: lighter !important;
}

button[type=button] {
  background:#00A6D0 !important; /* bleu priorité absolue */
  border-radius: 5px !important; /* Force un faible arrondi */
    -webkit-border-radius: 5px !important; /* Compatibilité anciens navigateurs */
    -moz-border-radius: 5px !important;
  margin: 1px;
  border:none !important;
}

table.detail,tr.detail
{
  background : #ebf9b0;
  padding-bottom : 0px;
  padding-top : 0px;
  cellspacing : 0px !important;
  border:1;
}

table.detail { 
  border-spacing: 0px !important; 
} /* cellspacing */


th.detail, td.detail {
 padding: 0px !important; 
} 

</style>

<script>
function togglePassword() {
    const pwdField = document.getElementById("pwd");
    // Alterne entre 'password' et 'text'
    if (pwdField.type === "password") {
        pwdField.type = "text";
    } else {
        pwdField.type = "password";
    }
}
</script>

<?php

/*
    Single Post Part
    ======================================= */

/*
    Header Area
    --------------------------------------- */

get_header();

/*
  Before Content Area

  ---------------------------------------
  Hooked: evolve_primary_container_open() - 10
  --------------------------------------- */

do_action( 'evolve_before_content_area' );

/*
  Before Post Title

  ---------------------------------------
  Hooked: evolve_breadcrumbs() - 10
  --------------------------------------- */

do_action( 'evolve_before_post_title' );

/*
  Before Post Content

  ---------------------------------------
  Hooked: evolve_pagination_before() - 10
  --------------------------------------- */

do_action( 'evolve_before_post_content' );

if (TEST == 1) $title = 'TEST BLOC-NOTES';
else $title = 'BLOC-NOTES';
/*
echo '
<h1 class="post-title" itemprop="name">' . $title . '</h1>
<div class="post-content" itemprop="description">';
*/

/* ----
<p style="test-align:justify">
Cliquez sur les photos...</p>
---- */

  date_default_timezone_set('Europe/Paris');
  doc_submit();  // pour transformer les A HREF en form 

  
  $code_admin = '20152021';
  // ne surtout pas modifier TEST et ce qui suit 

  $dircf = extract_config_dir ('cal_param');
  
  $DIR_EVOLVE   = $dircf['dir_base'];
  $URLCAF       = get_site_url() . '/' . $dircf['dir_main'];
  $DIRCAF       = $dircf['dir_main'];
  $URL          = get_site_url() . '/' . $dircf['dir_data'];
  $DIR          = $dircf['dir_data'];
  $DIR_NOTES    = $DIR . '/NOTES';

  if (TEST == 1) {
      $DIR_DOC      = $DIR . '/DOC';
      $DIR_COFFRE   = $DIRCAF . '/COFFRE-FORT';
      $DIR_PARTAGE  = $DIRCAF . '/PARTAGE';
      $log          = $DIRCAF . '/LOG/bocnote-' . date('Ymd') . '.log';
      $table_cadre = 'test_cadre';
      $table_notes = 'test_notes';
      $table_activ = 'test_activ';
      $table_corbeille = 'test_corbeille';
      $table_cr    = 'test_cr';
      $table_partic = 'test_partic';
      $table_idu = 'test_idu';
      $table_adherent = 'test_adherent';
      $table_dia    = 'test_dia';
      $table_bloc_log = 'test_cal_log';
      $table_abonnement = 'test_abonnement';
      $table_escalade   = 'test_escalade';
      $table_coffre     = 'test_coffre';
      $table_partage    = 'test_partage';
      $table_matos      = 'test_matos';
      $table_assocb     = 'test_assocb';
      $table_param      = 'cal_param';
  }
  else {

      $DIR_DOC      = $DIR . '/DOC';
      $DIR_COFFRE   = $DIRCAF . '/COFFRE-FORT';
      $DIR_PARTAGE  = $DIRCAF . '/PARTAGE';
      $log          = $DIR_EVOLVE . '/LOG/bloc-note-' . date('Ymd') . '.log';
      $table_cadre = 'cal_cadre';
      $table_notes = 'cal_notes';
      $table_activ = 'cal_activ';
      $table_corbeille = 'cal_corbeille';
      $table_cr    = 'cal_cr';
      $table_partic = 'cal_partic';
      $table_idu = 'cal_idu';
      $table_adherent = 'cal_adherent';
      $table_dia    = 'cal_dia';
      $table_bloc_log = 'cal_cal_log';
      $table_abonnement = 'cal_abonnement';
      $table_escalade   = 'cal_escalade';
      $table_coffre     = 'cal_coffre';
      $table_partage    = 'cal_partage';
      $table_matos      = 'cal_matos';
      $table_assocb     = 'cal_assocb';
      $table_param      = 'cal_param';
  }      
  
  /* include "wp-admin/includes/file.php";*/

  
  $DIR_NOTES    = $DIR . '/NOTES';
  $DIR_CORBEILLE = $DIR . '/CORBEILLE';
  $DIR_EXPORT   = $DIR . '/EXPORT';
  $DIR_CR       = $DIR . '/CR';
  $DIR_OLDNOTES = $DIR . '/OLDNOTES';
  $DIR_OLDCR    = $DIR . '/OLDCR';
  $DIR_IMG      = $DIR . '/IMG';

  
/*  
  $f_auth = $DIR . '/auth';
  $fd_auth = fopen ($f_auth, 'r' );
  $status_auth = submoins1(fgets($fd_auth, 4096));
  $code_authc  = submoins1(fgets($fd_auth, 4096));

  $date_first  = submoins1(fgets($fd_auth, 4096));
  $date_last   = submoins1(fgets($fd_auth, 4096));
  $date_email  = submoins1(fgets($fd_auth, 4096));
  $date_collecte = submoins1(fgets($fd_auth, 4096));
  fclose ($fd_auth);
*/  
  $collecte = extract_collecte ('cal_param');
  $status_auth    = $collecte['status'];
  $date_first     = $collecte['date_deb'];
  $date_last      = $collecte['date_fin']; 
  $date_collecte  = $collecte['date_collecte']; 
  $code_auth      = $code_authc;

  $f_perso = $DIR . '/perso';
  $s_perso = "";
  if (file_exists($f_perso))
  { 
    $fd_perso = fopen ($f_perso, 'r');
    while (($buffer = fgets($fd_perso, 4096)) !== false) {
      $s_perso .= $buffer;
    }
    fclose ($fd_perso);
  }


  $bdconf = extract_config_bd($table_param);

  //echo 'DB2_USER:' . $bdconf['db2_user'] . ' DB2_PASS:' . $bdconf['db2_password'] . ' DB2_NAME:' . $bdconf['db2_name'] . ' DB2_HOST:' . $bdconf['db2_host'] . '<br>';
  $wpdb2 = new wpdb($bdconf['db2_user'],$bdconf['db2_password'],$bdconf['db2_name'],$bdconf['db2_host']);

  if ($wpdb2->last_error)
    echo 'Erreur de connexion : ' . $wpdb2->last_error . '<br>'; 


  $now    = time();
  $year   = date("Y", $now);
  $month  = date("n", $now); if ($month < 10) $month = '0' . $month;
  $day    = date("j", $now); if ($day   < 10) $day   = '0' . $day;
  $hour   = date("G", $now); if ($hour < 10)  $hour  = '0' . $hour;
  $minute = date("i", $now); //if ($minute < 10) $minute = '0' . $minute;
  $second = date("s", $now); //if ($second < 10) $second = '0' . $second;

  //echo 'Nous sommes le ' . $day . '/' . $month . '/' . $year . '<br>';

   $date_repet = $_POST['date_repet'];
   $auth       = $_POST['auth'];
   $activite   = $_POST['activite'];
   $factivite  = $_POST['factivite'];
   $fcadre     = $_POST['fcadre'];
   $cadre      = $_POST['cadre'];
   $cadre_p    = $_POST['cadre_p'];
   $date_deb   = $_POST['date_deb'];
   $detail     = $_POST['detail'];
   $file       = $_POST['file'];
   $commande   = $_POST['commande']; //echo sup_anti_slash($commande) . '<br>';
   $type       = $_POST['type'];
   $date_fin   = $_POST['date_fin'];
   $perso      = $_POST['perso'];
   $code       = $_POST['code'];
   $status     = $_POST['status'];
   $date_firstx = $_POST['date_firstx'];
   $date_lastx  = $_POST['date_lastx'];
   $date_emailx = $_POST['date_emailx'];
   $date_collectex = $_POST['date_collectex'];
   $diff        = $_POST['diff'];
   $titre       = sup_anti_slash($_POST['titre']);
   $dir         = $_POST['dir'];
   $xemail      = $_POST['xemail']; 
   $coencadrant = $_POST['coencadrant'];
   $denivele    = $_POST['denivele'];
   $cotation    = $_POST['cotation'];    //10/02/2025
   $kms         = $_POST['kms'];         //10/02/2025
   $bformation  = $_POST['bformation'];
   $collecte    = $_POST['collecte'];
   $formation   = $_POST['formation'];
   $IDU         = $_POST['IDU'];
   $CP          = $_POST['CP'];       //condition physique
   $CT          = $_POST['CT'];       //compétence technique
   $cx          = $_POST['cx'];
   $maxp        = $_POST['maxp'];
   $dossier     = $_POST['dossier'];
   $dos_name    = $_POST['dos_name'];
   $ete         = $_POST['ete']; 
   $hiver       = $_POST['hiver'];

if (date('Y-m-d') >= date('Y'). '-09-01' && date('Y-m-d') < date('Y') . '01-01')
{
   $annee_escalade = date('Y');
   $annee_licence  = date('Y')+1;
}
else
{
  $annee_escalade = date('Y') - 1;
  $annee_licence  = date('Y');
}

   
//if (!isset($commande))  $commande = 'commande';
if (!isset($cx))        $cx = rand(1000,9999);   //attribution d'un identifiant
if (!isset($factivite)) $factivite="toutes";
if (!isset($diff))      $diff='sans';
if (isset($fcadre) && strlen($fcadre) > 2) 
  $fcadre=sup_anti_slash($fcadre);

$code_admin = 'ADMIN';
$code_cadre = 'ENCADRANT'; 
//echo '<p style="test-align:justify">';

if (TEST == 1) $Test = 'TEST'; else $Test='';


//compatibilité calendrier
$quand="ici";

if ($commande == 'Connexion cadre' || $commande == 'Connexion externe')
{
  //echo 'Controle des données de connexion<br>';
  $pass = $_POST['pass']; 
  $identifiant = $_POST['identifiant']; 
  $quand       = $_POST['quand'];
  $factivite   = $_POST['factivite'];

  //recherche les données du cadre dans la table des cadres avec l'identifiant unique de connexion
  $data_cadre = extract_cadre_ident ($identifiant);

  //echo $identifiant. ' ' . $pass . '<br>';
  //print_r ($cadre);
  //echo 'Pass : ' . $pass . ' - ' . hash('sha256', $pass);
  //echo $commande . '<br>';
  if ($commande == 'Connexion externe' || hash('sha256', $pass) == $data_cadre->password)
  {

    //echo '<p>Bonjour ' . $data_cadre->nick_name . '. Vous êtes autorisé à utilisez cette application.</p>';
    $auth = $code_encadrant;
    if (strstr($data_cadre->titre, 'Webmaster')) 
      $auth = $code_admin;

    $commande = 'RETOUR MENU';
    $cx = substr(strtolower(remove_accents($data_cadre->prenom)),0,1) . 
          substr(strtolower(remove_accents($data_cadre->nom)),0,7);
    //$cx = substr(strtolower($data_cadre->nom),0,4);

    //$cadre_p = recherche_cadre_2 ($cadre->nom, $cadre->prenom);
    $cadre_p = $data_cadre->nick_name;
    
    //$cadre = strtoupper(remove_accents($data_cadre->nick_name));
    //echo $cadre;
    add_log ('Connexion avec mot de passe réussie pour ' . $cadre_p);
  }
  else
  {
    add_log ('Erreur de connexion avec l\'identifiant ' . $identifiant);
    echo '<font color="red"><p>Erreur de connexion avec l\'identifiant <b>' . $identifiant . '</b> - recommencer et vérifier votre mot de passe</p></font>';
    $cadre_p = '';
  }
}

  if ($commande == 'Création identifiant et mot de passe')
    if (creation_identifiant_et_mot_de_passe()) $commande = 'ENCADRANT CAF MEYTHET';

  if (strstr($commande, 'Procédure identifiant') )
    procedure_mot_de_passe_oublie_ph_1();
  else if ($commande == 'Envoi de votre adresse')
    procedure_mot_de_passe_oublie_ph_2();

  if ($commande == 'CONNEXION')
  {
    $cadre_p = $_POST['ccadre'];
  }
  else if ($commande == 'ENVOI CADRE ET CODE')
  {
    $auth = hash('sha256', $auth);
    //echo 'Controle du cadre<br>';
    $precadre = $_POST['precadre'];
    //echo $auth . ' - ' . $precadre . ' - code_auth = ' . $code_auth . '<br>';
    if ($auth == $code_admin || $auth == $code_auth)
    {
      //Recherche du cadre
      $cadre_pr = recherche_cadre ($precadre);

      if (sizeof($cadre_pr) == 1)
          $cadre_p = $cadre_pr;
      else 
      {
        echo '<p>Choisir le profil à connecter au bloc-notes</p>
              <form method="post">
              <input type="radio" checked name="ccadre" value="' . $cadre_pr[0] . '">' . $cadre_pr[0] .  '
              <input type="radio" name="ccadre" value="' . $cadre_pr[1] . '">' . $cadre_pr[1] .  '<br>
              <input type="hidden" name="auth" value="' . $auth . '">
              <input type="submit" name="commande" value="CONNEXION"></form>';
      }
      
     }
     else
        $auth='';
  }

  if (!isset($cadre_p) || ($auth != $code_admin && $auth != $code_auth) )
  {
    if (isset($cadre_pr) && sizeof($cadre_pr) == 2)
    {
       echo '';
    }
  }
  //if (!(strstr($commande, 'Procédure') || strstr($commande, 'adresse'))) 
  if (!isset($commande))
  {
      echo '<div class="detail">';
      
     $identifiant = $_POST['identifiant'];
      echo '<h1>CONNEXION ENCADRANT</h1>
      Cette application <b>BLOC-NOTES</b> est réservée exclusivement aux encadrants du CAF de Meythet pour la préparation de leurs activités.<br>';
      //if ($status_auth == 'close')
      echo 'Pour modifier une activité il est nécessaire d\'utiliser le <a href="https://www.cafmeythet.org/wp/' . $Test . 'CALENDRIER/"><b>' . $Test . 'CALENDRIER des activités</b></a>
      <p class="oblique">La connexion au bloc-notes se fait avec les mêmes identifiants et mot de passe que vous utilisez sur le calendrier en ADHERENT. En cas de problème contacter le webmaster.<br>Michel Brusa.</p>
      <form method="post">
      <table><tr><td>Identifiant</td><td><input type="text" name="identifiant" value="' . $identifiant . '"></td></tr>
      <tr><td>Mot de passe</td><td><input type="password" id="pwd" size="8" name="pass" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr></table>
      <input type="submit" name="commande" value="Connexion cadre">
      <button type="button" onclick="togglePassword()">Mot de passe en clair</button>
      <input type="hidden" name="IDU" value="' . $IDU .'">
      <input type="hidden" name="quand" value="' . $quand . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      </form></div><!--detail-->';
      //<input type="submit" name="commande" value="Procédure identifiant ou mot de passe oublié cadre">
  }
  else if ($commande == 'ENVOI CADRE ET CODE' || $commande == 'CONNEXION' || strstr($commande, 'RETOUR'))
  {
    //echo 'COM = ' . $commande . '<br>';
    echo '<div class="detail">';
    $img_cadre = getImgCadre ($cadre_p);
    if ($img_cadre) echo '<IMG src="' . get_site_url() . '/' . $DIRCAF . '/trombi-images/tmb/' . $img_cadre . '" width="80px" align="right">';
    if ($commande == 'ENVOI CADRE ET CODE' || $commande == 'CONNEXION')
    {
      echo '<b>Bonjour ' . $cadre_p . '</b><br>';
      add_log ('Connexion ' . $cadre_p);
    }
    else
      echo '<b>' . $cadre_p . '</b>,<br>';
    $c_activite = extract_activite_cadre ($cadre_p);
    $activite = explode(",", $c_activite);
    if ($c_activite == '') $activite =array();
    switch (sizeof($activite))
    {
      case 0: echo 'Vous n\'encadrez aucune activité'; break;
      case 1: echo 'Vous êtes encadrant de l\'activité <b>' . $activite[0] . '</b><br>'; break;
      default: echo 'Vous encadrez les activités suivantes : ';
           for ($i=0; $i <sizeof($activite); $i++)
             echo '<b>' . $activite[$i] . '</b>, ';
    }
    $c_fonction = extract_fonction_cadre ($cadre_p);
    $fonction = explode (',', $c_fonction);
    if ($c_fonction != '')
    {
      switch (sizeof($fonction))
      {
        case 0 : break;
        case 1 : echo '<br>Fonction : <b>' . $fonction[0] . '</b><br>'; break;
        default : echo '<br>Fonctions : ' ;
             for ($i=0; $i <sizeof($fonction); $i++)
               echo '<b>' . $fonction[$i] . '</b>,';
      }
    }

    //if (stristr($c_fonction, 'webmaster'))  $auth=$code_admin;
    
    menu_principal();
    echo '</div><!--detail-->';
  }
  else if (strstr($commande, 'LISTE DES ACTIVITES'))
  {
    echo '<div class="detail">';
    if (!isset($factivite) || $factivite == '') 
      $factivite="toutes";
    add_log ($commande);

  $tri=1;
  if (!strstr($commande, "COLLECTE"))
      echo '<h1>Liste des activités</h1>';
  else
      echo '<h1>Collecte du ' . getJourDate($date_first) . ' au ' . getJourDate($date_last) . '</h1>';
  //Filtre de la liste des sorties
  echo '<div class="filtre"><form method="post">
  <b>RECHERCHER LES ACTIVITES </b><br>';

  echo '<b>Activité: </b>';
   if ($factivite == 'toutes')
     echo '<input type="radio" checked name="factivite" value="toutes"/>Toutes ';
   else
     echo '<input type="radio" name="factivite" value="toutes"/>Toutes ';
   if ($auth == $code_admin)
   {
       if ($factivite == 'Test')
        echo '<input type="radio" checked name="factivite" value="Test"/>Test ';
      else
        echo '<input type="radio" name="factivite" value="Test"/>Test '; 
   }
   if ($factivite == 'Alpinisme')
      echo '<input type="radio" checked name="factivite" value="Alpinisme"/>Alpinisme ';
   else
      echo '<input type="radio" name="factivite" value="Alpinisme"/>Alpinisme ';
   if ($factivite == 'Club')
      echo '<input type="radio" checked name="factivite" value="Club"/>Club ';
   else
      echo '<input type="radio" name="factivite" value="Club"/>Club '; 
   if ($factivite == 'Cascade de glace')
      echo '<input type="radio" checked name="factivite" value="Cascade de glace"/>Cascade de glace ';
   else
      echo '<input type="radio" name="factivite" value="Cascade de glace"/>Cascade de glace ';
   if ($factivite == 'Escalade')
      echo '<input type="radio" checked name="factivite" value="Escalade"/>Escalade ';
   else
      echo '<input type="radio" name="factivite" value="Escalade"/>Escalade ';
   if ($factivite == 'Escalade en falaise')
      echo '<input type="radio" checked name="factivite" value="Escalade en falaise"/>Escalade en falaise ';
   else
      echo '<input type="radio" name="factivite" value="Escalade en falaise"/>Escalade en falaise';
   if ($factivite == 'Formation')
      echo '<input type="radio" checked name="factivite" value="Formation"/>Formation ';
   else
      echo '<input type="radio" name="factivite" value="Formation"/>Formation ';
   if ($factivite == 'Kayak')
      echo '<input type="radio" checked name="factivite" value="Kayak"/>Kayak ';
   else
      echo '<input type="radio" name="factivite" value="Kayak"/>Kayak ';
   if ($factivite == 'Marche nordique')
      echo '<input type="radio" checked name="factivite" value="Marche nordique" />Marche nordique ';
   else
      echo '<input type="radio" name="factivite" value="Marche nordique" />Marche nordique ';
   if ($factivite == 'Ski alpin')
      echo '<input type="radio" checked name="factivite" value="Ski alpin"/>Ski alpin ';
   else
      echo '<input type="radio" name="factivite" value="Ski alpin"/>Ski alpin ';
   if ($factivite == 'Ski de fond')
      echo '<input type="radio" checked name="factivite" value="Ski de fond"/>Ski de fond ';
   else
      echo '<input type="radio" name="factivite" value="Ski de fond"/>Ski de fond ';

   if ($factivite == 'Ski de randonnée')
          echo '<input type="radio" checked name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
   else
      echo '<input type="radio" name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
   if ($factivite == 'Ski de randonnée nordique')
          echo '<input type="radio" checked name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   else
          echo '<input type="radio" name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   if ($factivite == 'Trail')
          echo '<input type="radio" checked name="factivite" value="Trail">Trail ';
   else
          echo '<input type="radio" name="factivite" value="Trail">Trail ';        
   if ($factivite == 'Randonnée alpine')
      echo '<input type="radio" checked name="factivite" value="Randonnée alpine" />Randonnée alpine ';
   else
      echo '<input type="radio" name="factivite" value="Randonnée alpine" />Randonnée alpine ';
   if ($factivite == 'Randonnée pédestre')
      echo '<input type="radio" checked name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
   else
      echo '<input type="radio" name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
   if ($factivite == 'Raquettes')
      echo '<input type="radio" checked name="factivite" value="Raquettes"/>Raquettes ';
   else
      echo '<input type="radio" name="factivite" value="Raquettes"/>Raquettes ';

   if ($factivite == 'Via ferrata')
          echo '<input type="radio" checked name="factivite" value="Via ferrata"/>Via ferrata ';
   else
          echo '<input type="radio" name="factivite" value="Via ferrata"/>Via ferrata ';
   if ($factivite == 'VTT')
          echo '<input type="radio" checked name="factivite" value="VTT"/>VTT ';
   else
          echo '<input type="radio" name="factivite" value="VTT"/>VTT ';

   echo '<br><table style="background-color:#a5a4a7;"><tr><td><b>RECHERCHE</b></td>
         <td><input type="text" name="fcadre" value="' . $fcadre . '" placeholder="encadrant ou titre ou jj/mm/aaaa"/></td></tr>
         <tr><td><input type="submit" class="bouton" name="x" value="CHERCHER"/></td><td></td></tr></table>';
         if (strstr($commande, 'ANCIENNES'))
          echo '<input type="hidden" name="commande" value="LISTE DES ACTIVITES ANCIENNES"/>';
         else
          echo '<input type="hidden" name="commande" value="LISTE DES ACTIVITES"/>';
         echo '
          <input type="hidden" name="dir" value="' . $dir . '">
          <input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="cx" value="' . $cx . '">
          <input type="hidden" name="cadre" value = "'. $cadre . '">
          <input type="hidden" name="cadre_p" value = "'. $cadre_p . '">
          <input type="hidden" name="commande" value = "'. $commande . '">
          </form></div>';


        
        echo '</h1> <p class="oblique">Les activités du même jour sont affichées dans l\'ordre de saisie ou de modification.</p>';
        if ($auth > 2000)
           echo '<p class="oblique"><font color="f38210">Vous pouvez modifier ou supprimer une activité en cliquant sur la date en couleur d\'une sortie (bleu pour à la journée, vert pour les WE, rouge pour les séjours)</font></p>';
 
        $tjour = time();

        if (strstr($commande, 'COLLECTE'))
        {
          //echo $date_first . '<br>';
          $scan = extract_activ_collecte ($date_first, $date_last);
          //print_r ($scan);
        }
        else if (strstr($commande, 'ANCIENNES'))
        {
          //echo 'Rétroactif<br>';
          $scan = extract_activ_retroactive (date ('Y-m-d'));
          //print_r ($scan);
        }
        else
        {
          //echo 'Les avenir<br>';
          $scan = extract_activ_avenir (date ('Y-m-d'));
          //print_r ($scan);
        }

        $date_search = '';
        if (strlen($fcadre) == 10 && substr($fcadre, 2,1) == '/' && substr($fcadre, 5,1) == '/')
        {
          $date_search = substr($fcadre,6,4) . '-' . substr($fcadre, 3,2) . '-' . substr($fcadre,0,2);
          if (strstr($commande, 'COLLECTE') && ($date_search < $date_first || $date_search > $date_last))
            echo '<font color="red">Date de recherche en dehors de la collecte et ignorée</font>';
          //else echo 'Recherche par date ' . $fcadre . ' - Date norm : ' . $date_search . '<br>';
        }
              //$bvis = true;
            
        foreach ($scan as $note)
        {
          $cadrel = $note->cadre;
          $acti   = $note->activite;
          $diff   = $note->diff;
          $titre  = $note->titre;
          $CP     = $note->CP;
          $CT     = $note->CT;
          if (strstr($commande, 'COLLECTE') && $note->type != 'J') continue;

         $bvis = true;
         if ($date_search != '' && $note->date_deb != $date_search) continue;
         
         if ($date_search == '' && strlen($fcadre) > 0 && (!(stristr($cadrel, $fcadre) || stristr(wd_remove_accents($titre), wd_remove_accents($fcadre))))) continue;
         
         
          if ($factivite != "toutes")
          {
            if ($acti != $factivite)
              $bvis = false;
          }
          
          if ($bvis)
          {
            //echo 'affichage de la note ' . $note->IDU . '<br>';

            affich_detail_bloc ($note->IDU);

            echo '<hr>';

          }
          
        }

        //echo '</table>';
        echo '<form method="post"><input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="cx" value="' . $cx . '"/>
          <input type="hidden" name="factivite" value="' . $factivite . '">
          <input type="hidden" name="fcadre" value="' . $fcadre . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cadre" value="' . $cadre . '">';
          retour_menu();
          echo '</form></div>';
  }
  else if (sup_anti_slash($commande) == "RESPONSABLES D'ACTIVITE")
  {
    echo '<div class="detail">
    <h1>Responsables d\'activité</h1>
    <p class="oblique_bleu">Si vous voyez une erreur dans cette liste, me contacter pour faire la correction</p>';
    $req = "SELECT * FROM cal_cadre WHERE titre LIKE '%%RA%%'";
    $rep = $wpdb2->get_results($req);

    foreach ($rep as $cadre)
    {
      $tab = explode(",", $cadre->titre);
      foreach ($tab as $ra)
      {
        if (strstr($ra, 'RA')) echo $ra . ' : ' . $cadre->nick_name . '<br>';;
      }
      
    }

    echo '<form method="post">';
      retour_menu();
      echo '<input type="hidden" name="auth" value="' . $auth . '">
      <input type="hidden" name="cx" value="' . $cx . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="fcadre" value="' . $fcadre . '">
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">      
      </form></div>';     

}
else if (strstr($commande, 'CONSULTATION CORBEILLE'))
{
  add_log ($commande);
  if($fcadre == '') $fcadre = $cadre_p;
  $tri=1;
 
  echo '<div class="detail">
        <h1><font color="red">Liste des activités de la corbeille</font></h1>';
  
  //Filtre de la liste des sorties
  echo '<div class="filtre"><form method="post">
  <b>RECHERCHER LES ACTIVITES </b><br>';

  echo '<b>Activité: </b>';
   if ($factivite == 'toutes')
     echo '<input type="radio" checked name="factivite" value="toutes"/>Toutes ';
   else
     echo '<input type="radio" name="factivite" value="toutes"/>Toutes ';
   if ($auth == $code_admin)
   {
       if ($factivite == 'Test')
        echo '<input type="radio" checked name="factivite" value="Test"/>Test ';
      else
        echo '<input type="radio" name="factivite" value="Test"/>Test '; 
   }
   if ($factivite == 'Alpinisme')
      echo '<input type="radio" checked name="factivite" value="Alpinisme"/>Alpinisme ';
   else
      echo '<input type="radio" name="factivite" value="Alpinisme"/>Alpinisme ';
   if ($factivite == 'Club')
      echo '<input type="radio" checked name="factivite" value="Club"/>Club ';
   else
      echo '<input type="radio" name="factivite" value="Club"/>Club '; 
   if ($factivite == 'Cascade de glace')
      echo '<input type="radio" checked name="factivite" value="Cascade de glace"/>Cascade de glace ';
   else
      echo '<input type="radio" name="factivite" value="Cascade de glace"/>Cascade de glace ';
   if ($factivite == 'Escalade')
      echo '<input type="radio" checked name="factivite" value="Escalade"/>Escalade ';
   else
      echo '<input type="radio" name="factivite" value="Escalade"/>Escalade ';
   if ($factivite == 'Escalade en falaise')
      echo '<input type="radio" checked name="factivite" value="Escalade en falaise"/>Escalade en falaise ';
   else
      echo '<input type="radio" name="factivite" value="Escalade en falaise"/>Escalade en falaise';
   if ($factivite == 'Formation')
      echo '<input type="radio" checked name="factivite" value="Formation"/>Formation ';
   else
      echo '<input type="radio" name="factivite" value="Formation"/>Formation ';
   if ($factivite == 'Kayak')
      echo '<input type="radio" checked name="factivite" value="Kayak"/>Kayak ';
   else
      echo '<input type="radio" name="factivite" value="Kayak"/>Kayak ';
   if ($factivite == 'Marche nordique')
      echo '<input type="radio" checked name="factivite" value="Marche nordique" />Marche nordique ';
   else
      echo '<input type="radio" name="factivite" value="Marche nordique" />Marche nordique ';
   if ($factivite == 'Ski alpin')
      echo '<input type="radio" checked name="factivite" value="Ski alpin"/>Ski alpin ';
   else
      echo '<input type="radio" name="factivite" value="Ski alpin"/>Ski alpin ';
   if ($factivite == 'Ski de fond')
      echo '<input type="radio" checked name="factivite" value="Ski de fond"/>Ski de fond ';
   else
      echo '<input type="radio" name="factivite" value="Ski de fond"/>Ski de fond ';

   if ($factivite == 'Ski de randonnée')
          echo '<input type="radio" checked name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
   else
      echo '<input type="radio" name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
   if ($factivite == 'Ski de randonnée nordique')
          echo '<input type="radio" checked name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   else
          echo '<input type="radio" name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   if ($factivite == 'Randonnée alpine')
      echo '<input type="radio" checked name="factivite" value="Randonnée alpine" />Randonnée alpine ';
   else
      echo '<input type="radio" name="factivite" value="Randonnée alpine" />Randonnée alpine ';
   if ($factivite == 'Randonnée pédestre')
      echo '<input type="radio" checked name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
   else
      echo '<input type="radio" name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
   if ($factivite == 'Raquettes')
      echo '<input type="radio" checked name="factivite" value="Raquettes"/>Raquettes ';
   else
      echo '<input type="radio" name="factivite" value="Raquettes"/>Raquettes ';
   
   if ($factivite == 'Trail')
          echo '<input type="radio" checked name="factivite" value="Trail">Trail ';
   else
      echo '<input type="radio" name="factivite" value="Trail">Trail ';
   
   if ($factivite == 'Via ferrata')
          echo '<input type="radio" checked name="factivite" value="Via ferrata"/>Via ferrata ';
   else
          echo '<input type="radio" name="factivite" value="Via ferrata"/>Via ferrata ';
   if ($factivite == 'VTT')
          echo '<input type="radio" checked name="factivite" value="VTT"/>VTT ';
   else
          echo '<input type="radio" name="factivite" value="VTT"/>VTT ';

   echo '<br><table style="background-color:#a5a4a7;"><tr><td><b>RECHERCHE</b></td>
         <td><input type="text" name="fcadre" value="' . $fcadre . '"></td></tr>
         <tr><td><input type="submit" class="bouton" name="x" value="CHERCHER"/></td><td></td></tr></table>
         <input type="hidden" name="commande" value="CONSULTATION CORBEILLE">
         <input type="hidden" name="dir" value="' . $dir . '">
          <input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="cx" value="' . $cx . '">
          <input type="hidden" name="cadre_p" value = "'. $cadre_p . '">
          </form></div>';

        if ($auth > 10 && $auth < 19)
        {
          //construction d'une entete fictive date du jour
          $jour = $year . $month . $day;
          echo '<b>au ' . getJourDate($jour) . '</b>';
        }
        
        echo '</h1> <p class="oblique">Les activités du même jour sont affichées dans l\'ordre de saisie ou de modification.</p>';
        if ($auth > 2000)
           echo '<p class="oblique"><font color="f38210">Vous pouvez restaurer ou supprimer une activité en cliquant sur la date en couleur d\'une sortie (bleu pour à la journée, vert pour les WE, rouge pour les séjours)</font></p>';
         /*
        echo '<table border="1">
        <tr><th>Date activité</th><th>Encadrant</th><th>Type</th><th>Activité (extrait)</th></tr>';
        */
        $tjour = time();


        $scan = extract_all_corbeille();


        
        foreach ($scan as $note)
        {
          $cadrel = $note->cadre;
          $acti   = $note->activite;
          $diff   = $note->diff;
          $titre  = $note->titre;

         $bvis = true;
         $date_search = '';
         if (strlen($fcadre) == 10 && substr($fcadre, 2,1) == '/' && substr($fcadre, 5,1) == '/')
         {
          $date_search = getEnteteDateFr($fcadre);
          //echo 'Recherche par date ' . $fcadre . ' - Date d\'entête : ' . $date_search . '<br>';
            if (substr($scan[$i],0,8) == $date_search)
              $bvis = true;
            //echo 'Find !';
          }
          else
          {
            if (strlen($fcadre) > 0 && !stristr($cadrel, $fcadre)) continue;
          }
          
          if ($factivite != "toutes")
          {
            if ($acti != $factivite)
              $bvis = false;
          }
          
          if ($bvis)
          {
            affich_detail_corbeille ($note->IDU);
            echo '<hr>';

          }
          
        }
        $nbre = extract_nbre_corbeille();
        
        //echo '</table>';
        echo '<form method="post"><input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="cx" value="' . $cx . '"/>
          <input type="hidden" name="factivite" value="' . $factivite . '">
          <input type="hidden" name="fcadre" value="' . $fcadre . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">';
          if ($nbre > 0 && $auth == $code_admin)
            echo '<input type="submit" name="commande" value="VIDER LA CORBEILLE" style="background:green !important;" Title="Supprimer toutes les sorties de la corbeille">';
          retour_menu();
          echo '</form></div>';
       
      }
      else if ($commande == 'AUTORISATION')
      {
         add_log ($commande);
         echo '<div class="detail"><h2>Gestion des autorisations</h2>
         <form method="post">
         Autoriser les encadrants pour la collecte trimestrielle : ';
         if ($status_auth == 'open')
           echo '<input type="radio" checked name="status" value="OUI"/>OUI
           <input type="radio" name="status" value="NON"/>NON ';
         else
           echo '<input type="radio" name="status" value="OUI"/>OUI
           <input type="radio" checked name="status" value="NON"/>NON ';
         echo '<br>Code autorisation des encadrants (supérieur à 999) :
           <input type="number" name="code" value="' . $code_authc . '"/><br>
         Premier jour du trimestre : <input type="date" name="date_firstx" value="' . $date_first . '" /><br>
         Dernier jour du trimestre : <input type="date" name="date_lastx" value="' . $date_last . '" /><br>
         Date de surveillance par email : <input type="date" name="date_emailx" value="' . $date_email . '" /><br>
         Date de début de collecte : <input type="date" name="date_collectex" value="' . $date_collecte . '" /><br>
         Message perso : <br>
         <TEXTAREA  name="perso" rows="3" cols="90" >' . sup_anti_slash($s_perso) . '</TEXTAREA><br>
         <input type="submit" name="commande"     value="MODIFIER">';
         retour_menu();
         echo '<input type="hidden" name="auth"         value="' . $auth . '">
         <input type="hidden" name="fcadre"       value="' . $fcadre . '">
         <input type="hidden" name="cadre_p"      value="' . $cadre_p . '">
         <input type="hidden" name="factivite"    value="' . $factivite . '">
         <input type="hidden" name="cx"           value="' . $cx . '">      
         </form></div><!--detail-->';
  }
  else if ($commande == 'VIDER LA CORBEILLE')
  {
      add_log ($commande);
      $nbre = extract_nbre_corbeille();

      echo '<div class="detail"><h1>Confirmation pour vider la corbeille</h1>
      <p>Il y a ' . $nbre . ' activités en corbeille . Cette commande qui vide toutes les activités d\un encadrant donné doit être confirmée pour être exécutée.</p>
      <form method="post">
      <input type="hidden" name="auth" value="' . $auth . '"/>
       <input type="hidden" name="cx" value="' . $cx . '"/>
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
       Prénom et nom du cadre : <input type="text" name="cadre" >
       <input type="submit" name="commande" value="CONFIRMER LE VIDAGE DE LA CORBEILLE">'; 
       retour_menu();
       echo '</form>
       </div><!--detail-->';
  }
  else if ($commande == 'CONFIRMER LE VIDAGE DE LA CORBEILLE')
  {
      add_log ($commande);
      $nbre = extract_nbre_corbeille();

      vidage_corbeille($cadre);

      echo '<div class="detail"><h1>Vidage complet de la corbeille</h1>
      <p>Les ' . $nbre . ' activités de la corbeille ont été supprimées.</p>
      <form method="post">
      <input type="hidden" name="auth" value="' . $auth . '">
       <input type="hidden" name="cx" value="' . $cx . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">';
      retour_menu();
      echo '</form></div><!--detail-->';
  }
  else if ($commande == 'RESTAURER CETTE ACTIVITE')
  {
      echo '<div class="detail"><h1>Restauration d\'une activité : IDU = ' . $IDU .'</h1>';
      $note = extract_corbeille_idu ($IDU);
      if (extract_activ_idu ($IDU) == false)
      {
        if (restauration_corbeille ($IDU)) 
        {
          
          delete_corbeille_idu ($IDU);
          update_delete_base ($IDU, $note->ident, 'Restauration corbeille');
          affich_detail_bloc ($IDU);
          echo 'La restauration de l\'activité est faite<br>';
        }
        else
        {
          echo 'La restauration de l\'activité en corbeille n\'a pas pu se faire';
        }
      }
      else
      {
        echo '<font color="red">Cette activité avec l\'IDU ' . $IDU . ' a déjà été restaurée. </font>';
      }

      affich_retour_blocnote ($IDU);
      echo '</div><!--detail-->'; 
  }
  else if ($commande == 'MODIFIER')
  {
     add_log ($commande);
     echo '<div class="detail"><h1>Enregistrement des autorisations</h1>';
     unlink ($f_auth);
     unlink ($f_perso);
     $fd_auth = fopen ($f_auth, 'w');
     if ($status == 'OUI')
     {
        echo 'Collecte ouverte<br>';
        add_log ($commande . ' - Collecte ouverte');
        fputs ($fd_auth, "open\n");
     }
     else if ($status == 'NON')
     {
        echo 'Collecte fermée<br>';
        add_log ($commande . ' - Collecte fermée');
        fputs ($fd_auth, "close\n");
     }
     fputs ($fd_auth, $code . "\n");
     fputs ($fd_auth, $date_firstx . "\n");
     fputs ($fd_auth, $date_lastx . "\n");
     fputs ($fd_auth, $date_emailx . "\n");
     fputs ($fd_auth, $date_collectex . "\n");
     fclose ($fd_auth);

     if ($code == $code_auth)
        echo 'Le code encadrant n\'est pas modifié<br>';
     $fd_perso = fopen ($f_perso, 'w');
     fwrite ($fd_perso, $perso);
     fclose ($fd_perso);
     affich_retour_blocnote(0);
     echo '</div>';
  }
  else if ($commande == 'STATISTIQUES')
  {
    $cadre_stat = $_POST['cadre_stat'];
    $date_d = $_POST['date_deb_stat'];
    $date_f = $_POST['date_end_stat']; 

    
    if ($date_d == '') 
    {
      //$cadre_stat = strtoupper(wd_remove_accents(extract_nom_cadre($cadre_p)));
      $cadre_stat = ''; 
    }
    
    
    add_log ($commande);
    //recherche du dernier CR des anciens comptes-rendus
    $scan = extract_activ_avec_cr ();
   
    $date_max = $scan[sizeof($scan)-1]->date_deb;

    echo '<div class="detail">
    <h1>Statistiques</h1>
    Cette fonction est essentiellement basé sur les données des comptes-rendus de sortie, ceux-ci sont indispensables pour avoir de bonnes statistiques des activités du club.<br>
    <form method="post">
    <p><input type="hidden" name="auth" value="' . $auth . '"/>
       Date de début : <input type="date" name="date_deb_stat" min="2021-04-01" value="' . get_debut_saison() . '" required> - 
       Date de fin :   <input type="date" name="date_end_stat" min="2021-04-01" max = "' . date('Y-m_d') . '" value="' . date('Y-m-d') . '"  required></p>
       Nom du cadre (tous si vide) : <input type="text" name="cadre_stat" value="' . $cadre_stat . '">
       <input type="hidden" name="cx" value="' . $cx . '"/>
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
    <input type="submit" name="commande" value="CALCUL DES STATISTIQUES">';
    retour_menu();
    echo '<br></form></div>';
  }
  else if ($commande == 'CALCUL DES STATISTIQUES') 
  {    
    $cadre_stat = $_POST['cadre_stat'];
    $date_d = $_POST['date_deb_stat'];
    $date_f = $_POST['date_end_stat'];
     echo '<div class="detail">';

    //echo 'Date départ : ' . $date_d . '<br>';
    $activite=array();
    $t=1;
    $not=0; $ns+0; $nbr=0;
    echo '<h2>' . $t++ . '- Sorties ' . $cadre_stat . ' entre le ' . getDateFr($date_d) . ' et le ' . getDateFr($date_f) . '</h2>';
    add_log ($commande . ' - du ' . $date_d . ' au ' . $date_f);

    $scan = extract_activ_statistique ($date_d, $date_f, $cadre_stat);
    echo 'nbre de sortie totale ' . sizeof($scan) . '<br>';
    foreach ($scan as $note)    
    {
       if ($note->annulation == 1 || $note->report != '' || $note->avance != '')   continue;   
              
       if ($cadre_stat != ''  && !stristr($note->cadre, $cadre_stat)) continue;

       $activ = $note->activite; 

       if ($activ != 'Club')
          $not++;
    }


    $scan = extract_activ_collecte ($date_d, $date_f);
    
    foreach ($scan as $note)    
    {
       if ($note->annulation == 1 || substr($note->report,0,1) == 2 || substr($note->avance,0,1) == 2)   
        {
             continue;
        }   
    
       


       if ($cadre_stat != ''  && !stristr($note->cadre, wd_remove_accents($cadre_stat))) continue;
       if ($note->activite != 'Club' && $note->annulation == 0)
        $ns++;

       if ($note->cr == 1) $not++;
       $demijp = extract_cr_demijp ($note->IDU);
       if ($demijp == '') $demijp = 0;
       $part = abs(extract_cr_participants($note->IDU));
       if ($demijp == 0 && ($note->activite == 'Escalade' || $note->activite == 'Marche nordique'))
          $part = $part/2; 
       //tenir compte du nombre de jour
        $tF=strtotime($note->date_fin);
        $tD=strtotime($note->date_deb);
        $nbj = round((($tF - $tD)/86400) + 1, 0);

       $part = $part * $nbj;
     
       $nbr += $part;
       //echo $part;
       $find=false;
       for ($j=0; $j<sizeof($activite); $j++)
       {
          if ($note->formation == 0)
          {
            if ($activite[$j]['activ'] == $note->activite)
            {
              $activite[$j]['count'] += 1;
              $activite[$j]['jourp'] += $part;
              $find = true;
              break;
            }
          }
          else // si formation
          {
            if ($activite[$j]['activ'] == 'Formation ('. $note->activite . ')')
            {
              $activite[$j]['count'] += 1;
              $activite[$j]['jourp'] += $part;
              $find = true;
              break;
            }
          }          
       }
       if (!$find)
       {
        if ($note->formation == 1)
        {
          add_log ('Trouvé formation');
          $activite[] = array('activ'=>'Formation (' . $note->activite . ')', 'count'=>1, 'jourp'=>$part);
        }
        else
          $activite[] = array('activ'=>$note->activite, 'count'=>1, 'jourp'=>$part);
       }
    }

    echo '<p>Nombre de sorties collectives avec CR : <b>' . $not . '</b>/' . $ns . ' - Nombre de jour-participants : <b>' . $nbr . '</b></p>
          <table border="1"><tr><th class="noir">Activité</th><th class="noir">Nombre de sorties</th><th class="noir">Jours/participants</th></tr>';
    $triactiv = array_values(array_sort($activite, 'count', SORT_DESC));
    for ($j=0; $j<count($triactiv); $j++)
    {
      if ($triactiv[$j]['activ'] != 'Club' && $triactiv[$j]['activ'] != 'Test' )
        echo '<tr><td class="noir">' . $triactiv[$j]['activ'] . '</td><td class="noir">' . $triactiv[$j]['count'] . '</td><td class="noir">' .  $triactiv[$j]['jourp'] . '</td></tr>'; 
    }
    echo '</table>';

    echo '<h2>' . $t++ . ' - Liste des activités terminées sans compte-rendu du '. $date_d . ' au ' . $date_f . '</h2>
    <p>Ne sont prises en compte que les activités terminées qui n\'ont pas été annulées.</p>
    <table border="1"><tr><th class="noir">Date</th><th class="noir">Encadrant</th><th class="noir">Activité</th><th class="noir">Titre</th></tr>';

    $date_limit = $date_f;
    $scan = extract_activ_retroactive($date_limit);
    //echo $date_limit;
    //echo 'SCAN = ' . sizeof($scan);
    
    $I=1;

    foreach ($scan as $note)
    {
      
      if ($note->date_deb < $date_d) continue; // debut statistique 
      if ($note->annulation == 1  || substr($note->report,0,1) == 2 || substr($note->avance,0,1) == 2) continue;
      if ($note->cr == 0)
      {
        //$activ = $note->activite;
        //$titre = $note->titre;
  
        if ($cadre_stat != ''  && !stristr($note->cadre, wd_remove_accents($cadre_stat))) continue;

        if ($note->activite != 'Club' && $note->activite != 'Test')
          echo '<tr><td class="noir">' . $I++ . '-' . getJourDate($note->date_deb) . '</td><td class="noir">' . $note->cadre .'</td><td class="noir">' . $note->activite . '</td><td class="noir">' . $note->titre . '</td></tr>';
      }
    }
    echo '</table>';
  
   
    echo '<h2>' . $t++ . '-Tableau des kms entre le ' . getDateFr($date_d) . ' et le ' . getDateFr($date_f) . '</h2>';
    $tabkms = array ();
    //$scan = scandir ($dircr);
    foreach ($scan as $note)
    {
      
       if ($note->date_deb < $date_d) continue;
       if ($note->date_fin > $date_f) continue; 


      //$cadre = $note->cadre;
      $kms = extract_cr_kms ($note->IDU);

       if ($cadre_stat != ''  && !stristr($note->cadre, wd_remove_accents($cadre_stat))) continue;
      //echo $cadre . ' - ' . $kms . ' kms <br>';
      $found = false;
      foreach ($tabkms as &$tab)
      {
        if (strtoupper($tab['nom']) == strtoupper($note->cadre)) // && $tab['annee'] == substr($note->date_deb, 0, 4))
        {
          $tab['kms'] += $kms;
          $found = true;
          //echo 'Addition ' . $tab['kms'] . '<br>';
          break;
        }          
      }
      unset ($tab);
      if (!$found)
      {
          $tabkms[] = array('nom' => $note->cadre, 'annee' => substr($note->date_deb, 0,4), 'kms' => $kms);
      }

       
    }

    $trikms = array_values(array_sort($tabkms, 'kms', SORT_DESC));
    echo '<table border="1"><tr><th class="noir">Encadrant</th><th class="noir">Kilomètres</th></tr>';
    foreach ($trikms as $tab)
    {
      if ($tab['nom'] == '') break;
      if ($tab['kms'] > 0)
        echo '<tr><td class="noir">' . strtoupper($tab['nom']) . '</td><td class="noir">' . $tab['kms'] . '</td></tr>';
    }

    
    echo '</table><form method="post"><input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="cx" value="' . $cx . '"/>
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
          <input type="submit" name="commande" value="STATISTIQUES">';
    retour_menu();
    echo '</form>
          <p class="oblique">Il est important de choisir une fois pour toutes votre identité, soit Prénom Nom soit le contraire.</p></div>';
  }
  else if ($commande == 'VUE MENSUELLE')
  {
     
      $annee     = $_POST['annee'];
      $mois      = $_POST['mois'];
      $nbrvisu   = $_POST['nbrvisu'];
      $sel       = $_POST['selexp'];
      $Mois = array('un','Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout','Septembre','Octobre', 'Novembre', 'Décembre' );

      echo '<div class="detail">';

      if($mois == '')
      {
        $mois=getMois();
      }
      if ($annee == '')
      {
       if ($nbrvisu == '') $nbrvisu = 3; //trimestre
       if ($status_auth != 'open')
          $annee=date('Y');
        else
        {
          $annee = substr($date_first,0,4);
          $mois  = $Mois[intval(substr($date_first,5,2))];
        }
      }

   
      foreach ($sel as $selexp) 
           $selection  .= $selexp;

      if ($selection == '')
        $selection = $_POST['selection'];

      if ($nbrvisu == '') $nbrvisu=1;
      add_log ($commande . ' ' . $annee . ' ' . $mois . ' ' . $nbrvisu);
      echo '<form method="post">
      <table class="detail"><tr><td>Nom du mois :</td><td> 
      <select name="mois">';
      echo 'MOIS = ' . $mois;
      if ($mois == 'Janvier')
        echo '<option selected>Janvier';
      else
        echo '<option>Janvier';
      if ($mois == 'Février')
        echo '<option selected>Février';
      else
        echo '<option>Février';
      if ($mois == 'Mars')
        echo '<option selected>Mars';
      else
        echo '<option>Mars';
      if ($mois == 'Avril')
        echo '<option selected>Avril';
      else
        echo '<option>Avril';
      if ($mois == 'Mai')
        echo '<option selected>Mai';
      else
        echo '<option>Mai';
      if ($mois == 'Juin')
        echo '<option selected>Juin';
      else
        echo '<option>Juin';
      if ($mois == 'Juillet')
        echo '<option selected>Juillet';
      else
        echo '<option>Juillet';
      if ($mois == 'Août')
        echo '<option selected>Août';
      else
        echo '<option>Août';
      if ($mois == 'Septembre')
        echo '<option selected>Septembre';
      else
        echo '<option>Septembre';
      if ($mois == 'Octobre')
        echo '<option selected>Octobre';
      else
        echo '<option>Octobre';
      if ($mois == 'Novembre')
        echo '<option selected>Novembre';
      else
        echo '<option>Novembre';
      if ($mois == 'Décembre')
        echo '<option selected>Décembre';
      else
        echo '<option>Décembre';
      echo '</select>
      </td></tr>
      <tr><td>Année : </td><td><input type="text" name="annee" size="5" minlength="4" maxlength="4" value="' . $annee .'"></td></tr>
      <tr><td>Nombre de mois :</td><td><input type="number" name="nbrvisu" value="' . $nbrvisu .'" Title="Nombre de mois à visualiser" min="1" max="3"></td></tr>
      </table>
                                    

  <p><b>Décocher les activités que vous ne désirez pas visualiser</b></p>';
       
  if ($selection == '') $selection='Randonnée pédestre,Raquettes,Marche nordique,Ski de randonnée,Ski de randonnée nordique';
    if (strstr($selection,"Alpinisme"))
     echo '<input type="checkbox" name="selexp[]" value="Alpinisme" id="sel1"checked> <label for"sel1">Alpinisme</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Alpinisme" id="sel1" <label for"sel1">Alpinisme</label> ';
  if (strstr($selection,"Randonnée pédestre"))
     echo '<input type="checkbox" name="selexp[]" value="Randonnée pédestre" id="sel1"checked> <label for"sel1">Randonnée pédestre</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Randonnée pédestre" id="sel1" <label for"sel1">Randonnée pédestre</label> ';
  if (strstr($selection,"Raquettes"))
    echo '<input type="checkbox" name="selexp[]" value="Raquettes" checked id="sel2"checked><label for"sel2">Raquettes</label> ';
  else 
    echo '<input type="checkbox" name="selexp[]" value="Raquettes" id="sel2" <label for"sel2">Raquettes</label> ';
  if (strstr($selection,"Marche nordique"))
   echo'<input type="checkbox" name="selexp[]" value="Marche nordique" checked id="sel3"><label for"sel3">Marche nordique</label><br>';
  else
   echo'<input type="checkbox" name="selexp[]" value="Marche nordique" id="sel3"><label for"sel3">Marche nordique</label><br> ';
  if (strstr($selection,"Ski de randonnée"))
    echo '<input type="checkbox" name="selexp[]" value="Ski de randonnée" checked id="sel4"><label for"sel4">Ski de randonnée</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Ski de randonnée" id="sel4"><label for"sel4">Ski de randonnée</label> ';
  if (strstr($selection,"Ski de randonnée nordique"))
    echo '<input type="checkbox" name="selexp[]" value="Ski de randonnée nordique" checked id="sel5"><label for"sel5"> Ski de randonnée nordique</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Ski de randonnée nordique" id="sel5"><label for"sel5"> Ski de randonnée nordique</label> ';
  if (strstr($selection,"Ski de fond"))
    echo '<input type="checkbox" name="selexp[]" value="Ski de fond" checked id="sel6"><label for"sel6"> Ski de fond</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Ski de fond"  id="sel6"><label for"sel6"> Ski de fond</label><br>';
  if (strstr($selection,"Ski alpin"))
    echo '<input type="checkbox" name="selexp[]" value="Ski alpin" checked id="sel6"><label for"sel6"> Ski Alpin</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Ski alpin"  id="sel6"><label for"sel6"> Ski alpin</label> ';
  if (strstr($selection,"Randonnée alpine"))
    echo '<input type="checkbox" name="selexp[]" value="Randonnée alpine" checked id="sel12"><label for"sel12"> Randonnée alpine</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Randonnée alpine" id="sel12"><label for"sel12"> Randonnée alpine</label> ';
  
  if (strstr($selection,"Trail"))
    echo '<input type="checkbox" name="selexp[]" value="Trail" checked id="sel13"><label for"sel13"> Trail</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Trail" id="sel13"><label for"sel13"> Trail</label><br>';
   
  if (strstr($selection,"Escalade"))
    echo '<input type="checkbox" name="selexp[]" value="Escalade" checked id="sel7"><label for"sel7"> Escalade</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Escalade" id="sel7"><label for"sel7"> Escalade</label> ';

  if (strstr($selection,"Cascade de glace"))
    echo '<input type="checkbox" name="selexp[]" value="Cascade de glace" checked id="sel8"><label for"sel8"> Cascade de glace</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Cascade de glace" id="sel8"><label for"sel8"> Cascade de glace</label><br>';
   if (strstr($selection,"Kayak"))
    echo '<input type="checkbox" name="selexp[]" value="Kayak" checked id="sel10"><label for"sel10"> Kayak</label> ';
  else
  echo '<input type="checkbox" name="selexp[]" value="Kayak"  id="sel10"><label for"sel10"> Kayak</label> ';
  if (strstr($selection,"Via ferrata"))
    echo '<input type="checkbox" name="selexp[]" value="Via ferrata" checked id="sel14"><label for"sel14"> Via ferrata</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Via ferrata" id="sel14"><label for"sel14"> Via ferrata</label><br>';
  if (strstr($selection,"VTT"))
    echo '<input type="checkbox" name="selexp[]" value="VTT" checked id="sel11"><label for"sel11"> VTT</label><br>';
  else
   echo '<input type="checkbox" name="selexp[]" value="VTT" id="sel11"><label for"sel11"> VTT</label><br>';
 if (strstr($selection,"Club"))
    echo '<input type="checkbox" name="selexp[]" value="Club" checked id="sel9"><label for"sel9"> Club</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Club" id="sel9"><label for"sel9"> Club</label><br>';
  if (strstr($selection,"Formation"))
    echo '<input type="checkbox" name="selexp[]" value="Formation" checked id="sel15"><label for"sel15"> Formation</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Formation" id="sel15"><label for"sel15"> Formation</label> ';
   if (strstr($selection,"Séjour"))
    echo '<input type="checkbox" name="selexp[]" value="Séjour" checked id="sel16"><label for"sel16"> Séjour ou WE</label> ';
  else
    echo '<input type="checkbox" name="selexp[]" value="Séjour" id="sel15"><label for"sel16"> Séjour ou WE</label> ';
   if (strstr(sup_anti_slash($selection),"Camp d'été"))
    echo '<input type="checkbox" name="selexp[]" value="Camp d\'été" checked id="sel17"><label for"sel17"> Camp d\'été</label><br>';
  else
    echo '<input type="checkbox" name="selexp[]" value="Camp d\'été" id="sel17"><label for"sel17"> Camp d\'été</label><br>';



    echo '<input type="submit" name="commande"  value="VUE DU MOIS">';  
    retour_menu();
    echo '<input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
          <input type="hidden" name="fcadre"    value="' . $fcadre . '">
          <input type="hidden" name="auth"      value="' . $auth . '">
          <input type="hidden" name="cx"        value="' . $cx . '">                
          </form></div>';

  }
  else if ($commande == 'RAPPEL SANS CR')
  {
      echo '<div class="detail"><h2>Rappel des encadrants pour les sorties terminées sans compte-rendu</h2>';
      echo 'CADRE_P ' . $cadre_p . '<br>';
      $frappel = $DIR . '/' . 'date_rappel';
      if (file_exists($frappel))
      {
        $fd = fopen ($frappel, 'r');
        $date_rappel = submoins1(fgets($fd, 256));
        fclose ($fd);
        $newd_rappel = date('Y-m-d', strtotime(date('d-m-Y', strtotime($date_rappel)) . " + 7 days"));
        
        echo '
        Le dernier rappel a été fait le ' .          getJourDate(getDateEntete ($date_rappel)) . '<br>
        Le prochain rappel doit être fait dès le ' . getJourDate(getDateEntete ($newd_rappel))  .'<br>
        <form method="post">
        <input type="submit" name="commande" value="LANCER LE RAPPEL">'; 

      }
      else
        echo '<form method="post"><p>Il semble que le fichier "date_rappel" est absent - retrouver le avant de lancer la commande</p>';
          
      echo '<input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
          <input type="hidden" name="fcadre"    value="' . $fcadre . '">
          <input type="hidden" name="auth"      value="' . $auth . '">
          <input type="hidden" name="cx"        value="' . $cx . '">';
      retour_menu();
      echo '</form></div>';
      
  }
  else if ($commande == 'LANCER LE RAPPEL')
  {
      echo '<div class="detail"><h2>Envoi des rappels des sorties terminées sans compte-rendu</h2>';
      rappel_sans_cr();
      $frappel = $DIR . '/' . 'date_rappel';
      unlink ($frappel);
      $date_rappel = date('Y-m-d');
      $fd = fopen ($frappel, 'w');
      fputs ($fd, $date_rappel . "\n");
      fclose ($fd);
      echo '<form method="post">
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">';
      retour_menu();
      echo '</form></div>';
  }
  else if ($commande == 'CONTROLE DOUBLON')
  {
      add_log ($commande);
      echo '<h1>Contrôle des doublons des sorties</h1>';
      
      $hour1 = date('His');
      //echo 'gmt_offset = ' . get_option('gmt_offset') . ' -- ' . get_option('timezone_string') . ' -- ' . date('Y-m-d H:i:s') . ' -- ' . $hour1 . '<br>';
      analyse_doublon ();

      //echo '<h1>Contrôle des doublons de OLDNOTES</h1>';
       //analyse_doublon ();

      echo '<form method="post">
         <input type="submit"  name="commande" value="CONTROLE DOUBLON" Title="Admin - affiche les doubles sorties d\'un encadrant d\'un même jour">'; 
      retour_menu();
      echo '<input type="hidden" name="auth" value="' . $auth . '">
         <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
         <input type="hidden" name="cx" value="' . $cx . '">
         </form>';
  }
  else if ($commande == 'VUE DU MOIS')
  {

      echo '<h1>Vue du mois </h1>';
      $Mois = array('un','Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout','Septembre','Octobre', 'Novembre', 'Décembre' );
      $annee     = $_POST['annee'];
      $mois      = $_POST['mois'];
      $sel       = $_POST['selexp'];
      $nbrvisu   = $_POST['nbrvisu'];
      add_log ($commande . ' - ' . $annee . '-' . $mois . ' - ' . $nbrvisu . ' - ' . $sel);
      if ($nbrvisu > 3) $nbrvisu=3;

      if($mois == '') $mois='Janvier';
      if ($annee == '') $annee=date('Y');

   
      foreach ($sel as $selexp) 
           $selection  .= sup_anti_slash($selexp) . ',';
  
    echo 'Sélection : ' . $selection . '<br>';
    if (strlen($mois) >= 3 && strlen($annee) == 4 && substr($annee,0,2) == '20')
    {
      if (stristr($mois, 'jan')) $nmois='01';
      else if (stristr($mois, 'fev')) $nmois='02';
      else if (stristr($mois, 'fév')) $nmois='02';
      else if (stristr($mois, 'mar')) $nmois='03';
      else if (stristr($mois, 'avr')) $nmois='04';
      else if (stristr($mois, 'mai')) $nmois='05';
      else if (stristr($mois, 'juin')) $nmois='06';
      else if (stristr($mois, 'juil')) $nmois='07';
      else if (stristr($mois, 'aoû')) $nmois='08';
      else if (stristr($mois, 'sep')) $nmois='09';
      else if (stristr($mois, 'oct')) $nmois='10';
      else if (stristr($mois, 'nov')) $nmois='11';
      else if (stristr($mois, 'dec')) $nmois='12';
      else if (stristr($mois, 'déc')) $nmois='12';
    
    for ($q = $nbrvisu ; $q >0; $q--)
    {
    $normd = $annee . '-' . $nmois . '-01';
    //echo $normd . '<br>';
    $nday=1;
    //echo 'NMOIS = ' . $nmois;
    $t1 = strtotime($normd . ' - 1 day');
    $monthp = date('N-Y-m-d', $t1);
    $last_dayp = substr($monthp, 10,2);
    $last_ndayp = substr($monthp, 0, 1);
    //echo 'Dernier jour du mois précédant est le ' . $last_dayp . '<br>';
    $lundi_monthp = $last_dayp - $last_ndayp + 1;
    //echo 'Dernier lundi du mois précédant est le ' . $lundi_monthp . '<br>';
    $date_month_p = date('Y-m-d', strtotime($normd . ' -' . $last_ndayp . ' days'));
    //echo 'Date mois précédant : ' . $date_month_p . '<br>';
     
    $t1 = strtotime($normd . ' + 1 month - 1 day');
    $last_dayc = substr(date('N-Y-m-d', $t1), 10,2);
    $last_ndayc = substr(date('N-Y-m-d', $t1), 0,1);
    $frontiere=0;
    /*
    $tableau_jour = array();
   
    $frontiere=0;
    //echo strtotime($date_month_p) . ' - ' . strtotime(date('Y-m-d')) . '<br>';
    if (strtotime($date_month_p) < strtotime(date('Y-m-d')))
    {

      //$scan = extract_activ_avenir ($normd);
      $scan = scandir ($DIR_OLDNOTES);
    
     for ($i = 0; $i<sizeof($scan); $i++)
        $tableau_jour[$i] = $scan[$i];
      $frontiere = $i+1;

      $scan = scandir ($DIR_NOTES);
      for ($i = 0; $i<sizeof($scan); $i++)
        $tableau_jour[$i+$frontiere] = $scan[$i];
      //echo $DIR_OLDNOTES . ' - ' . $frontiere . '<br>';
    }
    else
    {
      $scan = scandir ($DIR_NOTES);
      for ($i = 0; $i<sizeof($scan); $i++)
        $tableau_jour[$i] = $scan[$i];
      //echo $DIR_NOTES . ' - ' . $frontiere . '<br>';
    }
    */
   
    $index = 0;

    
    //echo 'Dernier jour du mois est le ' . $last_dayc . ' avec le numero ' . $last_ndayc . '<br>';
    
    $mois = $Mois[intval($nmois)];
    add_log ($commande . ' ' . $annee . ' ' . $mois);
    echo $mois . ' ' . $annee . '<br>
         <div class="lday">lundi</div>
         <div class="lday">mardi</div>
         <div class="lday">mercredi</div>
         <div class="lday">jeudi</div>
         <div class="lday">vendredi</div>
         <div class="lday">samedi</div>
         <div class="lday">dimanche</div>
         <div class="finld"></div>';
      if ($lundi_monthp + 6 != $last_dayp)
      {
         for ($nday=1; $nday<= $last_ndayp; $nday++)
         {
            $dates = getMonthPrec ($lundi_monthp);
            $dates_norm = substr($dates, 0,4) . '-' . substr($dates, 4,2) . '-' . substr($dates, 6,2);

            //mois précédant
            //$star=getActiveDay($frontiere, $dates, $dates_norm, $tableau_jour);
            $star=getActiveDay($frontiere, $dates, $dates_norm);
 
            echo '<div class="day"><font color="grey">' . $lundi_monthp++ . ' ' .  $star  . '</font></div>';
         }
      }

      for ($ndayc=1; $ndayc <= $last_dayc; $ndayc++)
      {

            $dates = getMonthCur($ndayc);

            $dates_norm = substr($dates, 0,4) . '-' . substr($dates, 4,2) . '-' . substr($dates, 6,2);

            //mois précédant
            //$star=getActiveDay($frontiere, $dates, $dates_norm, $tableau_jour);
            $star=getActiveDay($frontiere, $dates, $dates_norm);
 
            echo '<div class="day"><font color="blue"><b>' . $ndayc . ' ' . $star . '</b></font>';
            //if ($nday == 2) echo ' (ped:5  ski:6)';
            echo '</div>';
            
            $nday++;
            if($nday == 8)
            {
               $nday = 1;
               echo '<div class="finl"></div>';
            }
         }
         // finir le mois jusqu'au dimanche
         $num=1;
         for ($nday=$nday;$nday<8;$nday++)
         {
            $dates = getMonthNext ($num);
            $dates_norm = substr($dates, 0,4) . '-' . substr($dates, 4,2) . '-' . substr($dates, 6,2);

            //mois précédant
            //$star=getActiveDay($frontiere, $dates, $dates_norm, $tableau_jour);
            $star=getActiveDay($frontiere, $dates, $dates_norm);

            echo '<div class="day"><font color="grey">' . $num++ . '<br>' . $star .  ' </font></div>';
         } 
         echo '<div class="finl"></div>';

         if ($q > 1)
         {
          $nmois++;
          if ($nmois > 12)
          {
            $annee++;
            $nmois='01';
          }
        
          switch ($nmois)
          {
            case 1 : $mois='Janvier'; break;
            case 11 : $mois = 'Novembre'; break;
            case 12 : $mois = 'Décembre'; break;
          }
         }
       }
        echo '<form method="post">

         <input type="hidden" name="auth" value="' . $auth . '">         
         <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
         <input type="hidden" name="mois" value="' . $mois . '">
         <input type="hidden" name="annee" value="' . $annee . '">
         <input type="hidden" name="selection" value="' . $selection . '">
         <input type="hidden" name="cx" value="' . $cx . '"/>
         <input type="submit" name="commande" value="VUE MENSUELLE">';  
        retour_menu();
        echo '</form>';
    }
  }
  else if ($commande == 'MODIFICATION ACTIVITE') // commande modification
  {
       $note = extract_activ_idu ($IDU);
       add_log ($commande . ' - ' . 'IDU=' .  $IDU . ' - ' . $note->activite);
       echo '<div class="detail"><h1>Modification de l\'activité du ' . getJourDate($note->date_deb) . '</h1>';
      
       $cadre         = $note->cadre;
       $activite      = $note->activite;
       $titre         = $note->titre; 
       $diff          = $note->diff; 
       $coencadrant   = $note->coencadrant;
       $detail        = $note->detail;
       $type          = $note->type;
       $denivele      = $note->denivele;
       $formation     = $note->formation;
       $date_deb      = $note->date_deb;
       $date_fin      = $note->date_fin;
       $CP            = $note->CP;
       $CT            = $note->CT;
       $maxp          = $note->maxp;
       $cotation      = $note->cotation;
       $kms           = $note->kms;
       $camp          = $note->camp;
    
     affich_sortie ($IDU, $mode, $type, $date_deb, $date_fin, $cadre, $coencadrant, $activite, $titre, $detail, $denivele, $formation, $maxp,  $corbeille=false, $cotation, $kms, $camp);
     //affich_sortie ('N', $type_s, $file, $dir, $date_s, $date_sej, $cadre, $activite, $titre, $detail);
     echo '</div>';
  }
  else if ($commande == 'MODIFICATION CORBEILLE') // commande modification
  {

       //echo 'DIR = ' . $dir . '<br>';
       $note = extract_corbeille_idu ($IDU);
       add_log ($commande . ' - ' . $date_deb . ' - ' . $note->cadre);
       echo '<div class="detail"><h1><font color="red">Modification de l\'activité du ' . getJourDate($note->date_deb) . ' en corbeille</font></h1>';
      
       $cadre = $note->cadre;
       $activite = $note->activite;
       $titre = $note->titre; 
       $diff = $note->diff; 
       $coencadrant = $note->coencadrant;
       $detail = $note->detail;
       $type = $note->type;
       $denivele = $note->denivele;
       $formation = $note->formation;
       $date_deb = $note->date_deb;
       $date_fin = $note->date_fin;
       $maxp     = $note->maxp;
       $camp     = $note->camp;

     $corbeille = true;
     affich_sortie ($IDU, $mode, $type, $date_deb, $date_fin, $cadre, $coencadrant, $activite, $titre, $detail, $denivele, $formation, $maxp, $corbeille=true,
      $cotation,$kms,$camp);
     
     
     echo '</div>';
     $type = controle_type_sortie ($date_deb, $date_fin, '');
  }
  else if (strstr($commande,'REMPLACER CETTE ACTIVITE'))
  {
       
      echo '<div class="detail">';
      $note = extract_activ_idu ($IDU);

      add_log ($commande . ' - ' . $date_deb . ' - ' . $date_fin . ' - ' . $cadre . ' - ' . $IDU);
      
     if ($note->date_fin < $note->date_deb)
     {
        affich_detail_bloc ($IDU);

        echo '<p class="oblique_rouge">Vous êtes en train de déclarer un séjour avec une date de fin ('.getJourDate($note->date_fin) . ') antérieure à la date de début ('.getJourDate($note->date_deb) . '). Corrigez la date de fin ou effacer là pour revenir à une sortie à la journée.</p>';  
     }
     else if ($hiver == 'oui' && $ete == 'oui')
     {
        affich_detail_bloc ($IDU);

        echo '<p class="oblique_rouge"><b>Camp d\'hiver et camp d\'été</b><br>Cette activité ne peut être à la fois du camp d\'hiver et du camp d\'été. Il faut choisir ou laisser les deux cases vides pour indiquer que c\'est hors camp</p>';  
     }
     else if ($hiver == 'oui' && substr($note->date_deb,5,2) > 3)
     {
        
        affich_detail_bloc ($IDU);

        echo '<p class="oblique_rouge">La date choisie ('. getJourDate($note->date_deb) . ') pour cette activité du camp d\'hiver n\'est  pas compatible avec ce type de camp. Modifier la date ou choisir "hors camp"</p>'; 
        ; 
     } 
     else if ($ete == 'oui' && (substr($note->date_deb,5,2) != 6 && substr($note->date_deb,5,2) != 7))
     {
        
        affich_detail_bloc ($IDU);

        echo '<p class="oblique_rouge">La date choisie ('. getJourDate($note->date_deb) . ') pour cette activité du camp d\'été n\'est  pas compatible avec ce type de camp. Modifier la date ou choisir "hors camp"</p>'; 
        ; 
     }          
     else if ($note->preinscription == 1 || $note->complete == 1)
     {
        echo '<p class="oblique_rouge"><b>Cette activité a été mise à jour par le calendrier et ne peut plus être modifiée par le bloc-notes</p></b>';
        add_log ($commande . ' Refus cause PREINSCRIPTION ou COMPLETE');  
        affich_detail_bloc ($IDU);
        //echo '</div>';        
     }
     else if ($cadre == $coencadrant)
     {
        echo '<p class="oblique_rouge"><b>Le coencadrant ne peut être l\'encadrant principal.<br>Supprimer le ou modifier le coencadrant ' . $coencadrant . '</p></b>';
        add_log ($commande . ' Refus cause coencadrant et encadrant sont la même personne ' . $coencadrant);  
        affich_detail_bloc ($IDU);
        echo '</div>';        
     }
     else
     {
      
      //prise en compte camp d'été ou camp d'hiver

      if ($hiver == 'oui')
        $camp = 'hiver';
      else if ($ete == 'oui')
        $camp = 'été';

      $ident = $note->ident;
      //echo 'Remplacement de la note d\'IDU ' . $IDU;

     if ($date_fin == '') $date_fin = $date_deb;

     if ($denivele=='') $denivele=0;


    
     $type = controle_type_sortie ($date_deb, $date_fin, '');


     //echo 'TYPE = ' . $type . '<br>';
     if (stristr($bformation[0], 'Formation'))
      $formation = 1;
     else
      $formation = 0;

      $date_cre = date('Y-m-d H:i:s');
      //echo 'Choix camp : ' . $camp;
      enreg_sortie ($type, $date_deb, $date_fin, $date_cre, $activite, 
                    $cadre, $coencadrant, $titre, $diff, $detail, 
                    $denivele, $formation, $ident, $IDU, $CP, $CT, 
                    $maxp, $cotation, $kms, $camp);
                    
    }
    

      echo '<form method="post">
          <input type="hidden" name="auth" value="' . $auth . '">
          <input type="hidden" name="fcadre" value="' . $fcadre . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="factivite" value="' . $factivite . '"> 
          <input type="hidden" name="cx" value="' . $cx . '"/> 
          <input type="hidden" name="xemail" value="' . $xemail . '">';
      retour_menu();
      echo '</form>
            </div><!--detail-->';
  }
  else if (strstr($commande,"AJOUTER CETTE ACTIVITE" ))
  {
      $coencadrant = $_POST['coencadrant'];

      $cadre = strtoupper(wd_remove_accents($cadre));
      add_log ($commande . ' - ' . $cadre . ' - ' . $titre);
      echo '<div class="detail"><h1>Ajout et contrôle d\'une activité</h1>';

      //prise en compte camp d'été ou camp d'hiver
      if ($hiver == 'oui')
        $camp = 'hiver';
      else if ($ete == 'oui')
        $camp = 'été';
      if ($date_fin == '' || $date_fin < $date_deb) $date_fin = $date_deb;
      $type = controle_type_sortie ($date_deb, $date_fin, '');
      if ($denivele == '') $denivele=0; //sans dénivelé
      if ($coencadrant != '')
      {
        $coencadrant = strtoupper(wd_remove_accents($coencadrant));
      }

      //si demande de répétition confirmé
      if (substr($date_repet,0,2) == '20' && !strstr($commande, 'CONFIRMER'))
      {
        echo '<h2>Activité récurrente</h2>';
        $tp = strtotime ($date_deb . ' + 7 days');
        $date_min = date("Y-m-d", $tp);
        if ($date_repet < $date_deb || $date_repet < $date_min)
        {
          echo '<p class="oblique"><font color="red">Date de récurrence incorrecte.<br>La date de fin de récurrence (' . $date_repet . ') doit être plus grande que la date de l\'activité plus 7 jours (' . $date_min .').<br>Recommencer la programmation de votre activité.
          </font></p>
          <form method="post">
          <input type="hidden" name="auth"      value="' . $auth . '">
          <input type="hidden" name="fcadre"    value="' . $fcadre . '">
          <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
          <input type="hidden" name="factivite" value="' . $factivite . '"> 
          <input type="hidden" name="cx"        value="' . $cx . '"> 
          <input type="hidden" name="xemail"    value="' . $xemail . '">';
          retour_menu();
          echo '</form></p>';
          goto fin_recurrence;
        }
        echo '<p class="oblique"><font color="blue">Vous avez choisi de programmer une activité récurrente ce qui va entraîné un certain nombre de soirées. Afin d\'éviter des corrections fastideuses en cas d\'erreur vous allez devoir confirmer les donnéees suivantes ou faire un retour au bloc-notes.Observer bien avant de valider</font></p>
        Type d\'activité : <b>' . $activite . '</b><br>
        Encadrant : <b>' . sup_anti_slash($cadre) . '</b><br>
        Titre : <b>' . sup_anti_slash($titre) . '</b><br>
        Détail de la sortie : <b>' . sup_anti_slash($detail) . '</b><br>
        Difficulté : <b>' . $diff . '</b><br>
        Date de la première soirée : <b>' . getJourDate(getDateEntete($date_deb)) . '</b><br>
        Date de la dernière soirée ou fin de récurrence : <b>' . getJourDate(getDateEntete($date_repet)) . '</b><br><br>
        <form method="post"><input type="submit" name="commande" value="CONFIRMER AJOUTER CETTE ACTIVITE RECURRENTE" TITLE="Pour éviter les erreurs"> 
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="activite" value="' . $activite . '">
        <input type="hidden" name="diff" value="' . $diff . '">
        <input type="hidden" name="cadre_p" value="' . strtoupper(sup_anti_slash(wd_remove_accents($cadre_p))) . '">
        <input type="hidden" name="cadre" value="' . strtoupper(sup_anti_slash(wd_remove_accents($cadre))) . '">
        <input type="hidden" name="coencadrant" value="' . strtoupper(sup_anti_slash(wd_remove_accents($coencadrant))) . '">
        <input type="hidden" name="denivele" value="' . $denivele . '">  
        <input type="hidden" name="formation" value="' . $formation . '">  
        <input type="hidden" name="titre" value="' . sup_anti_slash($titre) . '">
        <input type="hidden" name="detail" value="' . sup_anti_slash($detail) . '">
        <input type="hidden" name="date_deb" value="' . $date_deb . '">
        <input type="hidden" name="date_repet" value="' .  $date_repet . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="cx" value="' . $cx . '">'; 
        retour_menu();
        echo '</form>';
        goto fin_recurrence;
      }

      //sans demande de répétition confirmée
      $IDU = get_IDU ($ident, false);  // nouveau IDU
      add_log ($commande . ' Attribution IDU=' . $IDU . ' ' . $cadre . ' - ' . $titre); 
   
      if ($date_fin == '') $date_fin = $date_deb;
      if (strtotime($date_fin) - strtotime($date_deb) < 0)
      {
        //correction de la date de fin
         $date_fin = $date_deb;
      }

     //echo 'COLLECTE = ' . $collecte . '<br>';

     
     //echo 'Type de sortie = ' . $type . '<br>';


     $cadre1 = strtoupper(wd_remove_accents($cadre1));
     $coencadrant1 = strtoupper(wd_remove_accents(recherche_cadre($coencadrant1)));
   
     if ($cadre == $coencadrant)
     {
        echo '<p class="oblique_rouge"><b>Le coencadrant ne peut être l\'encadrant principal. Supprimer le ou modifier le coencadrant</p></b>';
        add_log ($commande . ' Refus cause coencadrant et encadrant sont la même personne ' . $coencadrant);  
        goto fin_erreur;
     }


     //sans erreur cadre = coencadrant
     if (stristr($bformation[0], 'Formation'))
      $formation = 1; 
     else 
      $formation = 0;
     //echo 'Coencadrant = ' . $coencadrant . '<br>';
     //echo 'Formation = ' . $formation . ' Dénivelé = ' . $denivele . '<br>';
     


      //Controle même encadrant - même date1
      if ($activite != 'Club' && controle_exist_date_cadre ($date_deb, $cadre) > 0)
      {
        echo '<p><font color="red">Une activité avec le même encadrant ('. $cadre . ') est déjà enregistré pour le ' . getJourDate($date_deb) . ' et visualisable par le calendrier. Il n\'est pas possible de l\'enregistrer une seconde fois. Recommencer correctement votre saisie de l\'activité en changeant de date.</font></p>';
        add_log ($commande . ' - ' . $auth . ' - Refus cause doublon ' . $file);
        affich_retour_blocnote($IDU);
        goto fin_erreur;
      }

      //Enregistrement de la sortie sans récurrence
      {
        add_log ($commande . ' - Type ' . $type . ' - ' . $date_sortie . ' - ' . $cadre . ' - ' . $activite . ' - ' . $titre);

   
        $date_cre = date('Y-m-d H:i:s');
        
        //enregistrement sans répétition
        if (substr($date_repet,0,2) != '20')
        {
            
            //echo 'type = ' . $type . ' date_sortie = ' . $date_sortie . '<br>';
            enreg_sortie ($type, $date_deb, $date_fin, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $detail,$denivele, $formation, $ident, 
                          $IDU, $CP, $CT,$maxp, $cotation, $kms, $camp);

            affich_retour_blocnote($IDU);


        }
        else // enregistrement avec répétion
        {
            // controle de la date de repetition
            $IDU = get_IDU ($ident, false);
            add_log ($commande . ' Attribution IDU ' . $date_deb . ' - ' . $cadre); 
            //echo 'type = ' . $type . ' date_sortie = ' . $date_sortie . '<br>';
            enreg_sortie ($type, $date_deb, $date_fin, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $detail,$denivele, $formation, $ident, 
              $IDU, $CP, $CT,$maxp,$cotation, $kms, $camp);
           // activité à répéter chaque jour de la semaine jusqu'à la fin du trimestre
           if ($date_repet) echo 'Répétition ' . $date_deb . ' jusqu\'à ' . $date_repet . '<br>';
           $date_recurrence = $date_deb;
           $k=0;
           while ($date_recurrence < $date_repet)
           {
                //echo $ndate . ' + 7 days<br>';
                $tp = strtotime ($date_recurrence . ' + 7 days');
                $date_recurrence = date("Y-m-d", $tp);
                if ($date_recurrence > $date_repet) break;
                if ($k > 4) break;
                //echo $ndate . '<br>';
                $IDU = get_IDU ($ident, false);
                //echo 'type = ' . $type . ' date_sortie = ' . $date_sortie . '<br>';
                enreg_sortie ($type, $date_recurrence, $date_recurrence, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $detail,$denivele, 
                  $formation, $ident, $IDU, $CP, $CT,$maxp,$cotation, $kms, $camp);
                $k++;
           }
           affich_retour_blocnote($IDU);
        }
      }
      fin_erreur:
      fin_recurrence:
          echo '</div><!--detail-->';
 
      
  }
  else if (strstr($commande,'SUPPRIMER CETTE ACTIVITE' ))
  {
    echo '<div class="detail">';
      if (!strstr($commande, 'CORBEILLE'))
      {
        echo '<h1>Suppression d\'une activité</h1>';
        $note = extract_activ_idu ($IDU);
        add_log ($commande . ' - ' . $note->date_deb . ' - ' . $note->cadre . ' - ' . $note->titre);
        if ($note != false)
        {

          $cadre = $note->cadre;
          $titre = $note->titre;
          //recopie de l'activite dans la corbeille
          if (recopie_corbeille ($IDU))  
          {

            if (!delete_activ ($IDU))
              echo 'Suppression non réalisée dans la table avec IDU ' . $IDU . '<br>';
    
            else
            {
              
          
              echo 'L\'activité du ' . getJourDate($note->date_deb) . ' (' . $titre . ' de ' . $cadre . ') a bien été supprimée et mise dans la corbeille <br>';
              if ($auth == $code_admin)
                update_delete_base ($IDU, $note->ident, 'supprimé par admin');
              else
                update_delete_base ($IDU, $note->ident, 'supprimé par encadrant', $file);
            }
          }
          else
          {
            echo 'Erreur dans la suppression de l\'activité du ' . getJourDate($note->date_deb) . '- IDU ' . $IDU . '<br>';
          }
        }
        else
        {
          echo '<p class="oblique"><font color="red">Cette activité a déjà été supprimée. Vous avez du faire un rafraichissement du navigateur pour provoquer ce dysfonctionnement</font></p>';
        }
      }
      else
      {
        echo '<h1><font color="red">Suppression d\'une activité de la corbeille</font></h1>';
        $note = extract_corbeille_idu ($IDU);
        delete_corbeille_idu ($IDU);
        echo 'L\'activité du ' . getJourDate($note->date_deb) . ' (' . $titre . ' de ' . $cadre . ') a bien été supprimée de la corbeille <br>';
           
      }



       echo '<form method="post">
            <input type="hidden" name="auth" value="' . $auth . '"/>
            <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
            <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
            <input type="hidden" name="factivite" value="' . $factivite . '"/> 
            <input type="hidden" name="cx" value="' . $cx . '"/> 
            <input type="hidden" name="xemail" value="' . $xemail . '"/> ';
      if (strstr($commande, 'CORBEILLE'))
        echo '<p><input type="submit" name="commande" value="CONSULTATION CORBEILLE" Title="Admin - liste des sorties effacées" style="background:green !important;"></p>';
      else
      {
        echo '<p>
        <input type="submit" name="commande" value="LISTE DES ACTIVITES" >
        <input type="submit" name="commande" value="CREATION D\'UNE ACTIVITE" >
        </p>';
      }
      retour_menu();
      echo '</form></div><!--detail-->';
  }
  else if (strstr($commande,"EXPORT CAMP D"))
  {
      add_log ($commande);
      if (strstr($commande, 'ETE'))
      {
        echo '<div class="detail"><h1>Export des activités du camp d\'été</h1>';
        $ftxt    = 'export-sorties-du-camp-d-été-' . date('Y-m-d-H:i:s') . '.txt';
        $fxls    = 'export-sorties-du-camp-d-été-' . date('Y-m-d-H:i:s') . '.xlsx';
        $buffer = 'Programmation des activités du camp d\'été au ' . $day . '/' . $month . '/' . $year;
        $type_camp = "été";
      }
      else if (strstr($commande, 'HIVER')) 
      {
        echo '<div class="detail"><h1>Export des activités du camp d\'hiver</h1>';
        $ftxt    = 'export-sorties-du-camp-d-hiver-' . date('Y-m-d-H:i:s') . '.txt';
        $fxls    = 'export-sorties-du-camp-d-hiver-' . date('Y-m-d-H:i:s') . '.xlsx';
        $buffer = 'Programmation des activités du camp d\'hiver au ' . $day . '/' . $month . '/' . $year;
        $type_camp = "hiver";
      }

      $exportx = $DIR_EXPORT . '/' . $fxls;
      $exportf = $DIR_EXPORT . '/' . $ftxt;
      //partie texte
      $fdx = fopen ($exportf, 'w');
      if ($fdx)
      {
            $line = mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8');
            fprintf ($fdx, "%s\n\n", $line);
            $notes = extract_activ_collecte_camp ($type_camp);
            //print_r ($notes);
            $n = 1;
            foreach ($notes as $note)
            {
              $titre      = $note->titre;
              if ($note->camp == '') continue;
              if ($note->annulation == 1) continue;

              if ($date_c != '' && $note->date_deb != $date_c)
                $buffer = "----------------------------------\n";
              else
                $buffer = '';
              $date_c     = $note->date_deb;
              $cadre      = $note->cadre;
              $activite   = $note->activite;
              $diff       = $note->diff;
              $CP         = $note->CP;
              $CT         = $note->CT;
              $denivele   = $note->denivele;

              $buffer .= getJourDate($note->date_deb)  . ' - ' . $cadre . ' - ' . $activite . ' - ';
              $buffer .= $titre . ' - Diff : ' . $diff . ' - CP : ' . $CP . ' - CT : ' . $CT . ' - ' . $denivele;
              $line = mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8');
              fprintf ($fdx, "%s\n", $line);        
              $n++;
            }
          }

         //partie excel
         $spreadWsheet = new Spreadsheet();
         $Worksheet = $spreadWsheet->getActiveSheet();
   

        // Set document properties
        $spreadWsheet->getProperties()->setCreator('Michel Brusa')
        ->setLastModifiedBy('Michel Brusa')
        ->setTitle('Office 2007 XLSX Test Document')
        ->setSubject('Office 2007 XLSX Test Document')
        ->setDescription('Test document for Office 2007 XLSX, generated using PHP classes.')
        ->setKeywords('office 2007 openxml php')
        ->setCategory('Test result file');

        // Rename worksheet
        $Worksheet->setTitle(sup_anti_slash($commande));

        $Worksheet->setCellValue('A1', 'Date');
        $Worksheet->setCellValue('B1', 'Encadrant.');
        $Worksheet->setCellValue('C1', 'Activité');
        $Worksheet->setCellValue('D1', 'Titre');
        $Worksheet->setCellValue('E1', 'CP');
        $Worksheet->setCellValue('F1', 'CT');
        $Worksheet->setCellValue('G1', 'Dénivelé');
                
        $line = 2;

        foreach ($notes as $note)
        {
          $titre      = $note->titre;
          if ($note->camp == '') continue;
          if ($note->annulation == 1) continue;

          $n++;

          $numA = 'A' . $line; $numB = 'B' . $line; $numC = 'C' . $line; 
          $numD = 'D' . $line; $numE = 'E' . $line; $numF = 'F' . $line; 
          $numG = 'G' . $line;


          $Worksheet->setCellValue($numA, getJourDate($note->date_deb));
          $Worksheet->setCellValue($numB, $note->cadre);
          $Worksheet->setCellValue($numC, $note->activite);
          $Worksheet->setCellValue($numD, $note->titre);
          $Worksheet->setCellValue($numE, $note->CP);
          $Worksheet->setCellValue($numF, $note->CT);
          $Worksheet->setCellValue($numG, $note->denivele);
          $line++;
        }
 
        //Mise en forme
        //mettre en gras les titres
        $Worksheet->getStyle('A1:G1')->getFont()->setBold(true);
        //bloquet le volet première ligne
        $Worksheet->freezePane('A2');
        // Largeur des colonnes
        $Worksheet->getColumnDimension('A')->setWidth(20); //date
        $Worksheet->getColumnDimension('B')->setWidth(20); //cadre
        $Worksheet->getColumnDimension('C')->setWidth(20); //act.
        $Worksheet->getColumnDimension('D')->setWidth(50); //titre
        $Worksheet->getColumnDimension('E')->setWidth(10);
        $Worksheet->getColumnDimension('F')->setWidth(10);  
        $Worksheet->getColumnDimension('G')->setWidth(10);      
        //Centrer les colonnes A et C
        //echo 'Centrer A2:' . $numA . '<br>';
        //$Worksheet->getStyle('C2:' . $numC)->getAlignment()->setHorizontal('center');
        //$Worksheet->getStyle('A2:' . $numA)->getAlignment()->setHorizontal('center');

        $writer = new Xlsx($spreadWsheet);
        unlink ($exportx);
        $writer->save($exportx);

        echo '<p><button style="background:green !important;"><a href="' . $URL . '/EXPORT/' .  $ftxt . '" target="_blank"><font color="white"><b>' . $ftxt . '</b></font></a></button><br></p>
         <p><button style="background:green !important;"><a href="' . $URL . '/EXPORT/' .  $fxls . '" target="_blank"><font color="white"><b>' . $fxls . '</b></font></a></button><br></p>';
        echo '<p class="oblique">Ces deux boutons vous permettent d\'obtenir un export des activités des camps d\'été ou d\'hiver. Le premier bouton vert fait l\'export des activités en mode texte. Le second bouton fournit les données dans un fichier Excel. <br>Pour le texte utiliser n\'importe quel éditeur de texte.<br>Selon le navigateur utilisé, vous pouvez également faire "Enregistrer ..." en utilisant le bouton gauche de la souris ou en sélectionnant le lien. Le fichier d\'export sera alors enregistrer sur le dossier choisi de votre appareil. Vous pourrez alors utiliser Word ou un autre éditeur pour l\'ouvrir.</p>
         
          <form method="post">
          <input type="hidden" name="auth"      value="' . $auth . '">
          <input type="hidden" name="fcadre"    value="' . $fcadre . '">
          <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
          <input type="hidden" name="factivite" value="' . $factivite . '"> 
          <input type="hidden" name="cx"        value="' . $cx . '"> 
          <input type="hidden" name="xemail"    value="' . $xemail . '"> 
          <input type="submit" name="commande"  value="LISTE DES ACTIVITES">'; 
        retour_menu();
        echo '</form></p>
              </div>';
  }
  else if ($commande == 'EXPORT DES ACTIVITES')
  {
      add_log ($commande . ' - ' . $auth);

      echo '<div class="detail"><h1>EXPORT DES ACTIVITES</h1>
        <p class="oblique">Vous êtes un responsable d\'activité et vous ne vous intéressez pas à l\'ensemble des activités.<br>
        Décocher les activités que vous ne désirez pas exporter</p>
        <form method="post">
        <input type="checkbox" name="selexp[]" value="Randonnée pédestre" id="sel1"checked><label for"sel1">Randonnée pédestre</label> 
        <input type="checkbox" name="selexp[]" value="Raquettes" checked id="sel2"checked><label for"sel2">Raquettes</label> 
        <input type="checkbox" name="selexp[]" value="Marche nordique" checked id="sel3"><label for"sel3">Marche nordique</label><br>
        <input type="checkbox" name="selexp[]" value="Ski de randonnée" checked id="sel4"><label for"sel4">Ski de randonnée</label>
        <input type="checkbox" name="selexp[]" value="Ski de randonnée nordique" checked id="sel5"><label for"sel5"> Ski de randonnée nordique</label>
        <input type="checkbox" name="selexp[]" value="Ski de fond" checked id="sel6"><label for"sel6"> Ski de fond</label><br>
        <input type="checkbox" name="selexp[]" value="Trail" checked id="sel18"><label for"sel18"> Trail</label><br>        
        <input type="checkbox" name="selexp[]" value="Alpinisme" checked id="sel12"><label for"sel12"> Alpinisme</label>
        <input type="checkbox" name="selexp[]" value="Randonnée alpine" checked id="sel12"><label for"sel12"> Randonnée alpine</label>
        <input type="checkbox" name="selexp[]" value="Escalade" checked id="sel7"><label for"sel7"> Escalade</label>
        <input type="checkbox" name="selexp[]" value="Escalade en falaise" checked id="sel17"><label for"sel17"> Escalade en falaise</label>
        <input type="checkbox" name="selexp[]" value="Cascade de glace" checked id="sel8"><label for"sel8"> Cascade de glace</label><br>
        <input type="checkbox" name="selexp[]" value="Kayak" checked id="sel10"><label for"sel10"> Kayak</label>
        <input type="checkbox" name="selexp[]" value="Via ferrata" checked id="sel14"><label for"sel14"> Via ferrata</label><br>
        <input type="checkbox" name="selexp[]" value="VTT" checked id="sel11"><label for"sel11"> VTT</label><br>
        <input type="checkbox" name="selexp[]" value="Club" checked id="sel9"><label for"sel9"> Club</label><br>
        <input type="checkbox" name="selexp[]" value="Formation" checked id="sel15"><label for"sel15"> Formation</label><br>
        <input type="checkbox" name="selexp[]" value="Trail" checked id="sel16"><label for"sel16"> Trail</label><br>        
        <table><td>Adresse pour l\'export par email uniquement : </td><td><input type="text" name="xemail" value="' . $xemail . '"></td></table>

        <input type="hidden" name="auth" value="' . $auth . '"/>
        <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
        <input type="hidden" name="factivite" value="' . $factivite . '"/>  
        <input type="hidden" name="cx" value="' . $cx . '"/>
        <input type="submit" name="commande" value="EXPORT TRIMESTRE">
        <input type="submit" name="commande" value="EXPORTER LA SELECTION">  
        <input type="submit" name="commande" value="EXPORTER EN TABLEAU PAR EMAIL">';              
    retour_menu();
    echo '</form></p></div>';

  }
  else if ($commande == 'EXPORTER LA SELECTION')
  {
    add_log ($commande . ' -' . $auth);
     $sel       = $_POST['selexp'];

    foreach ($sel as $selexp) 
       $selection  .= $selexp;

     //echo 'Sélection : ' . $selection . '<br>';

     $ftxt    = 'export-sorties-' . $year . $month . $day . '-' . $hour . $minute . $second . '.txt';

     $exportf = $DIR_EXPORT . '/' . $ftxt;
     $fdx = fopen ($exportf, 'w');
     if ($fdx)
     {
        $buffer = 'Programmation des activités du CAF au ' . $day . '/' . $month . '/' . $year;
        $line = mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8');
        fprintf ($fdx, "%s\n\n", $line);
        $scan = scandir ($DIR_NOTES);
        sort ($scan);
        $n = 1;
        for ($i=0; $i<sizeof($scan);$i++)
        {
           if (substr($scan[$i],0,1) == '.') continue;
           if (getTrimestreCourant($scan[$i]) == false) continue;

//echo 'Export note ' . substr($scan[$i],0,15) . '<br>';
           $fname = $DIR_NOTES . '/' . $scan[$i];
           $fd = fopen ($fname, 'r');
           $cadre      = submoins1(fgets($fd, 4096));
           $activite   = submoins1(fgets ($fd, 4096));
           $titre      = submoins1(fgets ($fd, 4096));
           if (strstr($selection, $activite) && !stristr($titre, 'camp d'))
           {
             
              $ldiff      = submoins1(fgets ($fd, 4096));
              $diff = substr ($ldiff, 6, strlen($ldiff) - 13);

              $buffer = getExpDate ($scan[$i])  . ' - ' . $cadre . ' - ' . $activite;
              $line = sup_anti_slash(mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8'));
              fprintf ($fdx, "%s\n", $line);
              //$buffer = 'Titre : ' . $titre . ' - Difficulté : ' . $diff . ' - Mod. le ' . getCreationDate($scan[$i]);
              $buffer = $titre . ' - Difficulté : ' . $diff ;
              $line = sup_anti_slash(mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8'));
              fprintf ($fdx, "%s\n", $line);

              $limit=4;
              while (($buffer = fgets($fd, 4096)) !== false) {
                 $line = sup_anti_slash(mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8'));
                 fprintf ($fdx, "%s", $line);
                 if ($limit-- == 0)
                 {
                  break;
                 } 
               fprintf ($fdx, "\n\n");
              }
              fclose ($fd);
              $n++;

            }
          }
          fclose ($fdx);
        

     echo '<p><button style="background:green !important;"><a href="' . $URL . '/EXPORT/' .  $ftxt . '" target="_blank"><font color="white"><b>' . $ftxt . '</b></font></a></button><br></p>';
     echo '<p class="oblique">Utiliser le bouton vert ci-dessus pour exporter le fichier texte des activités et utiliser n\'importe quel éditeur de texte.<br>Selon le navigateur utilisé, vous pouvez également faire "Enregistrer ..." en utilisant le bouton gauche de la souris ou en sélectionnant le lien. Le fichier d\'export sera alors enregistrer sur le dossier choisi de votre appareil. Vous pourrez alors utiliser Word ou un autre éditeur pour l\'ouvrir.</p>
    <form method="post">
    <input type="hidden" name="auth" value="' . $auth . '">
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
    <input type="hidden" name="fcadre" value="' . $fcadre . '">
    <input type="hidden" name="factivite" value="' . $factivite . '"> 
    <input type="hidden" name="cx" value="' . $cx . '"> 
    <input type="hidden" name="xemail" value="' . $xemail . '"> 
    <input type="submit" name="commande" value="LISTE DES ACTIVITES">
    <input type="submit" name="commande" value="EXPORT DU CAMP D\'ETE">
    <input type="submit" name="commande" value="EXPORT TRIMESTRE">';
    retour_menu();
    echo '</form></p>';
    }
  }
  else if ($commande == 'EXPORT TRIMESTRE COLLECTE')
  {
        add_log ($commande . ' -' . $auth);
       
         $ntrimestre = 1;
   
         $first_day = $date_first;
   
         $ftxt    = 'export-trimestre-collecte_' . date('Ymd-His') . '.txt'; 

         $exportf = $DIR_EXPORT . '/' . $ftxt;
         $fdx = fopen ($exportf, 'w');
         if ($fdx)
         {
            $buffer = 'Collecte du trimestre du ' . getJourDate($first_day) . ' au ' . getJourDate($date_last);
            $line = mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8');
            fprintf ($fdx, "%s\n\n", $line);
            $scan = extract_activ_avenir (date('Y-m-d'));
 
            $n = 1;

            foreach ($scan as $note)
            {
               

               if (getTrimestreCourant($note->date_deb) == false) continue;

//echo 'Export note ' . substr($scan[$i],0,15) . '<br>';

               $cadre      = $note->cadre;
               $activite   = $note->activite;
               $titre      = $note->titre;
               if ($activite != 'Escalade' && $activite != 'Club')
               {
                  $diff = $note->diff;
                  switch ($diff)
                  {
                    case 'facile' : $diff='-D:F';break;
                    case 'moyen'  : $diff='-D:M';break;
                    case 'peu difficile' : $diff='-D:PD';
                    case 'assez difficile' : $diff='-D:AD';
                    case 'sans': $diff='';break;
                  }

                  $buffer = getTrimDate ($note->date_deb, $note->date_fin, $note->type)  . ' - ' . $cadre . ' - ' . $activite . ' - ' . $titre . $diff . ' - +' . $note->denivele;
                  $line = sup_anti_slash(mb_convert_encoding ($buffer, 'ISO-8859-1', 'UTF-8'));
                  fprintf ($fdx, "%s\n", $line);
                  
                  $n++;

                }
              }
              fclose ($fdx);
            

         echo '<p><button style="background:green !important;"><a href="' . $URL . '/EXPORT/' .  $ftxt . '" target="_blank"><font color="white"><b>' . $ftxt . '</b></font></a></button><br></p>';
         echo '<p class="oblique">Utiliser le bouton vert ci-dessus pour exporter le fichier texte des activités et utiliser n\'importe quel éditeur de texte.<br>Selon le navigateur utilisé, vous pouvez également faire "Enregistrer ..." en utilisant le bouton gauche de la souris ou en sélectionnant le lien. Le fichier d\'export sera alors enregistrer sur le dossier choisi de votre appareil. Vous pourrez alors utiliser Word ou un autre éditeur pour l\'ouvrir.</p>
        <form method="post">
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="factivite" value="' . $factivite . '"> 
        <input type="hidden" name="cx" value="' . $cx . '"> 
        <input type="hidden" name="xemail" value="' . $xemail . '"> 
        <input type="submit" name="commande" value="LISTE DES ACTIVITES">
        <input type="submit" name="commande" value="EXPORT TRIMESTRE COLLECTE">';         
        retour_menu();
        echo '</form></p>';
      }

  }
  else if ($commande == 'EXPORTER EN TABLEAU PAR EMAIL')
  {
      echo '<p class="oblique"><font color="blue">Cette nouvelle commande permet de recevoir la liste des sorties par mail sous la forme d\'un tableau. Prenez la précaution de saisir corrctement votre adresse mail.</font></p>';

      add_log ($commande . ' -' . $auth);
      $sel       = $_POST['selexp'];

      foreach ($sel as $selexp) 
        $selection  .= $selexp;
 
      $sujet   = 'Export de la sélection des sorties';

      $buffer = '<p><font color="blue">Programmation des activités du CAF au ' . $day . '/' . $month . '/' . $year . '</p>
      <table style="border:1px solid blue; border-collapse:collapse;">
      <tr><th style="border:1px solid blue;">Date</th><th style="border:1px solid blue;">Encadrant</th><th style="border:1px solid blue;">Activité</th><th style="border:1px solid blue;">Titre</th><th style="border:1px solid blue;">Diff.</th><th style="border:1px solid blue;">Détail</th></tr>';
            
      $scan = scandir ($DIR_NOTES);
      sort ($scan);
      $n = 1;
      for ($i=0; $i<sizeof($scan);$i++)
      {
         if (substr($scan[$i],0,1) == '.') continue;
         if (getTrimestreCourant($scan[$i]) == false) continue;

//echo 'Export note ' . substr($scan[$i],0,15) . '<br>';
         $fname = $DIR_NOTES . '/' . $scan[$i];
         $fd = fopen ($fname, 'r');
         $cadre      = submoins1(fgets($fd, 4096));
         $activite   = submoins1(fgets ($fd, 4096));
         $titre      = submoins1(fgets ($fd, 4096));
         if (strstr($selection, $activite) && !stristr($titre, 'camp d'))
         {
           
            $ldiff      = submoins1(fgets ($fd, 4096));
            $diff = substr ($ldiff, 6, strlen($ldiff) - 13);

            $buffer .= '<tr><td style="border:1px solid blue;">' . getExpDate ($scan[$i])  . '</td><td style="border:1px solid blue;">' . $cadre . '</td><td style="border:1px solid blue;">' . $activite . '</td><td style="border:1px solid blue;">'  .  $titre . '</td><td style="border:1px solid blue;">' . $diff . '</td><td style="border:1px solid blue;">';
            

            $limit=4;
            while (($buffer .= fgets($fd, 4096)) !== false) {
              if ($limit-- == 0)
                  break;
                  $buffer .= '</td></tr>';
            }
            fclose ($fd);
            $n++;

          }
        }
        $buffer .= '</table></font>';
      

        //echo $destinataire . '<br>';
        $destinataire = $xemail;
        $crm = sendmail ($destinataire, $sujet, $buffer);

        if ($crm)
          echo 'Envoi de l\'export des sorties à l\'adresse ' . $xemail . ' avec succès. Regarder votre boîte mail.<br>'; 

        echo '<p><form method="post">
          <input type="hidden" name="auth"      value="' . $auth . '">
          <input type="hidden" name="fcadre"    value="' . $fcadre . '">
          <input type="hidden" name="factivite" value="' . $factivite . '"> 
          <input type="hidden" name="cx"        value="' . $cx . '">         
          <input type="hidden" name="xemail"    value="' . $xemail . '">';
        retour_menu();
        echo '</form></p>';
  }
  else if ($commande == 'EXTRAIRE ADHERENT' || $commande == 'EXTRAIRE NON RENOUVELE')
  {
       $licence = $_POST['licence'];
      if (strstr($commande,'ADHERENT')) 
        echo '<h1>Données FFCAM du licencié ' . $licence . '</h1>';
      else
        echo '<h1>Données FFCAM - licence non renouvelée ' . $licence . '</h1>';

      $result = extract_adh_web($licence);
      if ($result)
      {
     
        echo '<table border="1">
        <tr><td class="noir" width="30%">Nom</td><td class="noir">'            .  $result->prenom . ' ' . $result->nom  .    '</td></tr>
        <tr><td class="noir" width="30%">Licence</td><td class="noir">'        .  $result->id .                              '</td></tr>
        <tr><td class="noir" width="30%">Catégorie</td><td class="noir">'      . $result->categorie .                        '</td></tr>
        <tr><td class="noir" width="30%">Naisssance</td><td class="noir">'     . $result->date_naissance .                   '</td></tr>
        <tr><td class="noir" width="30%">Mobile</td><td class="noir">'         . $result->portable .                         '</td></tr>
        <tr><td class="noir" width="30%">Tél. fixe</td><td class="noir">'      . $result->tel .                              '</td></tr>
        <tr><td class="noir" width="30%">Mail</td><td class="noir">'           . $result->email .                            '</td></tr>
        <tr><td class="noir" width="30%">Accident qui ?</td><td class="noir">' . $result->accident_qui . ' (' . $result->accident_tel . ')</td></tr>
        <tr><td class="noir" width="30%">Assurance AP</td><td class="noir">'   . $result->date_assurance_ap .                '</td></tr>
        <tr><td class="noir" width="30%">Assurance ACR</td><td class="noir">'  . $result->date_assurance_acr.                '</td></tr>
        <tr><td class="noir" width="30%">Adresse</td><td class="noir">'        . $result->adresse3 . ' ' . $result->codepostal . ' ' . $result->ville  . '</td></tr> 
        <tr><td class="noir" width="30%">ACTIVITES</td><td class="noir">';
        $act = $result->activites_pratiquees;
        foreach ($act as $acti)
          echo $acti->description . ' , ';
        echo '</td></tr>
        <tr><td class="noir" width="30%">DIPLOME(S)</td><td class="noir">';
        $dip = $result->diplomes;
        foreach ($dip as $dipl)
          echo $dipl->libelle . ' (' . $dipl->diplome . ') , ';
        echo '</td></tr>
        <tr><td class="noir" width="30%">FONCTION(S)</td><td class="noir">';
        $fonc = $result->fonctions;
        foreach ($fonc as $fonct)
          echo $fonct->libelle  . ' , ';
        echo '</td></tr>';
        echo '</table>';

      }
      echo '<form method="post">
      Entrer le numéro de licence
      <input type="text" name="licence" value="' . $licence . '" required>
      <input type="submit" name="commande" value="EXTRAIRE ADHERENT">';
      retour_menu();
      echo '
      <input type="hidden" name="auth"    value = "' . $auth . '"> 
      <input type="hidden" name="cadre_p" value = "' . $cadre_p . '"> 
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="cx"        value="' . $cx . '"> 
      </form>';
  }    
  else if ($commande == 'VERIFICATION LICENCE')
  {
      $nomadh = $_POST['nomadh'];
      $licence_saison = '7496' . $annee_licence . '0000';
      add_log ($commande . ' ' . $nomadh);
      $req = "SELECT COUNT(*) AS count FROM cal_adherent";
      $rep = $wpdb2->get_results($req);
      $total_count = $rep[0]->count;
      $req = "SELECT COUNT(*) AS count FROM cal_adherent where inscription like '2%%'";
      $rep = $wpdb2->get_results($req);
      $licence_count = $rep[0]->count;
      $req = "SELECT COUNT(*) AS count FROM cal_adherent where id > " . $licence_saison;
      $rep = $wpdb2->get_results($req);
      $nouveaux = $rep[0]->count;
      echo '<div class="detail"><h1>Vérification des licences (' . $licence_count . '/' . ($total_count - $nouveaux) . ' dont ' . $nouveaux . ' nouvelles)</h1>
      <form method="post"><input type="checkbox" name="renouv" value="avec" id="ren1"> <label for"ren1">afficher aussi les non renouvelés</label><br>
      Entrer les premières lettres du nom à contrôler ou le numéro de licence ou rien pour tout rechercher  :
      <br>
      <input type="text" name="nomadh" value="' . $nomadh . '">
      <input type="hidden" name="auth" value = "' . $auth . '"> 
      <input type="hidden" name="cadre_p" value = "' . $cadre_p . '"> 
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="cx" value="' . $cx . '">   
      <input type="submit" name="commande" value="CONTROLE ADHERENT">'; 
      retour_menu();
      echo '</form></div>';
  }
  else if ($commande == 'CONTROLE ADHERENT')
  {
    echo '<div class="detail">';
    $renouv = $_POST['renouv'];
    $nomadh = rtrim($_POST['nomadh']);
     //connexion à la base du calendrier
    $licence_saison = '7496' . $annee_licence . '0000';
    add_log ($commande . ' ' . $nomadh);
    $req = "SELECT COUNT(*) AS count FROM cal_adherent WHERE inscription LIKE '2%%'";
    $rep = $wpdb2->get_results($req);
    $total_count = $rep[0]->count;
    $req = "SELECT COUNT(*) AS count FROM cal_adherent WHERE inscription like '2%%'";
    $rep = $wpdb2->get_results($req);
    $licence_count = $rep[0]->count;
    $req = "SELECT COUNT(*) AS count FROM cal_adherent WHERE id > " . $licence_saison;
    $rep = $wpdb2->get_results($req);
    $nouveaux = $rep[0]->count;

    if (substr($nomadh, 0,4) == '7496')
    {
      $req = "SELECT * FROM cal_adherent WHERE id = " . $nomadh . " AND inscription LIKE '2%%'";
    }
    else if ($nomadh == '')
    {
      $req = "SELECT * FROM " . $table_adherent; 
      if ($renouv == '') 
        $req .= " WHERE inscription LIKE '2%%'";
      $req .= " ORDER BY nom ASC";
    }
    else
    {
      $req = "SELECT * FROM " . $table_adherent . " WHERE nom LIKE '" . $nomadh. "%%'";
      if ($renouv == '') 
        $req .= " AND inscription LIKE '2%%'";
      $req .= " ORDER BY nom ASC";
    }


    $rep = $wpdb2->get_results($req);


    if (sizeof($rep) == 1 && substr($nomadh, 0,4) == '7496' && $auth == $code_admin)
    {
        $d = $rep[0];
        echo 'Accès en modification aux données de ' . $d->prenom .  ' ' . $d->nom . '<br>'; 
      
        echo '<form method="post">
        Prénom : <input type="text" name="prenom" value="' . $d->prenom . '">
        Nom :    <input type="text" name="nom" value="'    . $d->nom .    '">
        Mobile : <input type="text" name="mobile" value="' . $d->mobile . '">
        Email :  <input type="text" name="email" value="'  . $d->email .  '">
         <input type="hidden" name="nomadh" value = "' . $nomadh . '">
         <input type="hidden" name="auth" value = "' . $auth . '"> 
         <input type="hidden" name="cadre_p" value = "' . $cadre_p . '">
         <input type="hidden" name="factivite" value="' . $factivite . '">
         <input type="hidden" name="cx" value="' . $cx . '"> 
         <input type="submit" name="commande" value="MODIFIER ADHERENT"> 
         </form>';    
    }
    else if (sizeof ($rep) > 0)
    {
        echo '<h1>Table des licences (' . $licence_count . '/' . ($total_count - $nouveaux) . ' dont ' . $nouveaux . ' nouveaux)</h1>
        <p class="oblique_bleu">Les nouveaux licenciés se distinguent par un numéro de licence supérieur à ' . $licence_saison . '.</p><table border="1"><tr><th class="noir">Licence</th><th class="noir">Prénom</th><th class="noir">Nom</th><th class="noir">Mobile</th><th class="noir">Email</th><th class="noir">Inscription</th></tr>';
    

        foreach ($rep as $d) 
        {
            if (substr($d->inscription,0,1) == '2')
            {
              $idref++;
              echo '<tr><td class="bleu">';
              echo '<form method="post" id="' . $idref . '"><a href="#" onClick="Submit(\'', $idref, '\');" 
              TITLE="Cliquez ici pour obtenir les données complètes FFCAM de l\'adhérent">
                <input type="hidden" name="nomadh" value = "' . $nomadh . '">
                 <input type="hidden" name="auth" value = "' . $auth . '"> 
                 <input type="hidden" name="cadre_p" value = "' . $cadre_p . '">
                 <input type="hidden" name="factivite" value="' . $factivite . '">
                 <input type="hidden" name="cx" value="' . $cx . '"> 
              <input type="hidden" name="licence" value="' . $d->id . '" />
              <input type="hidden" name="commande" value="EXTRAIRE ADHERENT">';
                                       
              echo '</form><b>' . $d->id  . '</b></a></div>
              </td><td class="bleu">' . $d->prenom . '</td><td class="bleu">' . $d->nom . '</font></td><td class="bleu">' . $d->mobile . '</font></td><td class="bleu">' .  $d->email . '</td><td class="bleu">' . $d->inscription . '</td></tr>';
            }
            else
            {
              $idref++;
              echo '<tr><td class="rouge">';
              echo '<form method="post" id="' . $idref . '"><a href="#" onClick="Submit(\'', $idref, '\');" 
              TITLE="Cliquez ici pour obtenir les données complètes FFCAM de la licence non renouvelée">
                <input type="hidden" name="nomadh" value = "' . $nomadh . '">
                 <input type="hidden" name="auth" value = "' . $auth . '"> 
                 <input type="hidden" name="cadre_p" value = "' . $cadre_p . '">
                 <input type="hidden" name="factivite" value="' . $factivite . '">
                 <input type="hidden" name="cx" value="' . $cx . '"> 
              <input type="hidden" name="licence" value="' . $d->id . '" />
              <input type="hidden" name="commande" value="EXTRAIRE NON RENOUVELE">';
              echo '</form><b>' . $d->id  . '</b></a></div>
              </td><td class="rouge">' . $d->prenom . '</td><td class="rouge">' . $d->nom . '</font></td><td class="rouge">' . $d->mobile . '</font></td><td class="rouge">' .  $d->email . '</td><td class="rouge">' . $d->inscription . '</td></tr>';
            }
        }
       
    
  
      if (sizeof($rep) > 0)
      {
        echo '</table>';
      }
  }
  else
    echo '<h1>Adhérent non trouvé</h1>
      <p class="oblique_rouge">Le nom <b>' . $nomadh . '</b> n\'est pas connu de la base du calendrier. Vérifiez bien l\'orthographe du nom recherché avant de relancer le contrôle ou ne mettez que les premières lettres du nom.</p>';
  echo '
    <form method="post"><input type="checkbox" name="renouv" value="avec" id="ren1"> <label for"ren1">rechercher aussi les non renouvelés</label>
    <br>Entrer les premières lettres du nom à contrôler ou rien pour tout rechercher :
    <br><input type="text" name="nomadh" value="' . $nomadh . '">
    <input type="hidden" name="auth" value = "' . $auth . '" > 
    <input type="hidden" name="cadre_p" value = "' . $cadre_p . '"> 
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="cx" value="' . $cx . '"> 
    <input type="submit" name="commande" value="CONTROLE ADHERENT">'; 
    retour_menu();
    echo '</form></div>';
  }
  else if ($commande == 'MODIFIER ADHERENT')
  {  
      $nomadh = $_POST['nomadh'];
      $nom    = $_POST['nom'];
      $prenom = $_POST['prenom'];
      $mobile = $_POST['mobile'];
      $email  = $_POST['email'];
    echo '<div class="detail"><h1>Modification adhérent</h1><table>
    <tr><td class="noir">Licence</td><td class="noir"> ' . $nomadh .  '</td></tr>
    <tr><td class="noir">Prénom</td><td class="noir">'  . $prenom . '</td></tr>
    <tr><td class="noir">Nom</td><td class="noir"> '  .    $nom . '</td></tr>
    <tr><td class="noir">mobile</td><td class="noir"> '  . $mobile . '</td></tr>
    <tr><td class="noir">email</td><td class="noir">' .   $email . '</td></tr></table>
    <form method="post">
    <input type="hidden" name="auth" value = "' . $auth . '" > 
    <input type="hidden" name="cadre_p" value = "' . $cadre_p . '"> 
    <input type="hidden" name="cx" value="' . $cx . '">';  
    retour_menu();
    echo '</form></div>';

  }
  else if (strstr($commande, 'CREATION'))
  {
    add_log ($commande);
    echo '<div class="detail"><h1>Nouvelle programmation d\'une activité';
    $date_min = date('Y-m-d'); 
    if (!strstr($commande, 'COLLECTE'))
    {
      if ($auth != $code_admin)
          $date_max = date('Y-m-d', strtotime($date_min . '+ 1 year'));
      else
          $date_max = date('Y-m-d', strtotime($date_min . '+ 3 year'));
      $collecte = 0;
    }
    else
    {
      $date_min = $date_first;
      $date_max = $date_last;
      $collecte = 1;
    }

//echo 'COLLECTE=' . $collecte . '<br>';

    if (!strstr($commande, "COLLECTE"))
      echo ' hors collecte';
    else if ($status_auth == 'open')
      echo ' (collecte en cours)';
    echo '</h1>';
    
    //echo '<p class="oblique"><font color="blue">La date max des activités est limitée au ' . getJourDate($date_max) . '</font></p>';
    $IDU=0;
    $mode='Simple';
    $type='';
    $date_deb='';
    $date_fin='';
    $coencadrant='';
    $activite='';
    $titre='';
    $detail='';
    $denivele='';
    $formation=0;
    $cadre = $cadre_p;
    affich_sortie ($IDU, $mode, $type, $date_deb, $date_fin, $cadre, $coencadrant, $activite, $titre, $detail, $denivele, $formation, $maxp, $corbeille=false, 
      $cotation, $kms,$camp);
    //affich_sortie ('N', 'Simple', '', '','', '', $cadre, '', '' , '');
     echo '</div><!--CREATION-->';
  }
  else if ($commande == 'STATISTIQUE DES CR')
  {
    $decr    = $_POST['debcr'];
    $fincr   = $_POST['fincr'];
    $cadrecr = $_POST['cadrecr'];
    if ($debcr == '') $debcr=get_debut_saison ();
    if ($fincr == '') $fincr=date('Y-m-d');
    add_log ($commande);
    echo '<div class="detail"><h1>Statistiques sur les comptes-rendus d\'une période</h1>
    <form method="post">
    Début statistique : <input type="date" min="2022-01-01" max="' . date('Y-m-d') . '" name="debcr" value="' . $debcr . '">
    Fin statistique :   <input type="date" min="2022-01-01" max="' . date('Y-m-d') . '" name="fincr" value="' . $fincr . '"><br>
    Nom de l\'encadrant sans son prénom (tous si champ vide) <input type="text" name="cadrecr" value="' . $cadrecr . '">
    <input type="hidden" name="xemail" value="' . $xemail . '"/> 
    <input type="hidden" name="auth" value="' . $auth . '"/>
    <input type="hidden" name="fcadre" value="' . $fcadre . '"/> 
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
    <input type="hidden" name="factivite" value="' . $factivite . '"/>
    <input type="hidden" name="cx" value="' . $cx . '"/>        
    <input type="submit" name="commande" value="STATS CR">';
    retour_menu();
    echo '</form></div>';
  }
  else if ($commande == 'STATS CR')
  {
      $debcr   = $_POST['debcr'];
      $fincr   = $_POST['fincr'];
      $cadrecr = strtoupper(wd_remove_accents($_POST['cadrecr']));
      add_log ($commande . ' - ' . $debcr . ' - ' . $fincr . ' - ' . $cadrecr);
      echo '<div class="detail"><h1>Statistiques sur les comptes-rendus du ' . getJourDate($debcr) . ' au ' . getJourDate($fincr) . ' - ' . $cadrecr . '</h1>';
      $noteall = extract_activ_avenir($debcr);
      echo '<table border="1">
        <th class="noir">Date</th><th class="noir">Type</th><th class="noir">Encadrant</th><th class="noir">titre</th><th class="noir">Nb part</th><th class="noir">Kms</th><th class="noir">Chauffeur</th>';
      foreach ($noteall as $note)
      {
        if ($note->date_deb > $fincr) continue;
        if ($note->annulation == 1) continue;
        if ($note->cr == 0) continue;
        if (extract_cr_participants($note->IDU) == 0) continue;
        if ($note->activite == 'Club' || $note->activite == 'Test') continue;
        if ($cadrecr != '')
        {
          if (!stristr($note->cadre, $cadrecr)) continue;
        }
               //tenir compte du nombre de jour
        $tF=strtotime($note->date_fin);
        $tD=strtotime($note->date_deb);
        $nbj = round((($tF - $tD)/86400) + 1, 0);
        //echo 'NBJ = ' . $nbj . '<br>';
        $nb = abs(extract_cr_participants ($note->IDU));
        //echo 'PAR = ' . $nb. '<br>';
        $nbre = $nbj * $nb;
        $kms = extract_cr_kms($note->IDU);
        if (extract_cr_chauffeur($note->IDU) == 1) 
          $chauffeur='O'; 
        else 
          $chauffeur = 'N';

        $date = date('d/m/Y', strtotime($note->date_deb));
        if ($note->date_fin != $note->date_deb)
          $date = date('d/m/Y', strtotime($note->date_deb)) . ' au ' . date('d/m/Y', strtotime($note->date_fin));
        echo '<tr><td class="noir">' . $date . '</td>
                  <td class="noir">' . $note->activite . '</td>
                  <td class="noir">' . $note->cadre .    '</td>
                  <td class="noir">' . substr($note->titre,0,50) .    '</td>
                  <td class="noir">' . $nbre        .    '</td>
                  <td class="noir">' . $kms         .    '</td>
                  <td class="noir">' . $chauffeur   .    '</td>
                  </tr>';
 
      }
       echo '</table><h1>Export des données</h1>';

      $file = $DIR_EXPORT . "/export_stat_cr.doc";
      $fde  = fopen($file, 'w');
      if ($fde)
      {
        $titre = "Statistique des comptes-rendus du " . getJourDate($debcr) . " au " . getJourDate($fincr) . " - " . $cadrecr . "\n\n";
        fprintf ($fde, $titre);
        $noteall = extract_activ_avenir($debcr);
       
        foreach ($noteall as $note)
        {
          if ($note->date_deb > $fincr) continue;
          if ($note->annulation == 1) continue;
          if ($note->cr == 0) continue;
          if ($note->activite == 'Club' || $note->activite == 'Test') continue;
          if ($cadrecr != '')
          {
            if (!stristr($note->cadre, $cadrecr)) continue;
          }
                 //tenir compte du nombre de jour
          $tF=strtotime($note->date_fin);
          $tD=strtotime($note->date_deb);
          $nbj = round((($tF - $tD)/86400) + 1, 0);
          //echo 'NBJ = ' . $nbj . '<br>';
          $nb = abs(extract_cr_participants ($note->IDU));
          //echo 'PAR = ' . $nb. '<br>';
          $nbre = $nbj * $nb;
          $kms = extract_cr_kms($note->IDU);

          $date = date('d/m/Y', strtotime($note->date_deb));
          if ($note->date_fin != $note->date_deb)
            $date = date('d/m/Y', strtotime($note->date_deb)) . ' au ' . date('d/m/Y', strtotime($note->date_fin));
          $line = $date . "\t" . $note->activite . "\t" . $note->cadre . "\t" . substr($note->titre,0,50) . "\t" . $nbre . "\t" . $kms . "\n";
          fprintf ($fde, $line);
     
        }
        fclose ($fde);
      }
      else
      {
        echo 'Impossible d\'ouvrir ' . $file . '<br>';
      }
      $mailcr = wd_remove_accents(recherche_mail_cadre ($cadre_p));
      echo '<form method="post">
      Début statistique : <input type="date" min="2022-01-01" max="' . date('Y-m-d') . '" name="debcr" value="' . $debcr . '">
      Fin statistique :   <input type="date" min="2022-01-01" max="' . date('Y-m-d') . '" name="fincr" value="' . $fincr . '"><br>
      Nom de l\'encadrant sans son prénom (tous si champ vide) <input type="text" name="cadrecr" value="' . $cadrecr . '">
      Mail destinataire pour export 
      <input type="text" name="mailcr"      value="' . $mailcr . '">
      <input type="hidden" name="xemail"    value="' . $xemail . '"> 
      <input type="hidden" name="auth"      value="' . $auth . '">
      <input type="hidden" name="fcadre"    value="' . $fcadre . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="cx"        value="' . $cx . '"> 
      <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
      <input type="hidden" name="exportcr"  value="' . $file . '">
      <input type="submit" name="commande"  value="STATS CR">
      <input type="submit" name="commande"  value="EXPORT MAIL CR">';
      retour_menu();
      echo '</form></div>';
  }
  else if ($commande == 'EXPORT MAIL CR')
  {
      $mailcr = $_POST['mailcr'];
      $debcr   = $_POST['debcr'];
      $fincr   = $_POST['fincr'];
      $cadrecr = strtoupper(wd_remove_accents($_POST['cadrecr']));
      echo '<div class="detail"><h1>Statistiques sur les comptes-rendus du ' . getJourDate($debcr) . ' au ' . getJourDate($fincr) . ' - ' . $cadrecr . '</h1>';
      $noteall = extract_activ_avenir($debcr);


      $sujet   = 'Statistiques sur les comptes-rendus du ' . getJourDate($debcr) . ' au ' . getJourDate($fincr) . ' - ' . $cadrecr;


      if ($mailcr != '')
      {
          $buffer = '<font color="blue"><table border="1">
        <th>Date</th><th>Type</th><th>Encadrant</th><th>titre</th><th>Nb part</th><th>Kms</th><th>Chauffeur</th>';

          foreach ($noteall as $note)
          {
            if ($note->date_deb > $fincr) continue;
            if ($note->annulation == 1) continue;
            if ($note->cr == 0) continue;
            if (extract_cr_participants($note->IDU) == 0) continue;
            if ($note->activite == 'Club' || $note->activite == 'Test') continue;
            if ($cadrecr != '')
            {
              if (!stristr($note->cadre, $cadrecr)) continue;
            }
                   //tenir compte du nombre de jour
            $tF=strtotime($note->date_fin);
            $tD=strtotime($note->date_deb);
            $nbj = round((($tF - $tD)/86400) + 1, 0);
            //echo 'NBJ = ' . $nbj . '<br>';
            $nb = abs(extract_cr_participants ($note->IDU));
            //echo 'PAR = ' . $nb. '<br>';
            $nbre = $nbj * $nb;
            $kms = extract_cr_kms($note->IDU);
            if (extract_cr_chauffeur($note->IDU) == 1)
              $chauffeur = 'O';
            else
              $chauffeur = 'N';

            $date = date('d/m/Y', strtotime($note->date_deb));
            if ($note->date_fin != $note->date_deb)
              $date = date('d/m/Y', strtotime($note->date_deb)) . ' au ' . date('d/m/Y', strtotime($note->date_fin));
            $buffer .= '<tr><td class="noir">' . $date . '</td>
                      <td>' . $note->activite . '</td>
                      <td>' . $note->cadre .    '</td>
                      <td>' . substr($note->titre,0,80) .    '</td>
                      <td>' . $nbre        .    '</td>
                      <td>' . $kms         .    '</td>
                      <td>' . $chauffeur   .    '</td>
                      </tr>';
     
          }
          $buffer .= '</table></font>';


          $crm = sendmail ($mailcr, $sujet, $buffer);
          echo 'Mail envoyé à ' . $mailcr . '<br>';

      }
      echo '<form method="post">
      <input type="hidden" name="xemail"    value="' . $xemail . '"> 
      <input type="hidden" name="auth"      value="' . $auth . '">
      <input type="hidden" name="fcadre"    value="' . $fcadre . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="cx"        value="' . $cx . '"/> 
      <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
      <input type="hidden" name="exportcr"  value="' . $file . '">
      <input type="submit" name="commande"  value="STATISTIQUE DES CR">';
      retour_menu();
      echo '</form></div>';
  }
  else if ($commande == 'IMPORT ACTIVITES CSV' || 
           $commande == 'RETOUR IMPORT CSV')
  { 
    echo '<div class="detail">
    <h1>Import pour récurrence des activités</h1>
    <p>Il faut construire un fichier csv (Excel) avec les données suivantes : <br>
    Colonne 1 : la date dans le format à préciser<br>
    Colonne 2 : le type d\'activité<br>
    Colonne 3 : prénom et nom de l\'encadrant<br>
    Colonne 4 : vide ou prénom et nom du co-encadrant<br></p>
    Colonne 5 : le titre de l\'activité<br>
    Colonne 6 : description de l\'activité<br>    
    <form method="post" enctype="multipart/form-data">
    Fichier d\'import csv : <input type="file" id="file" name="ffcsv" accept=".csv" value=""> 
    <input type="submit" name="commande"    value="ACQUERIR CSV">
    <input type="hidden" name="xemail"      value="' . $xemail . '"> 
    <input type="hidden" name="auth"        value="' . $auth . '">
    <input type="hidden" name="fcadre"      value="' . $fcadre . '">
    <input type="hidden" name="factivite"   value="' . $factivite . '">
    <input type="hidden" name="cx"          value="' . $cx . '">  
    <input type="hidden" name="cadre_p"     value="' . $cadre_p . '">';
    retour_menu();
    echo '</form></div>';
  }
  else if ($commande == 'ACQUERIR CSV')
  {
      $ffcsv = $_FILES['ffcsv'];
      echo '<div class="detail"><h1>Contrôle du fichier d\'import "' . $ffcsv['name'] . '"</h1>';
      $fd = fopen ($ffcsv['tmp_name'], 'r');
      echo '<table border="1">
      <th width="15%">Date</th><th>Activité</th><th>Encadrant</th><th>Coencadrant</th><th>Titre</th><th>Détail</th>';
      $n=0;
      for ($ligne = fgetcsv($fd, 1024, ";"); !feof($fd); $ligne = fgetcsv($fd, 1024, ";")) 
      {
        if ($n > 0)
        {
          $bloc[]  = array('date' => $ligne[0] , 'activite' => $ligne[1] ,'cadre'=>$ligne[2], 'coencadrant'=>$ligne[3], 'titre'=>mb_convert_encoding($ligne[4], 'UTF-8', 'ISO-8859-1'), 'detail'=>mb_convert_encoding($ligne[5], 'UTF-8', 'ISO-8859-1'));
          $bdate[$n-1]=$ligne[0];
          //print_r ($bloc);
        }
        $n++;
      }
      fclose ($fd);
      $bloctri = array_values(array_sort($bloc, 'date', SORT_ASC));
      $datedup = array_count_values($bdate);

     
      $err=0;
      $date1an = date('Y-m-d', strtotime(date('Y-m-d') . "+ 1 year"));
      //echo 'DATA1AN = ' . $date1an ;
      foreach ($bloctri as $note)
      {
        $cadre = strtoupper(wd_remove_accents(recherche_cadre ($note['cadre'])));

        $coencadrant  = strtoupper(wd_remove_accents(recherche_cadre ($note['coencadrant'])));
        $activite = $note['activite'];         
        $act_cadre    = extract_activite_cadre($cadre);
        $act_co       = extract_activite_cadre($coencadrant);
        $date         = date('d/m/Y', strtotime($note['date']));
        $date = getJourDate($note['date']);
        $cote = $note['date'] ; 
        $dat1 = date('m/d/Y', strtotime($note['date']));
 

        if ($dat1 == '01/01/1970')
        {
          $date = '<font color="red">' . $note['date'] . ' (1)</font>';
          $err=1;
          //echo 'err1 ' . $note['date'];
        }
 
        else if (strtotime($note['date']) < time())
        {
          $date = '<font color="red">' . $note['date'] . ' (2)</font>';
          $err=2;
        }
        else if ($note['date'] > $date1an)
        {
          $date = '<font color="red">' . $note['date'] . ' (3)</font>';
          $err=3;
        }
        else if ($datedup[$cote] > 1)
        {

          $date = '<font color="red">' . $note['date'] . ' (4)</font>';
          $err=4;
        }
        if ($note['cadre'] == '')
        {
          $cadre = '<font color="red">Encadrant obligatoire (5)</font>';
          $err=5;
        }
        else
        {

          if (sizeof(explode(' ', $cadre)) != 2) 
          {
            $cadre = '<font color="red">' . $note['cadre'] . ' (6)</font>';
            $err=6;
          }
        
          else if (!stristr($act_cadre, 'Escalade'))
          {
             $cadre = '<font color="red">' . $cadre . ' (7)</font>';
             $err=7;
          }

          //controle si une soirée est déjà occupée par le cadre
          if (controle_act_cadre($cadre, $note['date'], 'Escalade') )
          {
            $cadre = '<font color="red">' . $cadre . ' (11)</font>';
            $err=11;
          }
        }
        if ($note['coencadrant'] != '')
        {
          if (sizeof(explode(' ', $coencadrant)) != 2) 
          {
            $coencadrant = '<font color="red">' . $note['coencadrant'] . ' (8)</font>';
            $err=8;
          }

          else if (!stristr($act_co, 'Escalade'))
          {
            $coencadrant = '<font color="red">' . $coencadrant . ' (9)</font>';
            $err=9;
          }
          //controle si une soirée est déjà occupée par le cadre
          if (controle_act_cadre($coencadrant, $note['date'], 'Escalade') )
          {
            $coencadrant = '<font color="red">' . $cadre . ' (12)</font>';
            $err=12;
          }
        }
        $titre = $note['titre'];
        if ($titre == '')
        {
          $titre = '<font color="red">Titre obligatoire (10)</font>';
          $err=10;
        }
        $detail = $note['detail'];
        
        echo '<tr><td width="15%">' . $date . '</td>
                  <td>' . $activite . '</td>
                  <td>' . $cadre . '</td>
                  <td>' . $coencadrant . '</td>
                  <td>' . $titre . '</td>
                  <td>' . $detail . '</td></tr>';
      }
      echo '</table>';

      if ($err > 0)
      {
        echo '<p>Au moins une erreur est signalée en rouge dans votre tableau csv. Corriger le tableau et relancer l\'acquisition du fichier csv.</p>
        (1) La date n\'est pas au format YYYY-MM-DD  (2) La date est antérieure à la date du jour (3) La date dépasse la limite d\'une année (4) Des dates sont dupliquées (5) L\'encadrant est obligatoire (6) le nom du cadre est inconnu (7) Le cadre n\'encadre pas l\'escalade (8) Le coencadrant est inconnu (9) Le coencadrant n\'encadre pas l\'escalade (10) Un titre est obligatoire (11) encadrant déjà occupé avec une activité (12) coencadrant déjà occupé avec une activité<br>

        <form method="post" enctype="multipart/form-data">
        Fichier d\'import csv : <input type="file" id="file" name="ffcsv" accept=".csv" value=""> 
        <input type="submit" name="commande" value="ACQUERIR CSV">
        <input type="hidden" name="xemail" value="' . $xemail . '"> 
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">';
        retour_menu();
        echo '</form>';
      }
      else
      {
        echo '<p>Aucune erreur détectée dans le fichier d\'import csv des activités. Vérifier bien les jours de semaine avant de confirmer la génération de toutes les activités du tableau ainsi que d\'éventuelles erreurs d\'orthographe.</p>';

        move_uploaded_file ($ffcsv['tmp_name'], $DIR . '/' . $ffcsv['name']);

        echo '
        <form method="post">
        <input type="hidden" name="xemail" value="' . $xemail . '"> 
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="csvname" value="' . $DIR . '/' . $ffcsv['name'] . '">
        <input type="submit" name="commande" value="GENERATION DES ACTIVITES"> 
        <input type="submit" name="commande" value="RETOUR IMPORT CSV">'; 
        retour_menu();
        echo '</form>';
      }
      
      echo '</div>';
  }
  else if ($commande == 'GENERATION DES ACTIVITES')
  {
      $csvname = sup_anti_slash($_POST['csvname']);
      echo '<div class="detail"><h1>Génération des activités avec import fichier </h1>';
      echo 'CSV : ' . basename($csvname) . '<br>';
      $fd = fopen ($csvname, 'r');
      
      $n=0;
      for ($ligne = fgetcsv($fd, 1024, ";"); !feof($fd); $ligne = fgetcsv($fd, 1024, ";")) 
      {
        if ($n > 0)
        {
          $bloc[]  = array('date' => $ligne[0] , 'activite' => $ligne[1], 'cadre'=>$ligne[2], 'coencadrant'=>$ligne[3], 'titre'=>mb_convert_encoding($ligne[4], 'UTF-8', 'ISO-8859-1'), 'detail'=>mb_convert_encoding($ligne[5], 'UTF-8', 'ISO-8859-1'));
          $bdate[$n-1]=$ligne[0];
        }
        $n++;
      }
      fclose ($fd);
      $bloctri = array_values(array_sort($bloc, 'date', SORT_ASC));
      unlink ($csvname);
      foreach($bloctri as $note)
      {
        //print_r ($note);
        $IDU = get_IDU ($ident, false);  // nouveau IDU
        $ident = get_new_ident ();
        $date_deb = $date_fin = $note['date'];
        $cadre        = strtoupper(wd_remove_accents(recherche_cadre ($note['cadre'])));
        $activite = $note['activite'];
        if ($note['coencadrant'] != '')
            $coencadrant  = strtoupper(wd_remove_accents(recherche_cadre ($note['coencadrant'])));
        else 
            $coencadrant = '';         

        $type = 'U';
        $date_cre = date('Y-m-d H:i:s');
        $titre = $note['titre'];
        $diff = 'sans';
        $CP = $CT = '';
        $detail = $note['detail'];
        $denivele = 0;
        $formation = 0;
        $maxp=0;
        $kms = 0;
        
        add_log ($commande . ' Attribution IDU n° ' . $IDU . ' - ' . $cadre . ' - ' . $titre); 
        add_log ('enreg_sortie_IN - ' . $date_deb . ' - ' . $cadre);
        $ret = enregistrement_sortie ($IDU, $ident, $type, $date_deb, $date_fin, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $CP, $CT, $detail, $denivele, $formation, $maxp, $cotation, $kms);
        if ($ret == false)
          echo 'Une erreur pendant l\'enregistrement<br>';

        affich_detail_bloc($IDU);
      }
      echo '
        <form method="post">
        <input type="hidden" name="xemail"    value="' . $xemail . '"> 
        <input type="hidden" name="auth"      value="' . $auth . '">
        <input type="hidden" name="fcadre"    value="' . $fcadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="cx"        value="' . $cx . '">
        <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
        <input type="submit" name="commande"  value="RETOUR IMPORT CSV">'; 
        retour_menu();
        echo '</form>
              </div><!--detail-->';
  }
  else if ($commande == 'GESTION DES ENCADRANTS')
  {
      add_log ($commande);
      echo '<div class="detail"><h1>Gestion des encadrants</h1>
      <p class="oblique_bleu">En tant que responsable d\'une activité vous avez accès à la gestion des encadrants et en particulier la possibilité de consulter les données des encadrants.
      Dans le cas  d\' une modification ou d\'un ajout, laisser toujours la partie titre (liste des fonctions) au webmaster qui vous demandera également en cas d\'ajout une photo de l\'encadrant. <b>Ne surtout pas mettre d\'espace après ou avant la virgule de séparation</b>.</p>
      <p>Choisir un nom de cadre pour mettre à jour son profil (mobile, mail, activités, fonctions)</p>';
      $allcadre = extract_cadre('');
      echo '<form method="post">
           <table>';
      $n=3;
      foreach ($allcadre  as $cadre)
      {
        if ($n == 3)
          echo '<tr>';
        echo '<td>
        <input type="submit" name="majcadre" value="' . sup_anti_slash($cadre->nick_name) . '"> <input type="hidden" name="commande" value="MAJC"> </td> ';
        $n--;
        if ($n == 0)
        {
          echo '</tr>';
          $n=3;
        }
      }
      echo ' 
      <input type="hidden" name="auth" value = "' . $auth . '">
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">  
      </table>

       
       <input type="submit" name="commande" value="GESTION DES ENCADRANTS" Title="Admin - Pour ajouter un encadrant ou modifier le profil d\'un encadrant" style="background:green !important;"> 
       <input type="submit" name="commande" value="AJOUTER UN ENCADRANT" style="background:green" Title="Admin - Pour ajouter un encadrant ">'; 
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></div>';
  }
  else if ($commande == "MAJC")
  {
      add_log ($commande);
      $majcadre = $_POST['majcadre'];
      $img_cadre = getImgCadre ($majcadre);
      echo '<div class="detail">';
      if ($img_cadre) 
        echo '<IMG src="' . get_site_url() . '/' . $DIRCAF . '/trombi-images/tmb/' . $img_cadre . '" width="100 px" align="right">';
      echo '<h1>Mise à jour du profil de ' . sup_anti_slash($majcadre) . '</h1>';

      $rep = extract_cadre ($majcadre);
      $cadre       = $rep[0];
      $majacti     = $cadre->activite;
      $majtitre    = $cadre->titre;
      $majmobile   = $cadre->mobile;
      $majemail    = $cadre->email;
      $majprenom   = $cadre->prenom;
      $majnom      = $cadre->nom;

      echo '<form method="post"><br>
      <table><tr><td>Prénom</td><td><input type="text" name="majprenom" value="' . $majprenom . '"></td></tr>
      <tr><td>Nom</td><td><input type="text" name="majnom" value="' . $majnom . '"></td></tr>
      <tr><td>Mobile</td><td><input type="text" name="majmobile" value="' . $majmobile . '"></td></tr>
      <tr><td>Mail</td><td><input type="text" name="majemail" value="' . $majemail . '"></td></tr></table>
      Activités séparées par une virgule sans espace
      <input type="text" name="majacti" value="'  . $majacti . '"> <br>
      Fonctions séparées par une virgule sans espace (demander en cas de doute au webmaster de modifier ces données.)
      <TEXTAREA  name="majtitre" rows="2" cols="50" style="color:black; background-color:#fafafa; border-color:blue;" >' . $majtitre . '</TEXTAREA>
      <p class="oblique_bleu">Bien observer ce que vous modifier avant de faire la mise à jour ou la suppression.</p>
      <input type="hidden" name="majcadre" value="' . $majcadre . '">
      <input type="hidden" name="auth" value = "' . $auth . '">
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">  
      <input type="submit" name="commande" value="MISE A JOUR DU CADRE"> 
      <input type="submit" name="commande" value="SUPPRIMER LE CADRE" Title="Cette commande demande une confirmation"> 
      <input type="submit" name="commande" value="AJOUTER UN ENCADRANT">
      <br>
      <input type="submit" name="commande" value="GESTION DES ENCADRANTS" style="background:green !important;">'; 
      retour_menu();
      echo '</form></div>';
      //<input type="text" name="majtitre" value="' . $majtitre . '"><br>
    
  }
  else if ($commande == 'SUPPRIMER LE CADRE')
  {
      add_log ($commande);
      $majcadre = $_POST['majcadre'];
      add_log ($commande . ' - ' . $majcadre);     
      echo '<div class="detail"><h1>Supression du cadre ' . $majcadre . '</h1><p class="oblique_bleu">La suppression d\'un encadrant est une opération importante pour le club. Vous devez confirmer la suppression de celui-ci pour que l\'opération se fasse.</p>';
      
      echo '<form method="post">
      <p><input type="submit" name="commande" value="CONFIRMATION DE SUPPRESSION DU CADRE" Title="Cette commande va vraiment supprimer l\'encadrant ' . $majcadre . '">  
      <input type="submit" name="commande"  value="GESTION DES ENCADRANTS" style="background:green !important"> </p>';
      retour_menu();
      echo '
      <input type="hidden" name="majcadre"  value="' . $majcadre . '">
      <input type="hidden" name="auth"      value = "' . $auth . '"> 
      <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
      <input type="hidden" name="cx"        value="' . $cx . '">    
       </form></div>';

  }
  else if ($commande == 'CONFIRMATION DE SUPPRESSION DU CADRE')
  {
      $majcadre = $_POST['majcadre'];
      echo '<div class="detail"><h1>Supression du cadre ' . $majcadre . '</h1>';
      add_log ($commande . ' - ' . $majcadre);
      $ret = delete_cadre ($majcadre);

      echo '<p>' . $majcadre . ' a été supprimé(e) de la liste des encadrants</p>
      <form method="post"><input type="submit" name="commande" value="GESTION DES ENCADRANTS" style="background:green !important">'; 
      retour_menu();
      echo '
      <input type="hidden" name="auth" value = "' . $auth . '"> 
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">    
       </form></div>';

  }    
  else if ($commande == 'MISE A JOUR DU CADRE')
  {
      $majcadre   = $_POST['majcadre'];
      $majmobile  = $_POST['majmobile'];
      $majacti    = $_POST['majacti'];
      $majemail   = $_POST['majemail'];
      $majtitre   = $_POST['majtitre'];
      $majprenom  = $_POST['majprenom'];
      $majnom     = $_POST['majnom'];

      echo '<div class="detail">';
      $ret = maj_cadre ($majcadre, $majprenom, $majnom, $majmobile, $majacti, $majemail, $majtitre);
      $rep = extract_cadre ($majcadre);
      $cadre = $rep[0];
      echo '<table border="1">
            <tr><td>Nom</td><td>' .        $cadre->nick_name . '</td></tr>
            <tr><td>Mobile</td><td>' .     $cadre->mobile    . '</td></tr>
            <tr><td>Mail</td><td>' .       $cadre->email     .  '</td></tr>
            <tr><td>Activités</td><td>' .  $cadre->activite .  '</td></tr>
            <tr><td>Titres</td><td>' .     $cadre->titre    . '</td></tr>
            </table>';

        echo '<form method="post"><input type="submit" name="commande" value="GESTION DES ENCADRANTS" style="background:green !important">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '"> 
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">    
       </form></div>';
  }  
  else if ($commande == "AJOUTER UN ENCADRANT")
  {
      echo '<div class="detail"><h1>Ajout d\'un encadrant</h1>';
      add_log ($commande);
      echo '<form method="post"><br>
      <table>
      <tr><td>Prénom</td><td><input type="text" name="newprenom" value="' . $newprenom . '"></td></tr>
      <tr><td>Nom</td><td><input type="text" name="newnom" value="' . $newnom . '"></td></tr>
      <tr><td>Mobile</td><td><input type="text" name="newmobile" value="' . $newmobile . '"></td></tr>
      <tr><td>Email</td><td><input type="text" name="newemail" value="' . $newemail . '"></td></tr>
      <tr><td>Activité</td><td><input type="text" name="newactivite" value="' . $newactivite . '"></td></tr>
      <tr><td>Fonctions</td><td><TEXTAREA  name="newfonction" rows="2" cols="80" style="color:black; background-color:#fafafa; border-color:blue;" >' . $newfonction . '</TEXTAREA></td></tr>
      </table>
      <input type="submit" name="commande" value="ENREGISTRER LE NOUVEAU ENCADRANT">
      <input type="hidden" name="auth" value = "' . $auth . '">
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">  
      </form>';

      echo '<form method="post">
       <input type="submit" name="commande" value="GESTION DES ENCADRANTS" style="background:green !important"> 
       <input type="submit" name="commande" value="AJOUTER UN ENCADRANT" style="background:green !important">'; 
      retour_menu();
      echo '
       <input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></div>';
  }
  else if ($commande == 'ENREGISTRER LE NOUVEAU ENCADRANT')
  {
      echo '<div class="detail"><h1>Enregistrement encadrant</h1>';
      $newprenom    = sup_anti_slash($_POST['newprenom']);
      $newnom       = sup_anti_slash($_POST['newnom']);
      $newmobile    = $_POST['newmobile'];
      $newemail     = $_POST['newemail'];
      $newactivite  = $_POST['newactivite'];
      $newfonction  = $_POST['newfonction'];
      add_log ($commande . ' - ' . $newprenom . ' ' . $newnom);

      $nick_name  = $newprenom . ' ' . $newnom; 
      $repcadre  = extract_cadre ($nick_name);

      //mettre l'identifiant et le mot de passe dans la table des cadres
      $licence = controle_licence_2 ($newnom, $newprenom, $newemail);
      $adh     = extract_adherent_licence ($licence);
      echo 'Licence de l\'encadrant = ' . $licence . '<br>';


      if (sizeof($repcadre) > 0)
      {
        echo 'Le cadre "' . $nick_name . '" existe déjà<br>';
      }
      else
      {
         if (ajout_cadre ($newprenom, $newnom, $nick_name, $newmobile, $newemail, $newactivite, $newfonction))
          echo 'Le cadre ' . $nick_name . ' a bien été ajouté.<br>';
      }

      //maj cadre avec ident et password
      echo 'Mis à jour des identifiants et mot de passe encadrant<br>';
      add_log ('Mis à jour ident=' . $adh->ident);
      update_cadre_pass ($nick_name, $adh->ident, $adh->password);
      echo '<form method="post"><input type="submit" name="commande" value="GESTION DES ENCADRANTS" style="background:green !important;">'; 
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></div>';
  }
  else if ($commande == 'CHANGEMENT DE PROFIL ENCADRANT')
  {
      add_log ($commande);
      echo '<div class="detail"><h1>Changement de profil encadrant</h1>
      <p class="oblique">Pour des tas de raisons, vous devez remplacer un autre encadrant dans la saisie ou modification de ses activités (panne ou perte matériel, indisposition ...). Vous aller hériter du nouveau nom du cadre et de ses type d\'activité</p>
      <form method="post">
      Entrer au moins les deux premières lettres du nom de l\'encadrant
      <input type="texte" name="cadre_remp" value="' . $cadre_remp . '">
      <input type="submit" name="commande" value="PRENDRE UN NOUVEAU PROFIL">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        </form></div>';
  }
  else if ($commande == 'PRENDRE UN NOUVEAU PROFIL')
  {
      $cadre_remp = $_POST['cadre_remp'];
      //Recherche du cadre
      echo '<div class="detail">';
      $anc_cadre = strtoupper($cadre_p);
      $cadre_pr = recherche_cadre ($cadre_remp);
      add_log ($commande . ' - ' . $cadre_pr);

      //interdire de prendre le profil du webmaster
      if (stristr(extract_fonction_cadre ($cadre_pr), 'webmaster'))
      {
        echo '<p class="oblique">Il est impossible de prendre la place et les droits du Webmaster.Prenez contact avec lui pour toute opération sur le site <a href="mailto:webmaster@cafmeythet.org">Ecrire un mail au webmaster</a></p>
          <form method="post">';
        retour_menu();
        echo '<input type="hidden" name="auth"      value = "' . $auth . '">
              <input type="hidden" name="cadre_p"   value="' . $cadre_p . '">
              <input type="hidden" name="cx"        value="' . $cx . '">  
              </form>';
      }
      else
      {
        add_log ('Pas webmaster');

        if (isset($cadre_pr) && strlen($cadre_pr) > 3)
        {
            $cadre_p =  strtoupper(wd_remove_accents($cadre_pr));
            add_log ($cadre_p);
        }
        else 
        {
          echo '<p>Choisir le profil à connecter au bloc-notes</p>
                <form method="post">
                <input type="radio" checked name="ccadre" value="' . $cadre_pr[0] . '">' . $cadre_pr[0] .  '
                <input type="radio" name="ccadre" value="' . $cadre_pr[1] . '">' . $cadre_pr[1] .  '<br>
                <input type="hidden" name="auth" value="' . $auth . '">
                <input type="submit" name="commande" value="CONNEXION"></form>';
        }
        add_log ('Changement de profil ' . $cadre_p);
        echo 'Changement de profil <b>' . $anc_cadre . ' </b>par <b>' . $cadre_p . '</b><br>
        <p class="oblique">Faire retour menu pour continuer avec le nouveau profil</p>
        <form method="post">
        <input type="submit" name="commande" value="CHANGEMENT DE PROFIL ENCADRANT">';
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          </form>';
      }
      echo '</div>';
  }
  else if ($commande == 'TEST MAIL')
  {
      echo '<h1>Test notification par mail</h1>
      <p class="oblique_bleu">Cette fonction est utile pour tout ceux qui ne recoivent plus de mail de notification du calendrier des activités. Le bouton <b>ENVOI MAIL DE TEST</b> permet d\'envoyer à partir de l\'expéditeur "activite@cafmeythet.org" un mail de test (très simple) vers l\'adresse électronique choisie par le testeur.<br>Le bouton <b>TEST DE NOTIFICATION</b> envoie vers l\'adresse renseignée un mail identique à ceux de notification d\'une inscription (plus complexe).</p>

      <p><form method="post">
      <table>
      <tr><td>Expéditeur</td><td><input type="text" name="expediteur" value="activite@cafmeythet.org"></td></tr></td></tr>
      <tr><td>Destinataire</td><td><input type="text" name="destinataire"></td></tr>
      <tr><td>Objet</td><td><input type="text" name="objet"></td></tr>
      <tr><td>Message</td><td><input type="text" name="message"></td></tr></table>
       <input type="submit" name="commande" value="ENVOI MAIL DE TEST"> 
       <input type="submit" name="commande" value="TEST DE NOTIFICATION">';
       retour_menu();
       echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p>';
  }
  else if ($commande == 'ENVOI MAIL DE TEST' || $commande == 'TEST DE NOTIFICATION')
  {
      $expediteur   = $_POST['expediteur'];  
      $destinataire = $_POST['destinataire']; 
      $objet        = sup_anti_slash($_POST['objet']);
      $message      = sup_anti_slash($_POST['message']);
      if (strstr($commande,'ENVOI'))
      {
        echo '<h1>Envoi email simple de test</h1>';
        SendMailTest ($expediteur, $destinataire, $objet, $message);
        echo '<p class="oblique_bleu">Vérifier votre boite mail car un message a été expédié de <b> ' . $expediteur . '</b> vers <b>' . $destinataire . '</b> avec pour objet <b>' . $objet . '</b> <br>Message : <b>' . $message . '</b></p>';
      }
      else
      {
        echo '<h1>Envoi email de notification d\'inscription de test</h1>';
        SendMailNotificationTest ($expediteur, $destinataire, $objet, $message);
        echo '<p class="oblique_bleu">Vérifier votre boite mail car un message de notification d\'inscription (de test) a été expédié de <b> ' . $expediteur . '</b> vers <b>' . $destinataire . '</b>. Le mail de test envoyé est un mail comportant des éléments comme la couleur, une photo et un lien vers une activité passée.</p>';
      }

      echo '<p><form method="post">
      <table>
      <tr><td>Expéditeur</td><td><input type="text" name="expediteur" value="' . $expediteur . '"></td></tr></td></tr>
      <tr><td>Destinataire</td><td><input type="text" name="destinataire" value="' . $destinataire . '"></td></tr>
      <tr><td>Objet</td><td><input type="text" name="objet" value="' . $objet . '"></td></tr>
      <tr><td>Message</td><td><input type="text" name="message" value="' . $message . '"></td></tr></table>
       <input type="submit" name="commande" value="ENVOI MAIL DE TEST"> 
       <input type="submit" name="commande" value="TEST DE NOTIFICATION">';
       retour_menu();
       echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p>';
  }    
  else if ($commande == 'PARTAGE DE DOCUMENTS'          || $commande == 'DEPOSER UN DOCUMENT PARTAGE'
      || $commande == 'ACQUERIR CE DOCUMENT PARTAGE'  || $commande == 'ACCES A TOUS LES DOCUMENTS PARTAGES'
      || $commande == 'ACCES AU DOCUMENT PARTAGE SELECTIONNE'
      || $commande == 'LANCER LA RECHERCHE DE PARTAGE' || $commande == 'RECHERCHER DES DOCUMENTS PARTAGES'
      || $commande == 'SUPPRIMER LE DOCUMENT PARTAGE SELECTIONNE' 
      || $commande == 'CONFIRMER LA SUPPRESSION DU DOCUMENT PARTAGE')
  {
      if (TEST == 1)
        require_once "test_partage.php";
      else
        require_once "partage.php";
      add_log ($commande);
      partage();
  }      
  else if ($commande == 'ACCES AU CLASSEUR'           || $commande == "ACCES AU DOCUMENT SELECTIONNE"
      || $commande == 'ACCES PAR MOT DE PASSE'      || $commande == "REMPLACER LE DOCUMENT SELECTIONNE"
      || $commande == "ACQUERIR POUR REMPLACER"     || $commande == "MODIFIER LE DOCUMENT SELECTIONNE"
      || $commande == "PUBLIC"                      || $commande == "RESERVE" 
      || $commande == "PRIVE"                       || $commande == 'ENREGISTREMENT' 
      || $commande == 'PROTEGE'                     || $commande == 'PROTECTION PAR MOT DE PASSE'
      || $commande == "ACCES A LA LISTE DES DOCUMENTS"    || $commande == 'VUE DU DOSSIER'
      || $commande == "SUPPRIMER LE DOCUMENT SELECTIONNE" || strstr($commande,'CONFIRMER LA SUPPRESSION')
      || $commande == 'RECHERCHER DES DOCUMENTS'          || $commande == 'LANCER LA RECHERCHE'
      || $commande == 'DEPOSER UN DOCUMENT'               || $commande == 'ACQUERIR CE DOCUMENT')
  {
      if (TEST == 1)
        require_once "test_coffre.php";
      else
        require_once "coffre.php";
      add_log ($commande);
      coffre();
  }
  else if ($commande == 'NOMBRE ADHERENTS PAR ACTIVITE ET ANNEE')
  {  
    add_log ($commande);
    $annee = $_POST['annee'];
    if ($annee == '') 
      $annee=date('Y');

    echo '<h1>Participation à une activité</h1>
    <form method="post">
    Choisir l\'année : <input type="text" name="annee" value="' . $annee . '">
    <label for="select_act"><b>Choix d\'une activité :</b></label>
    <select name="act_name" id="select_act" style="color:black; background-color:#fafafa; border-color:blue;"> 
    <option value="nothing">-- Faire un choix d\'activité--</option>
    <option value="Alpinisme">Alpinisme</option>
    <option value="Escalade">Escalade</option>
    <option value="Kayak">Kayak</option>
    <option value="Marche nordique">Marche nordique</option>
    <option value="Randonnée pédestre">Randonnée pédestre</option>
    <option value="Raquettes">Raquettes</option>
    <option value="Randonnée alpine">Randonnée alpine</option>
    <option value="Ski de fond">Ski de fond</option>
    <option value="Ski de randonnée">Ski de randonnée</option>
    <option value="Ski de randonnée nordique">Ski de randonnée nordique</option> 
    <option value="Ski alpin">Ski alpin</option>
    <option value="Trail">Trail</option>        
    <option value="Via ferrata">Via ferrata</option>
    <option value="VTT">VTT</option>
    </select>
   <input type="hidden" name="auth" value = "' . $auth . '">
   <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
   <input type="hidden" name="cx" value="' . $cx . '">  
   <input type="submit" name="commande" value="DONNER LA LISTE DES ADHERENTS">';
   retour_menu();
   echo '</form>';
  }
  else if ($commande == 'DONNER LA LISTE DES ADHERENTS')
  {
        $annee    = $_POST['annee'];
        $act_name = $_POST['act_name'];
        add_log ($commande . ' - ' . $annee . ' - ' . $act_name);
        echo '<h1>Participation en ' . $annee . ' à l\'activité ' . $act_name . '</h1>
        Année : ' . $annee . ' - Activité : ' . $act_name . '<br>';

        $sql = "SELECT cal_partic.prenom, cal_partic.nom FROM `cal_activ`, `cal_partic` WHERE activite like '" . $act_name . "%%' and cal_activ.date_deb like '" . $annee . "%%' and cal_partic.IDU = cal_activ.IDU AND cal_partic.etat like 'INSCRIT' order by cal_partic.nom ASC, cal_partic.prenom ASC";
        $rep = $wpdb2->get_results($sql);
        $name = '';
        $count=1;
        $nb=1;
        //print_r ($rep);

        foreach ($rep as $part)
        {
          $prenom = str_replace ('-', ' ', $part->prenom);
          $nom    = str_replace ('-', ' ', $part->nom);
          if ($name != $prenom . ' ' . $nom)
          {
            if ($count > 1)
              $particip[]  = array('ordre' => $count-1 , 'nom' => $name, 
                'nombre' => $nb);
            $nb=1;
            $name = $prenom . ' ' . $nom;
            $count++;
          }
          else 
            $nb++;
        }
        $particip[]  = array('ordre' => $count-1 , 'nom' => $prenom . ' ' . $nom, 
                'nombre' => $nb);
        //print_r($particip);

        echo '<table border="1"><tr><th width="10%">Ordre</th><th>Nom</th><th width="15%">Nbre sorties</th></tr>';
        foreach($particip as $line)
          echo '<tr><td>' . $line['ordre'] . '</td>
                    <td>' . $line['nom']   . '</td>
                    <td>' . $line['nombre']. '</td></tr>';
        echo '</table>';
        echo '<p class="oblique">Attention, vous devez vérifier la liste et supprimer des doublons si l\'orthographe de certain prénoms ou noms n\'est pas exact ou à cause d\' inversions prénom et nom</p>'; 
        echo '<p><form method="post">
 
        <input type="submit" name="commande" value="EXPORT TAB EXCEL" TITLE="Export du tableau en fichier Excel">
        <input type="hidden" name="tableau" value="' . htmlspecialchars(serialize($particip)) . '">
       <input type="hidden" name="annee" value = "' . $annee . '">       
       <input type="hidden" name="act_name" value = "' . $act_name . '">
       <input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p>';

        //conserver le code d'autorisation $auth de fonction en fonction
        echo '<p><form method="post">
        <input type="submit" name="commande" value="NOMBRE ADHERENTS PAR ACTIVITE ET ANNEE" TITLE="Statistiques pour l\'escalade">';
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p>';
 }
 else if (strstr($commande, 'EXPORT TAB'))
 {
   echo '<div class="detail">
         <h1>Export des participants en fichier Excel</h1>';
   $tableau = $_POST['tableau'];
   $annee    = $_POST['annee'];
   $act_name = $_POST['act_name'];
   //print_r($tableau);
   $particip = unserialize(sup_anti_slash($tableau));
   //print_r($particip);
   $DIRXLS = $DIR . '/XLS/';
   $URLXLS = $URL . '/XLS/';

   if (!is_dir($DIRXLS))
    mkdir ($DIRXLS);

  $spreadWsheet = new Spreadsheet();
  $Worksheet = $spreadWsheet->getActiveSheet();

  // Set document properties
 $spreadWsheet->getProperties()->setCreator('Michel Brusa')
  ->setLastModifiedBy('Michel Brusa')
  ->setTitle('Office 2007 XLSX Test Document')
  ->setSubject('Office 2007 XLSX Test Document')
  ->setDescription('Test document for Office 2007 XLSX, generated using PHP classes.')
  ->setKeywords('office 2007 openxml php')
  ->setCategory('Test result file');

  // Rename worksheet
  $Worksheet->setTitle($act_name . ' ' . $annee);

  $Worksheet->setCellValue('A1', 'Ordre');
  $Worksheet->setCellValue('B1', 'Nom');
  $Worksheet->setCellValue('C1', 'Nombre');
  $line = 2;

  foreach($particip as $row)
  {
    $numA = 'A' . $line; $numB = 'B' . $line; $numC = 'C' . $line;
    //echo $numA . ' -> ' . $row["ordre"] . ' ' . $numB . ' -> ' .     $row["nom"]. '<br>';
    $Worksheet->setCellValue($numA, $row["ordre"]);
    $Worksheet->setCellValue($numB, $row["nom"]);
    $Worksheet->setCellValue($numC, $row["nombre"]);

    $line++;
  }
 
  //Mise en forme
  //mettre en gras les titres
  $Worksheet->getStyle('A1:C1')->getFont()->setBold(true);
  //bloquet le volet première ligne
  $Worksheet->freezePane('A2');
  // Largeur des colonnes
  $Worksheet->getColumnDimension('A')->setWidth(10);
  $Worksheet->getColumnDimension('B')->setWidth(30);
  $Worksheet->getColumnDimension('C')->setWidth(10);
  //Centrer les colonnes A et C
  
  $Worksheet->getStyle('C2:' . $numC)->getAlignment()->setHorizontal('center');
  $Worksheet->getStyle('A2:' . $numA)->getAlignment()->setHorizontal('center');


  $fxls = 'Participation ' . $annee . '_' . $act_name . '.xlsx';
  $writer = new Xlsx($spreadWsheet);
    unlink ($DIRXLS . $fxls);

    $writer->save($DIRXLS . $fxls);

    echo '<p>Utiliser le bouton suivant pour ouvrir le fichier</p> <button style="background:green !important;"><a href="' . $URLXLS  . $fxls . '"><font color="white">Participation ' . $annee . '_' . $act_name . 
    '</font></a></button>';
    echo '<p><form method="post">
    <input type="submit" name="commande" value="NOMBRE ADHERENTS PAR ACTIVITE ET ANNEE" TITLE="Statistiques pour l\'escalade">';
    retour_menu();
    echo '<input type="hidden" name="auth" value = "' . $auth . '">
   <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
   <input type="hidden" name="cx" value="' . $cx . '">  
   </form></p></div>';
 }
 else if (strstr($commande, 'GESTION DE L'))  //partie escalade
 {
        add_log ($commande);
        

        echo '<div class="detail"><h1>Gestion du nombre de participants à l\'escalade</h1>';
        $reqg = "SELECT * FROM " . $table_escalade . " WHERE `seltype` = '1'";
        $repg = $wpdb2->get_results($reqg);
        $controle = $repg[0]->controle;
        if ($controle == 1) 
          $check='checked'; 
        else 
          $check='';
        $date_ins =   $repg[0]->dateins;  
        //echo $wpdb2->last_error;
        //print_r ($repg);
        $reqc = "SELECT COUNT(*) AS count FROM " . $table_escalade . "  WHERE `seltype` = '" . $annee_escalade . "'";
        //echo $reqc . '<br>';
        $repc = $wpdb2->get_results($reqc);
        echo $wpdb2->last_error;
        //print_r ($repc);
        $count = $repc[0]->count;
        echo '<form method="post">Nombre de préinscrits à l\'escalade : ' . $count . '<br>
              <table><td class="note">Nombre max de participants :</td><td class="note"><input type="number" name="maxp" value="' . $repg[0]->maxp . '"></td></table>
              <input type="checkbox" name="controle" value="ON" id="selc" ' . $check . '> <label for"selc">Contrôle des dates des licences</label><br>
              Date de début d\'inscription : <input type="date" name="date_ins" value="' . $date_ins . '" required style="color:black; background-color:#fafafa; border-color:blue;"><br><br>
              <input type="submit" name="commande" value="VALIDER LES MODIFICATIONS"> 
              <input type="submit" name="commande" value="LISTE DES PREINSCRITS" Title="Préinscrits à l\'escalade"> 
              <input type="submit" name="commande" value="MAILING GRIMPEURS" Title="Envoi d\'un  mail à tous les préinscrits à l\'escalade"><br>
              <input type="hidden" name="auth" value = "' . $auth . '">
              <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
              <input type="hidden" name="cx" value="' . $cx . '">  
              <br>';
        echo '<p><form method="post">';
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
              <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
              <input type="hidden" name="cx" value="' . $cx . '">  
              </form></p></div>';
 }   
 else if ($commande == 'VALIDER LES MODIFICATIONS')    //partie escalade
 {
        add_log ($commande);
        $maxp     = $_POST['maxp'];
        $controle = $_POST['controle'];
        $date_ins = $_POST['date_ins'];
        if ($controle == 'ON')
         $ct_licence = 1;
        else 
          $ct_licence = 0;
        echo '<div class="detail"><h1>Prise en compte des paramètres de l\'escalade</h1>';
        $reqm = "UPDATE " . $table_escalade . " SET maxp = ". $maxp . ", controle = " . $ct_licence . ", dateins = '" . $date_ins . "'  WHERE seltype = '1' ";
        $wpdb2->get_results($reqm);
        echo $wpdb2->last_error;
        echo 'Nombre max de participants : ' . $maxp . '<br>
              Date d\'inscription = ' . $date_ins . '<br>';
        if ($ct_licence == 1)
          echo 'Contrôle des dates de licence<br>';
        else
          echo 'Pas de contrôle des dates de licence<br>';
        echo '<p><form method="post">';
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
        </form></p></div>';
 }
 else if ($commande == 'LISTE DES PREINSCRITS')    //partie escalade
 {
        add_log ($commande);
        // code de la nouvelle commande
        $reqc = "SELECT COUNT(*) AS count FROM " . $table_escalade . " WHERE seltype = '" . $annee_escalade . "'";
        $repc = $wpdb2->get_results($reqc);
        echo '<div class="detail"><h1>Liste des ' . $repc[0]->count . ' ' .pluriel('inscrit',$repc[0]->count) . ' à l\'escalade (' . $annee_escalade . '-' . ($annee_escalade + 1) . ')</h1>';
        $reql = "SELECT * FROM " . $table_escalade . " WHERE seltype = '" . $annee_escalade . "' ORDER BY nom ASC";
        $repl = $wpdb2->get_results($reql);

        echo '<table border="1"><th class="noir">Prénom Nom</th><th class="noir">Licence</th>';
        foreach ($repl as $adh)
        {
          $verl = "SELECT * FROM " . $table_adherent . " WHERE id = " . $adh->licence;
          $repverl = $wpdb2->get_results($verl);
          if (substr($repverl[0]->inscription,0,1) == '0')
            echo '<tr><td class="rouge">' . $adh->prenom . ' ' . $adh->nom . '</td><td class="rouge">' . $adh->licence . '</td></tr>';
          else
            echo '<tr><td class="noir">' . $adh->prenom . ' ' . $adh->nom . '</td><td class="noir">' . $adh->licence . '</td></tr>';
        }
        echo '</table>';

        echo '<p><form method="post">';
        retour_menu();
        echo '<input type="submit" name="commande" value="SUPPRIMER UNE ENTREE INCORRECTE"> 
          <input type="submit" name="commande" value="EXPORT ADRESSE EMAIL"> 
          <input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          </form></p></div>';
 }
 else if ($commande == 'MAILING GRIMPEURS')
 {
      add_log ($commande);
      echo '<div class="detail"><h1>Mailing vers tous les grimpeurs</h1>
      <p class="oblique_bleu">Le mail que vous allez élaborée ici va être envoyé en liste cachée vers tous les grimpeurs de la liste escalade. Par défaut le destinataire principal est club@cafmeythet.org et l\'expéditeur est activite@cafmeythet.org.</p>
      <p><form method="post">
      <table>
      <tr><td class="note">Expéditeur</td><td class="note"><input type="text" name="expediteur" value="activite@cafmeythet.org"></td></tr></td></tr>
      <tr><td class="note">Destinataire principal</td><td class="note"><input type="text" name="destinataire" value="club@cafmeythet.org"></td></tr>
      <tr><td class="note">Objet</td><td class="note"><input type="text" name="objet"></td></tr>
      <tr><td class="note">Message</td><td class="note"><TEXTAREA  name="message" rows="6" cols="40" style="color:black; background-color:#fafafa; border-color:blue;"></TEXTAREA></td></tr></table>
       <input type="submit" name="commande" value="ENVOI MAILING">';
       retour_menu();
       echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p></div>';      
  }
  else if ($commande == 'ENVOI MAILING')
  {
      $expediteur   = $_POST['expediteur'];  
      $destinataire = $_POST['destinataire']; 
      $objet        = sup_anti_slash($_POST['objet']);
      $message      = sup_anti_slash($_POST['message']);
      add_log ($commande . 'Exp : ' . $expediteur . ' Principal : ' . $destinataire);
      echo '<h1>Envoi des emails vers les grimpeurs</h1>
      <p class="oblique_bleu">Selon la taille de la liste, 1 ou 2 mails seront envoyés pour couvrir tous les destinataires (cachés)</b></p>';

      $req = "SELECT * FROM " . $table_escalade . " WHERE seltype = '" . $annee_escalade . "' ORDER BY nom ASC";
      //echo $req . '<br>';
      $rep = $wpdb2->get_results($req);
      $nbr_exp=0;
      $list='';
      foreach ($rep as $adh)
      {
        $nbr_exp++;
        if ($nbr_exp < 99)
        {

          $reqa = "SELECT email FROM " . $table_adherent . " WHERE id = '" . $adh->licence . "' ";
          $repa = $wpdb2->get_results($reqa);
          if ($repa[0]->email != '')
          {          
            if ($nbr_exp > 1) 
              $list .=';';
            $list .= $repa[0]->email;
          } 
        }
        else
        {
          //envoi mail de la première liste
          echo 'Envoi vers les destinataires : ' . $list . '<br>';
          if (TEST == 1) $list='mic.brusa@gmail.com;brusamarick@gmail.com';
          SendMailing ($expediteur, $destinataire, $objet, $message, $list);
          $list = '';
          $nbr_exp = 0;
        }
      }

      echo 'Envoi vers les destinataires : ' . $list . '<br>';
      if ($list != '')
      {
        if (TEST == 1) $list='mic.brusa@gmail.com;brusamarick@gmail.com';
          SendMailing ($expediteur, $destinataire, $objet, $message, $list);
      }
      //SendMailTest ($expediteur, $destinataire, $objet, $message);

      echo '<p><form method="post">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p>';
  }         
  else if ($commande == 'SUPPRIMER UNE ENTREE INCORRECTE')    //partie escalade
  {
        add_log ($commande);
        echo '<div class="detail"><h1>Suppression d\'une entrée incorrecte</h1><p>Pour supprimer un adhérent de la liste des inscrits à l\'escalade, cliquer sur le bouton correspondant à son nom. Une confirmation sera demandée pour l\'effacer définitivement.</p>';
        $reql = "SELECT * FROM " . $table_escalade . " WHERE seltype = '" . $annee_escalade . "' ORDER BY nom ASC";
        $repl = $wpdb2->get_results($reql);

        foreach ($repl as $adh)
        {
          $idref++;
          echo '<form id="', $idref, '" method="post"><input type="hidden" name="prenom" value="' . $adh->prenom . '">
          <input type="hidden" name="nom" value="' . $adh->nom . '">
          <input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          <input type="hidden" name="commande" value="EFFACER">
          <button><A HREF="#" onClick="Submit(\'', $idref, '\');" TITLE="Pour suppression"><font color="white">' . $adh->prenom . ' ' . $adh->nom . '</font><br></A></button></form>';
 
        }

        echo '<p><form method="post">
        <input type="submit" name="commande" value="SUPPRIMER UNE ENTREE INCORRECTE"> 
        <input type="submit" name="commande" value="EXPORT ADRESSE EMAIL">'; 
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">  
       </form></p></div>';
 }
 else if ($commande == 'EXPORT ADRESSE EMAIL')    //partie escalade
 {
        add_log ($commande);
        echo '<h1>Export des adresses mail de la liste escalade</h1>';
        // code de la nouvelle commande
        $reqc = "SELECT licence FROM " . $table_escalade . " WHERE seltype = '" . $annee_escalade . "'";
        $repc = $wpdb2->get_results($reqc);
        foreach ($repc as $adh)
        {
           $reqmail = "SELECT email FROM " . $table_adherent . " WHERE id = " . $adh->licence;
           $repmail = $repl = $wpdb2->get_results($reqmail);
           echo $repmail[0]->email . ';';
        }
        echo '<p><form method="post">
        <input type="submit" name="commande" value="LISTE DES PREINSCRITS" Title="Préinscrits à l\'escalade">'; 
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          </form></p>';
 }     
 else if ($commande == "EFFACER")   //partie escalade
 {
        add_log ($commande);
        $prenom = sup_anti_slash($_POST['prenom']);
        $nom    = sup_anti_slash($_POST['nom']);
        echo '<div class="detail"><h1>Effacement d\'un adhérent de la liste escalade</h1>
        <p>Vous devez confirmer l\'effacement définitif de<b> ' . $prenom . ' ' . $nom . ' </b>de la liste. Pour ne pas l\'effacer en cas d\'erreur utiliser la liste ou le retour.</p>
        <p><form method="post">
        <input type="submit" name="commande" value="CONFIRMER L\'EFFACEMENT"> 
        <input type="submit" name="commande" value="LISTE DES PREINSCRITS">'; 
        retour_menu();
        echo '<input type="hidden" name="prenom" value="' . $prenom . '">
          <input type="hidden" name="nom" value="' . $nom . '">
          <input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          </form></p></div>';
 } 
 else if (sup_anti_slash($commande) == "CONFIRMER L'EFFACEMENT")   //partie escalade
 {
        add_log ($commande);
        $prenom = sup_anti_slash($_POST['prenom']);
        $nom    = sup_anti_slash($_POST['nom']);
        echo '<div class="detail"><h1>Effacement définitif d\'un adhérent de la liste escalade</h1>';
 
        if (delete_escalade ($prenom, $nom, $annee_escalade))
            echo '<p>Effacement définitif de <b>' . $prenom . ' ' . $nom . '</b></p>';
        else
           echo '<p>Une erreur s\'est produite sur l\'effacement de <b>' . $prenom . ' ' . $nom . '. Faites appel au webmaster</b></p>';

        echo '<p><form method="post">
        <input type="submit" name="commande" value="LISTE DES PREINSCRITS">';
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">  
          </form></p></div>';
   }
   else if ($commande == 'GENERATION PASS ET IDENT')
   {
       echo '<div class="detail"><h1>Création mot de passe adhérent étape 1</h1><p class="oblique">Enter le prénom suivi du nom (en minuscule) tel qu\'il est enregistré sur la base de la FFCAM. Faire une VERIFICATION LICENCE pour avoir la bonne orthographe en cas de doute.</p>
        <form method="post">
        Prénom et nom : <input type="text" name="nom">
        <input type="submit" name="commande" value="Génération identifiant et mot de passe">
        <input type="submit" name="commande" value="VERIFICATION LICENCE">';
        retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
            <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
            <input type="hidden" name="cx" value="' . $cx . '">    
            </form></div>';
   }
   else if ($commande == 'Génération identifiant et mot de passe')
   {
       $nomc = $_POST['nom'];
       $noms = explode(" ", $nomc);

       $prenom = $noms[0]; $nom = $noms[1]; //cas simple sans prénom composé et sans nom composé du syle MARIE ROSIE DE ROUVIERS

       if (sizeof($noms) == 3)
       {
          // pour prénom composé 
          $prenom = $noms[0] . ' ' . $noms[1];
          $nom    = $noms[2];
          // pour nom composé
          $prenom_1 = $noms[0]; 
          $nom_1 = $noms[1] . ' ' . $noms[2];
       }
       else if (sizeof($noms) == 4)
       {
          $prenom_1 = $noms[0] . ' ' . $noms[1];  //prénom composé
          $nom_1    = $noms[2] . ' ' . $noms[3];  //nom composé
       }
       echo '<div class="detail"><h1>Création mot de passe adhérent étape 2</h1>';
       //recherche dans la table des adhérents
       $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '".  $nom . "' and prenom like '" . $prenom . "'";
       $rep = $wpdb2->get_results($req);
       if (sizeof($rep) > 0)  //sans nom ou prénom composé du style "LE BOUQUIN"
       {     
          $adh = $rep[0];
          //identifiant avec premiere lettre du prénom suivi du nom
          $ident = strtolower(substr($adh->prenom,0,1) . '.' . $adh->nom );
          $passm = str_shuffle(substr($adh->nom,0,4)) . substr($adh->id,9,3);
          $pass = substr ($passm, 0, 1) . strtolower(substr($passm,1));
          $case = 0;
       }
       else
       {
          $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '".  $nom_1 . "' and prenom like '" . $prenom_1 . "'";
          $rep = $wpdb2->get_results($req);
          $adh = $rep[0];     
          //identifiant avec premiere lettre du prénom suivi du nom

          if (sizeof ($noms) < 4)
            $nomc = $noms[1] . $noms[2];
          else
            $nomc = $noms[2] . $noms[3];

          $ident = strtolower(substr($adh->prenom,0,1) . '.' . $nomc);
          $passm = str_shuffle(substr($nomc,0,4)) . substr($adh->id,9,3);
          $pass = strtoupper(substr ($passm, 0, 1)) . strtolower(substr($passm,1));
          $case = 1;  
       }

       //vérification de l'unicité de l'identifiant
       $i=0;
       do {
        $i++;
        $req = "SELECT * FROM " . $table_adherent . " WHERE ident like '" . $ident . "' AND id != " . $adh->id;
        $rep = $wpdb2->get_results($req);
 
        if (sizeof($rep) > 0)
        {
          echo '<p><font color="red">L\'identifiant ' . $ident . ' est déjà pris par l\'adhérent ' . $rep[0]->prenom . ' ' . $rep[0]->nom . '</font></p>';
          if ($case == false)
            $ident = strtolower(substr($adh->prenom,0,1) . $i . '.' . $adh->nom );
          else
            $ident = strtolower(substr($adh->prenom,0,1) . $i . '.' . $nomc);
          echo 'Nouveau identifiant : ' . $ident . '<br>';
        }
       } 
       while (sizeof($rep) > 0);

       echo 'Prénom : ' . $adh->prenom . ' - Nom : ' . $adh->nom .
       '<br>Adresse mail : ' . $adh->email . ' - Mobile : ' . $adh->mobile .
       '<br>Ancien identifiant : ' . $adh->ident .
       '<br>Licence = ' . $adh->id .
       '<br>Identifiant = ' . $ident . 
       '<br>Password = ' . $pass . '<br>';
       //mot de passe 4 premiere lettre du nom mélangée suivi du numéro de licence

       $password = hash( 'sha256', $pass);


       echo '<form method="post">
       <input type="submit" name="commande" value="Enregistrement ident et pass">';
       retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
          <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
          <input type="hidden" name="cx" value="' . $cx . '">
          <input type="hidden" name="id" value="' . $adh->id. '">
          <input type="hidden" name="ident" value="' . $ident . '">
          <input type="hidden" name="pass" value="' . $pass . '">
          <input type="hidden" name="email" value="' . $adh->email . '">
          <input type="hidden" name="mobile" value="' . $adh->mobile . '">
          <input type="hidden" name="nom" value="' . $adh->nom . '">
          <input type="hidden" name="prenom" value="' . $adh->prenom . '">
           </form></div>';
   }        
   else if ($commande == 'Enregistrement ident et pass')
   {
      $id = $_POST['id'];  $ident = $_POST['ident'];  $pass = $_POST['pass'];
      $nom = $_POST['nom'];  $prenom = $_POST['prenom'];
      $mobile = $_POST['mobile'];  $email = $_POST['email'];
      echo '<div class="detail"><h1>Création mot de passe adhérent étape 3</h1>
      <p class="oblique_bleu">Copier le texte ci-dessous et l\'envoyer en réponse au mail de l\'adhérent.</p>
      Bonjour ' . substr($prenom,0,1) . strtolower(substr($prenom,1)) . '<br>
      <p>J\'ai fait générer ton identifiant et mot de passe pour te connecter au calendrier en ADHERENT.</p>
      <p>Enregistrement identifiant et MDP<br>
        Prénom : ' . $prenom . ' - Nom : ' . $nom .
       '<br>Adresse mail : ' . $email . ' - Mobile : ' . $mobile .
       '<br>Licence = ' . $id .
       '<br>Identifiant = <b>' . $ident . 
       '</b><br>Password = <b>' . $pass . '</b></p>
       <p>La première partie du mot de passe est un mélange des 4 premières lettres de ton nom (' . strtolower(substr($nom, 0, 4)) . ') pour faire <b>' . substr($pass,0,4) . '</b>.<br>
       La seconde partie numérique correspond au trois derniers chiffres de ta licence soit ' . substr($id, 9,3) . ' pour faire en tout <b>' . $pass . '</b></p>
       Michel<br>';

      $req = "UPDATE " . $table_adherent . " SET ident = '" . $ident . "' , password = '" . 
            hash('sha256', $pass) . "' WHERE id = " . $id;
      $wpdb2->get_results($req);

      echo '<form method="post">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
            <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
            <input type="hidden" name="cx" value="' . $cx . '">
            </form></div>';
   }
   else if ($commande == 'NEIGE')
   {
        echo '<div class="detail"><h1>Importation du fichier neige - secours - dva</h1>
        <p class="oblique_bleu">Le fichier d\'importation CSV ou EXCEL(texte) doit avoir au moins deux colonnes - la première avec le numéro de licence et la seconde avec la date de formation du licencié - le webmaster utilise un fichier Excel "Formation neige-secours AAAA.xlsx" qui comportent également le nom ou le groupe qui a donné la formation. Vous pouvez vous le procurer par une simple demande auprès de lui.</p>';
        
        echo '<form method="post" enctype="multipart/form-data">
        Fichier d\'import neige Excel ou csv : <input type="file" id="file" name="ffxls" accept=".xls,.xlsx,.csv"> 
        <input type="submit" name="commande" value="VALIDATION FICHIER NEIGE"> 
        <input type="submit" name="commande" value="LISTE FORMATION NEIGE"> 
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">'; 
        retour_menu();
        echo '</form></div>';
 }
 else if ($commande == 'VALIDATION FICHIER NEIGE' || 
          $commande == 'LISTE FORMATION NEIGE')
 {
        echo '<div class="detail">';
        if ($commande == 'VALIDATION FICHIER NEIGE')
        {
          $ffxls = $_FILES['ffxls'];
          $fname = $ffxls['name'];
          $XLS   = $DIR . '/XLS/';
          $file  = $XLS . $fname;
          $fileInfo     = new SplFileInfo($fname);
          $extent       = $fileInfo->getExtension();
          rename  ($ffxls['tmp_name'], $file);
          switch ($extent)
          {
            case 'xlsx': $file_type = 'Xlsx';  break;       
            case 'xls' : $file_type = 'Xls';   break;
            case 'csv' : $file_type = 'Csv';   break;
          }

//echo 'Extent = ' . $file_type . '<br>' . $fname . '<br>';
//echo 'File  = ' . $file . '<br>';
          $reader = IOFactory::createReader($file_type);
//echo 'createReader<br>';          
          $reader->setReadDataOnly(false);
//echo 'setReadDataOnly<br>';          
          $spreadsheet = $reader->load($file);
//echo 'Après load file <br>';
          $sheetList = array();
          $countf = $spreadsheet->getSheetCount();  //nombre de pages
//echo 'Nbre page = ' . $countf . '<br>';
          $loadedSheetNames = $spreadsheet->getSheetNames();

          foreach ($loadedSheetNames as $SheetName)
          { 
             $WorkSheet =  $SheetName;
             break;
          }
          echo 
          '<h1>Validation du fichier d\'import ' . $fname . '/' . $WorkSheet . '</h1>';
          $sheetData = $spreadsheet->getActiveSheet()->toArray(
            null, 
            false, 
            false,  //date excel ou (mauvaise interprétation des dates)
            true);  //lettre A, B ou index si false
   $line = 0;
   foreach ($sheetData as $row) 
   {
      $line++;
      if ($line == 1)
        continue;
      //print_r ($row);
      $licence = $row['A'];
      $date    = $row['B'];
      //echo 'date = ' . $date . '<br>';
      if (is_numeric($date))
        $date_norm = date ('Y-m-d', 
          \PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($date));

      if ($file_type == 'Csv')
      {
          $date_u = DateTime::createFromFormat('d/m/Y', $date);
          $date_norm = $date_u->format('Y-m-d');
      }


      //echo $licence . ' - ' . $row['B'] . ' - ' . $date . '=' . $date_norm . '<br>';  
 
      $date_neige = extract_neige ($licence);
      if ($date_neige == '0000-00-00'  || $date_norm > $date_neige)
      {
        if (!maj_neige ($licence, $date_norm))
            echo $licence . ' - ' . $date_norm . ' - KO<br>';
      }
    }

    }
    //Affichage de la liste des formés neige
    $liste = extract_liste_neige ();
      
    $saison_courante = get_debut_saison();
   

    echo '<h2>Adhérents ayant reçus une formation gestion des secours neige ou/et une formation DVA</h2></p>Les adhérents formés cette saison sont affichés en bleu. Ils sont classés par date de formation et dans la même date par nom.Pour rechercher un nom, utiliser le raccourci clavier Ctrl+F.</p>
        <table border="1"><th class="noir">Num</th><th class="noir" width="25%">Licence</th><th class="noir" width="15%">Date formation</th><th class="noir">Nom Prénom</th>';
        $i=1;
        foreach ($liste as $adh)
        {
          if ($adh->neige > $saison_courante)
            echo '<tr><td class="bleu">' . $i++ . '</td><td class="bleu">' . $adh->Id . '</td><td class="bleu">' . $adh->neige . '</td><td class="bleu">' . $adh->nom . ' ' . $adh->prenom . '</td></tr>';
            else if (controle_date_neige('titre', 'Raquettes', $adh->Id))
            echo '<tr><td class="noir">' . $i++ . '</td><td class="noir">' . $adh->Id . '</td><td class="noir">' . $adh->neige . '</td><td class="noir">' . $adh->nom . ' ' . $adh->prenom . '</td></tr>';
          //echo $adh->Id . ' - ' . $adh->neige . ' - ' . $adh->nom . ' ' . $adh->prenom . '<br>';
        }
        
         
        echo '</table><form method="post">
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '"> 
        <input type="submit" name="commande" value="NEIGE" TITLE="Importation ou liste des formations secours et DVA" style="background:green !important;">';
        retour_menu();
        echo '</form></div>';
 }
 else if ($commande == 'CONTACTER NOS ADHERENTS')
 {
        add_log ($commande);
        echo '<div class="detail"><h1>Contacter par mail nos adhérents</h1>
        <p class="oblique">Il s\'agit ici de lister les adresses mail des adhérents à une activité (par exemple l\'alpinisme) afin d\'envoyer un mailing avec activite@cafmeythet.org comme émetteur.</p>
        <form method="post">1-Choisir l\'activité<br>';
        menu_activite('');
        echo '2-Choisir une date de début de l\'activité (1 an max)<br>
        Date de début : <input type="date" name="date" value="' . $date . '" min="'
        . date('Y-m-d', strtotime(date('Y-m-d') . " - 1 year")) . '" max="' . date('Y-m-d') . '"  required style="color:black; background-color:#fafafa; border-color:blue;"><br>
        <input type="submit" name="commande" value="RESULTAT ET MAILING"> 
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">'; 
        retour_menu();
        echo '</form></div>';      
 }
 else if ($commande == 'RESULTAT ET MAILING')
 {
        add_log($commande);
        $factivite = $_POST['factivite']; $date = $_POST['date'];
        echo '<div class="detail"><h1>Contact adhérents de l\'activité ' . $factivite . '  - mailing</h1>';
        $i=0;
        $liste = extract_liste_mail_activite ($factivite, $date);
        $mails = array();
        $i=1; $mails[0]='xxxx';
        foreach ($liste as $adh)
        {
          if (!array_search($adh->email, $mails))
            $mails[$i++] = $adh->email;
        }
        echo '<font color="blue">' . $i . ' adhérents à contacter</font><br>';
        $i=0;
        foreach ($mails as $mail)
        {
           $lmail .= $mail . ';';
        }
 
        $lmail = substr($lmail, 0, strlen($lmail)-1);
        echo '<p>Liste : ' . substr($lmail,5) . '</p>';
        
        echo '<p class="oblique_bleu">Le mail que vous allez élaborée ici va être envoyé en liste cachée vers tous les adhérents de votre liste. Par défaut le destinataire principal est club@cafmeythet.org et l\'expéditeur est activite@cafmeythet.org.</p>
      <p><form method="post">
      <table>
      <tr><td class="note">Expéditeur</td><td class="note"><input type="text" name="expediteur" value="activite@cafmeythet.org"></td></tr></td></tr>
      <tr><td class="note">Destinataire principal</td><td class="note"><input type="text" name="destinataire" value="club@cafmeythet.org"></td></tr>
      <tr><td class="note">Objet</td><td class="note"><input type="text" name="objet"></td></tr>
      <tr><td class="note">Message</td><td class="note"><TEXTAREA  name="message" rows="6" cols="40" style="color:black; background-color:#fafafa; border-color:blue;"></TEXTAREA></td></tr></table>
       <input type="submit" name="commande" value="ENVOI MAILING ADHERENTS">';
       retour_menu();
       echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">
       <input type="hidden" name="factivite" value="' . $factivite . '">
       <input type="hidden" name="lmail" value="' . substr($lmail,5) . '">
       </form></div>';      
 }
 else if ($commande == 'MAJ ADHERENTS FFCAM')
 {

      echo '<div class="detail">
      <h1>Extraction des données de la FFCAM</h1>';
      // Requête curl à TESTWP
      $url = 'https://www.cafmeythet.org/wp/TESTWP/';


      $data = http_build_query([
        'commande'=>"CURL FFCAM"
      ]);

      // Initialize cURL session
      $ch = curl_init($url);

      // Set cURL options
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_POST, true);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

   

      // Execute the POST request
      $response = curl_exec($ch);
      $position = strpos($response, 'Mise à jour');
      echo substr($response, $position);
      echo '<form method="post">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
       <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
       <input type="hidden" name="cx" value="' . $cx . '">
       <input type="hidden" name="factivite" value="' . $factivite . '">
       </form></div>';
         
 }
 else if ($commande == 'ENVOI MAILING ADHERENTS')
 {
        $factivite = $_POST['factivite']; $lmail = $_POST['lmail'];
        $expediteur = $_POST['expediteur']; $objet = $_POST['objet'];
        $destinataire = $_POST['destinataire']; $message = $_POST['message'];

        echo '<div class="detail"><h1>Envoi vers les destinataires</h1>' . $lmail . '<br>';
        if (TEST == 1) 
          $lmail='mic.brusa@gmail.com;brusamarick@gmail.com';
        SendMailing ($expediteur, $destinataire, $objet, $message, $lmail);

        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
         <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
         <input type="hidden" name="cx" value="' . $cx . '">
         <input type="hidden" name="factivite" value="' . $factivite . '">
         <input type="hidden" name="lmail" value="' . $lmail . '">
         </form></div>'; 

 }
 else if ($commande == 'PAIE ASSO CB')
 {
        echo '<div class="detail"><h1>Menu des paiements Asso CB</h1>
        <form method="post">
        <input type="submit" name="commande" value="LECTURE FICHIER DES COMMANDES" TITLE="Prise en compte d\'un fichier de commande appelé aussi de récapitulatif"> 
        <input type="submit" name="commande" value="ACCES AUX PAIEMENTS">'; 
        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        </form>
        <p class="oblique_bleu">Ce menu est étendu à tous les encadrants du CAF Meythet depuis le mois d\'aôut.</p></div>'; 
 }
 else if ($commande == 'ACCES AUX PAIEMENTS')
 {
        add_log ($commande . ' ASSOCB');
        $compta = $_POST['compta'];
        $ftype = sup_anti_slash($_POST['ftype']); 
        $fnom = sup_anti_slash($_POST['fnom']);
        $date_d = $_POST['date_d'];
        if ($date_d != '')
          $date = getDateNormToFr ($date_d);

        if ($compta == 'compta')
          $check = 'CHECKED';
        else
          $check = '';

        echo '<div class="detail"><h1>Paiements Asso CB ' . $date . '</h1>
        <form method="post">
        <input type="checkbox" name="compta" value="compta" ' . $check . ' id="comta"> <label for"compta">avec les commandes entrées en comptabilité</label><br>';

        $reqt = "SELECT typeoption FROM " . $table_assocb ;
        if ($compta == '')
          $reqt .= " WHERE comptadate='0000-00-00'";
        $reqt .= " ORDER BY typeoption";
        $rept = $wpdb2->get_results($reqt);
    
        $tabtype = array(); $i=0;
        foreach ($rept as $type)
        {
          if ($i == 0)
            $tabtype[$i++] = $type;
          else
          {
            $connu = false;
            for ($j=0; $j<$i; $j++)
            {
              if ($type == $tabtype[$j])
              {
                $connu = true;
                break;
              }
            }
            if ($connu == false)
              $tabtype[$i++] = $type;
          }
        }

        if ($ftype == '' || $ftype == 'Les 10 derniers paiements')
            echo '<input type="radio" checked name="ftype" value="Les 10 derniers paiements">Les 10 derniers paiements ';
        else
            echo '<input type="radio" name="ftype" value="Les 10 derniers paiements">Les 10 derniers paiements ';
        if ($ftype == 'Tous les paiements')
            echo '<input type="radio" checked name="ftype" value="Tous les paiements">Tous les paiements ';
        else
            echo '<input type="radio" name="ftype" value="Tous les paiements">Tous les paiements ';

        foreach ($tabtype as $type)  
        {
          if ($ftype == $type->typeoption)
            echo '<input type="radio" checked name="ftype" value="' . $type->typeoption . '">' . 
          $type->typeoption . ' ';
        else
            echo '<input type="radio" name="ftype" value="' . $type->typeoption . '">' . $type->typeoption . ' ';          
        }  
    
        echo '<br>Recherche nom : au moins les deux premières lettres
             <input type="text" name="fnom" value="' . $fnom . '"> ';
        echo '<br>Recherche d\'une date de paiement : <input type="date" name="date_d" value="' . $date_d . '"  style="color:black; background-color:#fafafa; border-color:blue;"><br>' ;

        //recherche de la derniere mise à jour des paiements
        $req = "SELECT naissance FROM " . $table_assocb . " ORDER BY naissance DESC";
        $rep = $wpdb2->get_results($req);
        $datemaj = $rep[0]->naissance;
        echo 'Dernière prise en compte des paiements : <b>' . getJourDate($datemaj) . '</b><br>';
                
        echo '<input type="submit" name="x" value="REFRESH DES PAIEMENTS">';
              
        retour_menu();
        echo '<input type="hidden" name="commande" value="ACCES AUX PAIEMENTS">
              <input type="hidden" name="auth" value = "' . $auth . '">
              <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
              <input type="hidden" name="cx" value="' . $cx . '">
              <input type="hidden" name="factivite" value="' . $factivite . '">
              <input type="hidden" name="lmail" value="' . $lmail . '">
              </form>';    
        $req = "SELECT * FROM " . $table_assocb;
        if ($compta == '')
          $req .=  " WHERE comptadate='0000-00-00'"; 
        $nc = 1000;      
        if ($ftype == '') $ftype = 'Les 10 derniers paiements';     
        switch ($ftype)
        {      
          case 'Les 10 derniers paiements' : $nc=10; break;
          case 'Tous les paiements' : break;
          case 'Licence': $req .= " WHERE typeoption LIKE 'Part club%%' "; break;          
          default : 
          if (strstr($req,'WHERE'))
            $req .= " AND typeoption LIKE '%%" . $wpdb2->_real_escape($ftype) . "%%'" ;
          else  
            $req .= " WHERE typeoption LIKE '%%" . $wpdb2->_real_escape($ftype) . "%%'" ;
        }
        if ($fnom != '')
        {
          if (stristr($req, "WHERE"))
              $req .= " AND (nom LIKE '%%" . $fnom . "%%' OR prenom  LIKE '%%" . $fnom . "%%')";
          else
              $req .= " WHERE (nom LIKE '%%" . $fnom . "%%' OR prenom  LIKE '%%" . $fnom . "%%')";
        }
        if ($date_d != 0)
        {
          if (stristr($req, "WHERE"))
              $req .= " AND date LIKE '" . $date . "%%'";
          else
              $req .= " WHERE date LIKE '" . $date . "%%'";
        }

        $req .= " ORDER BY refcom DESC";
        //echo $req . '<br>';
        $rep = $wpdb2->get_results($req);
        echo '<table border="1">
        <tr><th>Référence</th><th>Nom</th><th>Type</th><th>Date</th><th>Payé</th></tr>';
        $total = 0;
        if ($compta == 'compta')
          echo '<p class="oblique_bleu">Les paiements en couleur bleu sont dans la comptabilité du CAF</p>';
        foreach ($rep as $pay)
        {
          $nc--;
          $total += $pay->paye;
          $idref++;
          echo '<tr><td><form method="post" id="' . $idref . '"><a href="#" onClick="Submit(\'', $idref, '\');" 
              TITLE="Cliquez ici pour obtenir les données complètes du paiement">
                <input type="hidden" name="refcom" value = "' . $pay->refcom . '">
                 <input type="hidden" name="auth" value = "' . $auth . '"> 
                 <input type="hidden" name="cadre_p" value = "' . $cadre_p . '">
                 <input type="hidden" name="factivite" value="' . $factivite . '">
                 <input type="hidden" name="cx" value="' . $cx . '"> 
              <input type="hidden" name="licence" value="' . $d->id . '" />
              <input type="hidden" name="commande" 
              value="DETAIL PAIEMENT">                               
              </form><b>';
              if ($pay->unit != $pay->paye)
                  echo '<font color="purple">';
              echo $pay->refcom;
              if ($pay->unit != $pay->paye)
                  echo '</font>';
              echo '</td>';
              if (substr($pay->comptadate,0,1)==2)
              {
                echo '<td><font color="blue">' . strtoupper($pay->nom . ' ' . $pay->prenom) . '</font></td>
                <td><font color="blue">' . $pay->typeoption . '</font></td>
                <td><font color="blue">' . $pay->date       . '</font></td>
                <td><font color="blue">' . $pay->paye       . '</font></td>
                </tr>';
              }
              else
              {
                echo '<td>' . strtoupper($pay->nom . ' ' . $pay->prenom) . '</td>
                <td>' . $pay->typeoption . '</td>
                <td>' . $pay->date       . '</td>
                <td>' . $pay->paye       . '</td>
                </tr>';                
              }
          if ($nc == 0) break;          
        }
        echo '<tr><td><b>TOTAL</b></td><td></td><td></td><td></td><td><b>' . $total . ' €</b></td></tr>
        </table>';

        echo '<form method="post">
        <input type="submit" name="commande" value="LECTURE FICHIER DES COMMANDES" TITLE="Prise en compte d\'un fichier de commande appelé aussi de récapitulatif"> 
        <input type="submit" name="commande" value="ACCES AUX PAIEMENTS"> ';
        $fonction = extract_fonction_cadre(wd_remove_accents($cadre_p));
        if (stristr($fonction, 'Webmaster'))
          echo '<input type="submit" name="commande" value="ENTREE EN COMPTA" style="background:purple !important;">';

        retour_menu();
        echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        </form></div>';        
  }
  else if ($commande == 'ENTREE EN COMPTA')
  {
    echo '<div class="detail">
    <h1>Marquage des plus anciens paiements en compta</h1>';
    $req = "SELECT * FROM " . $table_assocb . " 
      WHERE comptadate = '0000-00-00' ORDER BY refcom ASC";
    $rep = $wpdb2->get_results($req);
    $type = $rep[0]->typeoption;
    echo '<p>Le groupe de commande non comptabilisé et le plus ancien est <b>' . $type . '</b></p>'; //print_r($rep[0]);
    $firstref = $rep[0]->refcom;  $firstdate=substr($rep[0]->date,0,10);
    echo 'Ref premier : ' . $firstref . ' - ' . $firstdate . '<br>'; 
    $req = "SELECT * FROM " . $table_assocb . " 
      WHERE typeoption = '" . $wpdb2->_real_escape($type) . "' ORDER BY refcom DESC";
    $rep = $wpdb2->get_results($req);
    $lastref = $rep[0]->refcom;  $lastdate=substr($rep[0]->date,0,10);
    echo 'Ref dernier : ' . $lastref . ' - ' . $lastdate . '<br>';
    $req = "SELECT COUNT(*) AS count FROM " . $table_assocb . " WHERE typeoption = '" . $wpdb2->_real_escape($type) . "'";
    $rep = $wpdb2->get_results($req);
    echo 'Nombre de commandes : ' . $rep[0]->count . '<br>';
    echo '<form method="post">Date comptabilité : 
    <input type="date" name="comptadate" value="' . getDateFrToNorm($lastdate) . '"><br>
    Commentaire comptable
    <input type="text" name="comptatext">
    <input type="submit" name="commande" value="MARQUAGE COMPTABLE" style="background:purple !important;">';
    retour_menu();
    echo '<input type="hidden" name="type" value = "' . $type . '">
    <input type="hidden" name="count" value = "' . $rep[0]->count . '">    
    <input type="hidden" name="auth" value = "' . $auth . '">
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
    <input type="hidden" name="cx" value="' . $cx . '">
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="lmail" value="' . $lmail . '">
    </form></div>';    

  }
  else if ($commande == 'MARQUAGE COMPTABLE')
  {
    $type = sup_anti_slash($_POST['type']); 
    $comptadate = $_POST['comptadate'];
    $comptatext = $_POST['comptatext'];
    $count = $_POST['count'];
    echo '<div class="detail">
    <h1>Mise à jour comptable de ' . $count . ' commandes</h1>
    <p>Groupe de commande : ' . $type . '<br>
    Date de marquage compta : ' . $comptadate . '<br>
    Commentaire : ' . $comptatext . '<br>';

    $upd = "UPDATE " . $table_assocb . " SET comptadate = '" . $comptadate . "', comptatext = '" . $wpdb2->_real_escape($comptatext) . "' WHERE typeoption = '" . $wpdb2->_real_escape($type) . "'";
    $wpdb2->get_results($upd);
    echo '<form method="post">
    <input type="submit" name="commande" value="ACCES AUX PAIEMENTS">';
    retour_menu();
    echo '<input type="hidden" name="type" value = "' . $type . '">
      <input type="hidden" name="count" value = "' . $rep[0]->count . '">    
      <input type="hidden" name="auth" value = "' . $auth . '">
      <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
      <input type="hidden" name="cx" value="' . $cx . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="lmail" value="' . $lmail . '">
      </form></div>';
  }
  else if ($commande == 'LECTURE FICHIER DES COMMANDES')
  {
      add_log ($commande . ' ASSOCB');
      echo '<div class="detail">
      <h1>Prise en compte des paiements AssoCB</h1>
      <form method="post" enctype="multipart/form-data">
      Sélectionner le fichier Excel des paiements :
      <input type="file" id="file" name="ffile" 
      accept=".xls,.xlsx,.csv,.zip" value="" >
      <input type="submit"  name="commande"  value="ACQUISITION ASSOCB">';
      retour_menu();
      echo '<input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        </form>
        <p>Dans le cas ou ce fichier a été déjà enregistré, il sera ignoré.
        </p></div>';
  }  
  else if ($commande == 'ACQUISITION ASSOCB')
  {
      $ffile        = $_FILES['ffile'];
      $WorkSheet    = $_POST['WorkSheet'];    //nom de la feuille à lire
      $file         = $_POST['file'];
      $fname        = $_POST['fname'];
      $file_type    = $_POST['file_type'];
      $XLS          = $DIR . '/XLS/';        //dossier des tableurs Excell

  
      if ($WorkSheet == '')
      {
        $fname        = $ffile['name'];      //nom du fichier
  
        $file         = $XLS . $fname;       //nom complet
        $tmpfile      = $ffile['tmp_name'];  //fichier temporaire
        rename  ($ffile['tmp_name'], "$file");
      }
      add_log ($commande . ' ' . $fname);
      $fileInfo     = new SplFileInfo($fname);
      $extent       = $fileInfo->getExtension();

      switch ($extent)
      {
        case 'xlsx': $file_type = 'Xlsx';  break;       
        case 'xls' : $file_type = 'Xls';   break;
        case 'csv' : $file_type = 'Csv';   break;
      }

      $reader = IOFactory::createReader($file_type);
      $reader->setReadDataOnly(false);

      $spreadsheet = $reader->load($file);

      $sheetList = array();
      $countf = $spreadsheet->getSheetCount();  //nombre de pages

      $loadedSheetNames = $spreadsheet->getSheetNames();

      $I = 0;
      foreach ($loadedSheetNames as $SheetName) 
         $sheetList[$I++] =  $SheetName;
      if ($WorkSheet == '')          //y'a t'il déjà une page active ?
         $WorkSheet = $sheetList[0]; //on prend la première page par défaut


 
      echo '<div class="detail">
      <h1>Lecture du fichier AssoCB </h1><b>' . $fname . '/' . $WorkSheet . '</b><br>';
      //<p>Cliquer sur le nom d\'une feuille pour faire l\'acquisition des données
      //<form method="post" >';
      
      foreach ($loadedSheetNames as $SheetName)
      {
          if ($file_type == 'Csv')
            $SheetName .= ' csv';
          //echo '<input type="submit" value="' . $SheetName . '" name="WorkSheet"> '; 
          //echo 'Lecture de la feuille ' .  $SheetName . '<br>';
      }
      

      $reader = IOFactory::createReader($file_type);


      if ($file_type == 'Csv') 
        $reader->setDelimiter(";"); 
      else
        $reader->setLoadSheetsOnly($WorkSheet); //lecture de la feuille sélectionnée

      $spreadsheet = $reader->load($file);

      $sheetData = $spreadsheet->getActiveSheet()->toArray(null, false, false, false);
      //$sheetData = $spreadsheet->getActiveSheet()->toArray();

      lecture_par_ligne_et_cellule_cb ($sheetData);

      
      echo '<form method="post">
       <input type="submit" name="commande" value="LECTURE FICHIER DES COMMANDES" TITLE="Prise en compte d\'un fichier de commande appelé aussi de récapitulatif"> 
       <input type="submit" name="commande" value="ACCES AUX PAIEMENTS">';
      retour_menu();
      echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        </form></div>';        
  }
  else if ($commande == 'DETAIL PAIEMENT')
  {
    $refcom = $_POST['refcom'];
    echo '<h1>Détail du paiement de référence ' . $refcom . '</h1>
    <table border="1">
    <th>Libellé</th><th>Valeur</th>';
    add_log ($commande . ' ' . $refcom);
    $req = "SELECT * FROM " . $table_assocb . " WHERE refcom = " . $refcom;
    $rep = $wpdb2->get_results($req);
    //echo $req . '<br>';
    //print_r ($rep);
    $pay = $rep[0];
    echo '<tr><td>Référence unique</td><td>'    . $pay->refcom  . '</td></tr>
          <tr><td>Référence bancaire</td><td>'  . $pay->refbanc . '</td></tr>
          <tr><td>Nom</td><td>'  . $pay->nom . '</td></tr>
          <tr><td>Prénom</td><td>'  . $pay->prenom . '</td></tr>
          <tr><td>Option</td><td>'  . $pay->typeoption . '</td></tr> 
          <tr><td>Date</td><td>'  . $pay->date . '</td></tr>
          <tr><td>Prix unitaire</td><td>'  . $pay->unit . '</td></tr>
          <tr><td>Nombre</td><td>'  . $pay->quant . '</td></tr> 
          <tr><td>Payé</td><td><b>'  . $pay->paye . ' €';
    if ($pay->paye != $pay->unit)
      echo ' = ' . $pay->unit . ' € + ' . ($pay->paye - $pay->unit) . ' €';
    echo '</b></td></tr>
          <tr><td>Email</td><td>'  . $pay->email . '</td></tr>
          <tr><td>Téléphone</td><td>'  . $pay->mobile . '</td></tr>          
          <tr><td>Adresse</td><td>'  . $pay->adresse . '</td></tr>
          <tr><td>Code Postal</td><td>'  . $pay->cp . '</td></tr>
          <tr><td>Ville</td><td>'  . $pay->ville . '</td></tr>                    
    </table>';
    echo '<form method="post">
        <input type="submit" name="commande" value="LECTURE FICHIER DES COMMANDES" TITLE="Prise en compte d\'un fichier de commande appelé aussi de récapitulatif"> 
       <input type="submit" name="commande" value="ACCES AUX PAIEMENTS">';
    retour_menu();
    echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        </form></div>';      
  }
  else if ($commande == 'AFFICHAGE DE LA LOG')
  {
    $datel = $_POST['datel'];  $heurel = $_POST['heurel'];

    echo '<div class="detail"><h1>Log des dialogues du ' . $datel . '</h1>';
    affichage_log_dialogue ($datel,$heurel);
    echo '<form method="post">
    <input type="submit" name="commande" value="LOG DES DIALOGUES">'; 
    retour_menu();
    echo '<input type="hidden" name="auth" value = "' . $auth . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="lmail" value="' . $lmail . '">
        <input type="hidden" name="datel" value="' . $datel . '">        
        <input type="hidden" name="heurel" value="' . $heurel . '">        
        </form></div>';
  }
  else if ($commande == 'GESTION DES EPI'                || $commande == 'CONTROLE EPI'
           || $commande == 'CONTROLE DES EPI SELECTIONNES'  || $commande == 'CONFIRMATION DU CONTROLE'
           || $commande == 'LISTE FILTREE DES EPI'          || $commande == 'LISTE FILTREE DES EPI POUR CONTROLE'
           || $commande == 'DETAIL EPI'                     || $commande == 'TRI PAR IDENTIFIANT EPI'
           || $commande == 'TRI PAR DATE DE CONTROLE'       || $commande == 'TRI PAR LIEU DE STOCKAGE'
           || sup_anti_slash($commande) == 'TRI PAR TYPE D\'EQUIPEMENT'
           || $commande == 'TRI PAR DATE DE FIN DE VIE'     || $commande == 'HISTORIQUE DES CONTROLES'
           || $commande == 'CONFIRMATION DU CONTROLE'
           || $commande == 'AJOUTER UN EQUIPEMENT EPI'      || $commande == 'ENREGISTRER NOUVEAU EPI'
           || $commande == 'GESTION MATERIEL ET CARTE'      || $commande == 'GESTION MATERIEL, CARTES, LIVRES ET EPI'
           || $commande == 'GESTION DES CARTES'             || $commande == 'DETAIL CARTE'
           || $commande == 'ENREGISTRER LA CARTE'           || $commande == 'AJOUTER UNE CARTE'
           || $commande == 'ENREGISTRER LA NOUVELLE CARTE'  || $commande == 'SUPPRIMER LA CARTE'
           || $commande == 'GESTION DES LIVRES'             || $commande == 'DETAIL LIVRE'
           || $commande == 'ENREGISTRER LE LIVRE'           || $commande == 'AJOUTER UN LIVRE'
           || $commande == 'ENREGISTRER LE NOUVEAU LIVRE'   || $commande == 'SUPPRIMER LE LIVRE'           
           || $commande == 'GESTION DU MATERIEL'            || $commande == 'DETAIL MATERIEL'
           || $commande == 'ENREGISTRER LE MATERIEL'        || $commande == 'AJOUTER UN MATERIEL'
           || $commande == 'ENREGISTRER LE NOUVEAU MATERIEL' || $commande == 'SUPPRIMER LE MATERIEL'
           || $commande == 'DATES DES PROCHAINS CONTROLES EPI' || sup_anti_slash($commande) == 'EDITER L\'EPI'
           || $commande == 'ENREGISTRER EPI'             || sup_anti_slash($commande) == 'AJOUTER UNE IMAGE DE L\'EPI'
           || $commande == 'ACQUISITION IMAGE EPI'       || sup_anti_slash($commande) == 'AJOUTER UNE DOCUMENTATION DE L\'EPI'
           || $commande == 'ACQUISITION DOCUMENTATION EPI' || sup_anti_slash($commande) == "TYPES D'EQUIPEMENT"
           || $commande == 'AJOUTER UN NOUVEAU TYPE'        || $commande == 'ENREGISTRER LE TYPE'
           || sup_anti_slash($commande) == "ETATS D'UN CONTROLE"
           || $commande == 'AJOUTER UN NOUVEAU ETAT'        || sup_anti_slash($commande) == "ENREGISTRER LE NOUVEL ETAT"
           || $commande == 'LISTE AVEC FILTRES'             || $commande == 'LISTE DES EQUIPEMENTS FILTRES'
           || $commande == 'EXPORT CSV DES EPI'             || $commande == 'PARAMETRAGE EPI'
           || $commande == 'PRISE EN COMPTE DU PARAMETRAGE' || sup_anti_slash($commande) == "CONTROLE DIRECT DE L'EPI"                      || $commande == 'VALIDATION DU CONTROLE')
  {
    if (TEST == 1)  
      require_once "test_materiel.php";
    else
      require_once "materiel.php";
    add_log ($commande);
    materiel();
  }


  //echo '</p><!--test-align-->';
   
  //echo '</div><!--post-content-->';


  // V2.20 purge des fichiers d'export après 1 heure
  if (is_dir($DIR_EXPORT))
  {
    $scanexp = scandir ($DIR_EXPORT);
    
    if (sizeof ($scanexp) > 2)
    {
      for ($i = 2; $i < sizeof($scanexp); $i++)
      {
        if (substr($scanexp[$i],0,1) == '.') continue;
        $fic = $DIR_EXPORT . '/' . $scanexp[$i];
        $t = filemtime($fic);
        $datemod = date('Y-m-d Y:i:s', $t);

        if (time() - $t > 3600)
        {
          add_log ('Sup. fichier ' . $scanexp[$i] . ' créé le ' . $datemod);
          unlink ($fic);
        }
      }
    }
  }


/*
    After Content Area

  ---------------------------------------
  Hooked: evolve_primary_container_close() - 10
  --------------------------------------- */

do_action( 'evolve_after_content_area' );

/*
  Sidebars

  ---------------------------------------
  Hooked: evolve_sidebars() - 10
  --------------------------------------- */

do_action( 'evolve_sidebars_area' );

/*
  Footer Area
  --------------------------------------- */

get_footer();

function affichage_log_dialogue ($date, $heure)
{
  global $wpdb2;
    
    $req = "SELECT * FROM cal_cal_log WHERE appli = 'CAL' AND info LIKE '%%commande dialogue%%'";

  if ($date != '')
  {
    if ($heure == '00:00')
      $req .= " AND date_log like '" . $date . "%%' ";
    else 
      $req .= " AND date_log like '" . $date . "%%' AND date_log >= '" . $date . ' ' . $heure . ":00' ";
  }




  $req .= " ORDER by date_log";      
  
  $rep = $wpdb2->get_results($req);
  echo '<font color="blue">Résultat : ' . sizeof($rep) . ' lignes </font><br>';
  foreach ($rep as $log)
  {
    $buffer = $log->info;

    
    //echo $buffer . '<br><br>';
    //echo substr($buffer,0,20);
    echo substr($log->date_log,8,2) . '/' . substr($log->date_log,5,2)  .'/' . substr($log->date_log,0,4);
    echo substr($log->date_log,10, 9)  . ' - ';
    echo $log->appli . ' - ';
    //echo $log->date_log . ' - ';
    echo gras($log->user) . ' - ';
    if ($log->IDU != 0) echo gras(color('blue',$log->IDU)) . ' - ';
        

        
    $p2 = strpos($buffer, '.txt');
    if ($p2)
    {
      $p2 -= 4;
      $p1 = $p2-40;


      //echo substr($buffer,24, $p1-24);
      echo gras(color('green', substr($buffer, $p1,8))) . substr($buffer, $p1+8, $p2 - $p1 - 8);
      echo gras(color('blue', substr($buffer, $p2, 4))) . substr($buffer, $p2+4);
    }
    else
      echo htmlentities($buffer);
       

        echo '<br>';
    

  }
  return sizeof($rep);
    
}


function lecture_par_ligne_et_cellule_cb ($sheetData)
{
   global $spreadsheet, $wpdb2, $log, $cx, $cadre_p, $table_assocb;
   
   $line = 1;

   //print_r ($sheetData);
   $keydate = '';   
   foreach ($sheetData as $row) 
   {

      $i=1;

      foreach ($row as $cell)
      {

         $value = $cell;
         if (substr($cell, 0,2) == '="')
          $value = substr($cell, 2, strlen($cell) -3);
         else if (substr($cell, 0,1) == '=')
          $value = substr($cell, 1);


         if ($line == 1 && $i == 1 && $value == 'Référence commande')
          break;
         
         //echo 'L' . $line . 'C' . $i . ' = ' . $value . '<br>'; 
         switch ($i)
         {
            case 1 : $refcom  = $value;  break;
            case 2 : $refbanc = $value;  break;
            case 5 : $date    = $value;  break;
            case 6 : $unit    = $value;  break;
            case 11: $paye    = $value;  break;
            case 15: $nom     = $value;  break;
            case 16: $prenom  = $value;  break;
            case 17: $email   = $value;  break;            
            case 18: $adresse = $value;  break;
            case 19: $cp      = $value;  break;
            case 20: $ville   = $value;  break;
            case 22: $mobile  = $value;  break;
            case 23: $naissance = date('Y-m-d'); break;
            case 24: $typeoption = $value; break;            
            case 25: $quant     = $value; break;
         }

         if ($line > 1 && $date[$i]==1 && is_numeric($value))
         {

            //echo 'on passe ici';
            $datet = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($value);

            $value = date ('d/m/Y', $datet);
         }
         
         //echo '<td>' . $value . '</td>';
         $i++;

      }
      if ($line > 1 && $refcom > 0)
      {
          $req = "SELECT * FROM " . $table_assocb . " WHERE refcom = " . $refcom;
          $rep = $wpdb2->get_results($req);
          if ($wpdb2->last_error)
          {
            echo 'Erreur ' . $wpdb2->last_error . '<br>';
          }

          if (sizeof($rep) > 0)
          {
            echo '<p>Le paiement de référence <b>' . $refcom . '</b> du ' . $date . ' a déjà été pris en compte';
            if ($rep[0]->paye != $paye)
            {
              echo 'Montant enregistré = ' . $rep[0]->paye . '<br>
                    Montant courant ...= ' . $paye . '<br>';
              $upd = "UPDATE " . $table_assocb . " SET paye = " . $paye . " WHERE refcom = " . $refcom;
              $wpdb2->get_results($upd);
              echo $wpdb2->last_error;
            }
            if ($rep[0]->unit != $rep[0]->paye)
            {
              echo '<br><font color="red">Ce paiement de ' . $rep[0]->paye . ' est composé d\'un montant de ' . $rep[0]->unit . ' € et d\'un montant de ' . ($rep[0]->paye - $rep[0]->unit) . ' €<br></font>';
            }
            echo '</p>';            
          }
          else
          {
            add_log ('Le paiement de référence ' . $refcom . ' du ' . $date . ' est pris en compte');
            echo '<p>Le paiement de référence <b>' . $refcom . '</b> du ' . $date . ' a été pris en compte</p>';            
            $ins = "INSERT INTO " . $table_assocb . "  (`refcom`, `refbanc`, `typeoption`, `quant`, `unit`, `paye`, `nom`, `prenom`, `date`, `email`, `adresse`, `cp`, `ville`, `mobile`, `naissance`)  VALUES (". $refcom . ",'" . $refbanc . "','" . $wpdb2->_real_escape($typeoption) . "'," . $quant . "," . $unit . "," . $paye . ", '" . $wpdb2->_real_escape($nom) . "','" . $wpdb2->_real_escape($prenom) . "','" . $date . "','" . $email . "','" . $wpdb2->_real_escape($adresse) . "','" . $cp . "','" . $wpdb2->_real_escape($ville) . "','" . $mobile . "','" . $naissance . "')"; 
            //echo $ins . '<br>';            
            $wpdb2->get_results($ins);
            if ($wpdb2->last_error)
            {
                echo $ins . '<br>' . $wpdb2->last_error;
                exit;
            }
          }
       }

      $line++;
   }

}

function menu_activite ($factivite)
{
 
  echo '<p>';
  if ($factivite=='') $factivite='toutes';
  echo '<div class="filtre"><form method="post">';

  if ($factivite == 'Alpinisme')
    echo '<input type="radio" checked name="factivite" value="Alpinisme"/>Alpinisme ';
  else
    echo '<input type="radio" name="factivite" value="Alpinisme"/>Alpinisme ';

  if ($activite == 'Cascade de glace')
    echo '<input type="radio" checked name="factivite" value="Cascade de glace"/>Cascade de glace ';
  else
    echo '<input type="radio" name="factivite" value="Cascade de glace"/>Cascade de glace '; 
  if ($factivite == 'Escalade')
    echo '<input type="radio" checked name="factivite" value="Escalade"/>Escalade ';
  else
    echo '<input type="radio" name="factivite" value="Escalade"/>Escalade ';
  if ($factivite == 'Escalade en falaise')
    echo '<input type="radio" checked name="factivite" value="Escalade en falaise"/>Escalade en falaise ';
  else
    echo '<input type="radio" name="factivite" value="Escalade en falaise"/>Escalade en falaise ';   
   
  if ($factivite == 'Kayak')
    echo '<input type="radio" checked name="factivite" value="Kayak"/>Kayak ';
  else
    echo '<input type="radio" name="factivite" value="Kayak"/>Kayak ';
  if ($factivite == 'Marche nordique')
        echo '<input type="radio" checked name="factivite" value="Marche nordique" />Marche nordique ';
  else
    echo '<input type="radio" name="factivite" value="Marche nordique" />Marche nordique ';
  if ($factivite == 'Ski alpin')
    echo '<input type="radio" checked name="factivite" value="Ski alpin"/>Ski alpin ';
  else
    echo '<input type="radio" name="factivite" value="Ski alpin"/>Ski alpin ';
  if ($factivite == 'Ski de fond')
    echo '<input type="radio" checked name="factivite" value="Ski de fond"/>Ski de fond ';
  else
    echo '<input type="radio" name="factivite" value="Ski de fond"/>Ski de fond ';
  if ($factivite == 'Ski de randonnée')
        echo '<input type="radio" checked name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
  else
    echo '<input type="radio" name="factivite" value="Ski de randonnée"/>Ski de randonnée ';
  if ($factivite == 'Ski de randonnée nordique')
        echo '<input type="radio" checked name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
  else
        echo '<input type="radio" name="factivite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
  if ($factivite == 'Trail')
        echo '<input type="radio" checked name="factivite" value="Trail">Trail ';
  else
        echo '<input type="radio" name="factivite" value="Trail">Trail ';      

  if ($factivite == 'Randonnée pédestre')
    echo '<input type="radio" checked name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
  else
    echo '<input type="radio" name="factivite" value="Randonnée pédestre" />Randonnée pédestre ';
  if ($factivite == 'Raquettes')
    echo '<input type="radio" checked name="factivite" value="Raquettes"/>Raquettes ';
  else
    echo '<input type="radio" name="factivite" value="Raquettes"/>Raquettes ';
  /*
  if ($factivite == 'Raquettes alpines')
        echo '<input type="radio" checked name="factivite" value="Raquettes alpines"/>Raquettes alpines ';
  else
    echo '<input type="radio" name="factivite" value="Raquettes alpines"/>Raquettes alpines ';
  */  
  if ($factivite == 'Via ferrata')
        echo '<input type="radio" checked name="factivite" value="Via ferrata"/>Via ferrata ';
  else
        echo '<input type="radio" name="factivite" value="Via ferrata"/>Via ferrata ';

  if ($factivite == 'VTT')
        echo '<input type="radio" checked name="factivite" value="VTT"/>VTT ';
  else
        echo '<input type="radio" name="factivite" value="VTT"/>VTT ';
  if ($factivite == 'Comité Directeur')
        echo '<input type="radio" checked name="factivite" value="Comité Directeur"/>Comité Directeur ';
  else
        echo '<input type="radio" name="factivite" value="Comité Directeur"/>Comité Directeur ';
  if (strstr($factivite,'photos'))
        echo '<input type="radio" checked name="factivite" value="photos"/>Publication articles photos ';
  else
        echo '<input type="radio" name="factivite" value="photos"/>Publication articles photos ';
  echo '</div></p>';

}


function getCourtDate($date)
{
  $nom_jour = array ('lun', 'mar', 'merc', 'jeu','ven','sam','dim');
 
  $ts = strtotime($date);
  $njour = strftime ('%u', $ts);
  $jour_date = $nom_jour[$njour-1] . ' ' . date('d/m/Y', $ts) ;
  return $jour_date;
}





function getTrimDate ($date_deb, $date_fin, $type_s)
{
   
   if ($type_s == 'W')
      $ret = 'WE du ' . getCourtDate ($date_deb) . ' et ' . getCourtDate ($date_fin);
   else if ($type_s == 'S')
      $ret = 'Séjour du ' . getCourtDate ($date_deb) . ' au ' . getCourtDate ($date_fin);
   else
      $ret = getCourtDate ($date_deb);
   return $ret;
}



function getDateFr ($date_norm)
{
  return substr($date_norm, 8,2) . '/' . substr($date_norm, 5,2) . '/' . substr($date_norm, 0, 4);
}

function read_note ($dossier, $file, $auth )
{
   global $idref, $DIR, $fcadre, $factivite,$DIR_CORBEILLE;

   $fname = $dossier . '/' . $file;
   $fd = fopen ($fname, 'r');
   $cont = 0;
   echo '<tr><td>';
   if ($auth == 2015)
      echo  getWEDate($file)  . '</td>';
   else {
     $idref++;
     if ($dossier != $DIR_CORBEILLE)
     {
       echo ' <form id="', $idref, '" method="post"> <input type="checkbox" name="tcorb[]" value="' . $file . '" >
       <input type="hidden" name="auth" value="' . $auth . '"/>
       <A HREF="#" onClick="Submit(\'', $idref, '\');" TITLE="Pour modification administrateur"><b>' . 
       getWEDate($file) . '</b></A>
       <input type="hidden" name="commande" value="MODHISTO"/>
       <input type="hidden" name="file" value="' . $file . '"/>
       <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
       <input type="hidden" name="factivite" value="' . $factivite . '"/>
       <input type="hidden" name="cx" value="' . $cx . '"/>
       </form></td>';
     }
     else
     {
       $info = '';
       if (getAnnulation($DIR_CORBEILLE, $file))
        $info = '<font color="blue"> Annulation</font>';

       echo '<input type="checkbox" name="tcorb[]" value="' . $file . '" > <b>' . getWEDate($file)  . '</b>' . $info . '</td>';
     }
  
   }

   while (($buffer = fgets($fd, 4096)) !== false) {
     if (!strstr ($buffer, '</')) {
      if ($cont < 1)
          echo '<td>' . $buffer  . '<br><font color="grey">Mod. le ' . getModificationDate ($file) . ' ' . getModificationHour($file) . '</font></td>';
      if ($cont < 2)
         echo '<td>' . $buffer  . '</td>';
      else if ($cont == 2)
         echo '<td>' . $buffer ;
      else
         echo '<br>' . $buffer;
      $cont++;
    }
   }
   echo '</td></tr>';
}



function sup_anti_slash2 ($texte)
{

    while ( $p1 = strpos ($texte, "'"))
    {
         $texte = substr ($texte, 0, $p1-1) . '£' . substr ($texte, $p1+1);
    }
    while ( $p1 = strpos ($texte, '£'))
    {
         $texte = substr ($texte, 0, $p1) . "'" . substr ($texte, $p1+2);
    }

    while ( $p1 = strpos ($texte, '"'))
    {
         $texte = substr ($texte, 0, $p1-1) . '£' . substr ($texte, $p1+1);
    }
    while ( $p1 = strpos ($texte, '£'))
    {
         $texte = substr ($texte, 0, $p1) . '"' . substr ($texte, $p1+2);
    }
    return $texte;
}



function affich_sortie ($IDU, $mode, $type, $date_deb, $date_fin, $cadre, $coencadrant, $activite, $titre, $detail, $denivele, $formation, $maxp,  $corbeille, $cotation='', $kms=0, $camp='' )
{
 global $auth, $fcadre, $cadre_p, $factivite, $date_min, $date_max, $diff, $code_admin, $status_auth, $collecte, $datefirst, $date_last, $CP, $CT,$cx;
//echo 'Denivele = ' . $denivele;
 //$date_min = date('Y-m-d'); 
 
 $titre = sup_anti_slash($titre);
 $c_activite = extract_activite_cadre ($cadre);
 $activ = explode(',', $c_activite);
 

 if ($activite == '') 
 {
  $activite = $activ[0]; 
 }

  
 //echo '<b>Act cadre :' . $activite . '</b>';
 if ($diff == '') $diff='sans';
 if ($status_auth == 'close')
  echo '<form action="#annonce" method="post" align="left" >';
 
  echo '<form method="post" align="left" ><p clas="oblique">Pour une activité à la journée, ne remplisser  pas la date de fin. Les WE ou séjours seront déterminés automatiquement.</p>'; 
  echo '<table>
    <tr><td><b>Encadrant principal</b></td><td>
  <input type="text" name="cadre" value="' . strtoupper(wd_remove_accents(sup_anti_slash($cadre))) . '"></td></tr>
        <tr><td>Coencadrant';
  if ($IDU == '') echo '(uniquement le nom)';
  echo '</td><td><input type="text" name="coencadrant" value="' . 
        strtoupper(wd_remove_accents(sup_anti_slash($coencadrant))) . '" style="color:black; background-color:#fafafa; border-color:blue;"></td></tr>
        </table>
        <table><td><b>Date de début</b> : <input type="date" name="date_deb" value="' . $date_deb . '" min="' . $date_min . '" max="' . $date_max . '"  required style="color:black; background-color:#fafafa; border-color:blue;"></td><td> 
        <b>Date de fin </b> : <input type="date"  name="date_fin" value="' . $date_fin . '" max="' . $date_max . '" style="color:black; background-color:#fafafa; border-color:blue;"></td>
        </table>';
   
   
   echo '<b>Type d\'activité: </b> ';

   foreach ($activ as $type_activite)
   {
     if (strlen($type_activite) > 2 )
     {
       if ($activite == $type_activite)
        echo '<input type="radio" checked name="activite" value="' . $type_activite . '"/>' . $type_activite . ' ';
       else
        echo '<input type="radio" name="activite" value="' . $type_activite . '"/>' . $type_activite . ' ';
     }
   }

   echo '
   <input type="hidden" name="auth" value="' . $auth . '"/>
   <input type="hidden" name="file" value="' . $file . '"/>
   <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
   <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
   <input type="hidden" name="factivite" value="' . $factivite . '"/>
   <input type="hidden" name="cx" value="' . $cx . '"/>
   <font color="grey">(pour une sortie le titre est le nom du sommet)</font>
   <table style="background-color:#ebf9b0;">
      <tr><td><b>Titre</b></td><td><input type="text" name="titre" size="150" value="' . htmlentities($titre) . '" required ></td>
      </tr>
      <tr><td><b> Dénivelé approximatif </b></td><td><input type="number" name="denivele" style="color:black; background-color:#fafafa; border-color:blue;" min="0" max="20000" value="' . $denivele . '"> m</td><td><b>Distance approximative</b></td><td><input type="number" name="kms" style="color:black; background-color:#fafafa; border-color:blue;" min="0" max="200" value="' . $kms . '"> km</td>
      </tr>
      <tr><td><input type="checkbox" name="bformation[]" ';

      if ($formation == 1) echo 'checked ';

      echo 'value="Formation" id="sel1"<label for"sel1"> <b>Associée à une formation</b></label></td><td><b>Associée à un camp</b> 
      <input type="checkbox" name="ete" value="oui" ';
     if ($camp == 'été') echo 'checked >Camp d\'été ';
     else echo '>Camp d\'été ';
     echo '<input type="checkbox" name="hiver" value="oui"';
     if ($camp == 'hiver') echo 'checked >Camp d\'hiver </td>';
     else echo '>Camp d\'hiver </td>
     </tr>
     </table>

      <b> Difficulté :</b> ';   
   if ($diff == 'sans')
      echo '<input type="radio" checked name="diff" value="sans"/>Sans ';
   else
      echo '<input type="radio" name="diff" value="sans"/>Sans ';
   if ($diff == 'facile')
      echo '<input type="radio" checked name="diff" value="facile"/>Facile(F) ';
   else
      echo '<input type="radio" name="diff" value="facile"/>Facile(F) ';
   if ($diff == 'moyen')
      echo '<input type="radio" checked name="diff" value="moyen"/>Moyen(M) ';
   else
      echo '<input type="radio" name="diff" value="moyen"/>Moyen(M) ';
   if ($diff == 'peu difficile')
      echo '<input type="radio" checked name="diff" value="peu difficile"/>Peu difficile(PD) ';
   else
      echo '<input type="radio" name="diff" value="peu difficile"/>Peu difficile(PD) ';
   if ($diff == 'assez difficile')
      echo '<input type="radio" checked name="diff" value="assez difficile"/>Assez difficile(AD) ';
   else
      echo '<input type="radio" name="diff" value="assez difficile"/>Assez difficile(AD) ';
   if ($diff == 'difficile')
      echo '<input type="radio" checked name="diff" value="difficile"/>Difficile(D) ';
   else
      echo '<input type="radio" name="diff" value="difficile"/>Difficile(D) ';

   echo '<br> <b> Condition physique</b>  ';
   $chekpn = $chekpb = $chekpe = $chektn = $chektb = $chekte = '';
   switch ($CP)
   {
    case 'Moyenne': $chekpm = 'checked'; break;
    case 'Normale': $chekpn = 'checked'; break;
    case 'Bonne': $chekpb = 'checked'; break;
    case 'Trés bonne': $chekpe = 'checked'; break;
   }
      switch ($CT)
   {
    case 'Moyenne': $chektm = 'checked'; break;
    case 'Normale': $chektn = 'checked'; break;
    case 'Bonne': $chektb = 'checked'; break;
    case 'Trés bonne': $chekte = 'checked'; break;
   }
  echo '<input type="radio" ' . $chekpm . ' name="CP" value="Moyenne"/>Moyenne  
        <input type="radio" ' . $chekpn . ' name="CP" value="Normale"/>Normale 
        <input type="radio" ' . $chekpb . ' name="CP" value="Bonne"/>Bonne 
        <input type="radio" ' . $chekpe . ' name="CP" value="Très bonne"/>Très bonne 
        <a href="https://www.cafmeythet.org/wp/2022/12/31/condition-physique-et-technique/" target="_blank">Plus d\'info</a>
        <br><b> Compétence technique </b> 
        <input type="radio" ' . $chektm . ' name="CT" value="Moyenne"/>Moyenne 
        <input type="radio" ' . $chektn . ' name="CT" value="Normale"/>Normale 
        <input type="radio" ' . $chektb . ' name="CT" value="Bonne"/>Bonne 
        <input type="radio" ' . $chekte . ' name="CT" value="Très bonne"/>Très bonne
        <table height=1 style="background-color:#ebf9b0;">
        <td><b>Cotation et exposition</b> (telle que présentée en réunion et à l\'AG)</td><td><input type="text" name="cotation" value="' . $cotation . '"></td>
        </table>
        <b>Description, altitude, kms, lieu de départ, rendez-vous, recommandation ...</b>
  
   <TEXTAREA  name="detail" style="color:black; background-color:white; border-color:blue;" rows="3" cols="90" >' . sup_br(sup_anti_slash($detail)) . '</TEXTAREA>
   Nombre max de participants : <input type="number" min="0" max="99" name="maxp" value="' . $maxp . '" TITLE="Affichage COMPLET automatique si le nombre de participants est atteint"><br>';
   
   if ($corbeille == false && (stristr($c_activite, 'Escalade') || stristr($c_activite, 'Club')))
   { 
      $date_max = date('Y-m-d', strtotime($date_last . " + 1 year"));
      echo '<b>Récurrence</b> - répétée chaque semaine jusqu\'au <input type="date" name="date_repet" value="' . $date_repet . '" max="' . $date_max . '" /> (limitée au ' . getJourDate($date_last) . ')<br>';
   }
   if ($IDU > 0)
   echo '<br><font color="grey">IDU : ' . $IDU . '</font><br>';
   // double form pour gérer le mode modal
    

   if ($corbeille == false)
   {
     if ($IDU == 0)
     {
          echo '
            <input type="submit" name="commande" value="AJOUTER CETTE ACTIVITE"> 
            </form>';
     }
     else 
     {
        echo '      
            <input type="hidden" name="IDU" value="' . $IDU . '">
            <input type="submit" name="commande" value="REMPLACER CETTE ACTIVITE"> 
            <input type="submit" name="commande" value="SUPPRIMER CETTE ACTIVITE"> 
            </form>';
     }
  }
  else
  {
    echo '<input type="submit" name="commande" value="RESTAURER CETTE ACTIVITE"> 
          <input type="submit" name="commande" value="SUPPRIMER CETTE ACTIVITE DE LA CORBEILLE"> 


         <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
         <input type="hidden" name="auth" value="' . $auth . '">
         <input type="hidden" name="IDU" value="' . $IDU . '"></form>';
  }
   echo '      
   <form method="post">';
   retour_menu();
   echo '<input type="hidden" name="auth" value="' . $auth . '"/>
   <input type="hidden" name="file" value="' . $file . '"/>
   <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
   <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
   <input type="hidden" name="factivite" value="' . $factivite . '"/>
   <input type="hidden" name="cx" value="' . $cx . '"/>
   <input type="hidden" name="dir" value="' . $dir . '"/>';

   
   if ($mode == 'N') //mode Normal 
   {
      
      if ($file == '')
      {

          if ($auth == $code_admin) 
              echo '<br>
              <input type="submit" name="commande" value="LISTE DES ACTIVITES ANCIENNES" Title="Admin - affiche les sorties terminées" style="background:green !important;"> 
              <input type="submit" name="commande" value="ANNEES ANTERIEURES" Title="Admin - affiche les sorties terminées des années passées" style="background:green !important;">
              <input type="submit" name="commande" value="AJOUTER CETTE ACTIVITE AVEC URGENCE" Title="Admin - crée une sortie avec le type U visible immédiatement" style="background:green !important;"> 
              <input type="submit" name="commande" value="CONSULTATION CORBEILLE" Title="Admin - liste des sorties effacées" style="background:green !important;"> 
              <input type="submit" name="commande" value="AUTORISATION" Title="Admin - pour paramétrer" style="background:green !important;"> 
              <input type="submit" name="commande" value="CONTROLE DOUBLON" Title="Admin - affiche les doubles sorties d\'un encadrant d\'un même jour" style="background:green !important;"> 
              <input type="submit" name="commande" value="RAPPEL CR" Title="Admin - Pour envoyer un mail aux encadrants qui n\'ont pas fait de CR" style="background:green !important;"> 
              <input type="submit" name="commande" value="OLDCR" Title="Admin - Contrôle des CR,CSV et KMS en double dans OLDCR et CR" style="background:green !important;"> ';
              
 
      }
      else
      {

          if ($auth == $code_admin)
            echo '<input type="submit" name="commande" value="REMPLACER CETTE ACTIVITE AVEC URGENCE">';
          retour_menu();;
      }
          
  }
  else if ($mode == 'H') // mode Hight level -> gestion de la corbeille
  {
    echo '<input type="submit" name="commande" value="RESTAURER CETTE ACTIVITE">
          <input type="submit" name="commande" value="SUPPRIMER UNE ENTREE INCORRECTE">';
          retour_menu(); 
  }

}

function affich_sortie_long ($mode, $type, $file, $dir, $date, $date_sej, $cadre, $activite, $titre, $detail )
{
   global $auth, $fcadre, $factivite, $date_last, $diff, $code_admin,$cx;
   $date_min = date('Y-m-d'); 
   $date_max = date('Y-m-d', strtotime($date_min . '+ 1 year'));
   $titre = sup_anti_slash ($titre);
   echo '<h1>AJOUT D\'UNE ACTIVITE A LONG TERME</h1>
   <p class="oblique"><font color="blue">Il est possible ici de programmer un séjour ou un WE dont la date de fin peut dépasser la date de fin du trimestre (' . getDateFr($date_last) . '). La date de fin de séjour ne peut dépasser la date actuelle + 1 an (' . getDateFr($date_max) . ')</font></p>';  

   if ($diff == '') $diff='sans';
   echo '<form method="post" align="left">
        <b>Date de l\'activité</b> : <input type="date" name="date_sortie" value="' . $date . '" min="' . $date_min . '" max="' . $date_max . '"><br>
        <b>Durée: </b>';

   if ($type == 'WE')
      echo '<input type="radio" checked name="type" value="WE"/> WE ';
   else
      echo '<input type="radio" name="type" value="WE"/> WE ';
   if ($type == 'SEJOUR')
      echo '<input type="radio" checked name="type" value="SEJOUR"/> Séjour ';
   else
      echo '<input type="radio" name="type" value="SEJOUR"/> Séjour ';

    echo ' Date fin séjour :  <input type="date"  name="date_sejour" value="' . $date_sej . '" max="' . $date_max . '"/> 
   <br>
   <b>Activité: </b>';
   if ($auth == $code_admin)
   {
       if ($activite == 'Test')
        echo '<input type="radio" checked name="activite" value="Test"/>Test ';
       else
        echo '<input type="radio" name="activite" value="Test"/>Test ';  
   }
   
   if ($activite == 'Cascade de glace')
      echo '<input type="radio" checked name="activite" value="Cascade de glace"/>Cascade de glace ';
   else
      echo '<input type="radio" name="activite" value="Cascade de glace"/>Cascade de glace ';
   if ($activite == 'Escalade')
      echo '<input type="radio" checked name="activite" value="Escalade"/>Escalade ';
   else
      echo '<input type="radio" name="activite" value="Escalade"/>Escalade ';
   if ($activite == 'Escalade en falaise')
      echo '<input type="radio" checked name="activite" value="Escalade en falaise"/>Escalade en falaise ';
   else
      echo '<input type="radio" name="activite" value="Escalade en falaise"/>Escalade en falaise ';    
   if ($activite == 'Kayak')
      echo '<input type="radio" checked name="activite" value="Kayak"/>Kayak ';
   else
      echo '<input type="radio" name="activite" value="Kayak"/>Kayak ';
   if ($activite == 'Marche nordique')
      echo '<input type="radio" checked name="activite" value="Marche nordique" />Marche nordique ';
  else
      echo '<input type="radio" name="activite" value="Marche nordique" />Marche nordique ';
   if ($activite == 'Ski alpin')
       echo '<input type="radio" checked name="activite" value="Ski alpin"/>Ski alpin ';
   else
      echo '<input type="radio" name="activite" value="Ski alpin"/>Ski alpin ';    
   if ($activite == 'Ski de fond')
      echo '<input type="radio" checked name="activite" value="Ski de fond"/>Ski de fond ';
   else
      echo '<input type="radio" name="activite" value="Ski de fond"/>Ski de fond ';
   if ($activite == 'Ski de randonnée')
      echo '<input type="radio" checked name="activite" value="Ski de randonnée"/>Ski de randonnée ';
   else
      echo '<input type="radio" name="activite" value="Ski de randonnée"/>Ski de randonnée ';
   if ($activite == 'Ski de randonnée nordique')
      echo '<input type="radio" checked name="activite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   else
      echo '<input type="radio" name="activite" value="Ski de randonnée nordique"/>Ski de randonnée nordique ';
   
   if ($activite == 'Trail')
      echo '<input type="radio" checked name="activite" value="Trail">Trail ';
   else
      echo '<input type="radio" name="activite" value="Trail">Trail ';
      
   if ($activite == 'Randonnée alpine')
      echo '<input type="radio" checked name="activite" value="Randonnée alpine" />Randonnée alpine ';
   else
      echo '<input type="radio" name="activite" value="Randonnée alpine" />Randonnée alpine ';
   if ($activite == 'Randonnée pédestre')
      echo '<input type="radio" checked name="activite" value="Randonnée pédestre" />Randonnée pédestre ';
   else
      echo '<input type="radio" name="activite" value="Randonnée pédestre" />Randonnée pédestre ';
   if ($activite == 'Raquettes')
      echo '<input type="radio" checked name="activite" value="Raquettes"/>Raquettes ';
   else
      echo '<input type="radio" name="activite" value="Raquettes"/>Raquettes ';
  
   if ($activite == 'Via ferrata')
      echo '<input type="radio" checked name="activite" value="Via ferrata"/>Via ferrata ';
   else
      echo '<input type="radio" name="activite" value="Via ferrata"/>Via ferrata ';
   if ($activite == 'VTT')
          echo '<input type="radio" checked name="activite" value="VTT"/>VTT ';
   else
          echo '<input type="radio" name="activite" value="VTT"/>VTT ';
   
   echo '<table><tr><td><b>Encadrant:</b></td><td><input type="text" name="cadre" placeholder="Prénom Nom"></td></tr></table>
   <input type="hidden" name="auth" value="' . $auth . '"/>
   <input type="hidden" name="file" value="' . $file . '"/>
   <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
   <input type="hidden" name="factivite" value="' . $factivite . '"/>
   <input type="hidden" name="cx" value="' . $cx . '"/>
   <b> Activité à insérer</b> <font color="grey">(pour un séjour ou un WE le titre est le nom de l\'objectif)</font>
      <table><tr><td><b>Titre :</b></td><td><input type="text" name="titre" size="65"  ></td></tr></table>
      <b>Difficulté :</b> ';
   if ($diff == 'sans')
      echo '<input type="radio" checked name="diff" value="sans"/>Sans ';
   else
      echo '<input type="radio" name="diff" value="sans"/>Sans ';
   if ($diff == 'facile')
      echo '<input type="radio" checked name="diff" value="facile"/>Facile(F) ';
   else
      echo '<input type="radio" name="diff" value="facile"/>Facile(F) ';
   if ($diff == 'moyen')
      echo '<input type="radio" checked name="diff" value="moyen"/>Moyen(M) ';
   else
      echo '<input type="radio" name="diff" value="moyen"/>Moyen(M) ';
   if ($diff == 'peu difficile')
      echo '<input type="radio" checked name="diff" value="peu difficile"/>Peu difficile(PD) ';
   else
      echo '<input type="radio" name="diff" value="peu difficile"/>Peu difficile(PD) ';
   if ($diff == 'assez difficile')
      echo '<input type="radio" checked name="diff" value="assez difficile"/>Assez difficile(AD) ';
   else
      echo '<input type="radio" name="diff" value="assez difficile"/>Assez difficile(AD) ';
   if ($diff == 'difficile')
      echo '<input type="radio" checked name="diff" value="difficile"/>Difficile(D) ';
   else
      echo '<input type="radio" name="diff" value="difficile"/>Difficile(D) ';
    echo '<br>Description, altitude, dénivelé, kms, lieu de départ, recommandation ...
  
   <TEXTAREA  name="detail" style="color:black; background-color:white; border-color:blue;" rows="5" cols="90" >' . sup_anti_slash($detail) . '</TEXTAREA><br>
   <input type="hidden" name="dir" value="' . $dir . '"/>
   <input type="submit" name="commande" value="AJOUTER CETTE ACTIVITE">
   </form>';
   echo '<form method="post">';
   retour_menu();
   echo '<input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="file" value="' . $file . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="cx" value="' . $cx . '">
        </form>';
}


      
function enreg_sortie ($type, $date_deb, $date_fin, $date_cre, $activite, $cadre, 
                       $coencadrant, $titre, $diff, $detail,$denivele, 
                       $formation, $ident, $IDU, $CP, $CT, $maxp, 
                       $cotation='', $kms=0, $camp='')
{
  global $cadre_p, $date_sejour, $date_repet, $date_last, $auth, $code_auth, $code_admin, $fcadre, $factivite, $status_auth;


  add_log ('enreg_sortie_IN - ' . $date_deb . ' - ' . $cadre);
  add_log ('enreg_sortie_IN - ' . $date_deb . ' - maxp : ' . $maxp);
  if ($ident == '') // nouvelle activité
    $ident = get_new_ident ();
  

 
  if ($kms == '') $kms=0;
 //echo 'Kms = ' . $kms . '<br>';
  enregistrement_sortie ($IDU, $ident, $type, $date_deb, $date_fin, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $CP, $CT, $detail, $denivele, $formation, $maxp, $cotation, $kms, $camp);
  
    //$detail = sup_anti_slash ($detail);

    enreg_base ($IDU, $date_deb, sup_anti_slash($cadre), sup_anti_slash($titre), $activite, $diff, $ident);   
    add_log ('Enregistrement en BD - ' . $auth . '-' . $cadre . ' - '. $activite . ' - ' . $date_deb . ' Type = ' . $type);
 
    //echo 'Enregistrement de la sortie ok<br>';
    affich_detail_bloc ($IDU);

    if ($status_auth == 'open')
    {
      echo '<p class="oblique"><font color="blue">Pendant la durée de la collecte, vous pouvez modifier ou supprimer la sortie que vous venez de créer en utilisant le lien de couleur <b>"Enregistrement du ..."</b>.
          <br>Cette sortie ne sera pas visible sur le calendrier jusqu\'à la fin de la collecte à l\'exception des WE, séjour, sortie à long terme et des sorties programmées avant la date de début de collecte.</font></p></div>';
    }


   if ($type != 'J') //pas de mail pour la collecte
       ToSendMailRA ($IDU, sup_anti_slash($cadre), $activite, $content, "Création ou modification d'une activité");



    if ($status_auth == 'close')
    {
      echo '<!-- The Modal -->
        <div id="annonce" class="modal1">

        <!-- Modal content -->
        <div class="modal1-content">
          <h1>ANNONCE POUR LE CALENDRIER</h1>
          Pour visualiser cette nouvelle activité sur le calendrier, n\'oublier pas d\'utiliser le bouton <b>CHERCHER/RAFRAICHIR.</b><br>
          Cliquer ci-dessous sur FERMER pour continuer !</b>
          <a href="#" class="modal1_close" Title="Cliquez ici pour fermer cette annonce">FERMER</a>
       </div><!--content--></div><!--annonce-->';
    }




}



function rep_br_cr ($m)
{
   while ($p1 = strpos ($m, '<br>'))
   {
      $m = substr ($m, 0, $p1) . "\t\n" . substr ($m,  $p1 + 4, strlen($m) - $p1 - 4);
   }
   return $m;
}

function sup_br ($m)
{
   while ($p1 = strpos ($m, '<br>'))
   {
      $m = substr ($m, 0, $p1) . substr ($m,  $p1 + 4, strlen($m) - $p1 - 4);
   }
   return $m;
}



function SendMailAbonnement ($IDU, $email)
{
  $note = extract_activ_idu($IDU);

  $sujet   = 'Abonnement aux activités ' . $note->activite;

  $buffer = '<font color="blue">' . $note->cadre . ' propose le ' . getJourDate($note->date_deb) . ' une nouvelle sortie  <b>' . $note->activite . '</b> qui a pour titre "' . sup_anti_slash($note->titre) . '"<br>';
  if ($note->type == 'S')
    $buffer .= 'Cette activité est un séjour du ' . getJourDate($note->date_deb) . ' au ' . getJourDate($note->date_fin);
  else if ($note->type == 'W')
    $buffer .= 'Cette activité est un WE du ' . getJourDate($note->date_deb) . ' au ' . getJourDate($note->date_fin);
  else
    $buffer .= 'Cette activité est une sortie à la journée<br>';

  $buffer .= editer_link_mail($note->IDU);

  $buffer .= '<b>Le service d\'abonnement aux activités</b><br><br>PS:ne pas répondre à ce message automatique.</font>';

  //affichage de la photo du cadre dans le mail -- calendrier v2.82
  $urlphoto = get_url_photo ($note->cadre);
  $buffer = $urlphoto . $buffer;

  $crm = sendmail ($email, $sujet, $buffer);
}


function SendMailNotificationTest ($expediteur, $destinataire, $objet, $message )
{
  $sujet = $objet . '(' . date('d/m H:i:s') . ')';
    $headers = array(
        'From' => $expediteur,
        'Content-Type' => 'text/html; charset=UTF-8',
        'Content-Transfer-Encoding' => '8bit'
         );

    //$note = extract_activ_idu ($IDU);
    $cadre = 'Jean Pierre Aubertin'; 
    $activ = 'Randonnée pédestre';
    $titre = 'La randonnée pédestre de test';

  
    $sujet   = 'Inscription à l\'activité de test du ' . getJourDate(Date('Y-m-d'));
    $buffer  = '<font color="blue">Ce message de test imite un message de notification d\'inscription envoyé vers les encadrants (avec photo du président et lien vers une activité passée (Pointe Andey Rocher Leschaux).<br>Le Webmaster s\'est préinscrit.<br><b>' . $titre . ' du ' . getJourDate(Date('Y-m-d')) . '</b></font>';

  
    $buffer .= editer_link_mail(3747);

  $buffer .= '<br><b>Le calendrier des activités</b><br>PS: ne pas répondre à ce message automatique';

  //ajout de la photo du cadre v2.82
  $url_photo = get_url_photo($cadre);
  $buffer = $url_photo . $buffer;
    

  $crm = sendmail ($destinataire, $sujet, $buffer);


  
  if ($crm == false)
  {
    echo 'Envoi email mais sans succès vers ' . $destinataire . '<br>';
    add_log ('SendMailInscription du Webmaster ' . $destinataire . ' sans succès');
  }
  else
  {
     echo 'Envoi notification email avec succès vers ' . $destinataire . '<br>';
     add_log ('SendMailInscription du Webmaster vers ' . $destinataire  . ' avec succès');
  }

    return $crm;
}


function SendMailTest ($expediteur, $destinataire, $objet, $message )
{
  $sujet = $objet . '(' . date('d/m H:i:s') . ')';
    $headers = array(
        'From' => $expediteur,
        'Content-Type' => 'text/html; charset=UTF-8',
        'Content-Transfer-Encoding' => '8bit'
         );

    $crm = mb_send_mail ($destinataire, $sujet, $message, $headers);
    if ($crm)
      echo 'Compte-rendu : Message correctement envoyé vers ' . $destinataire . '<br>';
    else
      echo 'Compte-rendu : Problème détecté dans l\'envoi du message vers ' . $destinataire . '<br>';

    return $crm;
}

//$headers .= 'Bcc: 
function SendMailing ($expediteur, $destinataire, $objet, $message, $list )
{
  $sujet = $objet . '(' . date('d/m H:i:s') . ')';
    $headers = array(
        'From' => $expediteur,
        'Content-Type' => 'text/html; charset=UTF-8',
        'Content-Transfer-Encoding' => '8bit',
        'Bcc' => $list
         );

    $crm = mb_send_mail ($destinataire, $sujet, $message, $headers);
    echo '<p>';
    if ($crm)
      echo 'Compte-rendu : Message correctement envoyé vers ' . $destinataire . ' principal<br>';
    else
      echo 'Compte-rendu : Problème détecté dans l\'envoi du message vers ' . $destinataire . '<br>';
    echo '</p>';
    return $crm;
}


//avertir le RA de l'activité qu'une nouvelle sortie a été produite
function ToSendMailRA ($IDU, $cadre, $activite, $detail, $motif)
{

  global $status_auth, $auth, $date_email,$date_first, $date_last, 
  $code_admin;
  
  $note = extract_activ_idu($IDU);
  $date_deb = $note->date_deb;
  $type = $note->type;

  if ($status_auth == 'open' && $type == 'S')
  {
    echo 'Sans notification pendant  la collecte';
    return true;
  }
  else
  {
    $now = time();
    $stamp_email = strtotime($date_email);

    // fichier csv mailto.csv remplacé par la fonction getListDestRA
    $destinataire = getListDestRA ($activite);


    //if (($type == 'S' || $type == 'W') || ($now > $stamp_email && $auth != $code_admin && $destinataire != ''))
    {

      $sujet   = $motif;

      $buffer  = '<font color="blue"><b>Cadre : </b>' . $cadre . ' - <b>Activité : </b>' . $activite . '<br><b>' . sup_anti_slash($note->titre) . ' du ' . getJourDate($note->date_deb) . '</b><br>' .
      rep_cr_br(sup_anti_slash($note->detail)) . '</font><br>
      <font color="red">CETTE SORTIE VIENT D\'ETRE CREEE ET CE MESSAGE EST POUR LE RA DE L\'ACTIVITE</font></b><br>' . editer_link_mail($IDU) . '<br><b>Le bloc-notes des activités</b><br>PS:ne pas répondre à ce message automatique.';

      //echo $destinataire . '<br>'
      if (TEST == 1)
      {
        echo '<font color="red">En test ' . $destinataire . ' remplacé par mic.brusa@gmail.com</font><br>';
          $destinataire = 'mic.brusa@gmail.com';
      }
      $crm = sendmail ($destinataire, $sujet, $buffer);
        
      if ($crm == false)
        Echo 'Envoi notification ko vers RA: ' . $destinataire . '<br>';
      else
         Echo 'Envoi notification ok vers RA: ' . $destinataire . '<br>';
    }
  }
}

function get_url_photo ($cadre)
{
  global $DIRCAF;
  $imgcadre = getImgCadre ($cadre);
  //echo $imgcadre.'<br>';
  return '<IMG src="' . get_site_url() . '/' . $DIRCAF . '/trombi-images/tmb/' . $imgcadre . '" width="40px" align="right">';
}

// rep_cr_br : remplace tous les \n par des <br> html
function rep_cr_br ($m)
{
   while ($p1 = strpos ($m, "\n"))
   {
      $m = substr ($m, 0, $p1) . "<br>" . substr ($m,  $p1 + 1, strlen($m) - $p1 - 1);
   }
   return $m;
}



// Cette fonction indique si le cadre a demandé la préinscription des participants
function getListPre ($dir, $dircr, $file)
{

  
  $fname = $dircr . '/' . $file . '.csv';
  if (file_exists($fname))
    return true;
  else
    return false;
}



// Cette fonction indique si le cadre a demandé l'annulation de la sortie'



function getActiveDay ($frontiere, $day, $date_day)
{
  global $index, $selection, $DIR_OLDNOTES, $DIR_NOTES;
  $star='';
  //echo 'DAY = ' . $date_day . '<br>';


  $scan = extract_activ_day ($date_day);
  //return $star;
  //echo sizeof($scan);
  $gsel = explode (",", $selection);
  foreach ($scan as $note)
  //for ($i=$index; $i<sizeof($scan); $i++)
  {
    $found = false;
    if (true) //substr($scan[$i],0,8) == $day)
    {

      $found = true;
 
      $c= $note->cadre;
      $activ= $note->activite;
      $titre = $note->titre;
      $type = $note->type;

      $camp = false;
      $sej  = false;

      //echo 'Camp d\'été dans la sélection<br>';
      if (stristr($titre, 'camp d') || $note->camp != '')
      {
        if (stristr($selection, 'camp d'))
          $camp = true;
      }

      if ($note->type == 'S' || $note->type == 'W')
      {
        //echo 'Séjour ou WE ';
        if (strstr ($selection, 'Séjour'))
          $sej = true;
        //echo 'Séjour au ' . $note->date_deb . '-' . $activ . '-' . $selact;
      }
      
      foreach ($gsel as $selact)
      {
        if (strlen ($selact) > 1)
        {
          //if ($selact == $activ) echo $selact . '-' . $activ . "<br>";
          if ($note->annulation != 1 && ($selact == $activ || $camp || $sej))
          {
              /*echo '1'.$selact . '-2' . $activ;
              if ($sej) echo ' - 3 séjour ou we';
              if ($camp) echo ' - 4camp';
              echo '<br>';*/
      
              $img  = getIcone($activ);
              $star .= '<img src="' . $img . '" width="32">';
          }
        }
      }  

      /*
      if (strstr($selection, substr($activ, 0, strlen($activ)-1)) && $note->annulation != 1 && substr($note->report,0,1) != '2' && substr($note->avance,0,1) != '2' && $camp && $sej)
      {
          $img  = getIcone($activ);
          $star .= '<img src="' . $img . '" width="32">';
      }
      */
    }
    else if ($found)
    {
      $index = $i-1;
      break;
    }
  }
  return $star;
}



function  getMonthPrec ($day)
{
  global $normd;

  $month = date('Y-m-d', strtotime($normd . ' -7 days'));
  if ($day < 10) $dates = substr($month,0,4) . substr($month, 5,2) . '0' . $day;
  else $dates = substr($month,0,4) . substr($month, 5,2) . $day;


  return $dates;
}
function  getMonthCur ($day)
{
  global $normd;
  $month = $normd;

  if ($day < 10) $dates = substr($month,0,4) . substr($month, 5,2) . '0' . $day;
  else $dates = substr($month,0,4) . substr($month, 5,2) . $day;

  return $dates;
}

function  getMonthNext ($day)
{
  global $normd,$index;

  $month = date('Y-m-d', strtotime($normd . ' +31 days'));
  if ($day < 10) $dates = substr($month,0,4) . substr($month, 5,2) . '0' . $day;
  else $dates = substr($month,0,4) . substr($month, 5,2) . $day;

  return $dates;
}

function analyse_doublon ()
{
   $N=0;
   $sortie =array();
   //Contrôle des doublons

   $scan = extract_activ_avenir ('2022-01-01');
   $datej='';
   $u=1;
   echo 'Nombre d\'activités à traiter = ' . sizeof($scan) . "<br>";
   echo '<table border="1"><tr><th>Date</th><th>Encadrant</th><th>Activité</th><th>Titre</th></tr>';
   foreach($scan as $note)
   {
 
      if ($datej != $note->date_deb)
      {
         $IDU   = $note->IDU;            
         $datej = $note->date_deb;             
         $cadre = $note->cadre;
         $act   = $note->activite;
         $titre = $note->titre;
         //if ($datej == '2023-01-03') echo '"' . $cadre . '"<br>';
         $K = sizeof($sortie);

         if ($K > 0)
         {
            //echo $u++ . ' Date ' . $sortie[0]['date'] . ' - ';
            //echo $K . ' activités' ;
            $N += $K; //echo ' : ' . $N . "\n";
         }
         if ($K > 1)
         {

            for ($l=0; $l<$K;$l++)
            {
               for ($j=$l+1; $j<$K; $j++)
               {
                  //echo $K . ' Compare ' . $l . ' à '.  $j . "\n";
                  if ($sortie[$l]['cadre'] == $sortie[$j]['cadre'] && $sortie[$l]['act'] != 'Formation' && $sortie[$j]['act'] != 'Formation')
                   echo '
                   <tr><td>' . getJourDate($sortie[$l]['date']) . '</td><td>' . $sortie[$l]['cadre'] . '</td><td>' . $sortie[$l]['act'] . '</td><td>' . $sortie[$l]['titre'] . '</td></tr>
                   <tr><td>' . getJourDate($sortie[$j]['date']) . '</td><td>' . $sortie[$j]['cadre'] . '</td><td>' . $sortie[$j]['act'] . '</td><td>' . $sortie[$j]['titre'] . '</td></tr>';
               }
            }
         }
         array_splice ($sortie, 0);
         //echo "---------------------------------------------------<br>Nouvelle date = " . $datej . ' - Cadre : ' . $cadre . ' - Activité : ' . $act . "<br>";
         $sortie[]  = array('IDU' => $IDU, 'date' => $datej , 'cadre' => "$cadre", 'act' => $act, 'titre' => "$titre");

      }
      else
      {
        //echo $l . ' - ' . $k . '<br>';
         //sorties du même jour
         //$note_doub = extract_activ_idu ($sortie[j]['IDU']);
     
         $IDU1   = $note->IDU;
         $cadre1 = $note->cadre;

         $act1   = $note->activite;
         $titre1 = $note->titre;
        //if ($datej == '2023-01-03') echo '"' . $cadre1 . '"<br>';
         //echo 'Même date = ' . $datej . ' - Cadre : ' . $cadre1 . ' - Activité : ' . $act1 . "\n";
         $sortie[] = array('IDU'=>$IDU1, 'date' => $datej , 'cadre' => "$cadre1", 'act' => $act1,'titre' => "$titre1" );
//print_r ($sortie);
      }
   }
   echo '</table>';
   // fin de lecture des sorties
   //echo "Fin de lecture des activités\n";
   $K = sizeof($sortie);
}

function getMois()
{
  global $status_auth, $date_first;
  $Mois = array('un','Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout','Septembre','Octobre', 'Novembre', 'Décembre' );
  if ($status_auth != 'open')
   return $Mois[intval(date('m'))];
  else //collecte
  {
     return $Mois[intval(substr($date_first, 5,2))];
  }
}

function add_log ($message)
{
  global $IDU, $cx, $cadre_p;

  if ($IDU == '') $IDU=0;
  add_log_bd_bloc (date('Y-m-d H:i:s'), $cx, $IDU, $cadre_p . ' - ' . sup_anti_slash($message));
}

function affich_retour_blocnote ($IDU)
{
  global $auth, $fcadre, $factivite, $cx, $cadre_p;
  echo '<form method="post">
        <input type="hidden" name="auth" value="' . $auth . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '"> 
        <input type="hidden" name="cx" value="' . $cx . '">         
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">';
        retour_menu();
        echo '</form>';
}

function rappel_sans_cr ()
{
  // cette fonction analyse les sorties terminées depuis plus de sept jours et en cas d'absence de compte-rendu envoi un mail à l'encaadrant
  
  $date_moins7j = date('Y-m-d', strtotime("-7 day"));
  
  $scan = extract_activ_retroactive ($date_moins7j);
  foreach ($scan as $note)
  {

    if ($note->annulation == 1 || substr($note->report, 0, 1) == 2 || substr($note->avance, 0, 1) == 2 || $note->cr == 1) continue;
    // en théorie ne reste plus que les sorties terminées et sans compte-rendu
    

      $cadre = $note->cadre;
      $activ = $note->activite;
      $titre = sup_anti_slash($titre);
      $diff  = $note->diff;
      $detail .= sup_anti_slash($note->detail);
      $email_cadre = get_email_cadre ($cadre);
      if (stristr($activ, 'Club') || $email_cadre == '') continue;
      if ($note->date_deb < '2022-01-01') continue;
      echo 'Date : ' . getJourDate($note->date_deb) . '<br>';
      // recherche adresse mail de l'encadrant
      
      //**********************


      $sujet   = "Rappel sortie sans compte-rendu";
      $buffer  = '<font color="blue">Bonjour,<br>Votre sortie du ' . getJourDate($note) . ' qui est antérieure à une semaine n\'a pas encore fait l\'objet d\'un compte-rendu sur les sorties terminées du calendrier (mode rétroactif).<br><br>
      <b>' . getJourDate($note) . ' - ' . $cadre . ' - ' . $activ . ' - ' . $titre . '</b><br><br>
      Dans le cas ou cette sortie n\'a pu être faite, veuillez me prévenir afin qu\'elle soit annulée ou supprimée par mes soins (mailto:michel.brusa@cafmeythet.org).<br><br>Cet email sera renvoyé de temps en temps tant que le compte-rendu ne sera pas fait ou la sortie annulée.<br>Pour des besoins de statistique, le bureau du CAF a besoin de vos comptes-rendus.
      <br><br>Merci<br>Mail généré automatiquement (ne pas répondre).
      </font>';

    $destinataire = $email_cadre;
   
    $crm = sendmail ($destinataire, $sujet, $buffer);
      
    if ($crm == false)
    {
      add_log ('RAPPEL CR  KO VERS ' . $email_cadre . ' - ' . getJourDate($note->date_deb) . ' - ' . $cadre . ' - ' . $activ . ' - ' . $titre);
      echo 'Envoi notification mail ko vers ' . $email_cadre . '<br>';
    }
    else
    {
      add_log ('RAPPEL CR  OK VERS ' . $email_cadre . ' - ' . getJourDate($note->date_deb) . ' - ' . $cadre . ' - ' . $activ . ' - ' . $titre);
      echo 'Envoi notification mail ok vers ' . $email_cadre . '<br>';
    }
     
    }   // fin si sans CR et > 7 jours

}



function get_email_cadre ($cadre)
{
  global $DIR;
        //recherche tel et mail du cadre
  $csv = $DIR . '/' . 'trombi.csv';
  $fic  = fopen ($csv, 'r');
//recherche tel et mail du cadre
  $findcsv = false;
  for ($ligne = fgetcsv($fic, 1024); !feof($fic); $ligne = fgetcsv($fic, 1024)) 
  {
    $prenom=$ligne[0];
    $nom=remove_accents($ligne[1]);
    //echo 'NOM : ' . $nom . ' Cadre : ' . $cadre . '<br>';
    $tel=$ligne[2];
    $adresse=$ligne[3];
    $mailperso=$ligne[4];

    if (stristr ($cadre, $nom))
    {
      $findcsv = true;
      break;
    }
  }
  fclose ($fic);
  if ($findcsv)
  {
    if ($mailperso != '')
      $email_cadre = $mailperso;
    else
      $email_cadre = $prenom . '.' . $nom . '@cafmeythet.org';
  
    return strtolower($email_cadre);
  }
  else
    return false;
}


// Affichage d'une sortie sur le bloc-notes
function affich_detail_bloc ($IDU)
{
  global $commande, $cadre, $cadre_p, $auth, $code_auth, $code_admin, $fcadre, $factivite,$cx,$idref,$status_auth,$DIRCAF;

   $note = extract_activ_idu ($IDU);
   echo '<div class="note"><IMG src="' . getIcone($note->activite) . '"  width="100px" align="right">';
   $img_cadre = getImgCadre ($note->cadre);
   if ($img_cadre) 
    echo '<IMG src="' . get_site_url() . '/' . $DIRCAF . '/trombi-images/tmb/' . $img_cadre . '" width="76px" align="right">';
  
  
  //if ($auth == $code_admin || ($status_auth == 'open' && $auth == $code_auth))
  {
    $idref++;
    $Date = ' <form id="' . $idref . '" method="post">
    <input type="hidden" name="auth" value="' . $auth . '"/>
    <A HREF="#" onClick="Submit(\''. $idref . '\');" TITLE="Cliquez ici pour modifier ou supprimer cette activité" class="button"> ';

   switch ($note->type)
   {
    case 'U':
    case 'J': $Date .= '<b>Activité du ' . getJourDate($note->date_deb) . '</b></A>'; break;
    case 'W': $Date .= '<b><font color="green">Activité du WE du '   . getJourDate($note->date_deb) . ' au ' . getJourDate($note->date_fin) . '</font></b></A>'; break;
    case 'S': $Date .= '<b><font color="red">Activité du SEJOUR du ' . getJourDate($note->date_deb) . ' au ' . getJourDate($note->date_fin) . '</font></b></A>'; break;
    default:  $Date .= '<b>Activité du ' . getJourDate($note->date_deb) . '</b></A>';
   }

    $Date .= '<br>

    <input type="hidden" name="commande" value="MODIFICATION ACTIVITE"/>
    <input type="hidden" name="IDU" value="' . $note->IDU . '"/>
    <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
    <input type="hidden" name="cadre" value="' . $cadre . '"/>
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
    <input type="hidden" name="factivite" value="' . $factivite . '"/>
    <input type="hidden" name="cx" value="' . $cx . '"/>
    </form>';
  }
 
  echo $Date;
 
  $IDU = $note->IDU;
  $cadre = $note->cadre;
  $coencadrant = $note->coencadrant;
  $activ = $note->activite;
  $titre = $note->titre;
  $diff =  $note->diff;
  $CP   =  $note->CP;
  $CT   =  $note->CT;
  $cotation = $note->cotation;
  $kms      = $note->kms;
  $detail   = $note->detail;
  $denivele = $note->denivele;
  $formation = $note->formation;
  $maxp      = $note->maxp;
  $camp      = $note->camp;

 
  //recherche tel et mail du cadre
  $mobile = recherche_mobile_cadre ($cadre);
  $mail   = recherche_mail_cadre($cadre);
  
  echo '<b>Type d\'activite :</b> ' . $activ . '<br>
        <b>Encadrant : </b>' . $cadre;
 
  echo ' Tél : ' . $mobile;
  
     echo ' Mail : ' . $mail;
  if ($note->coencadrant) echo '<br><b>Coencadrant :</b> ' . $note->coencadrant . '<br>';
  //if ($note->activite != 'Club')
  {
    echo '<br><b>Difficulté</b> : ' . $diff;
    if ($CP != '') echo ' <b>Condition physique</b> ' . $CP;
    if ($CT != '') echo ' <b>Compétence technique</b> ' . $CT;
    echo '<br>';
  }

       
  echo  '<br>Titre : <b>' . sup_anti_slash($titre) . '</b>';
  if ($cotation != '') 
    echo '<br>Cotation : <b>' . $cotation . '</b>'; 
  if ($denivele > 0) 
    echo '<br>Dénivelé approximatif : <b>' . $denivele . ' m</b>';
  if ($kms > 0)
    echo '<br>Distance approximative : <b>' . $kms . ' kms</b>';
  if ($camp == 'hiver')
    echo '<br><b>Camp d\'hiver</b>';
  if ($camp == 'été')
    echo '<br><b>Camp d\'été</b>';
  echo '<br>Détail de l\'activité : <b>' . sup_anti_slash($detail) . '</b><br>';
  if ($formation == 1) echo '<br><b><font color="blue">Activité associée à une formation</font></b>';
  if ($nbrePar > 0)     echo 'Il y a ' . $nbrePar . ' de participant(s)<br>';
  echo '<div class="interne">';
  $nbrePar = extract_nbre_partic_idu($note->IDU);

  if ($maxp > 0)
    echo 'Nombre max de participants : ' . $maxp . '<br>';
  //choses interdites
  if ($note->preinscription == 1)
    echo '<font color="red"><b>PREINCRIPTION</b> (non modifiable par le bloc-notes)</font><br>';
  if ($note->complete == 1)
    echo '<font color="red"><b>COMPLETE</b> (non modifiable par le bloc-notes)</font><br>';
  if ($note->annulation == 1)
    echo '<font color="red"><b>ANNULEE</b> (non modifiable par le bloc-notes)</font><br>';
  $nl = 0;

  echo '<br><font color="grey">Créé le ' . getJourDate($note->date_cre) . ' (' . $note->IDU . ')</font>';
  echo '</div><!-- interne -->';
  
  if ($auth == $code_admin)
  {
      if ($note->preinscription)
       echo '<font color="blue"> PRE </font> ';
  }
  
  echo '</div><!-- note -->';
}



function affich_detail_corbeille ($IDU)
{
  global $commande, $cadre, $cadre_p, $auth, $code_auth, $code_admin, $fcadre, $factivite,$cx,$idref,$status_auth, $DIRCAF;

   $note = extract_corbeille_idu ($IDU);
  
   echo '<div class="note"><IMG src="' . getIcone($note->activite) . '"  width="100px" align="right">';
   $img_cadre = getImgCadre ($note->cadre);
   if ($img_cadre) 
    echo '<IMG src="' . get_site_url() . '/' . $DIRCAF . '/trombi-images/tmb/' . $img_cadre . '" width="76px" align="right">';

  if ($auth == $code_admin || ($status_auth == 'open' && $auth == $code_auth))
  {
    $idref++;
    $Date = ' <form id="' . $idref . '" method="post">
    <input type="hidden" name="auth" value="' . $auth . '"/>
    <A HREF="#" onClick="Submit(\''. $idref . '\');" TITLE="Cliquez ici pour restaurer ou supprimer cette activité de la corbeille" class="button">';
    if ($note->type != 'S' && $note->type != 'W')
      $Date .= '<b>Activité du ' . getJourDate($note->date_deb) . '</b></A>';
    else
      $Date .= '<b>' . getJourDate ($note->date_deb) . '</b></A>';
    $Date .= '
    <input type="hidden" name="commande" value="MODIFICATION CORBEILLE"/>
    <input type="hidden" name="IDU" value="' . $note->IDU . '"/>
    <input type="hidden" name="fcadre" value="' . $fcadre . '"/>
    <input type="hidden" name="auth" value="' . $auth . '"/>
    <input type="hidden" name="cadre" value="' . $cadre . '"/>
    <input type="hidden" name="cadre_p" value="' . $cadre_p . '"/>
    <input type="hidden" name="factivite" value="' . $factivite . '"/>
    <input type="hidden" name="cx" value="' . $cx . '"/>
    </form>';
  }
  else
  {
    if ($note->type == 'S' || $note->type == 'W')
      $Date = '<b>Activité du ' . getJourDate($note->date_deb) .  ' au ' . getJourDate($note->date_fin) . '</b><br>';
  else
    $Date = '<b>' . getJourDate($note->date_deb) . '</b><br>';
  }
  
  echo $Date;
 
 

  $IDU = $note->IDU;
  $cadre = $note->cadre;
  $coencadrant = $note->coencadrant;
  $activ = $note->activite;
  $titre = $note->titre;
  $diff =  $note->diff;

 
  $csv = $DIR . '/' . 'trombi.csv';
  $fic  = fopen ($csv, 'r');
  //recherche tel et mail du cadre
  $mobile = recherche_mobile_cadre ($cadre);
  $mail   = recherche_mail_cadre($cadre);
  $img    = $note->img;

  
  
  if ($img)
    echo '<IMG src="'. $img . '"  align="right"/>';
  
  echo '<b>Type d\'activite :</b> ' . $activ . '<br>
        <b>Encadrant : </b>' . $cadre;
 
  echo ' Tél : ' . $mobile;
  
     echo ' Mail : ' . $mail;
  if ($note->coencadrant) echo '<br>Coencadrant : ' . $note->coencadrant . '<br>';
  if ($note->formation == 1) echo '<br><b>Formation</b>';

       
  echo  '<br><b>Titre : </b>' . $titre ;
  if ($note->denivele > 0) echo '<br>Dénivelé approximatif : ' . $note->denivele . ' m';
  echo '<div class="interne">';

  $nl = 0;

  echo '<br><font color="grey">Créé le ' . getJourDate($note->date_cre) . '</font>';
  echo '</div>';
  if ($auth == $code_admin)
  {
      if ($note->preinscription)
       echo '<font color="blue"> PRE </font> ';
     /*
      if (extract_nbre_partic_idu($note->IDU))
       echo '<font color="blue"> LST </font> ';
      if ($note->cr == 1)
       echo '<font color="blue"> CR </font> ';
      if (extract_cr_kms ($note->IDU))
        echo '<font color="blue"> KMS </font>';
     if ($note->annulation == 1)
        echo '<font color="red"> <b>ANNULEE</b> </font> ';
     if ($note->report != '')
        echo '<font color="red"> <b>REPORTEE</b> </font> ';
     if ($note->avance != '')
        echo '<font color="red"> <b>AVANCEE</b> </font> ';
        */
  }
  //ATTENTION : le </div> doit être fait par l'appelant
  echo '</div>';
}

function menu_principal()
{
  global $cx, $cadre_p, $cadre, $auth, $status_auth, $code_admin, $fcadre;
    $fonction = extract_fonction_cadre(wd_remove_accents($cadre_p));
    $acti     = extract_activite_cadre ($cadre_p);
    $ident    = extract_ident ($cadre_p);



    echo '<form method="post">
        <input type="hidden" name="cx" value="' . $cx . '">
        <input type="hidden" name="fcadre" value="' . $fcadre . '">
        <input type="hidden" name="cadre_p" value="' . $cadre_p . '">
        <input type="hidden" name="cadre" value="' . $cadre . '">
        <input type="hidden" name="factivite" value="' . $factivite . '">
        <input type="hidden" name="auth" value="' . $auth . '">';

    echo '<input type="submit" name="commande" value="CREATION D\'UNE ACTIVITE" TITLE="Création d\'une activité hors collecte"> 
        <input type="submit" name="commande" value="LISTE DES ACTIVITES">';

    if ($status_auth == 'open')
    {
      echo '<input type="submit" name="commande" value="CREATION D\'UNE ACTIVITE DE LA COLLECTE TRIMESTRIELLE">
        <p><input type="submit" name="commande" value="LISTE DES ACTIVITES DE LA COLLECTE">
        <input type="submit" name="commande" value="EXPORT TRIMESTRE COLLECTE"></p>';  
    }
    echo ' 
    <input type="submit" name="commande" value="STATISTIQUES" Title="Nombre de sorties, de jours/participants et les kms fiscaux pour un encadrant"> 
    <input type="submit" name="commande" value="VUE MENSUELLE" Title="Permet de voir une ou plusieurs présences d\'activité sur un calendrier et sur plusieurs mois">
    <input type="submit" name="commande" value="VERIFICATION LICENCE" Title="Permet de voir si telle personne est licencié ou non"> 
    <input type="submit" name="commande" value="CONSULTATION CORBEILLE"> 
    <input type="submit" name="commande" value="EXPORT CAMP D\'ETE"> 
    <input type="submit" name="commande" value="EXPORT CAMP D\'HIVER"> 
    <input type="submit" name="commande" value="NOMBRE ADHERENTS PAR ACTIVITE ET ANNEE" TITLE="Statistiques pour l\'escalade"> 
    <input type="submit" name="commande" value="RESPONSABLES D\'ACTIVITE" TITLE="Liste des reponsables d\'activité"> ';

    if (stristr($acti, 'Escalade') || stristr($fonction, 'Webmaster'))
    {
        echo '<input type="submit" name="commande" value="IMPORT ACTIVITES CSV">   
        <input type="submit" name="commande" value="GESTION DE L\'ESCALADE" TITLE="Gestion des inscriptions de l\'escalade"> 
        <input type="submit" name="commande" value="LISTE DES PREINSCRITS" TITLE="Liste des inscrits à l\'escalade"> ';
              
    }
    if (strstr($fonction, 'Gestion des adhérents'))
      echo '<input type="submit" name="commande" value="STATISTIQUE DES CR"> 
          <input type="submit" name="commande" value="MAJ ADHERENTS FFCAM" TITLE="Prise en compte immédiate des nouvelles licences FFCAM">'; 

    
    if (stristr($fonction, 'Webmaster'))
      echo '<input type="submit" name="commande" value="CHANGEMENT DE PROFIL ENCADRANT" TITLE="Changer le nom de l\'encadrant principal" style="background:green !important;"> ';

    if (strstr($fonction, 'RA') || stristr($fonction,'président') || stristr($fonction,'Webmaster'))
      echo '<input type="submit" name="commande" value="GESTION DES ENCADRANTS" Title="Admin - Pour ajouter un encadrant ou modifier le profil d\'un encadrant" style="background:green !important;"> ';
    
    if (stristr($fonction, 'Comité Directeur'))
    {
      echo '<input type="submit" name="commande" value="ACCES AU CLASSEUR" style="background:green !important;">'; 
    }
    
    if (stristr($fonction,'Webmaster'))
    {
     echo '
      <input type="submit" name="commande" value="AUTORISATION" Title="Admin - pour paramétrer" style="background:green !important;">
      <input type="submit" name="commande" value="CONTROLE DOUBLON" Title="Admin - affiche les doubles sorties d\'un encadrant d\'un même jour" style="background:green !important;"> 
      <input type="submit" name="commande" value="RAPPEL SANS CR" Title="Admin - Pour envoyer un mail aux encadrants qui n\'ont pas fait de CR" style="background:green !important;"> 
      <input type="submit" name="commande" value="CONSULTATION CORBEILLE" Title="Admin - affiche les sorties mises en corbeille" style="background:green !important;"> 
      <input type="submit" name="commande" value="NEIGE" TITLE="Importation ou liste des formations secours et DVA" style="background:green !important;">';
    }

        
    echo '<input type="submit" name="commande" value="PAIE ASSO CB" TITLE="Gestion des paiements Asso CB" style="background:purple !important;"> ';
    
    if (stristr($fonction,'Responsable formation') || stristr($fonction, 'neige') || stristr($fonction, 'CD'))
    {
      echo '<input type="submit" name="commande" value="NEIGE" TITLE="Importation ou liste des formations secours et DVA" style="background:green !important;">';
    }
    if (!stristr($fonction,'EPI'))
    {
      echo '<input type="submit" name="commande" value="GESTION MATERIEL ET CARTE" TITLE="Gestion du matériel du CAF" style="background:green !important;">'; 
    }
    else
    {
      echo '<input type="submit" name="commande" value="GESTION MATERIEL, CARTES, LIVRES ET EPI" TITLE="Gestion du matériel du CAF et des EPI" style="background:green !important;">';
    }
    echo '<br><input type="submit" name="commande" value="PARTAGE DE DOCUMENTS" Title="Partage de documents entre tous les encadrants" style="background:grey !important;">';

    echo '<input type="submit" name="commande" value="CONTACTER NOS ADHERENTS" Title="Permet d\'envoyer un mail aux adhérents d\'une activité" style="background:grey !important;"> 
      <input type="submit" name="commande" value="TEST MAIL" Title="Pour tester la notification par email" style="background:grey !important;">';
    if (stristr($fonction,'Secrétaire') || stristr($fonction,'Webmaster'))
      echo '<input type="submit" name="commande" value="GENERATION PASS ET IDENT" Title="Génération d\'un identifiant et d\'un mot de passe adhérent" style="background:green !important;">';  

    echo  '</form>';
    echo '<p class="oblique">Redirection vers le calendrier</p>
      <form action="https://www.cafmeythet.org/wp/';
      if (TEST == 1) echo 'test';
      echo 'calendrier/" method="POST">
  <input type="hidden" name="identifiant" value="' . $ident . '">
  <input type="hidden" name="pass" value="Zabru123456!&">
  <input type="hidden" name="commande" value="Connexion externe">
  <button type="submit" Title="Connexion au CALENDRIER en encadrant">CALENDRIER</button>
  </form>';
}

function editer_link_mail ($IDU)
{
  $purl = "pourembrouillerquiveutcomprendrecommentcamarche";
  $purl = "ehcramactnemmocerdnerpmoctueviuqrelliuorbmeruop";

  $urlcal = get_site_url();
  if (TEST == 1)
    $urlcal .= '/testcalendrier/';
  else
    $urlcal .= '/calendrier/';

  $xrf = dechex(($IDU * 16)+ 300000);

  $link = '<p class="oblique"><font color="purple">Accéder directement à cette activité sur le calendrier par un simple clic sur </font>
  <a href="' . $urlcal . '?' . $purl . '=' . $xrf . '">CALENDRIER</a></p>'; 

  return $link;  
}


function retour_menu()
{
  echo '<input type="submit" name="commande" value="RETOUR MENU" style="background:#076899 !important;">';
}