<?php
//extraction des données pour la base de données du calendrier
function extract_config_bd($table_param)
{
  global $wpdb;
  $bd_array = array("db2_user" => "empty", "db2_host" => "empty", "db2_password" => "empty", "db2_name" => "empty");

  //appel à la table cal_param situé dans la BD de WP
  $reqbd = "SELECT * FROM `" . $table_param . "` 
        WHERE Type = 'DataBase'";
        
  $confbd = $wpdb->get_results($reqbd);
  foreach ($confbd as $bd)
  {
    switch ($bd->Nom)
    {
      case 'DB2_USER': $bd_array['db2_user'] = $bd->Valeur; break;
      case 'DB2_HOST': $bd_array['db2_host'] = $bd->Valeur; break;
      case 'DB2_PASSWORD': $bd_array['db2_password'] = $bd->Valeur; break;
      case 'DB2_NAME': $bd_array['db2_name'] = $bd->Valeur; break;
    }
  }
  return $bd_array;
}

//extraction des données pour la configuration des dossiers du calendrier
function extract_config_dir ($table_param)
{
  global $wpdb;
  $dir_array = array("theme" => "empty", "dir_base" => "empty", "dir_main" => "empty", "dir_data" => "empty");

  //appel à la table cal_param situé dans la BD de WP
  $reqdir = "SELECT * FROM `" . $table_param . "` 
        WHERE Type = 'Folder'";
        
  $confdir = $wpdb->get_results($reqdir);
  foreach ($confdir as $dir)
  {
    switch ($dir->Nom)
    {
      case 'Theme': $dir_array['theme'] = $dir->Valeur; break;
      case 'dir_base': $dir_array['dir_base'] = $dir->Valeur; break;
      case 'dir_main': if (TEST==0) 
                          $dir_array['dir_main'] = $dir->Valeur; 
                          break;
      case 'dir_main_test': if (TEST==1) 
                          $dir_array['dir_main'] = $dir->Valeur; 
                          break;
      case 'dir_data': if (TEST==0) 
                          $dir_array['dir_data'] = $dir->Valeur; 
                          break;
      case 'dir_data_test': if (TEST==1) 
                          $dir_array['dir_data'] = $dir->Valeur; 
                          break;                          
    }
  }
  return $dir_array;
}

//extraction des données pour la collecte
function extract_collecte ($table_param)
{
  global $wpdb;
  $collecte = array("status" => "empty", "date_deb" => "empty", "date_fin" => "empty", "date_collecte" => "empty");

  //appel à la table cal_param situé dans la BD de WP
  $reqcol = "SELECT * FROM `" . $table_param . "` WHERE Type = 'COLLECTE'";
  $repcol = $wpdb->get_results($reqcol);
  
  foreach ($repcol as $coll)
  {
    switch ($coll->Nom)
    {
      case 'Status_collecte': $collecte['status'] = $coll->Valeur; break;
      case 'Date_deb': $collecte['date_deb'] = $coll->Valeur; break;
      case 'Date_fin':  $collecte['date_fin'] = $coll->Valeur; break;
      case 'Date_collecte':  $collecte['date_collecte'] = $coll->Valeur; break;
    }
  }
  return $collecte;
}

//extraction des données pour les webservices
function extract_user_webmaster($table_param)
{
  global $wpdb;
  $req = "SELECT Valeur FROM " . $table_param . " WHERE `Type` = 'Webservice' AND `Nom` = 'id_user'";
  $rep = $wpdb->get_results($req);
  return $rep[0]->Valeur;
}

function extract_pass_webmaster($table_param)
{
  global $wpdb;
  $req = "SELECT Valeur FROM " . $table_param . " WHERE `Type` = 'Webservice' AND `Nom` = 'pass_user'";
  $rep = $wpdb->get_results($req);
  return $rep[0]->Valeur;
}

// GetListDestRA : retourne la liste des destinataires RA de notification mail en fonction de l'activité

function getListDestRA ($activite)
{
  global $wpdb2, $table_cadre;

  $destinataire = 'RA@cafmeythet.org';
  
  //recherche RA dans les fonctions des encadrants (titre)
  //echo 'Recherche pour ' . $activite . '<br>';
  $req = "SELECT * FROM " . $table_cadre . " WHERE titre LIKE '%%RA " . $activite . "%%'";
  $rep = $wpdb2->get_results($req);
  
  if (sizeof($rep) > 0)
  {
     $destinataire .= ',' . $rep[0]->email;
  }
  
  return $destinataire;
}


function extract_fonction_cadre_licence ($licence)
{
    global $wpdb2, $table_adherent, $table_cadre;
    $req = "SELECT " . $table_cadre . ".titre FROM " . $table_adherent . "," . $table_cadre . " WHERE " . $table_adherent . ".id = " . $licence . " AND " . $table_cadre . ".ident  = " . $table_adherent . ".ident";
    $rep = $wpdb2->get_results($req);
    return $rep[0]->titre;
}

//extraction des adresses mails des participants à une activité
function extract_liste_mail_activite ($activite, $date_debut)
{
  global $wpdb2, $table_activ, $table_partic, $table_adherent;
  $req = "SELECT " . $table_activ . ".date_deb, " . $table_activ . ".IDU, " 
  . $table_partic . ".nom, " . $table_partic . ".prenom, " . $table_adherent 
  . ".email FROM `" . $table_activ . "`,`" . $table_partic . "`,`" . $table_adherent 
  . "` WHERE activite like '" . $activite . "' AND " . $table_partic . ".IDU = " 
  . $table_activ . ".IDU AND " . $table_adherent . ".prenom = " . $table_partic 
  . ".prenom AND " . $table_adherent . ".nom = " . $table_partic . ".nom ORDER BY " .
  $table_activ . ".date_deb";
  //echo $req . '<br>';
  $rep = $wpdb2->get_results($req);
  return $rep;
}

//indique si vrai que des participants sont en liste d'attente
function verif_liste_attente ($IDU)
{
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU = " . $IDU . " AND etat LIKE 'LISTE D%%'";
  $rep = $wpdb2->get_results($req);

  if (sizeof($rep) > 0)
    return true;
  else
    return false;

}

//extraction d'une note d'activité
function extract_activ_idu ($IDU)
{
    global $wpdb2, $table_activ;
    $req = "SELECT * FROM " . $table_activ . " WHERE IDU=" . $IDU;
    $rep = $wpdb2->get_results($req);
    if (sizeof($rep) > 0)
      return $rep[0];
    else
    {
      //echo $req . '<br>';
      return false;
    }
}

function extract_corbeille_idu ($IDU)
{
    global $wpdb2, $table_corbeille;
    $req = "SELECT * FROM " . $table_corbeille . " WHERE IDU=" . $IDU;
    $rep = $wpdb2->get_results($req);
    return $rep[0];
}

function delete_corbeille_idu ($IDU)
{
    global $wpdb2, $table_corbeille;
    $req = "DELETE FROM " . $table_corbeille . " WHERE IDU=" . $IDU;
    $rep = $wpdb2->get_results($req);
}

function extract_nbre_corbeille ()
{
    global $wpdb2, $table_corbeille;
    $req  = "SELECT COUNT(*) AS count FROM " . $table_corbeille;
    $repc = $wpdb2->get_results($req);
    //echo $wpdb2->last_error;
    return $repc[0]->count;
}

function vidage_corbeille($cadre)
{
    global $wpdb2, $table_corbeille;
    $req = "DELETE FROM " . $table_corbeille . " WHERE cadre LIKE '%%" . $wpdb2->_real_escape($cadre) . "%%'";
    $rep = $wpdb2->get_results($req);
}

//nbre participants en attente ou inscrits
function getCountParticipantsAtt($IDU)
{
    global $wpdb2, $table_partic;
    $req  = "SELECT COUNT(*) AS count FROM " . $table_partic . " WHERE IDU = " . $IDU . " AND (etat LIKE 'EN ATTENTE' OR etat LIKE 'INSCRIT')";
    $rep = $wpdb2->get_results($req);
    if ($wpdb2->last_error)
      return false;
    else
      return $rep[0]->count;
}

function get_first_liste_attente ($IDU)
{
  //retourner le premier en liste d'attente
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU = " . $IDU . " AND etat LIKE 'Liste%%' ORDER BY date_inscription";
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]; 
  else
    return false;
}

//fixer le nbre max de participant suite à COMPLET
function setmaxpIDU ($IDU, $maxp)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET maxp = " . $maxp . " WHERE IDU = " . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;  
}


//extraction du nombre de participant d'une sortie
function extract_nbre_partic_idu ($IDU)
{
    global $wpdb2, $table_partic;
    $req  = "SELECT COUNT(*) AS count FROM " . $table_partic . " WHERE IDU = " . $IDU;
    $repc = $wpdb2->get_results($req);
    //echo $wpdb2->last_error;
    return $repc[0]->count;
}

function extract_activ_by_idu ($IDU)  //2.38
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE IDU = " . $IDU;
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties des jours entre ces deux dates
function extract_activ_two_dates ($date1, $date2, $camp='')
{
  global $wpdb2, $table_activ;

  if ($camp != '')
    $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $date1 . "' AND date_deb >= '" . $date2 . "' AND camp = '" . $camp . "' ORDER BY date_deb ASC";
  else
    $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $date1 . "' AND date_deb >= '" . $date2 . "' ORDER BY date_deb ASC";
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties du jour
function extract_activ_one_day ($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "'";
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties à venir à partir de ce jour
function extract_activ_avenir ($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $date . "' ORDER BY date_deb ASC";
  return $wpdb2->get_results($req);
}

function extract_activ_day ($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "'";
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties terminées (date de fin donc) à partir de ce jour
function extract_activ_retroactive ($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_fin <= '" . $date . "' ORDER BY date_deb DESC";
  return $wpdb2->get_results($req);
}

//extraction de toutes les séjours terminées (date de fin donc) à partir de ce jour
function extract_activ_sejour_retroactive ($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') ORDER BY date_deb DESC";
  return $wpdb2->get_results($req);
}

//extraction de toutes les séjours terminées (date de fin donc) à partir de ce jour
function extract_activ_sejour_retroactive_act ($date, $activite, $camp = '')
{
  global $wpdb2, $table_activ;
  if ($camp == '')
  {
    if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') AND formation = 1 ORDER BY date_deb DESC";
    else
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') AND activite LIKE '" .
        $activite . "' ORDER BY date_deb DESC"; 
  }
  else
  {
    if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') AND formation = 1 AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else
        $req = "SELECT * FROM " . $table_activ . " WHERE  annulation = 0 AND date_fin <= '" . $date . "' AND (type = 'S' OR type = 'W') AND activite LIKE '" .
        $activite . "' AND camp = '" . $camp . "' ORDER BY date_deb DESC"; 

  }
  //echo $req . '<br>';
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties à venir d'une période
function extract_activ_avenir_periode_act ($dated, $datef, $activite, $search, $camp)
{
  global $wpdb2, $table_activ;

  
  if ($search == '' || $search == 'ANNULEE')
  {
    /*
    if ($camp == '')
    {
      if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "'  ORDER BY date_deb ASC, type";
      else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND formation = 1  ORDER BY date_deb ASC, type";
      else
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND activite like '" . $activite . "'  ORDER BY date_deb ASC, type"; 
    }
    else
    { 
    */ 
      if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "'  AND camp = '" . $camp . "' ORDER BY date_deb ASC, type";
      else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND formation = 1  AND camp = '" . $camp . "'ORDER BY date_deb ASC, type";
      else
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND activite like '" . $activite . "'  AND camp = '" . $camp . "'ORDER BY date_deb ASC, type"; 
    /*}*/   
  }
  else
  { 
    /*if ($camp == '')
    {
      if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')   ORDER BY date_deb ASC, type";
      else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  ORDER BY date_deb ASC, type";
      else 
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  ORDER BY date_deb ASC, type"; 
    }
    else
    {*/
      if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb ASC, type";
      else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb ASC,type";
      else 
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $dated . "' AND date_deb <= '" . $datef . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb ASC,type"; 
    /*}*/   
  }  
  
  //echo $req . '<br>';
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties terminées d'une période (rétroactive 6 mois)
function extract_activ_retroactive_periode ($dated, $datef, $activite='toutes', $search='', $camp='')
{
  global $wpdb2, $table_activ;

  if ($search == '' || $search == 'ANNULEE')
  {
    
    if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND formation = 1  AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND activite LIKE '" . $activite . "'  AND camp = '" . $camp . "' ORDER BY date_deb DESC";      
  }
  else
  {

    if ($activite == 'toutes')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')   AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else
        $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND activite LIKE '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb DESC";         
  }
  
  //echo $req . '<br>';
  return $wpdb2->get_results($req);
}

//extraction de toutes les sorties terminées d'une période (rétroactive 6 mois)
function extract_activ_retroactive_periode_act ($dated, $datef, $activite='toutes', $search='', $camp='')
{
  global $wpdb2, $table_activ;
  if ($search == '' || $search == 'ANNULEE')
  {
    if ($activite == 'toutes')
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND formation = 1  AND camp = '" . $camp . "'ORDER BY date_deb DESC";
    else
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND activite like '" . $activite . "' AND camp = '" . $camp . "' ORDER BY date_deb DESC";    
  }
  else
  {
    if ($activite == 'toutes')
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb DESC";
    else if ($activite == 'Formation')
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb DESC";  
    else
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $dated . "' AND date_deb >= '" . $datef . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "' ORDER BY date_deb DESC";        
  }
  //echo '<br>' . $req . '<br>';
  return $wpdb2->get_results($req);
}

function extract_activ_sejour_avenir ($date_d, $date_f, $activite='toutes',$camp='')
{
  global $wpdb2, $table_activ;
  $date = date('y-m-d');
  if ($camp == '')
  {
    if ($activite == 'toutes')
      $req = "SELECT * FROM " . $table_activ . " WHERE (type = 'S' OR type = 'W') AND date_deb >= '" . $date_d . "' AND date_deb <= '" . $date_f . "' ORDER BY date_deb ASC";
    else
      $req = "SELECT * FROM " . $table_activ . " WHERE  (type = 'S' OR type = 'W') AND activite like '" . $activite . "' AND date_deb >= '" . $date_d . "' AND date_deb <= '" . $date_f . "' ORDER BY date_deb ASC";
  }
  else
  {
    if ($activite == 'toutes')
      $req = "SELECT * FROM " . $table_activ . " WHERE (type = 'S' OR type = 'W') AND date_deb >= '" . $date_d . "' AND date_deb <= '" . $date_f . "' AND camp = '" . $camp . "' ORDER BY date_deb ASC";
    else
      $req = "SELECT * FROM " . $table_activ . " WHERE  (type = 'S' OR type = 'W') AND activite like '" . $activite . "' AND date_deb >= '" . $date_d . "' AND date_deb <= '" . $date_f . "' AND camp = '" . $camp . "' ORDER BY date_deb ASC";    
  }
  //echo $req . '<br>';

  $ret = $wpdb2->get_results($req);
  
  return $ret;
}

function extract_activ_collecte_camp ($type_camp)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE camp LIKE '" . $type_camp . "' AND date_deb > '" . date('Y-m-d') . "' ORDER BY date_deb ASC";

  return $wpdb2->get_results($req);
}

function extract_activ_collecte ($date_first, $date_last)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $date_first . "' AND date_fin <= '" . $date_last . "' ORDER BY date_deb ASC";
  return $wpdb2->get_results($req);
}

function update_size_activ ($IDU, $W, $H)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET sizeW = " . $W ." , sizeH = " . $H . " WHERE IDU = " . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function add_filtre_adh ($licence, $filtres)
{
  global $wpdb2, $table_adherent;
  $req = "UPDATE " . $table_adherent . " SET filtres = '" . $wpdb2->_real_escape($filtres) . "' WHERE id = '" . $licence . "'";
  
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo $wpdb2->last_error . '<br>';
    return false;
  }
  else
    return true;
  
}


function extract_activ_statistique ($date_first, $date_last, $cadre)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $date_first . "' AND date_deb <= '" . $date_last . "' AND cadre like '%%" . 
  $wpdb2->_real_escape($cadre) . "%%' ORDER BY date_deb ASC";
  echo $req;
  return $wpdb2->get_results($req);
}

function extract_activ_avec_cr ()
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE cr=1 ORDER BY date_deb ASC";
  return $wpdb2->get_results($req);
}

function extract_all_corbeille ()
{
  global $wpdb2, $table_corbeille;
  $req = "SELECT * FROM " . $table_corbeille . " ORDER BY date_deb ASC";
  return $wpdb2->get_results($req);
}

function  extract_activ_image ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "SELECT img FROM " . $table_activ . " WHERE IDU =" . $IDU;
  $rep = $wpdb2->get_results($req);
  
  if (sizeof($rep) > 0 )
    return $rep[0]->img;
}


function update_activ_image ($IDU, $IMG)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET img = '" . $wpdb2->_real_escape($IMG) . "' , date_mod ='" . $now  .  "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  if ($wpdb2->last_error) echo $req . ' error ' . $wpdb2->last_error;
  $wpdb2->last_error;
}

function ajouter_activ_preinscription ($IDU)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET preinscription = 1 , date_mod ='" . $now  .  "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}


function supprimer_activ_preinscription ($IDU)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET preinscription = 0 , date_mod = '" . $now  .  "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  
  return $wpdb2->last_error;
}

function ajouter_activ_complet ($IDU)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET complet = 1 , date_mod ='" . $now  .  "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function extract_activ_dup ($date, $cadre)
{
  global $wpdb2, $table_activ;
  $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND cadre like '" . $wpdb2->_real_escape($cadre) . "' AND annulation = 0";
  return $wpdb2->get_results($req);
}

function suppression_complet_activ_idu ($IDU)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET complet = 0, date_mod ='" . $now  .  "' WHERE IDU =" . $IDU;
  $rep = $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function update_cadre_activ_idu ($IDU, $cadre)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET cadre = '" . $wpdb2->_real_escape($cadre) . "', date_mod ='" . $now  . "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function ajouter_remplacer_urlphoto ($IDU, $urlphoto)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET photo = '" . $wpdb2->_real_escape($urlphoto) . "', date_mod ='" . $now  . "' WHERE IDU =" . $IDU;
  $rep = $wpdb2->get_results($req);
  return $wpdb2->last_error;
}


function update_url_photo_activ ($IDU, $urlphoto)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET photo = '" . $wpdb2->_real_escape($urlphoto) . "', date_mod ='" . $now  . "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function update_set_annulation ($IDU, $raison)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET annulation = 1, date_mod ='" . $now  . "', cause_annul = '" . $raison . "' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  $ret = $wpdb2->last_error;
  if ($ret)
    echo $req . '<br>';
  return $ret; 
}

function update_reset_annulation_activ ($IDU)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET annulation = 0, date_mod ='" . $now  . "', cause_annul = '' WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  $ret = $wpdb2->last_error;
  if ($ret)
    echo $req . '<br>';
  return $ret;   
}

function insert_new_activ_report ($file, $newIDU, $newident, $date_report, $newdate_fin)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "INSERT INTO " . $table_activ . " (IDU, ident, date_deb, date_fin, type, activite, cadre, titre, detail, diff, img, annulation, avance, report, cr, date_cre, date_mod, photo, preinscription,complet,coencadrant2,coencadrant3,coencadrant4, img, preinscription,photo,cause_annul) VALUES (" . $newIDU . " , '" . $newident . "' , '" . $date_report . "' , '" . $newdate_fin ."' , '" . $file->type . "' , '" .
    $file->activite . "' , '" . $wpdb2->_real_escape($file->cadre) . "' , '" . $wpdb2->_real_escape($file->titre) . "' , '" . $wpdb2->_real_escape(replace_cr($file->$detail)) . 
    "' , '" . $file->diff .  "' , '" . $wpdb2->_real_escape($file->img) . "' , " . $file->annulation . " , '" . $file->avance ."' , '" . $file->report . "' , " . $file->cr . ",'" . 
    $file->date_cre . "','" . $now . "','" .  $file->photo . "'," . $file->preinscription . "," . $file->complet . ", '', '', '', '', 0, '', '')";
    //echo $req . '<br>';
  $rep = $wpdb2->get_results($req);

  if ($wpdb2->last_error ) {
      echo $req . '<br>';
    echo 'wpd2 error: ' . $wpdb2->last_error;
    $wpdb2->show_errors ();
    $wpdb2->print_error ();
  } 
}

function  delete_activ ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "DELETE FROM " . $table_activ . " WHERE IDU = " . $IDU;
  $rep  = $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo 'wpd2 error: ' . $wpdb2->last_error;
    return false;
  }
  else
    return true;
}

function restauration_corbeille ($IDU)
{
  global $wpdb2, $table_activ, $table_corbeille;
  $req = "SELECT * FROM " . $table_corbeille . " WHERE IDU = " . $IDU;
  $repctl  = $wpdb2->get_results($req);
  $note = $repctl[0];
  if ($note->cr == '') $note->cr = 0;
  if ($note->annulation =='') $note->annulation = 0;
  if ($note->report == '') $note_report = '0000-00-00';
  if ($note->avance == '') $note->avance = '0000-00-00';
  if ($note->preinscription == '') $note->preinscription = 0;


  $req = "INSERT INTO " . $table_activ . " (IDU, ident, type, date_deb, date_fin, date_cre, date_mod, activite, cadre, coencadrant, titre, detail, diff, denivele, formation, annulation, avance, report, cr, preinscription) 
    VALUES (" . $note->IDU . " , '" . $note->ident . "' , '" . $note->type . "' ,'" . $note->date_deb . "' , '" . $note->date_fin ."' , '" .     $note->date_cre .   "','" .
    $note->date_mod . "', '" . $note->activite . "' , '" . $wpdb2->_real_escape($note->cadre) . "','" . $wpdb2->_real_escape($note->coencadrant) . "' ,'" . 
    $wpdb2->_real_escape($note->titre) . "' , '" . $note->diff . "','" . $wpdb2->_real_escape(replace_cr($note->detail)) .     "' , " . $note->denivele . "," . $note->formation . "," .
    $note->annulation . ",'" . $note->avance . "','" . $note->report . "'," . $note->cr . "," . $note->preinscription . ")";
      //echo $req . '<br>';
    $rep = $wpdb2->get_results($req);
      
    if ($wpdb2->last_error ) {
      echo 'wpd2 error: ' . $wpdb2->last_error;
      echo $req . '<br>';
      $wpdb2->show_errors ();
      $wpdb2->print_error ();
      return false;
    }
    else
      return true; 
}


function recopie_corbeille ($IDU)
{
  global $wpdb2, $table_activ, $table_corbeille;
  $req = "SELECT * FROM " . $table_activ . " WHERE IDU = " . $IDU;
  $repctl  = $wpdb2->get_results($req);
  $note = $repctl[0];
  if ($note->cr == '') $note->cr = 0;
  if ($note->annulation =='') $note->annulation = 0;
  if ($note->report == '') $note->report  = '0000-00-44';
  if ($note->avance == '') $note->avance  = '0000-00-55';
  if ($note->preinscription == '') $note->preinscription = 0;
  if ($note->maxp == '') $note->maxp = 0;


  $req = "INSERT INTO " . $table_corbeille . " (IDU, ident, type, date_deb, date_fin, date_cre, date_mod, activite, cadre, coencadrant, coencadrant2, coencadrant3, coencadrant4, titre, detail, diff, denivele, formation, annulation, avance, report, cr, preinscription, img, sizeW, sizeH, cause_annul, maxp) 
    VALUES (" . $note->IDU . " , '" . $note->ident . "' , '" . $note->type . "' ,'" . $note->date_deb . "' , '" . $note->date_fin ."' , '" .     $note->date_cre .   "','" .
    $note->date_mod . "', '" . $note->activite . "' , '" . $wpdb2->_real_escape($note->cadre) . "','" . $wpdb2->_real_escape($note->coencadrant) . "' ,'" . 
    $wpdb2->_real_escape($note->coencadrant2) . "','" . $wpdb2->_real_escape($note->coencadrant3) . "','" . $wpdb2->_real_escape($note->coencadrant4) . "','" .$wpdb2->_real_escape($note->titre) . "' , '" . $note->diff . "','" . $wpdb2->_real_escape(replace_cr($note->detail)) .     "' , " . $note->denivele . "," . $note->formation . "," .
    $note->annulation . ",'" . $note->avance . "','" . $note->report . "', " . $note->cr . "," . $note->preinscription . ",'" . $note->img . "'," . $note->sizeW . "," . $note->sizeH . ",'" .
    $wpdb2->_real_escape($note->cause_annul) . "', " . $note->maxp . ")";
  
    $rep = $wpdb2->get_results($req);
      
    if ($wpdb2->last_error ) {
      echo 'wpd2 error: ' . $wpdb2->last_error . '<br>';
      echo $req . '<br>';
      $wpdb2->show_errors ();
      $wpdb2->print_error ();
      return false;
    }
    else
      return true; 
  }



function enregistrement_sortie ($IDU, $ident, $type, $date_deb, $date_fin, $date_cre, $activite, $cadre, $coencadrant, $titre, $diff, $CP, $CT,
  $detail,$denivele, $formation, $maxp, $cotation='', $nbkms=0, $camp='')
{
  global $wpdb2, $table_activ,$cx,$cadre_p;
  $ret = true;
  $req = "SELECT * FROM " . $table_activ . " WHERE IDU = " . $IDU;
  $repctl  = $wpdb2->get_results($req);
  //correction du 15/06/2025 sur le maxp
  if ($maxp == '') 
    $maxp=0;
  
  if (sizeof($repctl) == 0)
  {
    $req = "INSERT INTO " . $table_activ . " (IDU, ident, type, date_deb, date_fin, date_cre, date_mod, activite, cadre, coencadrant, titre, detail, diff, CP, CT, denivele, formation, report, avance, cr,annulation,complet,maxp, coencadrant2, coencadrant3, coencadrant4, cause_annul, img, preinscription, photo,cotation, kms, camp )  
    VALUES (" . $IDU . " , 
      '" . $ident . "' , 
      '" . $type . "' ,
      '" . $date_deb . "' , 
      '" . $date_fin ."' , 
      '" . $date_cre . "',  
      '" . $date_cre . "',
      '" . $activite . "' , 
      '" .  $wpdb2->_real_escape($cadre) . "',
      '" . $wpdb2->_real_escape($coencadrant) . "' ,
      '" . $wpdb2->_real_escape($titre) . "' ,
      '" . $wpdb2->_real_escape($detail) . "' ,
      '" . $diff . "' ,
      '" . $CP . "' ,
      '" . $CT . "' ,
       " . $denivele . ",
       " . $formation . ",
      '0000-00-00',         
      '0000-00-00',         
      0,                    
      0,                    
      0,                    
      " . $maxp . ",        
      '',                   
      '', 
      '',
      '',
      '',
      0,
      '',
      '" . $wpdb2->_real_escape($cotation) . "'," . $nbkms . " ,'" . $camp . "')";

    $rep = $wpdb2->get_results($req);
    //echo $req . '<br>';
    if ($wpdb2->last_error ) {
      echo 'wpd2 error: ' . $wpdb2->last_error;
      add_log_bd_bloc (date('Y-m-d H:i:s'), $cx, $IDU, $cadre_p . ' - ' . 'enregistrement_sortie : ' . sup_anti_slash($wpdb2->last_error) . 'ret = false');
      $wpdb2->show_errors ();
      $wpdb2->print_error ();
      $ret = false;
    }
 
  }
  else
  {
    add_log ('Protection doublon - Enregistrement sortie en UPDATE avec IDU ' . $IDU);
    
    $req = "UPDATE " . $table_activ . " SET type = '" . $type . "', date_deb = '" . $date_deb . "', date_fin = '" . $date_fin . "', date_mod = '" . $date_cre . "', 
    activite = '" . $activite . "', cadre = '" . $wpdb2->_real_escape($cadre) . "', coencadrant = '" . $wpdb2->_real_escape($coencadrant) . "', titre = '" . $wpdb2->_real_escape($titre) .
    "' , detail = '" . $wpdb2->_real_escape(replace_cr($detail)) . "', diff = '" . $diff . "', CP = '" . $CP ."', CT = '" . $CT . "', denivele = " . $denivele . ", 
    formation = " . $formation . ", maxp = " . $maxp . ", cotation = '" . $wpdb2->_real_escape($cotation) . "', kms = " . $kms . ", camp = '" . $camp . "' WHERE IDU = " . $IDU;
    //echo $req . '<br>';
    $rep = $wpdb2->get_results($req);
    //echo $req . '<br>';
    if ($wpdb2->last_error ) {
      echo 'wpd2 error: ' . $wpdb2->last_error;
      $wpdb2->show_errors ();
      $wpdb2->print_error ();
      $ret = false;
    }
  }

  return $ret;
}

function update_full_activ ($IDU, $type, $date_deb, $date_fin, $cadre, $activite, $coencadrant, $titre, $diff, $CP, $CT, $detail, $denivele, $formation, $preinscription, $complet, $maxp, $cotation='', $kms=0, $camp='')
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  if ($maxp == '') $maxp=0;
  $req = "UPDATE " . $table_activ . " SET type = '" . $type . "', date_deb = '" . $date_deb . "', date_fin = '" . $date_fin . "', cadre = '" . $wpdb2->_real_escape($cadre) . "', coencadrant = '" . $wpdb2->_real_escape($coencadrant) . "', activite = '" . $activite . "', titre = '" . $wpdb2->_real_escape($titre) . "', diff = '" . $diff . "', CP = '" . $CP . "', CT = '" . $CT . "' , denivele = " . $denivele . ", formation = " . $formation . ",detail = '" . $wpdb2->_real_escape($detail) . "', date_mod = '" . $now . "', maxp = " . $maxp . ", cotation = '" . $wpdb2->_real_escape($cotation) . "', kms = " . $kms . " , camp = '" . $camp . "' WHERE IDU =" . $IDU;
  $rep = $wpdb2->get_results($req);
  
  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    return false;
  }
  else
    return true;;
}


function update_full_partic ($IDU, $date_deb)
{
  global $wpdb2, $table_partic;
  
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
  {
    $upd = "UPDATE " . $table_partic . " SET date_deb = '" . $date_deb . "' WHERE IDU =" . $IDU;
    $wpdb2->get_results($upd);
  }
  if ($wpdb2->last_error)
  {
    echo $upd . '<br>';
    return false;
  }
  else
    return true;;
}


function update_avance_activ ($IDU, $date_avance)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET avance = '" . $date_avance . "', date_mod ='" . $now  . " WHERE IDU =" . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;
}

function update_report_activ ($IDU, $date_report)
{
  global $wpdb2, $table_activ;
  $now = date('Y-m-d H:i:s');
  $req = "UPDATE " . $table_activ . " SET report = '" . $date_report . "', date_mod ='" . $now  . " WHERE IDU =" . $IDU;
  return $wpdb2->get_results($req);
}

function ajout_preinscription_activ_idu ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET preinscription = 1 WHERE IDU =" . $IDU;
  return $wpdb2->get_results($req);
}



//extraction de tous les participants d'une sortie
function extract_all_partic_idu ($IDU)
{
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU=" . $IDU;
  return $wpdb2->get_results($req);
}

function extract_double_inscription ($IDU, $nom, $prenom, $date_deb )
{
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU <> " . $IDU . " AND date_deb LIKE '" . $date_deb . "' AND nom LIKE '" . $nom . "' AND prenom LIKE '" . $prenom . "'";
  return $wpdb2->get_results($req);
}


function delete_participant_name ($IDU, $prenom, $nom)
{
  global $wpdb2, $table_partic;
  $req = "DELETE FROM " . $table_partic . " WHERE IDU =" . $IDU . " AND prenom like '%%" . $wpdb2->_real_escape($prenom) . "%%' AND nom like '%%" . 
  $wpdb2->_real_escape($nom) . "%%'";
  $wpdb2->get_results($req);
  
  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    return false;
  }
  else
    return true;
}



function update_etat_participant ($IDU, $prenom, $nom, $etat)
{
  global $wpdb2, $table_partic;
  $req = "UPDATE " . $table_partic . " SET etat = '" . $wpdb2->_real_escape($etat) . "' WHERE IDU =" . $IDU . " AND prenom like '%%" . $prenom . "%%' AND nom like '%%" . $nom . "%%'";
  return $wpdb2->get_results($req);  
}

function update_partic_name($IDU, $prenom, $nom, $prenom_rep, $nom_rep, $tel, $mail, $car)
{
  global $wpdb2, $table_partic;
  $req = "UPDATE " . $table_partic . " SET prenom = '" . $wpdb2->_real_escape($prenom_rep) . "' , nom =  '" . $wpdb2->_real_escape($nom_rep) . "',
  mobile='" . $tel . "', email='" . $mail . "', voiture='" . $car . "' WHERE IDU =" . $IDU . " AND prenom like '%%" . $wpdb2->_real_escape($prenom) . "%%' AND nom like '%%" . $wpdb2->_real_escape($nom) . "%%'";
  
  $wpdb2->get_results($req);

  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    return false;
  }
  else
    return true;
} 

function existe_partic_name ($IDU, $prenom, $nom)
{
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE IDU = " . $IDU . " AND prenom LIKE '%%" . $wpdb2->_real_escape($prenom) . "%%' AND nom LIKE '%%" . 
  $wpdb2->_real_escape($nom) . "%%'";
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0];
  else
  {
    //echo $req . '<br>';
    return false;
  }
}

//ajout d'une preinscription
function ajout_partic_idu ($IDU, $date_deb, $prenom, $nom,$tel, $mail, $car, $etat, $date)
{
  global $wpdb2, $table_partic;

  $reqs = "SELECT * FROM " . $table_partic . " WHERE prenom = '" . $prenom . "' AND nom = '" . $nom . "' AND IDU = " . $IDU;
  $reps = $wpdb2->get_results($reqs);

  if (sizeof($reps) > 0)
    return false;
  
  $req = "INSERT INTO " . $table_partic . " (IDU, date_deb, prenom, nom, mobile, email, voiture, etat, date_inscription) VALUES
          (" . $IDU . ", '" . $date_deb . "','" . $wpdb2->_real_escape($prenom) . "','" . $wpdb2->_real_escape($nom) . "','" . $tel . "','" . $wpdb2->_real_escape($mail) . "','" . $wpdb2->_real_escape($car) . "','" . $wpdb2->_real_escape($etat) . "','" . $date ."')";
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo $wpdb2->last_error;
    return false;
  }
  return true;
}



function update_all_inscrit ($IDU, $etat, $attente = '')
{
 global $wpdb2, $table_partic;
  $req = "UPDATE " . $table_partic . " SET etat = '" . $wpdb2->_real_escape($etat) . "' WHERE IDU = " . $IDU;
  if ($attente != '')
    $req .= " AND etat NOT LIKE '" . $wpdb2->_real_escape($attente) . "'";
  
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo $wpdb2->last_error;
    return false;
  }
  return true;  
}

//mis à blanc des mobiles et des mails d'une sortie
function  raz_mobile_email_idu ($IDU)
{
  global $wpdb2, $table_partic;
  $req = "UPDATE " . $table_partic . " SET mobile = '', email='' WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);
}

//extraction du compte-rendu d'une sortie
function extract_cr_idu ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);
  return $rep[0];
}

function extract_cr_demijp ($IDU) //version 2.29
{
  global $wpdb2, $table_cr;
  $req = "SELECT demijp FROM " . $table_cr . " WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);
  return $rep[0]->demijp;
}

function maj_compte_rendu ($IDU, $cr, $nbkms, $nbpart, $demijp, $chauffeur,$securite)
{
  global $wpdb2, $table_cr, $table_activ;
  if ($demijp == '') $demijp = 0;
  if ($nbkms == '') $nbkms=0;
  if ($nbpart == '') $nbpart=0;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);

  
  if (sizeof($rep) == 0)
    $req = "INSERT INTO " . $table_cr . " (IDU, cr, kms, participants, demijp, chauffeur, securite) VALUES (" . $IDU . " ,  '" . $wpdb2->_real_escape($cr) . "' , " . $nbkms . " , " . $nbpart . "," . $demijp . "," . $chauffeur . 
      ", '" . $wpdb2->_real_escape($securite) . "')";
  else
    $req = "UPDATE " . $table_cr . " SET cr = '" . $wpdb2->_real_escape($cr) . "', kms = " . $nbkms . ", participants = " . $nbpart . ", demijp = " . $demijp . ", chauffeur = " . $chauffeur . ", securite = '" . $wpdb2->_real_escape($securite) . "'  WHERE IDU = " . $IDU; 
  
  $rep = $wpdb2->get_results($req);
  if ($wpdb2->last_error) 
  {
    echo $wpdb2->last_error;
    return false;
  }
  $req = "UPDATE " . $table_activ . " SET cr = 1 WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  
  return true;
}

function update_coencadrant($IDU, $coencadrant2, $coencadrant3, $coencadrant4)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET coencadrant2 = '" . strtoupper($wpdb2->_real_escape($coencadrant2)) . "', 
                                          coencadrant3 = '" . strtoupper($wpdb2->_real_escape($coencadrant3)) . "',
                                          coencadrant4 = '" . strtoupper($wpdb2->_real_escape($coencadrant4)) . "'  WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);  
  if ($wpdb2->last_error)
  { 
    echo $wpdb2->last_error;
    return false;
  }
  else
    return true;                                       
}


function extract_cr_contenu ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]->cr;
  else
    return false;
}


function extract_cr_chauffeur ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  return $rep[0]->chauffeur;
}


function extract_cr_kms ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]->kms;
  else
    return false;
}


function extract_cr_securite ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT securite FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]->securite;
  else
    return false;
}
function extract_cr_participants ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "SELECT * FROM " . $table_cr . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]->participants;
  else
    return false;
}



//Suppression compte-rendu d'une sortie supprimée
function delete_cr_idu ($IDU)
{
  global $wpdb2, $table_cr;
  $req = "DELETE FROM " . $table_cr . " WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);
}

function delete_all_partic_idu ($IDU)
{
  global $wpdb2, $table_partic;
  $req = "DELETE FROM " . $table_partic . " WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);  
}

function delete_activ_idu ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "DELETE FROM " . $table_activ . " WHERE IDU=" . $IDU;
  $rep = $wpdb2->get_results($req);  
}

//recherche de toutes les participations de prenom nom à toutes les sorties terminées ou non
function extract_all_partic_name_avenir ($prenom, $nom)
{
  global $wpdb2, $table_partic;
  $date = date('Y-m-d');
  $req = "SELECT * FROM " . $table_partic . " WHERE prenom LIKE '" . $wpdb2->_real_escape($prenom) . "' AND nom LIKE '" . $wpdb2->_real_escape($nom) . "' AND date_deb > '" . $date . "' ORDER BY date_deb ASC";  
  return $wpdb2->get_results($req);
}

function extract_all_partic_name_retroactif6 ($prenom, $nom)
{
  global $wpdb2, $table_partic;
  $req = "SELECT * FROM " . $table_partic . " WHERE prenom LIKE '" . $wpdb2->_real_escape($prenom) . "' AND nom LIKE '" . $wpdb2->_real_escape($nom) . "' ORDER BY date_deb ASC";  
  return $wpdb2->get_results($req);
}
//retourne le liste complete des activité triées par date ascendante
function extract_all_activ ($quand, $mode, $date, $camp='')
{
  global $wpdb2, $table_activ;
  
  $cejour = date('Y-m-d');
  if ($mode == 'DESCENDRE')
  {
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb >= '" . $date . "' AND camp = '" . $camp . "' ORDER BY date_deb ASC";  
      //echo 'Recherche des notes de dates supérieures ou égales à ' . $date . '<br>';
  }
  else
  {
      $req = "SELECT * FROM " . $table_activ . " WHERE date_deb <= '" . $date . "' AND date_deb >= '" . $cejour . "' AND camp = '" . $camp . "' ORDER BY date_deb DESC"; 
      //echo 'Recherche des notes de dates inférieures ou égales à ' . $date . 'jusqua ' . $cejour . '<br>' ; 
  }
  //echo $req . '<br>';
  return $wpdb2->get_results($req);
}

//extraite le nbre de dialogue sur une activité
function extract_count_dia ($IDU)
{
  global $wpdb2, $table_dia;
  $req = "SELECT COUNT(*) AS count FROM " . $table_dia . " WHERE IDU = " . $IDU;
  $repcount = $wpdb2->get_results($req);

  if ( $wpdb2->last_error ) {
          //echo $file . '<br>';
          //echo 'wpd2 error: ' . $wpdb2->last_error;
          $wpdb2->show_errors ();
          //$wpdb2->print_error ();
  }
  
  return $repcount[0]->count;
}

function ajout_cadre ($prenom, $nom, $nick_name, $mobile, $email, $activite, $fonction)
{
   global $wpdb2, $table_cadre;  
   $req = "INSERT INTO " . $table_cadre . " (prenom, nom, nick_name, mobile, email, activite, titre) VALUES ('" . $wpdb2->_real_escape($prenom) . "','" . $wpdb2->_real_escape($nom) . "','" . $wpdb2->_real_escape($nick_name) . "','" . $mobile . "','" . $email . "','" . $activite . "','" . $fonction . "')";
   $wpdb2->get_results($req);
   if ($wpdb2->last_error) 
   {
      echo $rep . '<br>';
      echo $wpdb2->last_error . '<br>';
      return false;
   }
   else
      return true;
}

function maj_cadre ($nick_name, $prenom, $nom, $mobile, $acti, $email, $titre)
{
   global $wpdb2, $table_cadre;
   $req = "UPDATE " . $table_cadre . " SET prenom = '" . $prenom . "',nom = '" . $nom . "', mobile = '" . $mobile . "', activite = '" . $acti . "', email = '" . $email . "', titre = '" . $titre . "' 
      WHERE nick_name like '%" . $nick_name . "%'";

   $wpdb2->get_results($req);
   if ($wpdb2->last_error) 
   {
      echo $rep . '<br>';
      echo $wpdb2->last_error . '<br>';
      return false;
   }
   else
      return true;
}

function delete_cadre ($nick_name)
{     
   global $wpdb2, $table_cadre;
   $req = "DELETE FROM " . $table_cadre . " WHERE nick_name = '" . $nick_name . "'";
   $wpdb2->get_results($req);

   if ($wpdb2->last_error) 
   {
    echo $rep . '<br>';
    echo $wpdb2->last_error . '<br>';
    return false;
   }
   else
    return true;
}

//Mise à jour table adherent avec ident et password
function update_adherent_pass ($licence, $identifiant, $pass)
{
   global $wpdb2, $table_adherent;
   $req = "UPDATE " . $table_adherent . " SET ident = '" . $identifiant . "' , password = '" . $pass . "' 
   WHERE id  = '" . $licence . "'";
   $wpdb2->get_results($req);
   if ($wpdb2->last_error) 
   {
    echo $req . '<br>';
    echo $wpdb2->last_error . '<br>';
    return false;
   }
   else
    return true;   
}



//maj cadre avec ident et password
function update_cadre_pass ($nick_name, $identifiant, $pass)
{
   global $wpdb2, $table_cadre;
   $req = "UPDATE " . $table_cadre . " SET ident = '" . $identifiant . "' , password = '" . $pass . "' WHERE nick_name like '" . $nick_name . "'";
   $wpdb2->get_results($req);
   if ($wpdb2->last_error) 
   {
    echo $rep . '<br>';
    echo $wpdb2->last_error . '<br>';
    return false;
   }
   else
    return true;   
}


function extract_adherent_licence ($licence)
{
   global $wpdb2, $table_adherent;
   $req = "SELECT * FROM " . $table_adherent . " WHERE id like '" . $licence . "'";
   $rep = $wpdb2->get_results($req);
   if (sizeof($rep) > 0)
    return $rep[0];
   else
    return false;
}


function extract_adherent_ident ($identifiant)
{
   global $wpdb2, $table_adherent;
   $req = "SELECT * FROM " . $table_adherent . " WHERE ident LIKE '" . $identifiant . "'";
   $rep = $wpdb2->get_results($req);
   if (sizeof($rep) > 0)
    return $rep[0];
   else
    return false;
}


function extract_cadre_ident ($identifiant)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM `" . $table_cadre . "` WHERE ident like '" . $identifiant . "'";
   $rep = $wpdb2->get_results($req);

  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    echo $wpdb2->last_error;
    return false;
  }

   if (sizeof($rep) > 0)
    return $rep[0];
   else
    return false;
}

//extraction de la liste des adherents pour un identifiant donné
function extract_ident_adherent ($identifiant)
{
   global $wpdb2, $table_adherent;
   $req = "SELECT id, ident, prenom, nom, email, filtres FROM " . $table_adherent . " WHERE ident = '" . $identifiant . "'";
   $rep = $wpdb2->get_results($req);
   if (sizeof($rep) > 0)
    return $rep[0];
   else
    return false;
}

//ext1raction de la liste des encadrants
function extract_all_cadre ()
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " ORDER BY nom";
   return $wpdb2->get_results($req);
}

function extract_cadre ($nick_name)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%" . $wpdb2->_real_escape(sup_anti_slash($nick_name)) . "%' ORDER BY nom";
   return $wpdb2->get_results($req);
}   

//extraction de l'identifiant d'un encadrant via sa licence
function extract_ident_adherent_licence ($licence)
{
   global $wpdb2, $table_adherent;
   $req = "SELECT * FROM " . $table_adherent . " WHERE id like '%%" . $licence . "%%'";
   $rep = $wpdb2->get_results($req);
   return $rep[0]->ident;
}

//extraction de l'identifiant d'un encadrant
function extract_ident ($cadre)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $cadre . "%%'";
   $rep = $wpdb2->get_results($req);
   return $rep[0]->ident;
}

//extraction de la liste des activités d'un encadrant
function extract_activite_cadre ($cadre)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $cadre . "%%'";
   $rep = $wpdb2->get_results($req);
   return $rep[0]->activite;
}

//extraction de la liste des fonctions d'un encadrant
function extract_fonction_cadre ($cadre)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $wpdb2->_real_escape($cadre) . "%%'";
   $rep = $wpdb2->get_results($req);
   
   return $rep[0]->titre;
}

function extract_nom_cadre ($nick_name)
{
   global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $wpdb2->_real_escape($nick_name) . "%%'";
   $rep = $wpdb2->get_results($req);
   if (sizeof($rep) > 0)
      return $rep[0]->nom;
   else
      return false;
}

function extract_prenom_cadre ($nick_name)
{
   global $wpdb2, $table_cadre;

   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $wpdb2->_real_escape($nick_name) . "%%'";
   $rep = $wpdb2->get_results($req);

   if (sizeof($rep) > 0)
      return $rep[0]->prenom;
   else
      return false;
}

function recherche_mobile_cadre ($cadre)
{
  global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like '%%" . $wpdb2->_real_escape($cadre) . "%%'";
   $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep[0]->mobile;
  else
  {
    //probléme de prenom composé ?
    $tcadre = explode (' ', $cadre);
    if (sizeof($tcadre) == 3)
    {
      $req = "SELECT * FROM " . $table_cadre . " WHERE nom like  '%%" . $wpdb2->_real_escape($tcadre[2]) . "%%'";
      $rep = $wpdb2->get_results($req);
      if (sizeof($rep) > 0)
        return $rep[0]->mobile;
    }
    return '';
  }
}

function recherche_mail_cadre ($cadre)
{
  global $wpdb2, $table_cadre;
   $req = "SELECT * FROM " . $table_cadre . " WHERE nick_name like  '%%" . $wpdb2->_real_escape($cadre) . "%%'";
   $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
  {
    return strtolower($rep[0]->email);
    //return strtolower(wd_remove_accents($rep[0]->prenom . '.' . $rep[0]->nom)) . '@cafmeythet.org';
  }
  else
  {
    //probléme de prenom composé ?
    $tcadre = explode (' ', $cadre);
    if (sizeof($tcadre) == 3)
    {
      $req = "SELECT * FROM " . $table_cadre . " WHERE nom like  '%%" . $wpdb2->_real_escape($tcadre[2]) . "%%'";
      $rep = $wpdb2->get_results($req);
      if (sizeof($rep) > 0)
      {
        //return strtolower(wd_remove_accents($rep[0]->prenom . '.' . $rep[0]->nom)) . '@cafmeythet.org';
        return strtolower($rep[0]->email);
      }
    }
    return '';
  }
}

function recherche_cadre ($precadre)
{
     global $wpdb2, $table_cadre;
     if ($precadre == '') return '';
     $req = "SELECT * FROM " . $table_cadre . " WHERE nom like '%%" . $wpdb2->_real_escape($precadre) . "%%'";
     $rep = $wpdb2->get_results($req);
     if (sizeof($rep) == 1)
        return $rep[0]->nick_name;
     else if (sizeof($rep > 1))
     {
        foreach ($rep as $cadre)
          $tcadre[] = $cadre->nick_name;
        return $tcadre;
     }
     return false;
}

function recherche_cadre_2 ($precadre, $prenom)
{
     global $wpdb2, $table_cadre;
     if ($precadre == '') return '';
     $req = "SELECT * FROM " . $table_cadre . " WHERE nom like '%%" . $wpdb2->_real_escape($precadre) . "%%' AND prenom like '%%" . $wpdb2->_real_escape($prenom) . "%%'";
     $rep = $wpdb2->get_results($req);
     if (sizeof($rep) == 1)
        return $rep[0]->nick_name;
     else if (sizeof($rep > 1))
     {
        foreach ($rep as $cadre)
          $tcadre[] = $cadre->nick_name;
        return $tcadre;
     }
     return false;
}

function controle_act_cadre($cadre, $date, $activite)
{
  global $wpdb2, $table_activ;
  $req = "SELECT cadre, date_deb FROM " . $table_activ . " WHERE cadre LIKE '" . $cadre . "' AND date_deb LIKE '" . $date . "' AND activite LIKE '" . $activite . "'";
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return true;
  else
    return false;
}



function effacer_dialogue_idu ($IDU)
{
  global $wpdb2, $table_dia;
  $req = "DELETE  FROM " . $table_dia . " WHERE IDU=" . $IDU ;
  return $wpdb2->get_results($req);
}

function extract_dialogue ($IDU)
{
  global $wpdb2, $table_dia;
  $req = "SELECT * FROM " . $table_dia . " WHERE IDU=" . $IDU . " ORDER BY date_dialogue ASC";
  return $wpdb2->get_results($req);
}

function add_dialogue ($IDU, $ident, $md5, $date_deb, $date_dialogue, $pseudo, $message, $nom='')
{
  global $wpdb2, $table_dia;
  $req = "INSERT INTO " . $table_dia . " (IDU, ident, md5, date_deb, date_dialogue, nom, message, prenomnom) VALUES (" . $IDU . ", '" . $ident . "','" . $md5 . "','" .
  $date_deb . "', '" .  $date_dialogue . "','" . $wpdb2->_real_escape($pseudo) . "','" .  $wpdb2->_real_escape($message) . "', '" .  $wpdb2->_real_escape($nom) . "')";
  //echo $req . '<br>';
  return $wpdb2->get_results($req);
}

function extract_all_dialogue()
{
  global $wpdb2, $table_dia;
  $req = "SELECT * FROM " . $table_dia . " ORDER BY IDU, date_dialogue ASC";
  return $wpdb2->get_results($req);
}

function verif_dialogue_existe ($IDU, $md5, $pseudo)
{
  global $wpdb2, $table_dia;
  $req = "SELECT * FROM " . $table_dia . " WHERE IDU=" . $IDU . " AND md5 = '" . $md5 . "' AND nom = '" . $pseudo . "'";
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return true;
  else
    return false;
}

function purge_log ($date)
{
  global $wpdb2, $table_cal_log;
  $req = "DELETE FROM " . $table_cal_log . " WHERE date_log <= '" . $date . "%%'";
  add_log ($req);
  $wpdb2->get_results($req);
}

function get_count_log ($date)
{
  global $wpdb2, $table_cal_log;
  $req = "SELECT COUNT(*) AS count FROM " . $table_cal_log . " WHERE date_log <= '" . $date . "%%'";
  $rep = $wpdb2->get_results($req);
  return $rep[0]->count;
}


function getDateOldLogCal()
{
  global $wpdb2, $table_cal_log;
  $req = "SELECT * FROM " . $table_cal_log;
  $rep = $wpdb2->get_results($req);
  return $rep[0]->date_log;
}

function add_log_bd_cal ($date, $user, $IDU, $message)
{
  global $wpdb2, $table_cal_log;
  //echo 'Ecriture sur ' . $table_cal_log . ' de ' . $message . '<br>';
  $req = "INSERT INTO " . $table_cal_log . " (date_log, user, IDU, info, appli) VALUES ('" . $date . "', '" . $user . "'," . $IDU . ",'" . $wpdb2->_real_escape($message) . "', 'CAL')";
  //echo $req . '<br>';
  $wpdb2->get_results($req);
}

function add_log_bd_bloc ($date, $user, $IDU, $message)
{
  global $wpdb2, $table_bloc_log;
  $req = "INSERT INTO " . $table_bloc_log . " (date_log, user, IDU, info, appli) VALUES ('" . $date . "', '" . $user . "'," . $IDU . ",'" . $wpdb2->_real_escape($message) . "', 'BLO')";
  //echo $req . '<br>';
  $wpdb2->get_results($req);
}

function add_log_bd_classeur ($date, $user, $Id, $message)
{
  global $wpdb2, $table_cal_log;
  
  $req = "INSERT INTO " . $table_cal_log . " (date_log, user, IDU, info, appli) VALUES ('" . $date . "', '" . $user . "'," . $Id . ",'" . $wpdb2->_real_escape($message) . "', 'CLA')";
  //echo $req . '<br>';
  $wpdb2->get_results($req);
  //echo $req . '<br>' . $wpdb2->last_error;
}

function full_controle_doc($doc_name)
{
  global $wpdb2, $table_doc;
  $req = "SELECT doc_name FROM " . $table_doc . " WHERE doc_name = '" . $wpdb2->_real_escape($doc_name) . "'";     
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return true;
  else
    return false;
}

function verif_doc_name ($IDU, $doc_name)
{
  global $wpdb2, $table_doc;
  $req = "SELECT doc_name FROM " . $table_doc . " WHERE IDU = " . $IDU . " AND doc_name = '" . $wpdb2->_real_escape($doc_name) . "'";     
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return true;
  else
    return false;
}

function extract_doc_idu ($IDU)
{
  global $wpdb2, $table_doc;
  $req = "SELECT * FROM " . $table_doc . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($req);
  if (sizeof($rep) > 0)
    return $rep;
  else
    return false;
}

function add_doc_idu ($IDU, $date_expire, $doc_name, $ext)
{
  global $wpdb2, $table_doc;


  $req = "INSERT INTO " . $table_doc . " (IDU, date_delete, doc_name, doc_type) 
          VALUES (" . $IDU . ", '" . $date_expire . "','" . $wpdb2->_real_escape($doc_name) . "','" .  $ext . "')";
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    echo $wpdb2->last_error;
    return false;
  }
  else
    return true;
}

function supprimer_doc_name($IDU, $doc_name)
{
  global $wpdb2, $table_doc;
  $req = "DELETE FROM " . $table_doc  . " WHERE IDU = " . $IDU . " AND doc_name = '" . $wpdb2->_real_escape($doc_name) . "'";     
  $rep = $wpdb2->get_results($req);
  if ($wpdb2->last_error)
    return false;
  else
    return true;
}

function maj_doc_name ($IDU, $date_expire, $doc_name, $ext)
{
  global $wpdb2, $table_doc;
  $req = "UPDATE " . $table_doc . " SET date_delete = '" . $date_expire . "' WHERE IDU = " . $IDU . " AND doc_name = '" . $wpdb2->_real_escape($doc_name) . "'"; 
  $wpdb2->get_results($req);
  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    return false;
  }
  else
    return true;
}


function extract_log()
{
     global $wpdb2, $table_cal_log;
     $req = "SELECT * FROM " . $table_cal_log;
     $rep = $wpdb2->get_results($req);
     return $rep;
}

function extract_abonnement ($activite)
{
     global $wpdb2, $table_abonnement;
     $req = "SELECT * FROM " . $table_abonnement . " WHERE type_act like '" . $activite . "'";
     $rep = $wpdb2->get_results($req);
     return $rep;
}

function extract_abonnement_sejour ()
{
     global $wpdb2, $table_abonnement;
     $req = "SELECT * FROM " . $table_abonnement . " WHERE type_act like 'séjour'";
     $rep = $wpdb2->get_results($req);
     return $rep;
}


function extract_adherent_licence_mail ($licence, $mail)
{
     global $wpdb2, $table_adherent;
     $req = "SELECT * FROM " . $table_adherent . " WHERE id = ". $licence . " and email = '" . $mail . "'";
     $rep = $wpdb2->get_results($req);
     return $rep[0];
}

function extract_info_p ($licence)
{
     global $wpdb2, $table_adherent;
     $req = "SELECT * FROM " . $table_adherent . " WHERE id = ". $licence;
     $rep = $wpdb2->get_results($req);
     return $rep[0];
}

function extract_neige ($licence)
{
     global $wpdb2, $table_adherent;
     $req = "SELECT * FROM " . $table_adherent . " WHERE id = ". $licence;
     $rep = $wpdb2->get_results($req);
     return $rep[0]->neige;
} 




function maj_neige ($licence, $date)
{
    global $wpdb2, $table_adherent;

    if (is_numeric($licence))
    {
      $req = "UPDATE " . $table_adherent . " SET neige = '" . $date . "' WHERE id = " . $licence;
      $wpdb2->get_results($req);
      if ($wpdb2->last_error)
      {
        echo $req . '<br>';
        return false;
      }
      else
        return true;
    }
    return true;
}        


function delete_escalade ($prenom, $nom, $annee_escalade)
{
  global $wpdb2, $table_escalade;
  $del = "DELETE FROM " . $table_escalade . " WHERE prenom = '" . $prenom . "' AND nom = '" . $nom . "' AND seltype = '" . $annee_escalade . "'";
  $wpdb2->get_results($del);
  if ($wpdb2->last_error)
  {
    echo $req . '<br>';
    return false;
  }
  else
    return true;
}




function extract_liste_neige ()
{
    global $wpdb2, $table_adherent;
    $req = "SELECT Id, nom, prenom, neige FROM " . $table_adherent . " WHERE neige LIKE '2%%' ORDER BY neige DESC, nom ASC";
    $rep = $wpdb2->get_results($req);
    
    return $rep;
}

function controle_licence($nom, $prenom, $email)
{
   global $wpdb2, $table_adherent, $table_;
   $nom = rtrim($nom);
   if ($email == '') $email='sansemail';
   $prenom = rtrim($prenom);   


   //est-ce que le prenom et nom existe dans la table des adhérents  
   $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $nom . "%%' AND prenom like '" . substr($prenom,0,12) . "%%' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   
   if (substr($rep[0]->inscription,0,1) == '2') return true;

   //est-ce qu'un prenom composé tel que jean-marie existe
   if (strstr($prenom, '-'))
   {
    $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $wpdb2->_real_escape($nom) . "%%' AND prenom like '" . 
    $wpdb2->_real_escape(replace_tiret_name(substr($prenom,0,12))) . "%%' AND inscription LIKE '2%%'";
    $rep = $wpdb2->get_results($req);
    if (substr($rep[0]->inscription,0,1) == '2') return true;
   }

   //est-ce qu'un prénom composé tel que jean philippe existe
   if (strstr($prenom, ' '))
   {
    $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $wpdb2->_real_escape($nom) . "%%' AND prenom like '" . 
    $wpdb2->_real_escape(replace_espace_name(substr($prenom,0,12))) . "%%' AND inscription LIKE '2%%'";
    $rep = $wpdb2->get_results($req);
    if (substr($rep[0]->inscription,0,1) == '2') return true;
   }

   //est-ce qu'il y a eu une inversion entre le prénom et le nom
   $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $prenom . "%%' AND prenom like '" . substr($nom,0,12) . "%%' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   if (substr($rep[0]->inscription,0,1) == '2')
   {
    echo '<b><font color="red">ATTENTION : vous avez inversé votre prénom et nom. Prière de modifier votre inscription.</font></b><br>';
    return true;
   }

   $req = "SELECT * FROM " . $table_adherent . " WHERE email like '" . $email . "' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   foreach ($rep as $d)
   {
    if (substr($d->inscription,0,1) == '2') return true;
   }
  

    //est-ce une nouvelle adhésion : interrogation
    return false;
   
}

function controle_licence_2 ($nom, $prenom, $email)  //retourne le numéro de licence
{
   global $wpdb2, $table_adherent, $num_club;
   if (substr($prenom, 0, 4) == $num_club)           //inscription avec licence
    return $prenom;

   $nom = rtrim($nom);
   if ($email == '') $email='sansemail';
   $prenom = rtrim($prenom);   


   //est-ce que le prenom et nom existe dans la table des adhérents  
   $req = "SELECT id, inscription FROM " . $table_adherent . " WHERE nom like '" . $nom . "%%' AND prenom like '" . substr($prenom,0,12) . "%%' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   
   if (substr($rep[0]->inscription,0,1) == '2') 
    return $rep[0]->id;

   //est-ce qu'un prenom composé tel que jean-marie existe
   if (strstr($prenom, '-'))
   {
      $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $wpdb2->_real_escape($nom) . "%%' AND prenom like '" . $wpdb2->_real_escape(replace_tiret_name(substr($prenom,0,12))) . "%%' AND inscription LIKE '2%%'";
      $rep = $wpdb2->get_results($req);
      if (substr($rep[0]->inscription,0,1) == '2') 
        return $rep[0]->id;
   }

   //est-ce qu'un prénom composé tel que jean philippe existe
   if (strstr($prenom, ' '))
   {
    $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $wpdb2->_real_escape($nom) . "%%' AND prenom like '" . 
    $wpdb2->_real_escape(replace_espace_name(substr($prenom,0,12))) . "%%' AND inscription LIKE '2%%'";
    $rep = $wpdb2->get_results($req);
    if (substr($rep[0]->inscription,0,1) == '2') 
      return $rep[0]->id;
   }

   //est-ce qu'un nom composé tel que praet-comini
   if (strstr($nom, '-'))
   {
      $req = "SELECT * FROM " . $table_adherent . " WHERE prenom like '" . $wpdb2->_real_escape($prenom) . "%%' AND nom like '" . $wpdb2->_real_escape(replace_tiret_name(substr($nom,0,12))) . "%%' AND inscription LIKE '2%%'";
      $rep = $wpdb2->get_results($req);
      if (substr($rep[0]->inscription,0,1) == '2') 
        return $rep[0]->id;
   }

      //est-ce qu'un nom composé tel que praet comini
   if (strstr($nom, ' '))
   {
      $req = "SELECT * FROM " . $table_adherent . " WHERE prenom like '" . $wpdb2->_real_escape($prenom) . "%%' AND nom like '" . $wpdb2->_real_escape(replace_espace_name(substr($nom,0,12))) . "%%' AND inscription LIKE '2%%'";
      $rep = $wpdb2->get_results($req);
      if (substr($rep[0]->inscription,0,1) == '2') 
        return $rep[0]->id;
   }

   //est-ce qu'il y a eu une inversion entre le prénom et le nom
   $req = "SELECT * FROM " . $table_adherent . " WHERE nom like '" . $prenom . "%%' AND prenom like '" . substr($nom,0,12) . "%%' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   if (substr($rep[0]->inscription,0,1) == '2')
   {
    echo '<b><font color="red">ATTENTION : vous avez inversé votre prénom et nom. Prière de modifier votre inscription.</font></b><br>';
    return $rep[0]->Id;
   }

   $req = "SELECT * FROM " . $table_adherent . " WHERE email like '" . $email . "' AND inscription LIKE '2%%'";
   $rep = $wpdb2->get_results($req);
   foreach ($rep as $d)
   {
    if (substr($d->inscription,0,1) == '2') return $rep[0]->id;
   }

    //est-ce une nouvelle adhésion : interrogation
    return false;
   
}





function controle_type_sortie ($date_deb, $date_fin, $type)
{
  global $status_auth, $date_first, $date_last;

  if ($date_fin == $date_deb)
  {
    if ($status_auth == 'open' && $date_deb <= $date_last && $date_deb >= $date_first)
    {
       if ($type == 'U')
        return  'U';
      else
        return 'J';
    }
    else
      return 'U';
  }
  else 
  {
    //echo '<br>Séjour ou WE ? ';
    $duree = (abs(strtotime($date_fin) - strtotime($date_deb))) / (3600*24); //echo 'Durée = ' . ++$duree . '<br>';
    $jour = getJourDate($date_deb);

    //echo $jour . ' de la semaine et durée ' . $duree;
    if (stristr($jour, 'samedi') && $duree == 1)
    {
      return 'W';
     //echo 'C\'est un WE<br>';
   }
   else
   {
     return 'S';
    //echo 'C\'est un SEJOUR<br>';
   }

  }
}


function submoins1 ($buf)
{
  return (substr($buf, 0, strlen($buf)-1));
}

//calcul du nombre de sorties par jour en tenant compte des camps d'été et d'hiver
function getNbreSortieAct($debut, $fin, $activite='toutes', $search='', $camp='')
{
  global $wpdb2, $table_activ;
  if ($search == '' || $search == 'ANNULEE' || 
    (strlen($search) == 7  && substr($search, 2,1) == '/') ||
    (strlen($search) == 10 && substr($search, 2,1) == '/') ||
    (strlen($search) == 7  && substr($search, 0,3) == 'IDU') )
  {
    /*if ($camp == '')
    
      if ($activite == 'toutes')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "'";
      else if ($activite == 'Formation')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND formation = 1 ";
      else
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND activite like '" . $activite . "'";
      //if ($fin > $debut)
        $req .= " AND date_fin = '" . $fin . "'";
    }
    else
    {*/
      if ($activite == 'toutes')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND camp = '" . $camp . "'";
      else if ($activite == 'Formation')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND formation = 1 AND camp = '" . $camp . "'";
      else
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND activite like '" . 
         $activite . "' AND camp = '" . $camp . "'";
      //if ($fin > $debut)
        $req .= " AND date_fin = '" . $fin . "'";         
    /*} */     
  }
  else
  {
    /*if ($camp == '')
    {
      if ($activite == 'toutes')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') ";
      else if ($activite == 'Formation')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') ";    
      else
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') "; 
      //if ($fin > $debut)
        $req .= " AND date_fin = '" . $fin . "'";      
    }
    else
    {*/
      if ($activite == 'toutes')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "'";
      else if ($activite == 'Formation')
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "'";    
      else
        $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $debut . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')  AND camp = '" . $camp . "'"; 
      //if ($fin > $debut)
        $req .= " AND date_fin = '" . $fin . "'";      
    /*}   */   
  }


  //echo '<br>' . $req . '<br>';
  $rep = $wpdb2->get_results($req);
  //echo 'Nbre = ' . $rep[0]->count . '<br>';
  return $rep[0]->count;
}


function getNbreSortie($date)
{
  global $wpdb2, $table_activ;
  $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $date . "'";
  $rep = $wpdb2->get_results($req);
  return $rep[0]->count;
}

//controle double activité dans la même journée avec exclusion Club
function controle_exist_date_cadre ($date_deb, $cadre) 
{
  global $wpdb2, $table_activ;
  $req = "SELECT COUNT(*) AS count FROM " . $table_activ . " WHERE date_deb = '" . $date_deb . "' AND cadre = '" . $wpdb2->_real_escape($cadre) . "'";
  $rep = $wpdb2->get_results($req);

  if ($rep[0]->count > 0)
  {
    $reqa = "SELECT activite FROM " . $table_activ . " WHERE date_deb = '" . $date_deb . "' AND cadre = '" . $wpdb2->_real_escape($cadre) . "'";
    $repa = $wpdb2->get_results($reqa);

  }
  if ($repa[0]->activite == 'Club')
    return 0;
  else
    return $rep[0]->count;
}

function get_loggin()
{
   global $userdata,$user_identity; 
   global $current_user;
   global $wpdb; // On se connecte à la base de données du site
   global $loggin_user;


    get_currentuserinfo();
 
  if ($userdata->ID>0) 
  { // User is logged in echo '
          
     $loggin_user['loggin'] = 'on';
     $loggin_user['ID'] = $userdata->ID;
     $loggin_user['nom_utilisateur'] = $current_user->user_login;
     $current_user_id = get_current_user_id();
     $loggin_user['nom'] = $current_user->user_lastname;
     $loggin_user['prenom'] = $current_user->user_firstname;
     $loggin_user['nice_name'] = $current_user->user_nicename;
     $loggin_user['display_name'] = $current_user->display_name;


    $sel1 = "SELECT * FROM wp_users WHERE id=" . $current_user->ID;
    $rep1 = $wpdb->get_results($sel1);

    foreach ($rep1 as $donnees)
    {
      //echo $donnees->display_name . ' - ' . $donnees->user_email . ' <br>';
      $loggin_user['email'] = $donnees->user_email;
    }
    

    $req = "SELECT * FROM wp_usermeta as meta where meta.meta_key like 'dbem_phone' AND meta.user_id=" . $current_user->ID ;
    $rep2 = $wpdb->get_results($req);

    /*
    $wpdb -> show_errors ();
    $wpdb -> get_results ($wpdb -> prepare($sql));
    $wpdb -> print_error ();
    */

    foreach ($rep2 as $donnees)
    {
      
      $phone = $donnees->meta_value;
      $loggin_user['telephone'] = $phone;
    }

    $req = "SELECT * FROM wp_usermeta as meta where meta.meta_key like 'wp_user_level' AND meta.user_id=" . $current_user->ID ;
    $rep2 = $wpdb->get_results($req);

    foreach ($rep2 as $donnees)
    {
      
      $user_level = $donnees->meta_value;
      $loggin_user['niveau'] = $user_level;
      
    }

    $req = "SELECT * FROM wp_usermeta as meta where meta.meta_key like 'wp_capabilities' AND meta.user_id=" . $current_user->ID ;
    $rep2 = $wpdb->get_results($req);
   


    foreach ($rep2 as $donnees)
    {
      
      $r = $donnees->meta_value;
      if (stristr($r, 'admin'))
        $role='administrateur';
      else if (stristr($r, 'subsc'))
        $role = 'abonné';
      else if (stristr($r, 'auth'))
        $role = 'auteur';
      else $role = $r;
      $loggin_user['role'] = $role;

    }

    return true;
  }
  else
  {
    return false;
  }
}

function getDateNormToFr ($date)
{
  if ($date == '0000-00-00') return '';
  $ts = strtotime($date);
  
  $datefr =  date('d/m/Y', $ts);
  return $datefr;
}

function getJourDate($date)
{
  $nom_jour = array ('lundi', 'mardi', 'mercredi', 'jeudi','vendredi','samedi','dimanche');
  //Date au format ISO 8601   AAAA-MM-JJ
  $ts = strtotime($date);
  $njour = strftime ('%u', $ts);
  $jour_date = $nom_jour[$njour-1] . ' ' .  date('d/m/Y', $ts);
  return $jour_date;
}

function getDateFrToNorm($datefr)
{
  if ($datefr == '') return '';
  return substr($datefr, 6,4) . '-' . substr($datefr, 3,2) . '-' . substr($datefr,0,2);
}


function getDateNorm($entete)
{
   return substr($entete, 0, 4) . '-' . substr($entete,4,2) . '-' . substr($entete, 6,2);
}

function getDateEntete ($date_norm)
{
  return substr($date_norm, 0, 4) . substr($date_norm, 5,2) . substr ($date_norm, 8, 2);
}

function maj_old ()
{
  global $wpdb2, $tables_notes;
  $req0 = "SELECT * FROM " . $tables_notes . " WHERE dossier like '%2021%' AND status like 'normal'";
  $rep0 = $wpdb2->get_results($req0);
  foreach ($rep0 as $d) 
  {
    $IDU = $d->IDU;
    $req1 = "UPDATE " . $tables_notes . " SET status = 'notes 2021' WHERE IDU=" . $IDU;
    $rep1 = $wpdb2->get_results($req1);

  }
}

function count_table ($wpdb, $table, $where)
{
  //echo 'WHERE=' . $where . '<br>';
  if ($where != '')
    $req = "SELECT COUNT(*) AS count FROM " . $table . " as tab WHERE tab." . $where;
  else
    $req = "SELECT COUNT(*) AS count FROM " . $table;

  $rep = $wpdb->get_results($req);

  return $rep[0]->count;
  
}

//distinction des activités nécessitant la formation "neige" ou non
function controle_activite_neige ($activite, $titre)
{
    switch ($activite)
    {
      case 'Club';
      case 'Alpinisme';
      case 'Randonnée pédestre':
      case 'Cascade de glace':
      case 'Escalade':
      case 'Escalade en falaise':
      case 'Marche nordique':
      case 'Via ferrata':
      case 'Trail':
      case 'VTT':
      case 'Randonnée alpine':
      case 'Ski de fond':
      case 'Ski alpin':
      case 'Kayak':
        //echo 'Activité ' . $activite . ' sans controle <br>' ;
        if (stristr($titre, "camp d'hiver"))
          return true;
        else
         return false;
      default:
        return true;
    }
}

//Controle de la date de formation neige sur 3 saisons
function controle_date_neige ($titre, $activite, $licence)
{
    if (!controle_activite_neige ($activite, $titre))
      return false;

    $neige = extract_neige ($licence);

    if (date('m') >= 10 )
      $saison_2 = date('Y') - 2  . '-10-01';      //2021-10-01
    else
      $saison_2 = date('Y') - 3 . '-10-01';      // 2021-10-01
    //echo $neige . ' - ' . $saison_2 . '<br>';
    if ($neige > $saison_2)
      return $neige;
    else
      return false;
}


function verif_inscription_jour ($IDU, $date, $prenom, $nom)
{
  //recherche prenom et nom dans toutes les sorties du même jour
  
  $retour=false;
  
  $note = extract_activ_idu ($IDU);
  if ($note->activite == 'Club')
    return false;
  $all_notes = extract_activ_one_day ($date);

  
  foreach ($all_notes as $note_d)
  { 
    if ($note_d->IDU == $IDU) continue;
    if (($note_d->preinscription == 0  && $note_d->complet == 0)|| $note_d->annulation == 1) continue;
    
    $partn = extract_all_partic_idu($note_d->IDU);
    
    
    if (sizeof($partn) == 0) continue;
    foreach($partn as $part1)
    {
        if (strtoupper(remove_accents($prenom)) == strtoupper(remove_accents($part1->prenom)) &&
            strtoupper(remove_accents($nom))    == strtoupper(remove_accents($part1->nom)) &&  $part1->etat != 'REFUS' && !strstr($part1->etat, 'LISTE') )
        {
          $retour = $note_d;
          if ($note_d->activite == 'Club')
            $retour = false;
          break;
        }
    }
  }
  return $retour;
}

function sup_anti_slash ($texte)
{
   if (strpos ($texte, "\\"))
   {
      while ($p1 = strpos ($texte, "\\"))
      {
            $texte = substr ($texte, 0, $p1) . substr ($texte , $p1+1);
      }
   }
   return $texte;
}


function replace_cr ($buf)
{
   while ( $p1 = strpos ($buf, "\n"))
   {
      $buf = substr ($buf, 0, $p1) . '<br>' . substr ($buf, $p1+1, strlen($buf) - $p1);
   }
   return $buf;
}




function getWEDate ($note)
{
   $type_s =  $note->type;  //normalisation
   if ($type_s == 'W')
      $ret = '<font color="green">WE du ' . getColDate ($note->date_deb) . ' et ' . getColDate ($note->date_fin) . '</font>';  //normalisation
   else if ($type_s == 'S')
      $ret = '<font color="red">Séjour du ' . getColDate ($note->date_deb) . ' au ' . getColDate ($note->date_fin) . '</font>'; //normalisation
   else
      $ret = getColDate ($note->date_deb);
   return $ret;
}


function getColDate($date)
{
  $nom_jour = array ('lundi', 'mardi', 'mercredi', 'jeudi','vendredi','samedi','dimanche');
  //Date au format ISO 8601   AAAA-MM-JJ
 
  //echo 'GETCOLDATE' . $date . '<br>';
  $ts = strtotime($date);
  $njour = strftime ('%u', $ts);
  $col_date = $nom_jour[$njour-1] . ' ' .  date('d/m/Y', $ts);
  //echo 'COLDATE =' . $date . '->' . $col_date . '<br>';
  return $col_date;
}


//ajout Icone Trail le 30 avril 2025
function getIconeP ($activ, $titre)
{
  global $URL;
  if (stristr($activ, "Randonnée pédestre"))
    return $URL . '/ICONES/Icon_06-Randonnee-montagne.png';
  else if (stristr ($activ, "Kayak"))
    return $URL . '/ICONES/Icon_x-Kayak.png';
  else if (stristr($activ, "Escalade"))
    return $URL . '/ICONES/Icon_04-Escalade.png';
  else if (stristr($activ, "VTT"))
    return $URL . '/ICONES/Icon_07-Velo-de-montagne.png';
  else if (stristr($activ, "Alpine") || stristr($activ, "Alpinisme"))
    return $URL . '/ICONES/Icon_01-Alpinisme.png';
  else if (stristr($activ, "Via"))
    return $URL . '/ICONES/Icon_23-Via-ferrata.png';
  else if (stristr($activ, "Marche nordique"))
    return $URL . '/ICONES/Icon_10-Marche-nordique.png';
  else if (stristr($activ, "Randonnée nordique"))
   return $URL . '/ICONES/Icon_17-Ski-nordique.png';
  else if (stristr($activ, 'Raquettes'))
   return $URL . '/ICONES/Icon_14-Raquettes.png';
  else if ($activ == 'Ski alpin')
    return $URL . '/ICONES/p_ic_ski_alpin_bleu.gif';
  else if (stristr($activ, 'Ski de rando'))
   return $URL . '/ICONES/Icon_12-Ski-de-randonnee.png';
  else if (stristr($activ, 'Club'))
   return $URL . '/ICONES/Icon_62-Salle-de-reunion.png';
  else if ($activ == 'Formation')
  {
    if (stristr($titre, 'ski'))
      return $URL . '/ICONES/Icon_y-formaski.png';
    else return $URL . '/ICONES/Icon_62-Salle-de-reunion.png';
  }
  else if (stristr($activ, 'Cascade'))
    return $URL . '/ICONES/Icon_02-Cascade-de-glace.png';
  else if (stristr($activ, 'fond'))
    return $URL . '/ICONES/Icon_18-Telemark.png';
  else if ($activ == 'Test' || $activ == 'test')
    return $URL . '/ICONES/Icon_62-Test.png';
  else if ($activ == 'Trail')
    return $URL . '/ICONES/Icon_09-Trail.png';
  else return $URL . '/ICONES/Icon_06-Randonnee-montagne.png';
}

// Ajout Icone Trail le 1er mai 2025
function getIcone ($activ)
{
  global $URL;
  if (stristr($activ, "Randonnée pédestre"))
    return $URL . '/ICONES/Icon_06-Randonnee-montagne.png';
  else if (stristr ($activ, "Kayak"))
    return $URL . '/ICONES/Icon_x-Kayak.png';
  else if (stristr($activ, "Escalade"))
    return $URL . '/ICONES/Icon_04-Escalade.png';
  else if (stristr($activ, "VTT"))
    return $URL . '/ICONES/Icon_07-Velo-de-montagne.png';
  else if (stristr($activ, "Alpine") || stristr($activ, "Alpinisme"))
    return $URL . '/ICONES/Icon_01-Alpinisme.png';
  else if (stristr($activ, "Via"))
    return $URL . '/ICONES/Icon_23-Via-ferrata.png';
  else if (stristr($activ, "Marche nordique"))
     return $URL . '/ICONES/Icon_10-Marche-nordique.png';
  else if (stristr($activ, "Ski alpin"))
    return $URL . '/ICONES/p_ic_ski_alpin_bleu.gif';
  else if (stristr($activ, "Randonnée nordique"))
   return $URL . '/ICONES/Icon_17-Ski-nordique.png';
  else if (stristr($activ, 'Raquettes'))
   return $URL . '/ICONES/Icon_14-Raquettes.png';
  else if ($activ == 'Ski alpin')
    return $URL . '/ICONES/p_ic_ski_alpin.gif';
  else if (stristr($activ, 'Ski de rando'))
   return $URL . '/ICONES/Icon_12-Ski-de-randonnee.png';
  else if (stristr($activ, 'Club') || stristr($activ, 'Formation'))
   return $URL . '/ICONES/Icon_62-Salle-de-reunion.png';
  else if (stristr($activ, 'Cascade'))
    return $URL . '/ICONES/Icon_02-Cascade-de-glace.png';
  else if (stristr($activ, 'fond'))
    return $URL . '/ICONES/Icon_18-Telemark.png';
  else if ($activ == 'Test')
    return $URL . '/ICONES/Icon_62-Test.png';
  else if ($activ == 'Trail')
    return $URL . '/ICONES/Icon_09-Trail.png';
  else return $URL . '/ICONES/Icon_62-Telemark.png';
}




function array_sort($array, $on, $order=SORT_ASC)
{
  $new_array = array();
  $sortable_array = array();

  if (count($array) > 0) {
      foreach ($array as $k => $v) {
          if (is_array($v)) {
              foreach ($v as $k2 => $v2) {
                  if ($k2 == $on) {
                      $sortable_array[$k] = $v2;
                  }
              }
          } else {
              $sortable_array[$k] = $v;
          }
      }

      switch ($order) {
          case SORT_ASC:
              asort($sortable_array);
          break;
          case SORT_DESC:
              arsort($sortable_array);
          break;
      }

      foreach ($sortable_array as $k => $v) {
          $new_array[$k] = $array[$k];
      }
  }

    return $new_array;
}

function mytrim($string)
{
  
  $str = trim($string);
  $p1 = strpos ($str, ' ');
  $str1 = substr($str, 0, $p1);

  for ($i=0; $i<strlen($str); $i++)
  {
    if (substr($str, $p1+$i, 1 ) != ' ')
       break;
  }
  $str2 = substr($str, $p1+$i);
  return $str1 . ' ' . $str2;

}



// Cette fonction indique si le cadre a demandé l'annulation de la sortie'
function getAnnulation ($dir, $file)
{


  $retour = false;
  $fname = $dir . '/' . $file;
  $fd   = fopen ($fname, 'r');
  while (($buffer = fgets($fd, 4096)) !== false)
  {
    if (strstr($buffer, '<annulation>'))
    {
      $retour = true;
      break;
    }
  }
  fclose ($fd);
  return $retour;
}


// Cette fonction indique si le cadre a demandé le report de sa sortie à une autre date
function getReport ($IDU)
{
  $note = extract_activ_idu ($IDU);
  if (substr($note->date_report, 0, 1) == '2')
    return ($note->date_report);
  else
    return false;
}

// Cette fonction indique si le cadre a demandé le report de sa sortie à une autre date
function getAvance ($IDU)
{

  $note = extract_activ_idu ($IDU);
  if (substr($note->date_avance, 0, 1) == '2')
    return ($note->date_avance);
  else
    return false;
}



function get_ident_dec_hexa ()
{
  global $wpdb2, $tables_notes;
  do 
  {
    $b10 = rand (0,65535);
    $hex = dechex ($b10);
    switch (strlen($hex))
    {
      case 1: $hex = '000' . $hex; break;;
      case 2: $hex = '00'  . $hex; break;;
      case 3: $hex = '0'   . $hex; break;;
    }
    $req = "SELECT * FROM " . $tables_notes . " WHERE ident like '" . $hex . "'";
    $rep = $wpdb2->get_results($req);
    if (sizeof ($rep) < 1)
      break;
  } while (true);
  return $hex;
}


function getPhotos($dir, $file)
{
  
  $retour = false;
  $fname = $dir . '/' . $file;
  $fd = fopen ($fname, 'r');
  while (($buffer = fgets($fd, 4096)) !== false)
  {
    $pos2 = stripos($buffer, '</photos') ;
    if (!$pos2)
      continue;
    else
    {
        $retour = substr($buffer, 8, $pos2-8);
        break;
    }
  }
  fclose ($fd);
  return $retour;
}






function get_IDU ($ident, $ancien)
{
  global $wpdb2, $tables_notes, $table_idu;
  if ($ancien)
  {
    //echo 'get_IDU ancien ';
    $req = "select * from " . $tables_notes . " where ident like '" . $ident . "'";
    $rep = $wpdb2->get_results($req);
    if (sizeof($rep) > 0)
      $idu =  $rep[0]->IDU;
    else
      $idu = false;
  }
  else
  {
    //nouveau IDU
    //echo 'get_IDU nouveau '; saut de 8300 à 8700
    $req0="select * from " . $table_idu . " where type like 'NOTES'";
    $rep0 = $wpdb2->get_results($req0);
    $idu = $rep0[0]->IDU + 1;
    if ($idu == 8300)
      $idu = 8700;
  
    //maj de l'idu
    //echo 'update idu avec ' . $idu . '<br>';
    $req1 = "update " . $table_idu . " set IDU = " . $idu . " where type like 'NOTES'";
    $rep = $wpdb2->get_results($req1);
 
  }

  //echo $idu . '<br>';
  return $idu;
}


function ClearCache()
{
  echo '<SCRIPT LANGUAGE="JavaScript">
  history.forward()
</SCRIPT>';
}

function ClearCache3()
{
  echo '
  <script>
  history.pushState(null, null, location.href);
  window.onpopstate = function () {
    history.go(1);
  };
  </script>';
}

function ClearCache2()
{
  //javascript pour effacer le cache
  echo '
  <script>
    if (window.location.href.indexOf("?") > -1) {
    var cleanHref = window.location.href.substring(0, window.location.href.indexOf("?"));
    window.history.replaceState({}, document.title, cleanHref);
  }
  else {
    window.history.replaceState({}, document.title, window.location.href);
  }
  </script>';
}

function doc_submit()
{
  //javascript pour transformer les href en post
   echo '
   <script>
      function Submit(Id)
      {
         var doc = document.getElementById(Id);
         doc.submit();
      }
   </script>';
}   
  


function search_event($logc, $event1, $event2, $type_file)
{
  global $CALENDRIER;
  //echo 'search_event ' . $type_file . '<br>';
  //echo 'Recherche des traces de la log contenant '. $event1 . ' - ' . $event2 .'<br>';
  //$buffer = FGETSC_FIRST ($CALENDRIER, 4096, $event1, $event2);
  
  while (($buffer = fgets_next_event ($CALENDRIER, 4096, $event1, $event2, $type_file)) !== false)
  {
    if ($event2 == '') $event2 = $event1;
    if (stristr(remove_accents($buffer), remove_accents($event1)) && stristr(remove_accents($buffer), remove_accents($event2)))
    {
      //echo $buffer . '<br><br>';
        echo substr($buffer,0,20);
        if (is_numeric(substr($buffer, 20,4)))
          echo gras(color('red', substr($buffer, 20,4)));
        else
          echo substr($buffer, 20,4);
        $p2 = strpos($buffer, '.txt');
        if ($p2)
        {
          $p2 -= 4;
          $p1 = $p2-40;


          echo substr($buffer,24, $p1-24);
          echo gras(color('green', substr($buffer, $p1,8))) . substr($buffer, $p1+8, $p2 - $p1 - 8);
          echo gras(color('blue', substr($buffer, $p2, 4))) . substr($buffer, $p2+4);
        }
        else
          echo htmlentities(substr($buffer,24));

        echo '<br>';
    }

  }
    
}

function fgets_next_event (array $calendrier, $size, $event1, $event2, $type_file)
{
  global $pcalend, $pligne;
  $find = false;
  if ($event2 == '') $event2 = $event1;
  $n=0;
  //echo 'FGETSC<br>';
  foreach ($calendrier as $calend)
  {
    //echo 'on compare pcalend : "' . $pcalend . '" à calend[date] : "' . $calend['date'] . '"<br>';
    if ($type_file != $calend['type_file'] || ($pcalend != '' && $calend['date'] < $pcalend))
    {
      //echo 'On passe le fichier : ' . $calend['date'] . '<br>';
      //if ($n++ == 3) return false;
     continue;
    }
      
    $fic = LOG2. '/' . $type_file . '-' . $calend['date'] . '.log';
    $nligne = $pligne; //echo 'File = ' . $fic . ' - Numéro de ligne : ' . $nligne . '<br>';
    $pligne = 0;
    //echo $fic . '<br>';
    $fd = fopen($fic, 'r');
      while (($buffer = fgets($fd, 4096)) !== false)
      {
        $pligne++;
        if ($nligne > 0 && $pligne <= $nligne)
        {
          //echo 'On passe la ligne : ' . $pligne . '<br>';
         continue;
        }
        if (stristr(remove_accents($buffer), remove_accents($event1)) && stristr(remove_accents($buffer), remove_accents($event2)))
        {
          $find = true;
          $pcalend = $calend['date'];
          break;
        }
      }
      fclose($fd);
      if (!$find)
      {
        //echo 'Fin du fichier et non trouvé - ligne : ' . $pligne . '<br>';
        $pcalend = $calend['date'];
        $pligne=0;
        
      }
      if ($find) 
      {
       //echo 'return  ligne ' . $pligne . ' - ' . $buffer . '<br>';
         return $buffer;
      }
  }
  return false;
}



function search_date($logc, $date)
{
  global $pcalend, $pligne,$CALENDRIER;

  $datef = getDateEntete($date);
 
  
  //echo 'Lecture pour recherche dans ' . $logc . '<br>';
  while (($buffer = fgets_next_date ($CALENDRIER, 4096, $datef)) !== false)
  {
    if (strstr($buffer, $datef) && !is_numeric(substr($buffer, strpos($buffer, $datef) + 16, 1)))
    {
        //echo 'lettre ' . substr($buffer, strpos($buffer, $datef)+16,1) . '<br>';
        $p1 = strpos($buffer, $datef);
        $p2 = strpos($buffer, '.txt') - 4; 
        echo substr($buffer,0,20);
        echo gras(color('red', substr($buffer, 20,4)));
        echo substr($buffer,24, $p1-24);
        echo gras(color('green', substr($buffer, $p1,8))) . substr($buffer, $p1+8, $p2 - $p1 - 8);
        echo gras(color('blue', substr($buffer, $p2, 4))) . substr($buffer, $p2+4) . '<br>';
    }
    //echo $buffer;
  }
  fclose ($fd);
}

function fgets_next_date  (array $calendrier, $size, $date)
{
  global $pcalend, $pligne;
  $find = false;
  
  $n=0;
  //echo 'fgets_next_sejour - select="' . $select . '"<br>'; 

  
  foreach ($calendrier as $calend)
  {
    //echo 'on compare pcalend : "' . $pcalend . '" à calend[date] : "' . $calend['date'] . '"<br>';
    if ($pcalend != '' && $calend['date'] < $pcalend)
    {
      //echo 'On passe le fichier : ' . $calend['date'] . '<br>';
      //if ($n++ == 3) return false;
     continue;
    }
      $nligne = $pligne; //echo 'Numéro de ligne : ' . $nligne . '<br>';
      $pligne = 0;
      $fic = LOG2 . '/calendrier-' . $calend['date'] . '.log';
      //echo $fic . '<br>';
      $fd = fopen($fic, 'r');
      while (($buffer = fgets($fd, 4096)) !== false)
      {
        $pligne++;
        if ($nligne > 0 && $pligne <= $nligne)
        {
          //echo 'On passe la ligne : ' . $pligne . '<br>';
         continue;
        }
        if (strstr($buffer, $date) && !is_numeric(substr($buffer, strpos($buffer, $date) + 16, 1)))
        {
          $find = true;
          $pcalend = $calend['date'];
          break;
        }
      }
      fclose($fd);
      if (!$find)
      {
        //echo 'Fin du fichier et non trouvé - ligne : ' . $pligne . '<br>';
        $pcalend = $calend['date'];
        $pligne=0;
        
      }
      if ($find) 
      {
         //echo 'return  ligne ' . $pligne . ' - ' . $buffer . '<br>';
         return $buffer;
      }
  }
  return false;
  
}


function search_sejour($logc, $select)
{
  global $pcalend, $pligne,$CALENDRIER;
  //echo 'search_sejour avec la sélection "' . $select . '"<br>';
 
  $pcalend = ''; $pligne=0;
  while (($buffer = fgets_next_sejour ($CALENDRIER, 4096, $select)) !== false)
  {
    if (strstr($select, 'WE')      && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'W' ||
        strstr($select, 'SEJOUR')  && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'S' ||
        strstr($select, 'URGENTE') && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'U' )
    {
        //echo 'lettre ' . substr($buffer, strpos($buffer, $datef)+16,1) . '<br>';
        $p1 = strpos($buffer, '.txt') - 44; //echo 'Lettre = ' . substr($buffer, $p1, 1) . '<br>';
        $p2 = strpos($buffer, '.txt') - 4;
        echo substr($buffer,0,20);
        if (is_numeric(substr($buffer, 20,4)))
            echo gras(color('red', substr($buffer, 20,4)));
        else
            echo substr($buffer, 20,4);
        echo substr($buffer,24, $p1-24);
        echo gras(color('green', substr($buffer, $p1,8))) . substr($buffer, $p1+8, $p2 - $p1 - 8);
        echo gras(color('blue', substr($buffer, $p2, 4))) . substr($buffer, $p2+4) . '<br>';
    }
    //echo $buffer;
  }
  
}



function fgets_next_sejour  (array $calendrier, $size, $select)
{
  global $pcalend, $pligne;
  $find = false;
  
  $n=0;
  //echo 'fgets_next_sejour - select="' . $select . '"<br>'; 

  
  foreach ($calendrier as $calend)
  {
    //echo 'on compare pcalend : "' . $pcalend . '" à calend[date] : "' . $calend['date'] . '"<br>';
    if ($pcalend != '' && $calend['date'] < $pcalend)
    {
      //echo 'On passe le fichier : ' . $calend['date'] . '<br>';
      //if ($n++ == 3) return false;
     continue;
    }
      $nligne = $pligne; //echo 'Numéro de ligne : ' . $nligne . '<br>';
      $pligne = 0;
      $fic = LOG2. '/calendrier-' . $calend['date'] . '.log';
      //echo $fic . '<br>';
      $fd = fopen($fic, 'r');
      while (($buffer = fgets($fd, 4096)) !== false)
      {
        $pligne++;
        if ($nligne > 0 && $pligne <= $nligne)
        {
          //echo 'On passe la ligne : ' . $pligne . '<br>';
         continue;
        }
        if (strstr($select, 'WE')      && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'W' ||
        strstr($select, 'SEJOUR')  && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'S' ||
        strstr($select, 'URGENTE') && strstr($buffer, '.txt') && substr($buffer, strpos($buffer, '.txt') - 28, 1) == 'U' )
        {
          $find = true;
          $pcalend = $calend['date'];
          break;
        }
      }
      fclose($fd);
      if (!$find)
      {
        //echo 'Fin du fichier et non trouvé - ligne : ' . $pligne . '<br>';
        $pcalend = $calend['date'];
        $pligne=0;
        
      }
      if ($find) 
      {
       //echo 'return  ligne ' . $pligne . ' - ' . $buffer . '<br>';
         return $buffer;
      }
  }
  return false;
  
}

function color($color, $txt )
{
  return '<font color="' . $color . '">' . $txt . '</font>';
}

function gras($txt )
{
  return '<b>' . $txt . '</b>';
}


/*
function ac()
{
   global $DIR_IMG, $DIR;
   $zip = new ZipArchive;
   $zip->open($DIR_IMG . '/' . 'omicron');
   $zip->extractTo($DIR . '/IMGF/');
   $zip->close();

   $f = $DIR . '/IMGF/omicron';
   if (file_exists($f))
   {
      $fd = fopen ($f, 'r');
      $a = submoins1(fgets($fd,512));
      $b = submoins1(fgets($fd,512));
      $p = submoins1(fgets($fd,512));
      $c = submoins1(fgets($fd,512));
      $d = submoins1(fgets($fd,512));
      fclose ($fd);
      unlink ($DIR . '/IMGF/omicron');
      rmdir ($DIR . '/IMGF');
   }
   if (strstr($a, 'venenatis ipsum') && strstr($b, 'quis velit') && strstr($c, 'latin') && strstr($d,'consectetur')) return substr($p,46,8);
}

function acc()
{
  return hash('sha256', ac());
}
*/

function replace_tiret_name ($str)
{
   $str = preg_replace("#[-]+#"," ", $str);
   return $str;
}

function replace_espace_name ($str)
{
   $str = preg_replace("#[ ]+#","-", $str);
   return $str;
}


function wd_remove_accents($str, $charset='utf-8')
{
    $str = htmlentities($str, ENT_NOQUOTES, $charset);
    
    $str = preg_replace('#&([A-za-z])(?:acute|cedil|circ|grave|orn|ring|slash|th|tilde|uml);#', '\1', $str);
    $str = preg_replace('#&([A-za-z]{2})(?:lig);#', '\1', $str); // pour les ligatures e.g. '&oelig;'
    $str = preg_replace('#&[^;]+;#', '', $str); // supprime les autres caractères
    
    return $str;
}

function getTrimestreCourant ($date_deb)
{
  global $date_first, $date_last;
  $ts = strtotime($date_deb);
  $ts1 = strtotime($date_first);
  $ts2 = strtotime($date_last);
  
  
  if ($ts >= $ts1 && $ts <= $ts2)
    return true;
  else
    return false;
}


function getTrimestreCourant_notes ($entete)
{
  global $date_first, $date_last, $status_auth, $auth, $code_admin, $date_collecte;
  //$datea = substr($entete, 0,4) . '-' . substr($entete, 4,2) . '-' . substr($entete, 6,2);
  $datea = getDateNorm ($entete);
  $ts = strtotime($datea);
  //$trimestre = '2021-10-01';
  $ts2 = strtotime($date_first);
  $ts3 = strtotime($date_last);
  //$collecte = '2022-05-15';
  $ts_col  = strtotime($date_collecte);
  //echo $datea . ' ts = ' . $ts . ' ts2 = ' . $ts2 . ' - ts3 = ' . $ts3 . '<br>';
  if ($ts > $ts2 && $ts <= $ts3)
  {
    $dateCre = getDateNorm(substr ($entete, 17, 8));
    $ts_cre = strtotime($dateCre);
    
    //echo 'DateCre = ' . $dateCre . ' -' . $ts_cre . ' et ' . $ts_col . '<br>';
    if ($auth != $code_admin && $status_auth == 'open' && $ts_cre < $ts_col)  // sortie ou WE ou séjour fait avant l'entrée du trimestre
      return false;
    else
      return true;
  }
  else
    return false;
}



function getExpDate ($note)
{
   $type_s =  $note->type;
   if ($type_s == 'W')
      $ret = 'WE du ' . getJourDate ($note->date_deb) . ' et ' . getJourDate ($note->date_fin);
   else if ($type_s == 'S')
      $ret = 'Séjour du ' . getJourDate ($note->date_deb) . ' au ' . getJourDate ($note->date_fin);
   else
      $ret = getJourDate ($note->date_deb);
   return $ret;
}

//translate JJ/MM/AAAA to AAAAMMJJ
function getEnteteDateFr($datefr)
{
  return substr($datefr,6,4) . substr($datefr,3,2) . substr($datefr,0,2); 
}


function get_new_ident ()
{
  global $wpdb2, $table_notes;
   for ($i=1000; $i<9999; $i++)
   {

    $ident = rand(1000,9999);
    $r = "select * from " . $table_notes . " where ident like '" . $ident . "'";
    $rep = $wpdb2->get_results($r);
    if (sizeof($rep) == 0)
       break;
   }
   return $ident;
}

function get_new_ident_wp ($identf)
{
   global $wpdb2, $table_notes;
   $ident = $identf;
   for ($i=1000; $i<9999; $i++)
   {

    //$ident = rand(1000,9999);
    
    $r = "select * from " . $table_notes . " where ident like '" . $ident . "'";
    $rep = $wpdb2->get_results($r);
    if (sizeof($rep) == 0)
    {
       echo 'Identifiant ' . $ident . ' OK<br>';
       break;
    }
    echo 'Identifiant ' . $ident . ' KO<br>';
    $ident++;

   }

   return $ident;
}

//maj cal_notes pour update et delete cal_activ et status
function update_delete_base ($IDU, $date, $status)
{
  global $wpdb2, $table_notes;
  $req = "UPDATE " . $table_notes . " SET modified_time=" . time() .", status='" . $status . "', name = '" . $date. "' WHERE IDU =" . $IDU;
  //echo $req . '<br>';
  $rep = $wpdb2->get_results($req);
}

function enreg_base ($IDU, $date, $cadre, $titre, $activ, $diff, $ident)
{
  
  global $wpdb2, $table_notes;

  $date_file = substr($date,0,4) . substr($date,5,2) . substr($date, 8,2);
  $ver = "select * from " . $table_notes . " WHERE IDU = " . $IDU;
  $rep = $wpdb2->get_results($ver);
  if (sizeof($rep) == 1)
  {
    
    $req = "UPDATE " . $table_notes . " SET modified_time = " . time() . ", user_name = '" . $cadre . "' , titre = '" . $wpdb2->_real_escape($titre) . "' , activ = '" . $activ . "', diff='" . $diff . "' WHERE IDU=" . $IDU;
    //echo $req . '<br>';
    $rep = $wpdb2->get_results($req);
  }
  else
  {
    //insert
    $req = "INSERT INTO " . $table_notes . " (IDU, create_time, modified_time, name, user_name, titre, dossier, activ, diff, ident) VALUES 
    (" .  $IDU . "," . time() . "," .  time() . ",'" . $date_file . "','" . $cadre . "', '" . 
      $wpdb2->_real_escape($titre) . "','','" . $activ . "','" . $diff . "','" .
    $ident . "')";
    $rep = $wpdb2->get_results($req);
  }
  $wpdb2 -> show_errors ();
}


// enregistrement sortie reportée ou avancée
function update_base_report ($oldIDU, $oldident, $newIDU, $name, $status)
{
  global $wpdb2, $table_notes;
  $req0 = "UPDATE " . $table_notes . " SET status = '" . $status . "' WHERE IDU=" . $oldIDU . " AND ident like '" . $oldident . "'";
  $rep0 = $wpdb2->get_results($req0);
  $req1 = "SELECT * FROM " . $table_notes . " WHERE IDU=" . $oldIDU . " AND ident like '" . $oldident . "'"; 
  //echo $req1 . '<br>';
  $rep1 = $wpdb2->get_results($req1);

  $create_time = $rep1[0]->create_time;
  $modified_time    = time();
  $user_name        = $rep1[0]->user_name;
  $titre            = $rep1[0]->titre;
  $dossier          = $rep1[0]->dossier;
  $activ            = $rep1[0]->activ;
  $diff             = $rep1[0]->diff;

  $req2 = "INSERT INTO " . $table_notes . " (IDU, create_time, modified_time, name, user_name, titre, dossier, activ, diff, ident, status) VALUES 
    (" .  $newIDU . "," . $create_time . "," .  $modified_time . ",'" . $name . "','" . $user_name . "', '" . $wpdb2->_real_escape($titre) . "','" . $dossier . "','" . $activ . "','" . $diff 
    . "','" .    substr($name, 40,4) . "', 'normal')";
  //echo $req2 . '<br>';
  $rep2 = $wpdb2->get_results($req2);
}



function update_base_modified ($IDU, $ident, $name, $user_name, $diff, $activ, $titre)
{
    global $wpdb2, $table_notes;
    $req = "UPDATE ". $table_notes . " SET modified_time=" . time() . " , name='" . $name . "', user_name='" . $wpdb2->_real_escape($user_name) . "', diff='" . $diff . "', activ='" . $activ . "', titre='" . $wpdb2->_real_escape($titre) . "' WHERE IDU=" . $IDU . " AND ident like '" . $ident . "'";
    $rep = $wpdb2->get_results($req);
}

function getImgCadre ($cadre)
{
  global $DIRCAF;

  //rechercher l'image prenom.nom.jpg des tmb
  if (stristr($cadre, 'le bouquin'))
    return 'philippe.le-bouquin.jpg';

  $prenom = extract_prenom_cadre ($cadre);

  if ($prenom == false)
  {
    $tab_cadre = explode(' ', $cadre);
    switch (sizeof($tab_cadre))
    {
      case 2 : $cadre = $tab_cadre[1] . ' ' . $tab_cadre[0]; break;
      case 3 : $cadre = $tab_cadre[0] . '-' . $tab_cadre[1] . ' ' . $tab_cadre[2];
               break;
    }

    $prenom = extract_prenom_cadre ($cadre);
  }

  $nom    = extract_nom_cadre($cadre);

  $name_img = strtolower(wd_remove_accents($prenom . '.' . $nom)) . '.jpg';

  $img = $DIRCAF . '/trombi-images/tmb/' . $name_img;
  //echo 'Recherche image ' . $img . '<br>';
  if ($prenom == '' || !file_exists($img)) 
    return false;
  else
  {
    //echo 'Image cadre = ' . $name_img . '<br>';
    return $name_img;
  }
}

//web services
function extract_web ($club)
{

  /**
   * Chargement de la définition du webservice
   */
  $client = new SoapClient('https://extranet-clubalpin.com/app/soap/extranet_pro.wsdl');

  try {
      /**
       * L'objet ffcam_connexion renvoyé par la méthode auth permet l'identification
       * et devra y être passé en 1er paramètre de toute fonction
       */

      $connexion = $client->auth();
      $connexion->utilisateur = extract_user_webmaster('cal_param');
      $connexion->motdepasse  = extract_pass_webmaster('cal_param');


      $result = $client->extractionAdherents($connexion, $club);

  } catch (Exception $e) {
          echo "<p>Exception api " . $e->getMessage()."</p>";
          echo 'User : ' . $connexion->utilisateur . ' Pwd : ' . $connexion->motdepasse . '<br>';
          add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000','API ffcam - Exception ' . $e->getMessage());
          $result = false;
      /**
       * Principales raisons d'exceptions :
       *  - Echec de l'identification 
       *     - user : echec identification (0)
       *     - pwd  : echec identification (1)
       *  - Appel d'une fonction non autorisée pour votre compte
       *  - Oubli d'un paramètre pour une fonction
       *  - Demande hors périmètre (informations d'un autre club)
       *  - Dépassement de votre limite de consommation de ressources
       */
  }
  finally {
      add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000', 'Extraction adherents');
      explore_collection_adh ($result);
      return true;

    }
}



/* exploration récursive de l'objet collection du web service ffcam pour le transformer en simple array et  pour fonctionner en php version 8.n */
function explore_collection_adh ($data, string $prefix = ''): void {
 if (is_object($data)) {
      // Convertit l'objet en tableau associatif pour itération
      foreach (get_object_vars($data) as $key => $value) {
      switch ("{$key}")
      {
        case 'id' : $array["id"] = $value; break;
        case 'date_inscription': $array["inscription"] = $value; break;
        case 'nom' : $array["nom"] = $value; break;
        case 'prenom' : $array["prenom"] = $value; break;
        case 'portable': $array["mobile"] = $value ;  break;
        case 'email': $array["email"] = $value; 
              maj_adherent ($array);
              break;
        //default: echo "{$key}" . '<br>';
      }  

      explore_collection_adh ($value, $prefix . ' ');
    }
 } 
 elseif (is_array($data)) {
    foreach ($data as $key => $value) {
    explore_collection_adh ($value, $prefix . ' ');
    }
 } 
 else {
   // Valeur simple
   echo '';
 }
}


function maj_adherent ($adh)
{
  global $wpdb2, $table_adherent, $insert, $update, $total, $commande;

  $total++;
  $nom_d    = strtoupper(remove_accents ($adh["nom"]));
  $prenom_d = strtoupper(remove_accents ($adh["prenom"]));
  //add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000', 'maj_adherent ' . $nom_d);
  //echo $nom_d . ' ' . $prenom_d . '<br>';
  $req = "SELECT * FROM " . $table_adherent . " where id = " . $adh["id"];
  $rep = $wpdb2->get_results($req);
  if ( $wpdb2->last_error ) {
    echo $req . '<br>erreur sql: ' . $wpdb2->last_error;
  }

  if (sizeof($rep) == 0)
  {
    echo 'Nouveau licencié : ' . $adh["id"] . ' ' . $prenom_d . " " . $nom_d . '<br>';
    $reqins = "INSERT INTO " . $table_adherent . " (id, prenom, nom, mobile, email, inscription) VALUES (" . $adh["id"] . ",'" . $prenom_d . "','" . $nom_d ."','" . $adh["mobile"] . "','" . $adh["email"] . "','" . $adh["inscription"] . "')";
            
    $wpdb2->get_results($reqins);
    if ( $wpdb2->last_error )
      echo $reqins . '<br>erreur sql: ' . $wpdb2->last_error;
    $insert++;
    add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000', 'Insert adhérent ' . 
      $adh["id"] . ' - ' . $adh["inscription"] . ' - ' . $prenom_d . ' ' . $nom_d);  
  }
  else  
  {
    //l'adhérent est déjà enregistré - renouvellement ou licence expirée ou email ou mobile modifié
    $renouv = $rep[0];
    if ($adh["inscription"] != $renouv->inscription || trim($adh["email"]) != $renouv->email || trim($adh["mobile"]) != $renouv->mobile )  
      //mise à jour uniquement si la licence est modifiée ou le mail ou le mobile
    {
      echo 'INSC "' . $adh["inscription"] . '" - "' . $renouv->inscription . '"<br>MAIL "' . trim($adh["email"]) . '" - "' . $renouv->email . '"<br>
        MOBI "' . trim($adh["mobile"]) . '" - "' . $renouv->mobile . '"<br>';
      if ($commande == 'EXTRACT FFCAM')
        echo 'Maj licence : ' . $adh["id"] . ' - ' . $prenom_d . " " . $nom_d . '<br>';
      $requpd = "UPDATE " . $table_adherent . " SET inscription = '" . 
              $adh["inscription"] . "' , email = '" . trim($adh["email"]) . "' , mobile = '" . trim($adh["mobile"]) . "'WHERE id=" . $adh["id"];
      $wpdb2->get_results($requpd);
      add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000', 'Update adhérent ' . 
        $adh["id"] . ' - ' . $adh["inscription"] . ' - ' . $prenom_d . ' ' 
        . $nom_d);
      $update++;
    }
  }
          
} 


function verif_web ($id)
{
  global $cx;
  add_log_bd_cal (date('Y-m-d H:i:s'), $cx, '0000','Vérification de la licence ' . $id . ' par WebService');
  /**
   * Chargement de la définition du webservice
   */
  $client = new SoapClient('https://extranet-clubalpin.com/app/soap/extranet_pro.wsdl');
      
  try {
      /**
       * L'objet ffcam_connexion renvoyé par la méthode auth permet l'identification
       * et devra y être passé en 1er paramètre de toute fonction
       */
      

      $connexion = $client->auth();
      $connexion->utilisateur = extract_user_webmaster('cal_param');
      $connexion->motdepasse  = extract_pass_webmaster('cal_param');
      /**
       * Exemple de fonction : vérification d'un adhérent
       */
      $result = $client->verifierUnAdherent($connexion, $id);
      //echo 'Controle du club ' . $verif . '<br>';
     
      //affichageDeTest($result);
      if ($result->existe === 1) {
          // Code à exécuter si le numéro d'adhérent existe
          // D'autres informations sont disponibles dans $result comme par exemple la date d'inscription
          // pour vérifier si besoin que l'adhérent est à jour de cotisation
        //echo '<br>' . $verif . ' existe<br>'; 
        return $result;
      } 
      else 
      {
          // Code à exécuter si le numéro d'adhérent n'existe pas
        //echo '<br>' . $verif . ' n\'existe pas<br>';
        return false;
      }
  } catch (Exception $e) {
          echo "<p>Exception api " . $e->getMessage()."</p>";
          echo 'User : ' . $connexion->utilisateur . ' Pwd : ' . $connexion->motdepasse . '<br>';
          add_log_bd_cal (date('Y-m-d H:i:s'), $cx, '0000','API ffcam - Exception ' . $e->getMessage());
      /**
       * Principales raisons d'exceptions :
       *  - Echec de l'identification (erreur identifiant/mot de passe ou données non fournies)
       *  - Appel d'une fonction non autorisée pour votre compte
       *  - Oubli d'un paramètre pour une fonction
       *  - Demande hors périmètre (informations d'un autre club)
       *  - Dépassement de votre limite de consommation de ressources
       */
      $result = false;
  }
  return $result;
}


function extract_adh_web ($adherent)
{
  
  /**
   * Chargement de la définition du webservice
   */
  $client = new SoapClient('https://extranet-clubalpin.com/app/soap/extranet_pro.wsdl');

  try {
      /**
       * L'objet ffcam_connexion renvoyé par la méthode auth permet l'identification
       * et devra y être passé en 1er paramètre de toute fonction
       */
      

      $connexion = $client->auth();
      $connexion->utilisateur = extract_user_webmaster('cal_param');
      $connexion->motdepasse  = extract_pass_webmaster('cal_param');
      /**
       * Exemple de fonction : vérification d'un adhérent
       */
      //$result = $client->verifierUnAdherent($connexion, $verif);
      //echo 'Controle du club ' . $verif . '<br>';
      $result = $client->extractionAdherent($connexion, $adherent);
      return $result;
      //affichageDeTest($result);
      if ($result->existe === 1) {
          // Code à exécuter si le numéro d'adhérent existe
          // D'autres informations sont disponibles dans $result comme par exemple la date d'inscription
          // pour vérifier si besoin que l'adhérent est à jour de cotisation
        echo '<br>' . $adherent . ' existe<br>'; 
        return $result;
      } 
      else 
      {
          // Code à exécuter si le numéro d'adhérent n'existe pas
        echo '<br>' . $adherent . ' n\'existe pas<br>';
        return false;
      }
  } catch (Exception $e) {
          echo "<p>Exception api " . $e->getMessage()."</p>";
          echo 'User : ' . $connexion->utilisateur . ' Pwd : ' . $connexion->motdepasse . '<br>';
          add_log_bd_cal (date('Y-m-d H:i:s'), 'cron', '0000','API ffcam - Exception ' . $e->getMessage());
      /**
       * Principales raisons d'exceptions :
       *  - Echec de l'identification (erreur identifiant/mot de passe ou données non fournies)
       *  - Appel d'une fonction non autorisée pour votre compte
       *  - Oubli d'un paramètre pour une fonction
       *  - Demande hors périmètre (informations d'un autre club)
       *  - Dépassement de votre limite de consommation de ressources
       */
  }
}

function procedure_mot_de_passe_oublie_ph_1()
{
    global $IDU, $quand, $factivite, $fcadre;

    echo '<h1>Procédure mot de passe oublié</h1><p class="oblique">Pour être certain que c\'est bien vous qui avez lancé cette procédure de regenération de votre identifiant et mot de passe, <b>un code unique vous sera envoyé sur l\'adresse email associé à votre licence</b> du CAF. En cas de changement d\'adresse email par rapport à celle enregistrée, demandez à votre webmaster de faire la modification des données de votre licence.</p>
    <form method="post">
    Adresse email associée à votre licence
    <input type="text" name="mail" value="' . $mail . '" required>
    <input type="submit" name="commande" value="Envoi de votre adresse">
    <inpur type="submit" name="commande" value="RETOUR BLOC-NOTES">
    <input type="hidden" name="IDU" value="' . $IDU . '">
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="fcadre" value="' . $fcadre . '">  
    <input type="hidden" name="quand" value="' . $quand . '">          
    </form>';
}

function procedure_mot_de_passe_oublie_ph_2()
{
    $IDU     = $_POST['IDU'];
    $quand   = $_POST['quand'];
    $factivite = $_POST['factivite'];
    $fcadre  = $_POST['fcadre'];
    $mail    = trim($_POST['mail']);

    $code =rand(1000,9999);
    SendMailCodeProc ($mail, $code);
    echo '<h1>Procédure pour mot de passe ou identifiant oublié</h1>
    <p classe="oblique">Vous avez besoin du code unique qui vous a été envoyé par mail pour créer ou changer vos identifiants et mot de passe.Prendre toujours le dernier code de sécurité reçu par mail.<br>Pour l\'identifiant vous pouvez prendre des éléments de votre prénom et nom ou votre adresse email ou votre numéro de licence de façon à ce qu\'il soit unique.<br>Le mot de passe doit avoir au moins 8 caractères avec au moins 1 majuscule, 1 minuscule et un chiffre. Les caractères spéciaux ne sont pas obligatoire mais conseillé.</p>
    <form method="post">
    <table>
    <tr><td>Code unique reçu par mail</td><td><input type="text" name="code_r" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Votre numéro de licence CAF</td><td><input type="text" name="licence" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Identifiant</td><td><input type="text" name="identifiant" minlength="4" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Mot de passe</td><td><input type="password" name="pass" minlength="8" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Ressaisir votre mot de passe</td><td><input type="password" name="repass" minlength="8" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    </table>
    <input type="submit" name="commande" value="Création identifiant et mot de passe"> 
    <input type="submit" class="bouton" name="x" value="RETOUR CALENDRIER" title="Retour à la liste des activités filtrées"  style="background:#076899;"> 
    <input type="hidden" name="IDU" value="' . $IDU . '">
    <input type="hidden" name="quand" value="' . $quand . '">
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="code" value="' . $code . '">
    <input type="hidden" name="mail" value="' . $mail . '">
    </form>';
}


function creation_identifiant_et_mot_de_passe()
{
    $code    = trim($_POST['code']);
    $code_r  = trim($_POST['code_r']);
    $IDU     = $_POST['IDU'];
    $quand   = $_POST['quand'];
    $factivite = $_POST['factivite'];
    $licence = $_POST['licence'];  
    $mail    = $_POST['mail'];
    $pass    = trim($_POST['pass']);
    $repass  = trim($_POST['repass']);
    $identifiant = trim($_POST['identifiant']);
    echo '<h1>Contrôle identifiant et mot de passe</h1>';
    $bpass = true;



    //echo $code . ' - mail = ' . $mail .'<br>';
    //verification du code sécurité
    if ($code_r != $code)
    {
      echo '<br>Le code que vous avez reçu par email ne correspond pas à celui que vous avez proposé. Regardez bien vos derniers messages reçus<br>C\'est un code numérique formé de 4 chiffres<br>';
      $bpass = false;
    }
    else
    {
      //test sur table adhérent Michel 749620159004
      echo 'Envoi avec licence ' . $licence;
      $adh = extract_adherent_licence_mail ($licence, $mail);

      if (sizeof($adh) == 0)
      {
        echo 'Le numéro de licence <b>' . $licence . '</b> et l\'adresse mail "<b>' . $mail . '</b>" ne correspondent pas à une licence du CAF<br>';
        $bpass = false;      
      }  
      else
      {  

        //test sut table cadre - est-ce un cadre et est-ce que l'identifiant est unique
        $allcadre = extract_all_cadre ();
        $bcadre = false; $bid=true;
        
        foreach ($allcadre as $cadre)
        {
          if ($adh->prenom == strtoupper(remove_accents($cadre->prenom)) && $adh->nom == strtoupper(remove_accents($cadre->nom)))
          {
             echo '<p>' . $cadre->prenom . ' ' . $cadre->nom . ' est bien cadre du CAF Meythet</p>';
             $bcadre = true;
             $nick_name = $cadre->nick_name;
             
          }
          else
          {
            if ($identifiant == $cadre->identifiant)
            {
              $bid = false;
            }
          }
        }

        if ($bid == false)
        {
          echo 'L\'identifiant ' . $identifiant . ' est déjà pris par un autre cadre<br>';
          $bpass = false;      
        }
        if ($bcadre == false)
        {
          echo $adh->prenom . ' ' . $adh->nom . ' n\'existe pas dans la liste des cadres<br>';
          $bpass = false;
        }

        if (strlen($identifiant) < 4)
        {
          echo 'Identifiant trop court. Au moins 4 caractères';
          $bpass = false;      
        }    
        if (strlen($pass) < 8)
        {
          echo 'Mot de passe trop court. Au moins 8 caractères';
          $bpass = false;      
        }
        if ($pass != $repass)
        {
          echo 'Vous n\'avez pas ressaisi le même mot de passe dans le champ de vérification.';
          $bpass = false;
        }


        //if ( ! preg_match("~^[\w]+$~", $psswrd) ) return "Uniquement des lettres ou des chiffres !" ;    
        if ( ! preg_match("~[A-Z]~", $pass) ) 
        {
            echo '<br>Vous n\'avez pas mis une majuscule dans le mot de passe.';
            $bpass = false;
        }
        if ( ! preg_match("~[a-z]~", $pass) ) 
        {
            echo '<br>Vous n\'avez pas mis une majuscule dans le mot de passe.';
            $bpass = false;
        }    
        if ( ! preg_match("~[0-9]~", $pass) )
        {
          echo '<br>Vous n\'avez pas mis un chiffre dans le mot de passe.';
          $bpass = false;
        }  
      }  
    }
    //echo '<br>' . $pass . '<br>';
    if (!$bpass) 
    {
        echo '<br><font color="red">Au moins une erreur - Recommencer la procédure</font>';

      //echo hash('SHA256', $pass);
      
      echo '<p classe="oblique">Vous avez besoin de votre numéro de licence et de votre adresse email pour créer ou changer vos identifiants et mot de passe.<br>Le mot de passe doit avoir au moins 8 caractères avec au moins 1 majuscule, 1 minuscule et un chiffre. Les caractères spéciaux ne sont pas obligatoire mais conseillé.<br>Pour l\'identifiant vous pouvez prendre des éléments de votre prénom et nom ou votre adresse email ou votre numéro de licence de façon à ce qu\'il soit unique.Sa longueur doit faire au moins 4 caractères.</p>
      <form method="post">
      <table>
      <tr><td>Code unique reçu par mail</td><td><input type="text" name="code_r" value="' . $code_r . '" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr><tr><td>Licence</td><td><input type="text" name="licence" value="' . $licence . '" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Identifiant</td><td><input type="text" name="identifiant" value="' . $identifiant . '" minlength="4" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Mot de passe</td><td><input type="password" required name="pass" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Ressaisir votre mot de passe</td><td><input type="password" name="repass" required minlength="8" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      </table>
      <input type="submit" name="commande" value="Création identifiant et mot de passe">
      <input type="hidden" name="IDU" value="' . $IDU . '">
      <input type="hidden" name="quand" value="' . $quand . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="code" value="' . $code . '">
      <input type="hidden" name="mail" value="' . $mail . '">
      </form>';
    }
    else
    {
      //mise à jour de la table des cadres avec l'identifiant et le SAH256 du mot de passe
      update_cadre_pass ($nick_name, $identifiant, hash('sha256', $pass));
      echo '<p>' . $nick_name . ', vous êtes le seul détenteur de votre mot de passe. Il n\'est pas enregistré sur le site. Ne pas oublier ce couple identifiant et mot de passe</p>';
      return true;
    }
}

function creation_identifiant_et_mot_de_passe_adherent()
{
    $code    = trim($_POST['code']);
    $code_r  = trim($_POST['code_r']);
    $IDU     = $_POST['IDU'];
    $quand   = $_POST['quand'];
    $factivite = $_POST['factivite'];
    $licence = $_POST['licence'];
    $mail    = $_POST['mail'];
    $pass    = trim($_POST['pass']);
    $repass  = trim($_POST['repass']);
    $identifiant = trim($_POST['identifiant']);
    echo '<h1>Contrôle identifiant et mot de passe</h1>';
    $bpass = true;

       
    //echo $code . ' - mail = ' . $mail .'<br>';
    //verification du code sécurité
    if ($code_r != $code)
    {
      echo '<br>Le code que vous avez reçu par email ne correspond pas à celui que vous avez proposé. Regardez bien vos derniers messages reçus<br>C\'est un code numérique formé de 4 chiffres<br>';
      $bpass = false;
    }
    else
    {
      //test sur table adhérent Michel 749620159004
      $adh = extract_adherent_licence_mail ($licence, $mail);

      if (sizeof($adh) == 0)
      {
        echo 'Le numéro de licence <b>' . $licence . '</b> et l\'adresse mail "<b>' . $mail . '</b>" ne correspondent pas à votre licence du CAF<br>';
        $bpass = false;      
      }  
      else
      {  
        //test sut table cadre - est-ce un cadre et est-ce que l'identifiant est unique
        $alladh = extract_ident_adherent ($identifiant);
        $bid=true;
        
        foreach ($alladh as $adh)
        {
          if ($adh->id != $licence)
          {
              $bid = false;
              break;
          }
 
        }

        if ($bid == false)
        {
          echo 'L\'identifiant ' . $identifiant . ' est déjà pris par un autre adhérent<br>';
          $bpass = false;      
        }


        if (strlen($identifiant) < 4)
        {
          echo 'Identifiant trop court. Au moins 4 caractères';
          $bpass = false;      
        }    
        if (strlen($pass) < 6)
        {
          echo 'Mot de passe trop court. Au moins 6 caractères';
          $bpass = false;      
        }
        if ($pass != $repass)
        {
          echo 'Vous n\'avez pas ressaisi le même mot de passe dans le champ de vérification.';
          $bpass = false;
        }


        //if ( ! preg_match("~^[\w]+$~", $psswrd) ) return "Uniquement des lettres ou des chiffres !" ;    
        if ( ! preg_match("~[A-Z]~", $pass) ) 
        {
            echo '<br>Vous n\'avez pas mis une majuscule dans le mot de passe.';
            $bpass = false;
        }
        if ( ! preg_match("~[a-z]~", $pass) ) 
        {
            echo '<br>Vous n\'avez pas mis une majuscule dans le mot de passe.';
            $bpass = false;
        }    
        if ( ! preg_match("~[0-9]~", $pass) )
        {
          echo '<br>Vous n\'avez pas mis un chiffre dans le mot de passe.';
          $bpass = false;
        }  
      }  
    }
    //echo '<br>' . $pass . '<br>';
    if (!$bpass) 
    {
        echo '<br><font color="red">Au moins une erreur - Recommencer la procédure</font>';

      //echo hash('SHA256', $pass);
      
      echo '<p classe="oblique">Vous avez besoin de votre numéro de licence et de votre adresse email pour créer ou changer vos identifiants et mot de passe.<br>Le mot de passe doit avoir au moins 6 caractères avec au moins 1 majuscule, 1 minuscule et un chiffre. Les caractères spéciaux ne sont pas obligatoire mais conseillé.<br>Pour l\'identifiant vous pouvez prendre des éléments de votre prénom et nom ou votre adresse email ou votre numéro de licence de façon à ce qu\'il soit unique.Sa longueur doit faire au moins 4 caractères.</p>
      <form method="post">
      <table>
      <tr><td>Code unique reçu par mail</td><td><input type="text" name="code_r" value="' . $code_r . '" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr><tr><td>Licence</td><td><input type="text" name="licence" value="' . $licence . '" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Identifiant</td><td><input type="text" name="identifiant" value="' . $identifiant . '" minlength="4" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Mot de passe</td><td><input type="password" required name="pass" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      <tr><td>Ressaisir votre mot de passe</td><td><input type="password" name="repass" required minlength="8" style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
      </table>
      <input type="submit" name="commande" value="Adhérent - Création identifiant et mot de passe">
      <input type="hidden" name="IDU" value="' . $IDU . '">
      <input type="hidden" name="quand" value="' . $quand . '">
      <input type="hidden" name="factivite" value="' . $factivite . '">
      <input type="hidden" name="code" value="' . $code . '">
      <input type="hidden" name="mail" value="' . $mail . '">
      </form>';
    }
    else
    {

      //mise à jour de la table des adhérents avec l'identifiant et le SAH256 du mot de passe
      update_adherent_pass ($licence, $identifiant, hash('sha256', $pass));
      $adh = extract_adherent_licence_mail ($licence, $mail);
      echo '<p>' . $adh->prenom . ' ' . $adh->nom . ', vous êtes le seul détenteur de votre mot de passe. Il n\'est pas enregistré sur le site. Ne pas oublier ce couple identifiant et mot de passe</p>';
      return true;
    }
}



function procedure_mot_de_passe_oublie_adh_1()
{
    global $IDU, $quand, $factivite;

    echo '<h1>Procédure adhérent mot de passe oublié</h1>
    <p class="oblique_bleu">Attention : si vous avez pris votre licence le jour J auprès de la FFCAM, veuillez attendre J+1 pour créer votre identifiant et mot de passe.</p>
    <p class="oblique">Pour être certain que c\'est bien vous qui avez lancé cette procédure de regénération de votre identifiant et mot de passe, <b>un code unique vous sera envoyé sur l\'adresse email associé à votre licence</b> du CAF. En cas de changement d\'adresse email par rapport à celle enregistrée, demandez à votre webmaster de faire la modification des données de votre licence.</p>
    <p><b>Aller lire votre boite mail pour récupérer le code unique une fois que vous avez utilisé le bouton d\'envoi.</b></p>
    <p><form method="post">
    Adresse email associée à votre licence
    <input type="text" name="mail" value="' . $mail . '" required>
    <input type="submit" name="commande" value="Envoi de votre adresse mail adhérent">
    <inpur type="submit" name="commande" value="RETOUR BLOC-NOTES">
    <input type="hidden" name="IDU" value="' . $IDU . '">
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="quand" value="' . $quand . '">          
    </form></p>';
}

function procedure_mot_de_passe_oublie_adh_2()
{
    $IDU     = $_POST['IDU'];
    $quand   = $_POST['quand'];
    $factivite = $_POST['factivite'];
    $mail    = trim($_POST['mail']);

    $code =rand(1000,9999);
    SendMailCodeProc ($mail, $code);
    echo '<h1>Procédure adhérent pour mot de passe ou identifiant oublié</h1>
    <p classe="oblique">Vous avez besoin du code unique qui vous a été envoyé par mail pour créer ou changer vos identifiants et mot de passe.Prendre toujours le dernier code de sécurité reçu par mail.<br>Pour l\'identifiant vous pouvez prendre des éléments de votre prénom et nom ou votre adresse email ou votre numéro de licence de façon à ce qu\'il soit unique.<br>Le mot de passe doit avoir au moins 6 caractères avec au moins 1 majuscule, 1 minuscule et un chiffre. Les caractères spéciaux ne sont pas obligatoire mais conseillé.</p>
    <form method="post">
    <table>
    <tr><td>Code unique reçu par mail</td><td><input type="text" name="code_r" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Votre numéro de licence CAF</td><td><input type="text" name="licence" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Identifiant</td><td><input type="text" name="identifiant" minlength="4" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Mot de passe</td><td><input type="password" name="pass" minlength="6" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    <tr><td>Ressaisir votre mot de passe</td><td><input type="password" name="repass" minlength="6" required style="color:black;  background-color:#fafafa; border-color:blue;"></td></tr>
    </table>
    <input type="submit" name="commande" value="Adhérent - Création identifiant et mot de passe">
    <input type="hidden" name="IDU" value="' . $IDU . '">
    <input type="hidden" name="quand" value="' . $quand . '">
    <input type="hidden" name="factivite" value="' . $factivite . '">
    <input type="hidden" name="code" value="' . $code . '">
    <input type="hidden" name="mail" value="' . $mail . '">
    </form>';
}

//retourne un calendrier des jours sélectionnés - nday est un tableau version 6.80
//1:lundi 2:mardi 3:mercredi 4:jeudi 5:vendredi 6:samedi 0:dimanche
function getNextDays($nday, $months = 12) 
{
    $datedays = [];

    foreach ($nday as $day)
    {
      //echo 'Analyse jour ' . $day;
      $currentDate = new DateTime();
      $endDate = (clone $currentDate)->modify("+$months months");      
      $currentDate = new DateTime();
      while ($currentDate <= $endDate) 
      {
        if ($currentDate->format('N') == $day) 
        { // 2 corresponds to Tuesday
            $datedays[] = $currentDate->format('Y-m-d');
        }
      
        $currentDate->modify('+1 day');
      }
    }
    sort($datedays); 
    return $datedays;
}

function SendMailCodeProc ($email, $code)
{

  $destinataire = $email;


  $sujet   = 'Code de sécurité d\'accès à la procédure "mot de passe" oublié';
  $buffer  = '<font color="blue">Recopier ce code <b>' . $code . ' </b>pour accéder à la procédure identifiant ou/et mot de passe oublié.</font><br><b><br>PS: ne pas répondre à ce message automatique';
  
  
  //version 2.73 avec sendmail() au lieu de mail()
  $crm = sendmail ($destinataire, $sujet, $buffer);

}

function getNewId()
{
  global $wpdb2, $table_idu;
  $req = "SELECT IDU FROM " . $table_idu . " WHERE type LIKE 'COFFRE'";
  $rep = $wpdb2->get_results($req);
  $Id = $rep[0]->IDU + 1;
  $req = "UPDATE " . $table_idu . " SET IDU = " . $Id . " WHERE type LIKE 'COFFRE'";
  $wpdb2->get_results($req);
  return $Id;
}

function pluriel ($word, $count) 
{
    if ($count > 1) {
        $last_char = substr($word, -1);
        if ($last_char != 's') {
            $word .= 's';
        }
    }
    return $word;
}

function get_debut_saison ()
{

  if (date('Y-m-d') > date('Y'). '-09-01' && date('Y-m-d') < date('Y') . '12-31')
   $debut_saison = date('Y') . '-09-01';
  else
   $debut_saison = date('Y') - 1 . '-09-01';      //2023-10-01
 
  return $debut_saison;
}

function get_fin_saison ()
{

  if (date('Y-m-d') > date('Y'). '-09-01' && date('Y-m-d') < date('Y') . '12-31')
   $fin_saison = date('Y') + 1 . '-08-30';
  else
   $fin_saison = date('Y') - 1 . '-08-30';      //2023-10-01
 
  return $fin_saison;
}


function sendmail ($destinataire, $sujet, $message)
{
    $sujet = $sujet . '(' . date('d/m H:i:s') . ')';
    $headers = array(
        'From' => 'activite@cafmeythet.org',
        'Content-Type' => 'text/html; charset=UTF-8',
        'Content-Transfer-Encoding' => '8bit'
         );

    return mb_send_mail ($destinataire, $sujet, $message, $headers);
}

//retour un tableau des activités sur un jour de la semaine
function filtre_nom_jour($quand, $activite='toutes', $search='', $camp='')
{
  global $wpdb2, $table_activ;
  //echo 'Function filtre_nom_jour<br>';
  
  //echo 'Activité du ' . $nom_jour . '<br>';
  switch ($quand)
  {
      case 'lundi'     :$ndays=1; break;
      case 'mardi'     :$ndays=2; break;
      case 'mercredi'  :$ndays=3; break;
      case 'jeudi'     :$ndays=4; break;
      case 'vendredi'  :$ndays=5; break;
      case 'samedi'    :$ndays=6; break;
      case 'dimanche'  :$ndays=7; break;
  }

  $calend = getNextDays($ndays);
 
  $scan=array();
  $i=0;
  foreach($calend as $date)
  {
    if ($camp == '')
    {
      if ($search == '')
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1";
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "'";      
      }
      else
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')"; 
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')";              
      }
    }
    else
    {
      if ($search == '')
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND camp = '" . $camp . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND camp = '" . $camp . "'";
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND camp = '" . $camp . "'";      
      }
      else
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'"; 
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'";              
      }      
    }
    //echo $req . '<br>';
    $rep = $wpdb2->get_results($req);

    if (sizeof($rep)>0)
    {
      foreach ($rep as $activ)
      {
        $scan[$i++]=$activ;
      }
    }
  }

  return $scan;

}

function ajout_paie_assocb ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET paie = 1 WHERE IDU = " . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;   
}

function retrait_paie_assocb ($IDU)
{
  global $wpdb2, $table_activ;
  $req = "UPDATE " . $table_activ . " SET paie = 0 WHERE IDU = " . $IDU;
  $wpdb2->get_results($req);
  return $wpdb2->last_error;   
}

//retour un tableau des activités sur un jour de la semaine
function filtre_noms_jours($quand, $activite='toutes', $search='', $camp='')
{
  global $wpdb2, $table_activ, $njour;

  $ndays = array();
  $i=0;
  foreach ($njour as $day)
  {

    switch ($day)
    {
        case 'lundi'     :$ndays[$i++]=1; break;
        case 'mardi'     :$ndays[$i++]=2; break;
        case 'mercredi'  :$ndays[$i++]=3; break;
        case 'jeudi'     :$ndays[$i++]=4; break;
        case 'vendredi'  :$ndays[$i++]=5; break;
        case 'samedi'    :$ndays[$i++]=6; break;
        case 'dimanche'  :$ndays[$i++]=7; break;
    }
  }

  $calend = getNextDays($ndays);

 
  $scan=array();
  $i=0;
  foreach($calend as $date)
  {
    if ($camp == '')
    {
      if ($search == '')
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1";
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "'";      
      }
      else
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')"; 
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%')";              
      }
    }
    else
    {
      if ($search == '')
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND camp = '" . $camp . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND camp = '" . $camp . "'";
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND camp = '" . $camp . "'";      
      }
      else
      {
        if ($activite == 'toutes')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'";
        else if ($activite == 'Formation')
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND formation = 1 AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'"; 
        else
          $req = "SELECT * FROM " . $table_activ . " WHERE date_deb = '" . $date . "' AND activite like '" . $activite . "' AND (cadre LIKE '%%" . $wpdb2->_real_escape($search) . "%%' OR titre LIKE '%%" . $wpdb2->_real_escape($search) . "%%') AND camp = '" . $camp . "'";              
      }      
    }
    //echo $req . '<br>';
    $rep = $wpdb2->get_results($req);

    if (sizeof($rep)>0)
    {
      foreach ($rep as $activ)
      {
        //echo 'Ajout ' . $date . '<br>';
        $scan[$i++]=$activ;
      }
    }
  }

  return $scan;

}



function getDateFirstMonth($mmaaaa)
{
  $day   = '01';
  $month = substr($mmaaaa, 0, 2);
  $year  = substr($mmaaaa, 3,4);
  if (checkdate($month, $day, $year))
    return $year . '-' . $month . '-' . $day;
  else
    return false;

}

function getDateLastMonth($mmaaaa)
{
  $day   = '01';
  $month = substr($mmaaaa, 0, 2);
  $year  = substr($mmaaaa, 3,4);
  $date  = $year . '-' . $month . '-' . $day;
  return date('Y-m-t', strtotime($date));
}
?>